/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417.decoder;

final class Codeword {
    private static final int BARCODE_ROW_UNKNOWN = -1;
    private final int startX;
    private final int endX;
    private final int bucket;
    private final int value;
    private int rowNumber = -1;

    Codeword(int n5, int n6, int n7, int n8) {
        this.startX = n5;
        this.endX = n6;
        this.bucket = n7;
        this.value = n8;
    }

    boolean hasValidRowNumber() {
        Codeword codeword = this;
        return codeword.isValidRowNumber(codeword.rowNumber);
    }

    boolean isValidRowNumber(int n5) {
        return n5 != -1 && this.bucket == n5 % 3 * 3;
    }

    void setRowNumberAsRowIndicatorColumn() {
        this.rowNumber = this.value / 30 * 3 + this.bucket / 3;
    }

    int getWidth() {
        return this.endX - this.startX;
    }

    int getStartX() {
        return this.startX;
    }

    int getEndX() {
        return this.endX;
    }

    int getBucket() {
        return this.bucket;
    }

    int getValue() {
        return this.value;
    }

    int getRowNumber() {
        return this.rowNumber;
    }

    void setRowNumber(int n5) {
        this.rowNumber = n5;
    }

    public String toString() {
        return this.rowNumber + "|" + this.value;
    }
}

