/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.common.ui.blur;

import io.dcloud.common.adapter.util.MessageHandler;
import io.dcloud.common.util.ThreadPool;
import java.util.ArrayList;

public class AppEventForBlurManager {
    private static final String TAG = "AppScrollManager";
    private static boolean sScrollStart = false;
    private static long sLastChangedTime = 0L;
    private static boolean mLoop = false;
    public static final boolean isBlur = true;
    private static ArrayList<OnAppChangedCallBack> callBacks = new ArrayList();

    public static void onScrollChanged(int n5, int n6) {
        sScrollStart = true;
        sLastChangedTime = System.currentTimeMillis();
        if (!mLoop) {
            AppEventForBlurManager.onScrollStart();
        }
        AppEventForBlurManager.startLoop();
    }

    private static void startLoop() {
        if (!mLoop) {
            mLoop = true;
            ThreadPool.self().addThreadTask(new Runnable(){

                @Override
                public void run() {
                    while (sScrollStart) {
                        mLoop = true;
                        if (System.currentTimeMillis() - sLastChangedTime > 500L) {
                            sScrollStart = false;
                            mLoop = false;
                            sLastChangedTime = 0L;
                            AppEventForBlurManager.onScrollEnd();
                            continue;
                        }
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                }
            }, true);
            return;
        }
    }

    public static synchronized void addEventChangedCallBack(OnAppChangedCallBack onAppChangedCallBack) {
        if (!callBacks.contains(onAppChangedCallBack)) {
            callBacks.add(onAppChangedCallBack);
            return;
        }
    }

    public static synchronized void removeEventChangedCallBack(OnAppChangedCallBack onAppChangedCallBack) {
        if (callBacks.contains(onAppChangedCallBack)) {
            callBacks.remove(onAppChangedCallBack);
            return;
        }
    }

    private static void onScrollStart() {
        MessageHandler.post(new Runnable(){

            @Override
            public void run() {
                ArrayList arrayList = callBacks;
                int n5 = arrayList.size();
                for (int i5 = 0; i5 < n5; ++i5) {
                    Object e5 = arrayList.get(i5);
                    ((OnAppChangedCallBack)e5).onContentScrollStart();
                }
            }
        });
    }

    private static void onScrollEnd() {
        MessageHandler.post(new Runnable(){

            @Override
            public void run() {
                ArrayList arrayList = callBacks;
                int n5 = arrayList.size();
                for (int i5 = 0; i5 < n5; ++i5) {
                    Object e5 = arrayList.get(i5);
                    ((OnAppChangedCallBack)e5).onContentScrollEnd();
                }
            }
        });
    }

    public static void onSplashclosed() {
        MessageHandler.post(new Runnable(){

            @Override
            public void run() {
                ArrayList arrayList = callBacks;
                int n5 = arrayList.size();
                for (int i5 = 0; i5 < n5; ++i5) {
                    Object e5 = arrayList.get(i5);
                    ((OnAppChangedCallBack)e5).onSplashclosed();
                }
            }
        });
    }

    public static interface OnAppChangedCallBack {
        public void onContentScrollStart();

        public void onContentScrollEnd();

        public void onSplashclosed();
    }
}

