/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.net.Uri;
import androidx.annotation.IntRange;
import androidx.annotation.Nullable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import pl.droidsonroids.gif.GifDrawable;
import pl.droidsonroids.gif.GifOptions;
import pl.droidsonroids.gif.InputSource;
import pl.droidsonroids.gif.annotations.Beta;

public abstract class GifDrawableInit<T extends GifDrawableInit<T>> {
    private InputSource mInputSource;
    private GifDrawable mOldDrawable;
    private ScheduledThreadPoolExecutor mExecutor;
    private boolean mIsRenderingTriggeredOnDraw = true;
    private final GifOptions mOptions = new GifOptions();

    protected abstract T self();

    public T sampleSize(@IntRange(from=1L, to=65535L) int sampleSize) {
        this.mOptions.setInSampleSize(sampleSize);
        return this.self();
    }

    public GifDrawable build() throws IOException {
        if (this.mInputSource == null) {
            throw new NullPointerException("Source is not set");
        }
        return this.mInputSource.createGifDrawable(this.mOldDrawable, this.mExecutor, this.mIsRenderingTriggeredOnDraw, this.mOptions);
    }

    public T with(GifDrawable drawable) {
        this.mOldDrawable = drawable;
        return this.self();
    }

    public T threadPoolSize(int threadPoolSize) {
        this.mExecutor = new ScheduledThreadPoolExecutor(threadPoolSize);
        return this.self();
    }

    public T taskExecutor(ScheduledThreadPoolExecutor executor) {
        this.mExecutor = executor;
        return this.self();
    }

    public T renderingTriggeredOnDraw(boolean isRenderingTriggeredOnDraw) {
        this.mIsRenderingTriggeredOnDraw = isRenderingTriggeredOnDraw;
        return this.self();
    }

    public T setRenderingTriggeredOnDraw(boolean isRenderingTriggeredOnDraw) {
        return this.renderingTriggeredOnDraw(isRenderingTriggeredOnDraw);
    }

    @Beta
    public T options(@Nullable GifOptions options) {
        this.mOptions.setFrom(options);
        return this.self();
    }

    public T from(InputStream inputStream) {
        this.mInputSource = new InputSource.InputStreamSource(inputStream);
        return this.self();
    }

    public T from(AssetFileDescriptor assetFileDescriptor) {
        this.mInputSource = new InputSource.AssetFileDescriptorSource(assetFileDescriptor);
        return this.self();
    }

    public T from(FileDescriptor fileDescriptor) {
        this.mInputSource = new InputSource.FileDescriptorSource(fileDescriptor);
        return this.self();
    }

    public T from(AssetManager assetManager, String assetName) {
        this.mInputSource = new InputSource.AssetSource(assetManager, assetName);
        return this.self();
    }

    public T from(ContentResolver contentResolver, Uri uri) {
        this.mInputSource = new InputSource.UriSource(contentResolver, uri);
        return this.self();
    }

    public T from(File file) {
        this.mInputSource = new InputSource.FileSource(file);
        return this.self();
    }

    public T from(String filePath) {
        this.mInputSource = new InputSource.FileSource(filePath);
        return this.self();
    }

    public T from(byte[] bytes) {
        this.mInputSource = new InputSource.ByteArraySource(bytes);
        return this.self();
    }

    public T from(ByteBuffer byteBuffer) {
        this.mInputSource = new InputSource.DirectByteBufferSource(byteBuffer);
        return this.self();
    }

    public T from(Resources resources, int resourceId) {
        this.mInputSource = new InputSource.ResourcesSource(resources, resourceId);
        return this.self();
    }

    public InputSource getInputSource() {
        return this.mInputSource;
    }

    public GifDrawable getOldDrawable() {
        return this.mOldDrawable;
    }

    public ScheduledThreadPoolExecutor getExecutor() {
        return this.mExecutor;
    }

    public boolean isRenderingTriggeredOnDraw() {
        return this.mIsRenderingTriggeredOnDraw;
    }

    public GifOptions getOptions() {
        return this.mOptions;
    }
}

