/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.common;

import com.dcloud.zxing2.Binarizer;
import com.dcloud.zxing2.LuminanceSource;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.common.BitArray;
import com.dcloud.zxing2.common.BitMatrix;

public class GlobalHistogramBinarizer
extends Binarizer {
    private static final int LUMINANCE_BITS = 5;
    private static final int LUMINANCE_SHIFT = 3;
    private static final int LUMINANCE_BUCKETS = 32;
    private static final byte[] EMPTY = new byte[0];
    private byte[] luminances = EMPTY;
    private final int[] buckets = new int[32];

    public GlobalHistogramBinarizer(LuminanceSource luminanceSource) {
        super(luminanceSource);
    }

    private void initArrays(int n5) {
        if (this.luminances.length < n5) {
            this.luminances = new byte[n5];
        }
        for (n5 = 0; n5 < 32; ++n5) {
            this.buckets[n5] = 0;
        }
    }

    private static int estimateBlackPoint(int[] nArray) throws NotFoundException {
        int n5;
        int n6;
        int n7;
        int n8 = nArray.length;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        for (n7 = 0; n7 < n8; ++n7) {
            n6 = nArray[n7];
            if (n6 > n11) {
                n10 = n7;
                n11 = n6;
            }
            if (n6 <= n9) continue;
            n9 = n6;
        }
        n11 = 0;
        n7 = 0;
        for (n6 = 0; n6 < n8; ++n6) {
            int n12 = n6;
            n5 = n12 - n10;
            if ((n5 = nArray[n12] * n5 * n5) <= n7) continue;
            n7 = n5;
            n11 = n6;
        }
        if (n10 <= n11) {
            int n13 = n11;
            n11 = n10;
            n10 = n13;
        }
        if (n10 - n11 > n8 / 16) {
            n6 = n7 = -1;
            n7 = n8;
            for (n8 = n10 - 1; n8 > n11; --n8) {
                int n14 = n8 - n11;
                n5 = n14 * n14 * (n10 - n8) * (n9 - nArray[n8]);
                if (n5 <= n6) continue;
                n6 = n5;
                n7 = n8;
            }
            return n7 << 3;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    public BitArray getBlackRow(int n5, BitArray bitArray) throws NotFoundException {
        int n6;
        int n7;
        LuminanceSource luminanceSource = ((Binarizer)object).getLuminanceSource();
        int n8 = luminanceSource.getWidth();
        if (bitArray != null && bitArray.getSize() >= n8) {
            bitArray.clear();
        } else {
            BitArray bitArray2;
            bitArray = bitArray2;
            bitArray2 = new BitArray(n8);
        }
        GlobalHistogramBinarizer globalHistogramBinarizer = object;
        GlobalHistogramBinarizer globalHistogramBinarizer2 = object;
        globalHistogramBinarizer2.initArrays(n8);
        Object object = luminanceSource.getRow(n5, globalHistogramBinarizer2.luminances);
        int[] nArray = globalHistogramBinarizer.buckets;
        for (n7 = 0; n7 < n8; ++n7) {
            n6 = (object[n7] & 0xFF) >> 3;
            nArray[n6] = nArray[n6] + 1;
        }
        Object object2 = object;
        int n9 = GlobalHistogramBinarizer.estimateBlackPoint(nArray);
        n7 = object2[0] & 0xFF;
        n6 = object2[1] & 0xFF;
        int n10 = 1;
        int n11 = n6;
        n6 = n7;
        n7 = n11;
        while (n10 < n8 - 1) {
            int n12 = n10 + 1;
            int n13 = object[n12] & 0xFF;
            if ((n7 * 4 - n6 - n13) / 2 < n9) {
                bitArray.set(n10);
            }
            n6 = n7;
            n7 = n13;
            n10 = n12;
        }
        return bitArray;
    }

    @Override
    public BitMatrix getBlackMatrix() throws NotFoundException {
        int n5;
        BitMatrix bitMatrix;
        GlobalHistogramBinarizer globalHistogramBinarizer = this;
        Object object = globalHistogramBinarizer.getLuminanceSource();
        int n6 = ((LuminanceSource)object).getWidth();
        int n7 = ((LuminanceSource)object).getHeight();
        BitMatrix bitMatrix2 = bitMatrix;
        bitMatrix = new BitMatrix(n6, n7);
        globalHistogramBinarizer.initArrays(n6);
        int[] nArray = globalHistogramBinarizer.buckets;
        for (n5 = 1; n5 < 5; ++n5) {
            int n8 = n7 * n5 / 5;
            byte[] byArray = ((LuminanceSource)object).getRow(n8, this.luminances);
            int n9 = n6 * 4 / 5;
            for (int i5 = (v54724) / 5; i5 < n9; ++i5) {
                int n10 = (byArray[i5] & 0xFF) >> 3;
                nArray[n10] = nArray[n10] + 1;
            }
        }
        int n11 = GlobalHistogramBinarizer.estimateBlackPoint(nArray);
        object = ((LuminanceSource)object).getMatrix();
        for (int i6 = 0; i6 < n7; ++i6) {
            n5 = i6 * n6;
            for (int i7 = 0; i7 < n6; ++i7) {
                if ((object[n5 + i7] & 0xFF) >= n11) continue;
                bitMatrix2.set(i7, i6);
            }
        }
        return bitMatrix2;
    }

    @Override
    public Binarizer createBinarizer(LuminanceSource luminanceSource) {
        return new GlobalHistogramBinarizer(luminanceSource);
    }
}

