/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.common.util;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import androidx.core.content.FileProvider;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.adapter.util.MobilePhoneModel;
import io.dcloud.common.util.HashUtils;
import io.dcloud.common.util.IOUtil;
import io.dcloud.common.util.Md5Utils;
import io.dcloud.common.util.ReflectUtils;
import java.io.File;
import java.io.FileInputStream;
import java.lang.constant.Constable;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class LoadAppUtils {
    private static final String TAG = "LoadAppUtils";
    private static final int APP_TYPE_ALL = 0;
    private static final int APP_TYPE_NON_SYSTEM = 1;
    private static final int APP_TYPE_SYSTEM = 2;
    public static final int APK_INSTALLED = 0;
    public static final int APK_UNINSTALLED = -2;
    public static final int APK_UPGRADE = 1;
    public static final int APK_DOWNGRADE = -1;

    public static int getLoadState(PackageInfo packageInfo, int n5) {
        if (packageInfo == null) {
            return -2;
        }
        int n6 = packageInfo.versionCode;
        if (n6 == n5) {
            return 0;
        }
        if (n6 < n5) {
            return 1;
        }
        return -1;
    }

    public static PackageInfo getLoadedApp(Context context, PackageManager packageManager, String string2) {
        Context context2 = context;
        context = null;
        try {
            return context2.getPackageManager().getPackageInfo(string2, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return context;
        }
    }

    public static String getLoadedAppNameByPackageInfo(Context context, PackageManager packageManager, PackageInfo packageInfo) {
        if (packageManager == null) {
            packageManager = context.getPackageManager();
        }
        return packageManager.getApplicationLabel(packageInfo.applicationInfo).toString();
    }

    public static boolean isAppLoad(Context context, String string2) {
        if (string2 == null) {
            return false;
        }
        if (string2.equals(context.getPackageName())) {
            return true;
        }
        try {
            return context.getPackageManager().getPackageInfo(string2, 256) != null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return new File("/sdcard/Android/data/" + string2).exists();
        }
    }

    public static void uninstall(Context context, String string2) {
        Context context2;
        try {
            context2 = context;
            context = Uri.fromParts((String)"package", (String)string2, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        Intent intent = new Intent("android.intent.action.DELETE", (Uri)context);
        Intent intent2 = intent;
        intent.addFlags(0x10000000);
        context2.startActivity(intent2);
    }

    public static boolean openApp(Context context, String string2) {
        string2 = context.getPackageManager().getLaunchIntentForPackage(string2);
        if (string2 != null) {
            context.startActivity((Intent)string2);
            return true;
        }
        return false;
    }

    public static boolean isSystemApp(ApplicationInfo applicationInfo) {
        if ((applicationInfo.flags & 1) > 0) {
            return !applicationInfo.publicSourceDir.startsWith("data/dataapp") && !applicationInfo.publicSourceDir.startsWith("/data/dataapp");
            {
            }
        }
        return false;
    }

    public static String getAppSignatureMd5(Context context, String string2) {
        try {
            return Md5Utils.md5LowerCase(Arrays.toString(context.getPackageManager().getPackageInfo((String)string2, (int)64).signatures[0].toByteArray()));
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getAppSignatureSHA1(Context signatureArray) {
        signatureArray = signatureArray.getPackageManager().getPackageInfo((String)signatureArray.getPackageName(), (int)64).signatures;
        String string2 = null;
        int n5 = signatureArray.getPackageManager().getPackageInfo((String)signatureArray.getPackageName(), (int)64).signatures.length;
        for (int i5 = 0; i5 < n5; ++i5) {
            try {
                string2 = LoadAppUtils.getSignatureString(signatureArray[i5], "SHA1");
                continue;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return null;
            }
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static String getSignatureString(Signature object, String string2) {
        StringBuilder stringBuilder;
        String string3 = string2;
        object = object.toByteArray();
        string2 = "error!";
        Object object2 = MessageDigest.getInstance(string3);
        if (object2 == null) return string2;
        byte[] byArray = ((MessageDigest)object2).digest((byte[])object);
        object = byArray;
        object2 = stringBuilder;
        try {
            stringBuilder = new StringBuilder();
            int n5 = byArray.length;
            for (int i5 = 0; i5 < n5; ++i5) {
                ((StringBuilder)object2).append(Integer.toHexString(object[i5] & 0xFF | 0x100).substring(1, 3));
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        {
            continue;
        }
        return ((StringBuilder)object2).toString();
        noSuchAlgorithmException.printStackTrace();
        return string2;
    }

    private static String[] getPackageSignatures(Context object, String object2) {
        block7: {
            object = object.getPackageManager().getPackageArchiveInfo((String)object2, 64);
            if (object == null) break block7;
            object2 = object.signatures;
            if (object.signatures == null) break block7;
            if (((Signature[])object2).length <= 0) break block7;
            Context context = object;
            object = HashUtils.getHash(Arrays.toString(object2[0].toByteArray())).toLowerCase(Locale.ENGLISH);
            object2 = context.applicationInfo.packageName;
            try {
                return new String[]{object, object2};
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object parsePackage(String object, int n5) {
        File file;
        Exception exception2;
        Object t5;
        int n6;
        block11: {
            Object object2;
            File file2;
            DisplayMetrics displayMetrics;
            int n7;
            try {
                n6 = Build.VERSION.SDK_INT;
                t5 = n6 >= 21 ? ReflectUtils.getObjectConstructor("android.content.pm.PackageParser", new Class[0]).newInstance(null) : ReflectUtils.getObjectConstructor("android.content.pm.PackageParser", String.class).newInstance(object);
                n7 = n6;
            }
            catch (Exception exception2) {}
            DisplayMetrics displayMetrics2 = displayMetrics;
            new DisplayMetrics().setToDefaults();
            file = file2;
            file2 = new File((String)object);
            if (n7 >= 21) {
                object = n5;
                object2 = t5.getClass().getMethod("parsePackage", File.class, Integer.TYPE).invoke(t5, file, object);
            } else {
                Integer n8 = n5;
                object2 = object = t5.getClass().getMethod("parsePackage", File.class, String.class, DisplayMetrics.class, Integer.TYPE).invoke(t5, file, object, displayMetrics2, n8);
            }
            if (object != null) break block11;
            Log.d((String)TAG, (String)("---parsePackage is null------;;sourceFile=" + file.getAbsolutePath()));
            return null;
        }
        if (n6 >= 21) {
            Object object3 = object;
            Constable constable = ReflectUtils.classForName("android.content.pm.PackageParser$Package");
            Method method = t5.getClass().getDeclaredMethod("collectCertificates", new Class[]{constable, File.class, Integer.TYPE});
            method.setAccessible(true);
            constable = Integer.valueOf(1);
            method.invoke(t5, object, file, constable);
            return object3;
        }
        Object object4 = object;
        Constable constable = ReflectUtils.classForName("android.content.pm.PackageParser$Package");
        Class[] classArray = new Class[]{constable, Integer.TYPE};
        constable = Integer.valueOf(1);
        t5.getClass().getDeclaredMethod("collectCertificates", classArray).invoke(t5, object, constable);
        return object4;
        exception2.printStackTrace();
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getApkFileSignatureAndPackageName(Context var0, String var1_2) {
        block7: {
            try {
                var0 /* !! */  = LoadAppUtils.getPackageSignatures((Context)var0 /* !! */ , (String)var1_2 /* !! */ );
                if (var0 /* !! */  != null) {
                    return var0 /* !! */ ;
                }
            }
            catch (Exception var0_1) {
                break block7;
            }
            try {
                var0 /* !! */  = LoadAppUtils.parsePackage((String)var1_2 /* !! */ , 64);
            }
            catch (OutOfMemoryError v0) {
                return null;
            }
            if (var0 /* !! */  != null) ** GOTO lbl-1000
            return null;
lbl-1000:
            // 1 sources

            {
                var1_2 /* !! */  = LoadAppUtils.getApkSignature(var0 /* !! */ , (String)var1_2 /* !! */ );
                if (var1_2 /* !! */  == null) return null;
            }
            {
                if (var1_2 /* !! */ .length <= 0) return null;
                v1 /* !! */  = var0 /* !! */ ;
                var0 /* !! */  = HashUtils.getHash(Arrays.toString(var1_2 /* !! */ [0].toByteArray())).toLowerCase(Locale.ENGLISH);
                var1_2 /* !! */  = (String)ReflectUtils.getObjectFieldNoDeclared(ReflectUtils.getField(v1 /* !! */ , "applicationInfo"), "packageName");
                return new String[]{var0 /* !! */ , var1_2 /* !! */ };
            }
        }
        var0_1.printStackTrace();
        return null;
    }

    public static Signature[] getApkSignature(Object signatureArray, String string2) {
        block5: {
            NoSuchFieldException noSuchFieldException2;
            block6: {
                Signature[] signatureArray2 = signatureArray;
                signatureArray = new Signature[]{};
                try {
                    signatureArray = (Signature[])ReflectUtils.getField(signatureArray2, "mSignatures");
                    break block5;
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (NoSuchFieldException noSuchFieldException2) {
                    break block6;
                }
                illegalAccessException.printStackTrace();
                break block5;
            }
            noSuchFieldException2.printStackTrace();
        }
        if (signatureArray == null) {
            return null;
        }
        if (signatureArray.length <= 0) {
            return null;
        }
        return signatureArray;
    }

    public static String[] getApkFileSignatureAndPackageNameEx(Context object, String object2) {
        Exception exception2;
        block9: {
            block7: {
                block8: {
                    try {
                        object = LoadAppUtils.parsePackage((String)object2, 64);
                        if (object == null) break block7;
                    }
                    catch (Exception exception2) {}
                    object2 = (Signature[])ReflectUtils.getField(object, "mSignatures");
                    if (object2 == null) break block8;
                    if (((Signature[])object2).length == 0) break block8;
                    Object object3 = object;
                    object = HashUtils.getHash(Arrays.toString(object2[0].toByteArray())).toLowerCase(Locale.ENGLISH);
                    object2 = (String)ReflectUtils.getField(object3, "packageName");
                    return new String[]{object, object2};
                    break block9;
                }
                return null;
            }
            return null;
        }
        exception2.printStackTrace();
        return null;
    }

    public static boolean isValidAppPackageName(String string2) {
        return Pattern.compile("^[a-zA-Z_]\\w*(\\.[a-zA-Z_]\\w*)*$").matcher(string2).matches();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getApkFileLable(Context var0, String var1_2) {
        block25: {
            block27: {
                block26: {
                    var2_3 = "android.content.res.AssetManager";
                    try {
                        var3_5 = Class.forName("android.content.pm.PackageParser");
                        v0 = new Class[1];
                    }
                    catch (Exception var0_1) {
                        break block25;
                    }
                    var4_6 = v0;
                    {
                        v0[0] = String.class;
                        var5_7 = Build.VERSION.SDK_INT;
                        if (var5_7 < 21) break block26;
                    }
                    v1 = var3_5.getConstructor(null);
lbl13:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
                }
                v1 = var3_5.getConstructor((Class<?>)var4_6);
                ** while (true)
                var4_6 = v1;
                v2 = new Object[1];
                var6_9 /* !! */  = v2;
                {
                    v2[0] = var1_2 /* !! */ ;
                    var4_6 = var5_7 >= 21 ? var4_6.newInstance(null) : var4_6.newInstance((Object[])var6_9 /* !! */ );
                    v3 = var5_7;
                    Log.d((String)"DownloadUtils", (String)("pkgParser:" + var4_6.toString()));
                }
                var6_9 /* !! */  = v4;
                {
                    new DisplayMetrics().setToDefaults();
                    if (v3 < 21) ** GOTO lbl34
                    v5 = new Class[2];
                }
                var7_10 = v5;
                {
                    v5[0] = File.class;
                    v5[1] = Integer.TYPE;
                    ** GOTO lbl40
lbl34:
                    // 1 sources

                    v6 = new Class[4];
                }
                var7_10 = v6;
                {
                    v6[0] = File.class;
                    v6[1] = String.class;
                    v6[2] = DisplayMetrics.class;
                    v6[3] = Integer.TYPE;
lbl40:
                    // 2 sources

                    var3_5 = var3_5.getDeclaredMethod("parsePackage", (Class<?>[])var7_10);
                    if (var5_7 < 21) break block27;
                }
                var5_8 = v7;
                {
                    v7 = new File((String)var1_2 /* !! */ );
                    var6_9 /* !! */  = Integer.valueOf(0);
                    v8 = new Object[2];
                }
                var7_10 = v8;
                {
                    v8[0] = var5_8;
                    v8[1] = var6_9 /* !! */ ;
                    ** GOTO lbl61
                }
            }
            var5_8 = v9;
            {
                v9 = new File((String)var1_2 /* !! */ );
                var7_10 = 0;
                v10 = new Object[4];
            }
            var8_11 = v10;
            {
                v10[0] = var5_8;
                v10[1] = var1_2 /* !! */ ;
                v10[2] = var6_9 /* !! */ ;
                v10[3] = var7_10;
                var7_10 = var8_11;
lbl61:
                // 2 sources

                var3_5 = var3_5.invoke(var4_6, var7_10);
            }
            {
                v11 = (ApplicationInfo)var3_5.getClass().getDeclaredField("applicationInfo").get(var3_5);
            }
            var3_5 = v11;
            {
                v12 = var2_3;
                Log.d((String)"DownloadUtils", (String)("pkg:" + var3_5.packageName + " uid=" + var3_5.uid));
            }
            {
                var2_3 = Class.forName(v12);
            }
            {
                var3_5 = var2_3.getConstructor(null).newInstance(null);
            }
            {
                v13 = var0;
                v14 = var2_3;
                v15 = new Class[1];
            }
            var0 = v15;
            {
                v15[0] = String.class;
                v16 = v14.getDeclaredMethod("addAssetPath", (Class<?>)var0);
                v17 = var3_5;
                v18 = new Object[1];
            }
            var0 = v18;
            {
                v18[0] = var1_2 /* !! */ ;
                v16.invoke(v17, (Object[])var0);
            }
            {
                var0 = v13.getResources();
                var1_2 /* !! */  = var3_5.getClass();
                v19 = var0;
                var2_3 = v19.getDisplayMetrics().getClass();
                var4_6 = v19.getConfiguration().getClass();
                v20 = new Class[3];
            }
            var5_8 = v20;
            {
                v20[0] = var1_2 /* !! */ ;
                v20[1] = var2_3;
                v20[2] = var4_6;
                v21 = var0;
                var0 = v21.getDisplayMetrics();
                var1_2 /* !! */  = v21.getConfiguration();
                var0 = (Resources)Resources.class.getConstructor(var5_8).newInstance(new Object[]{var3_5, var0, var1_2 /* !! */ });
                var1_2 /* !! */  = null;
                var2_4 = v11.labelRes;
                if (var2_4 == 0) ** GOTO lbl99
            }
            {
                var1_2 /* !! */  = var0.getText(var2_4);
lbl99:
                // 2 sources

                v22 = var1_2 /* !! */ ;
                Log.d((String)"DownloadUtils", (String)("label=" + var1_2 /* !! */ ));
            }
            return v22.toString();
        }
        var0_1.printStackTrace();
        return "-1";
    }

    public static Intent getDataAndTypeIntent(Context context, String string2, String string3) {
        Intent intent;
        Intent intent2 = intent;
        new Intent().addFlags(0x10000000);
        intent2.setAction("android.intent.action.VIEW");
        if (Build.VERSION.SDK_INT >= 24) {
            Intent intent3 = intent2;
            context = FileProvider.getUriForFile((Context)context, (String)(context.getPackageName() + ".dc.fileprovider"), (File)new File(string2));
            intent3.addFlags(1);
            intent3.setDataAndType((Uri)context, string3);
            return intent3;
        }
        Intent intent4 = intent2;
        intent4.setDataAndType(Uri.fromFile((File)new File(string2)), string3);
        return intent4;
    }

    public static boolean startSecuritySettingPage(Context context) {
        if (LoadAppUtils.isVivoRom()) {
            return LoadAppUtils.startShortcutSettingsVivo(context);
        }
        if (LoadAppUtils.isEMUIRom()) {
            Context context2 = context;
            return LoadAppUtils.startShortcutSettingsEMUI(context2, context2.getPackageName());
        }
        Context context3 = context;
        return LoadAppUtils.startAppDetailSettings(context3, context3.getPackageName());
    }

    public static boolean isVivoRom() {
        Locale locale = Locale.ENGLISH;
        return Build.FINGERPRINT.toLowerCase(locale).contains("vivo") || Build.MODEL.toLowerCase(locale).contains("vivo");
        {
        }
    }

    public static boolean isEMUIRom() {
        return Build.MANUFACTURER.equalsIgnoreCase(MobilePhoneModel.HUAWEI);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean startShortcutSettingsVivo(Context context) {
        Intent intent;
        Exception exception2;
        block5: {
            Intent intent2;
            Context context2;
            try {
                context2 = context;
            }
            catch (Exception exception2) {}
            intent = intent2;
            new Intent("com.bbk.launcher.installshortcutpermission.open").setPackage("com.bbk.launcher2");
            if (context2 instanceof Activity) break block5;
            intent.setFlags(0x10000000);
        }
        context.startActivity(intent);
        return true;
        exception2.printStackTrace();
        return false;
    }

    private static boolean startAppDetailSettings(Context context, String string2) {
        return SafeCenter.goSafeCenter(context);
    }

    public static boolean startShortcutSettingsEMUI(Context context, String string2) {
        Intent intent;
        Intent intent2 = intent;
        intent = new Intent();
        if (!(context instanceof Activity)) {
            intent2.setFlags(0x10000000);
        }
        Intent intent3 = intent2;
        intent3.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent3.setData(Uri.fromParts((String)"package", (String)string2, null));
        context.startActivity(intent3);
        return true;
    }

    public static String getAppName(Context context) {
        int n5;
        Context context2;
        try {
            Context context3 = context;
            context2 = context3;
            n5 = context3.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).applicationInfo.labelRes;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return context2.getResources().getString(n5);
    }

    public static String getAppVersionName(Context object, String string2) {
        Context context = object;
        object = "";
        try {
            return context.getPackageManager().getPackageInfo((String)string2, (int)0).versionName;
        }
        catch (Exception exception) {
            return object;
        }
    }

    static class SafeCenter {
        private static ArrayList<Item> datas = new ArrayList();

        SafeCenter() {
        }

        static void init(Context object) {
            block18: {
                block16: {
                    Exception exception2;
                    JSONArray jSONArray;
                    String string2;
                    File file;
                    if (!datas.isEmpty()) break block18;
                    File file2 = file;
                    file = new File(object.getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS) + "/temp.j");
                    object = string2;
                    string2 = new String(IOUtil.toString(new FileInputStream(file2)));
                    file2 = jSONArray;
                    jSONArray = new JSONArray((String)object);
                    int n5 = 0;
                    while (true) {
                        block17: {
                            Item item;
                            try {
                                if (n5 >= file2.length()) break block16;
                            }
                            catch (Exception exception2) {}
                            Object object2 = file2.optJSONObject(n5);
                            String string3 = object2.optString("p");
                            if (TextUtils.isEmpty((CharSequence)string3)) break block17;
                            ArrayList<Item> arrayList = datas;
                            Item item2 = item;
                            Item item3 = item;
                            String string4 = string3;
                            JSONObject jSONObject = object2;
                            JSONObject jSONObject2 = jSONObject;
                            JSONObject jSONObject3 = jSONObject;
                            object2 = jSONObject.optString("c");
                            string3 = jSONObject3.optString("e");
                            String string5 = jSONObject2.optString("a");
                            item2(string4, (String)object2, string3, string5);
                            arrayList.add(item3);
                            break block17;
                            break;
                        }
                        ++n5;
                    }
                    exception2.printStackTrace();
                }
                if (datas.isEmpty()) {
                    datas.add(new Item("com.miui.securitycenter", "com.miui.permcenter.permissions.PermissionsEditorActivity", "extra_pkgname", null));
                    datas.add(new Item("com.miui.securitycenter", "com.miui.permcenter.permissions.AppPermissionsEditorActivity", "extra_pkgname", null));
                    datas.add(new Item("com.meizu.safe", "com.meizu.safe.security.AppSecActivity", "packageName", null));
                    datas.add(new Item("com.aliyun.mobile.permission", "com.aliyun.mobile.permission.ExternalAppDetailActivity", "packageName", null));
                    datas.add(new Item("com.iqoo.secure", "com.iqoo.secure.MainActivity", "packageName", null));
                    datas.add(new Item("com.sonymobile.cta", "com.sonymobile.cta.SomcCTAMainActivity", "package", null));
                    datas.add(new Item("com.mediatek.security", "com.mediatek.security.ui.PermissionControlPageActivity", "package", null));
                    datas.add(new Item("com.yulong.android.launcher3", "com.yulong.android.launcher3.LauncherSettingsActivity", "package", null));
                    datas.add(new Item("com.android.settings", "com.android.settings.Settings$ManageApplicationsActivity", "package", null));
                    datas.add(new Item(null, null, "package", "android.settings.MANAGE_APPLICATIONS_SETTINGS"));
                }
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static boolean goSafeCenter(Context var0) {
            block13: {
                block14: {
                    block12: {
                        try {
                            v0 = var0;
                            SafeCenter.init(v0);
                            var1_2 /* !! */  = v0.getPackageManager();
                            var2_3 = 0;
lbl6:
                            // 2 sources

                            while (var2_3 < SafeCenter.datas.size()) {
                                v1 = var1_2 /* !! */ ;
                                break block12;
                            }
                            return true;
                        }
                        catch (Exception var0_1) {
                            break block13;
                        }
                    }
                    var3_4 = v2;
                    {
                        v2 = new Intent();
                        var4_5 = SafeCenter.datas.get(var2_3);
                    }
                    {
                        try {
                            if (v1.getPackageInfo(var4_5.pname, 0) == null) break block14;
                        }
                        catch (PackageManager.NameNotFoundException v3) {}
                        if (TextUtils.isEmpty((CharSequence)var4_5.clsName)) ** GOTO lbl-1000
                        v4 = var4_5;
                        var1_2 /* !! */  = v4.pname;
                        v5 = var3_4.setClassName((String)var1_2 /* !! */ , v4.clsName);
                        ** GOTO lbl26
lbl-1000:
                        // 1 sources

                        {
                            if (!TextUtils.isEmpty((CharSequence)var4_5.pname)) {
                                v5 = var3_4.setPackage(var4_5.pname);
                            }
lbl26:
                            // 4 sources

                            if (TextUtils.isEmpty((CharSequence)var4_5.action)) ** GOTO lbl-1000
                            var3_4.setAction(var4_5.action);
                        }
lbl-1000:
                        // 2 sources

                        {
                            if (TextUtils.isEmpty((CharSequence)var4_5.extParamName)) ** GOTO lbl-1000
                            var1_2 /* !! */  = var4_5.extParamName;
                            var3_4.putExtra((String)var1_2 /* !! */ , var0.getPackageName());
                        }
lbl-1000:
                        // 2 sources

                        {
                            v6 = var0;
                            v7 = var3_4;
                            v8 = v7;
                            v7.setFlags(0x10000000);
                        }
                        {
                            v6.startActivity(v8);
                            Logger.e("Permission", "successful " + Build.MODEL + "intent=" + var3_4);
                            return true;
                        }
                    }
                }
                ++var2_3;
                ** GOTO lbl6
            }
            Logger.e("Permission", "Exception =" + var0_1);
            return false;
        }

        static class Item {
            String pname;
            String clsName;
            String extParamName;
            String action;

            Item(String string2, String string3, String string4, String string5) {
                this.pname = string2;
                this.clsName = string3;
                this.extParamName = string4;
                this.action = string5;
            }
        }
    }
}

