/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.common.util.emulator;

import android.content.Context;
import android.hardware.SensorManager;
import android.text.TextUtils;
import io.dcloud.common.util.emulator.CheckResult;
import io.dcloud.common.util.emulator.CommandUtil;
import java.io.File;
import java.util.Locale;

public class EmulatorCheckUtil {
    public static final int RESULT_MAYBE_EMULATOR = 0;
    public static final int RESULT_EMULATOR = 1;
    public static final int RESULT_UNKNOWN = 2;
    private static String[] known_pkgNames = new String[]{"sdcard/Android/data/com.bluestacks.home", "sdcard/Android/data/com.bluestacks.settings", "sdcard/Android/data/com.microvirt.guide", "sdcard/Android/data/com.microvirt.launcher2"};

    private EmulatorCheckUtil() {
    }

    public static final EmulatorCheckUtil getSingleInstance() {
        return SingletonHolder.INSTANCE;
    }

    private int getUserAppNum(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return 0;
        }
        return string2.split("package:").length;
    }

    private String getProperty(String string2) {
        String string3 = CommandUtil.getSingleInstance().getProperty(string2);
        if (TextUtils.isEmpty((CharSequence)string3)) {
            return null;
        }
        return string3;
    }

    private CheckResult checkFeaturesByHardware() {
        int n5;
        if ((this = ((EmulatorCheckUtil)this).getProperty("ro.hardware")) == null) {
            return new CheckResult(0, null);
        }
        String string2 = ((String)this).toLowerCase(Locale.ENGLISH);
        string2.getClass();
        int n6 = -1;
        switch (string2.hashCode()) {
            default: {
                break;
            }
            case 937844646: {
                if (!string2.equals("android_x86")) break;
                n6 = 6;
                break;
            }
            case 100361430: {
                if (!string2.equals("intel")) break;
                n6 = 5;
                break;
            }
            case 3613077: {
                if (!string2.equals("vbox")) break;
                n6 = 4;
                break;
            }
            case 3570999: {
                if (!string2.equals("ttvm")) break;
                n6 = 3;
                break;
            }
            case 109271: {
                if (!string2.equals("nox")) break;
                n6 = 2;
                break;
            }
            case -822798509: {
                if (!string2.equals("vbox86")) break;
                n6 = 1;
                break;
            }
            case -1367724016: {
                if (!string2.equals("cancro")) break;
                n6 = 0;
            }
        }
        switch (n6) {
            default: {
                n5 = 2;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n5 = 1;
            }
        }
        return new CheckResult(n5, (String)this);
    }

    /*
     * Enabled aggressive block sorting
     */
    private CheckResult checkFeaturesByFlavor() {
        int n5;
        if ((this = ((EmulatorCheckUtil)this).getProperty("ro.build.flavor")) == null) {
            return new CheckResult(0, null);
        }
        String string2 = ((String)this).toLowerCase(Locale.ENGLISH);
        if (!string2.contains("vbox") && !string2.contains("sdk_gphone")) {
            n5 = 2;
            return new CheckResult(n5, (String)this);
        }
        n5 = 1;
        return new CheckResult(n5, (String)this);
    }

    /*
     * Enabled aggressive block sorting
     */
    private CheckResult checkFeaturesByModel() {
        int n5;
        if ((this = ((EmulatorCheckUtil)this).getProperty("ro.product.model")) == null) {
            return new CheckResult(0, null);
        }
        String string2 = ((String)this).toLowerCase(Locale.ENGLISH);
        if (!(string2.contains("google_sdk") || string2.contains("emulator") || string2.contains("android sdk built for x86"))) {
            n5 = 2;
            return new CheckResult(n5, (String)this);
        }
        n5 = 1;
        return new CheckResult(n5, (String)this);
    }

    /*
     * Enabled aggressive block sorting
     */
    private CheckResult checkFeaturesByManufacturer() {
        int n5;
        if ((this = ((EmulatorCheckUtil)this).getProperty("ro.product.manufacturer")) == null) {
            return new CheckResult(0, null);
        }
        String string2 = ((String)this).toLowerCase(Locale.ENGLISH);
        if (!string2.contains("genymotion") && !string2.contains("netease")) {
            n5 = 2;
            return new CheckResult(n5, (String)this);
        }
        n5 = 1;
        return new CheckResult(n5, (String)this);
    }

    /*
     * Enabled aggressive block sorting
     */
    private CheckResult checkFeaturesByBoard() {
        int n5;
        if ((this = ((EmulatorCheckUtil)this).getProperty("ro.product.board")) == null) {
            return new CheckResult(0, null);
        }
        String string2 = ((String)this).toLowerCase(Locale.ENGLISH);
        if (!string2.contains("android") && !string2.contains("goldfish")) {
            n5 = 2;
            return new CheckResult(n5, (String)this);
        }
        n5 = 1;
        return new CheckResult(n5, (String)this);
    }

    private CheckResult checkFeaturesByPlatform() {
        if ((this = ((EmulatorCheckUtil)this).getProperty("ro.board.platform")) == null) {
            return new CheckResult(0, null);
        }
        int n5 = ((String)this).toLowerCase(Locale.ENGLISH).contains("android") ? 1 : 2;
        return new CheckResult(n5, (String)this);
    }

    private CheckResult checkFeaturesByBaseBand() {
        if ((this = ((EmulatorCheckUtil)this).getProperty("gsm.version.baseband")) == null) {
            return new CheckResult(0, null);
        }
        int n5 = ((String)this).contains("1.0.0.0") ? 1 : 2;
        return new CheckResult(n5, (String)this);
    }

    private int getSensorNumber(Context context) {
        return ((SensorManager)context.getSystemService("sensor")).getSensorList(-1).size();
    }

    private boolean supportCameraFlash(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.camera.flash");
    }

    private boolean supportBluetooth(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.bluetooth");
    }

    private boolean hasLightSensor(Context context) {
        return ((SensorManager)context.getSystemService("sensor")).getDefaultSensor(5) != null;
    }

    public static CheckResult checkPkgNameForEmulator() {
        int n5 = 2;
        int n6 = 0;
        int n7 = 0;
        while (true) {
            Object object = known_pkgNames;
            if (n7 >= known_pkgNames.length) break;
            if (new File((String)(object = object[n7])).exists()) {
                ++n6;
            } else {
                n5 = 0;
            }
            if (n6 > 2) break;
            ++n7;
        }
        if (n6 != 1) {
            if (n6 == 2) {
                n5 = 1;
            }
        } else {
            n5 = 0;
        }
        return new CheckResult(n5, "PkgName");
    }

    public boolean emulatorCheck(Context context) {
        if (context != null) {
            int n5 = 0;
            int n6 = this.checkFeaturesByHardware().result;
            if (n6 != 0) {
                if (n6 == 1) {
                    return true;
                }
            } else {
                n5 = 1;
            }
            n6 = EmulatorCheckUtil.checkPkgNameForEmulator().result;
            if (n6 != 0) {
                if (n6 == 1) {
                    return true;
                }
            } else {
                ++n5;
            }
            n6 = this.checkFeaturesByFlavor().result;
            if (n6 != 0) {
                if (n6 == 1) {
                    return true;
                }
            } else {
                ++n5;
            }
            n6 = this.checkFeaturesByModel().result;
            if (n6 != 0) {
                if (n6 == 1) {
                    return true;
                }
            } else {
                ++n5;
            }
            n6 = this.checkFeaturesByManufacturer().result;
            if (n6 != 0) {
                if (n6 == 1) {
                    return true;
                }
            } else {
                ++n5;
            }
            n6 = this.checkFeaturesByBoard().result;
            if (n6 != 0) {
                if (n6 == 1) {
                    return true;
                }
            } else {
                ++n5;
            }
            n6 = this.checkFeaturesByPlatform().result;
            if (n6 != 0) {
                if (n6 == 1) {
                    return true;
                }
            } else {
                ++n5;
            }
            n6 = this.checkFeaturesByBaseBand().result;
            if (n6 != 0) {
                if (n6 == 1) {
                    return true;
                }
            } else {
                n5 += 2;
            }
            if (this.getSensorNumber(context) <= 7) {
                ++n5;
            }
            if (!this.supportCameraFlash(context)) {
                ++n5;
            }
            if (!this.supportBluetooth(context)) {
                ++n5;
            }
            if (!this.hasLightSensor(context)) {
                ++n5;
            }
            return n5 > 3;
        }
        throw new IllegalArgumentException("context must not be null");
    }

    private static class SingletonHolder {
        private static final EmulatorCheckUtil INSTANCE = new EmulatorCheckUtil();

        private SingletonHolder() {
        }
    }
}

