/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.audio;

import android.content.Context;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.PlaybackParams;
import android.net.Uri;
import android.os.Build;
import android.provider.MediaStore;
import io.dcloud.application.DCLoudApplicationImpl;
import io.dcloud.base.R;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.IEventCallback;
import io.dcloud.common.DHInterface.ISysEventListener;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.constant.DOMException;
import io.dcloud.common.util.FileUtil;
import io.dcloud.common.util.JSONUtil;
import io.dcloud.common.util.JSUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.feature.audio.AbsAudio;
import java.io.File;
import java.io.FileDescriptor;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class AudioPlayer
extends AbsAudio
implements ISysEventListener,
IEventCallback {
    private IWebview mWebview;
    private IApp _app;
    String mFunId;
    private MediaPlayer mMediaPlayer;
    private Map<String, String> events;
    private JSONObject params;
    private int bufferPercent;
    private int startTime;
    private String mSrcPath;
    private float volume;
    private boolean autoplay;
    private boolean isCanMix;
    private boolean needPause;
    private AudioManager mAudioMgr;
    private AudioManager.OnAudioFocusChangeListener mAudioFocusChangeListener;
    private boolean isPrepared;
    private boolean isPlay;
    private boolean isCanplay;
    private boolean isStoped;

    private AudioPlayer(JSONObject jSONObject, IWebview iWebview) {
        HashMap hashMap;
        MediaPlayer mediaPlayer;
        AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener;
        IWebview iWebview2 = iWebview;
        this.bufferPercent = 0;
        this.startTime = Integer.MIN_VALUE;
        this.mSrcPath = "";
        this.volume = 1.0f;
        this.autoplay = false;
        this.isCanMix = false;
        this.needPause = false;
        Object object = onAudioFocusChangeListener;
        onAudioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

            public void onAudioFocusChange(int n5) {
                if (n5 != -1 && n5 != -2 && n5 != -3) {
                    return;
                }
                if (!AudioPlayer.this.needPause) {
                    AudioPlayer.this.pause();
                    return;
                }
            }
        };
        this.mAudioFocusChangeListener = object;
        this.isPrepared = false;
        this.isPlay = false;
        this.isCanplay = false;
        this.isStoped = false;
        object = mediaPlayer;
        mediaPlayer = new MediaPlayer();
        this.mMediaPlayer = object;
        object = hashMap;
        hashMap = new HashMap();
        this.events = object;
        this.params = jSONObject;
        this.mWebview = iWebview;
        this.addListener();
        this._app = iWebview2.obtainFrameView().obtainApp();
        iWebview2.obtainFrameView().addFrameViewListener(this);
        this._app.registerSysEventListener(this, ISysEventListener.SysEventType.onStop);
        this.setStyle(this.params);
    }

    private void requestAudioFocus() {
        AudioManager audioManager;
        if (this.mAudioMgr == null) {
            this.mAudioMgr = (AudioManager)this.mWebview.getActivity().getSystemService("audio");
        }
        if ((audioManager = this.mAudioMgr) != null) {
            audioManager.requestAudioFocus(this.mAudioFocusChangeListener, 3, 1);
            return;
        }
    }

    private void addListener() {
        AudioPlayer audioPlayer = this;
        audioPlayer.mMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mediaPlayer) {
                AudioPlayer.this.execEvents("canplay", "");
            }
        });
        audioPlayer.mMediaPlayer.setOnSeekCompleteListener(new MediaPlayer.OnSeekCompleteListener(){

            public void onSeekComplete(MediaPlayer mediaPlayer) {
                AudioPlayer.this.execEvents("seeked", "");
            }
        });
        audioPlayer.mMediaPlayer.setOnBufferingUpdateListener(new MediaPlayer.OnBufferingUpdateListener(){

            public void onBufferingUpdate(MediaPlayer mediaPlayer, int n5) {
                AudioPlayer.access$102(AudioPlayer.this, n5);
            }
        });
        audioPlayer.mMediaPlayer.setOnInfoListener(new MediaPlayer.OnInfoListener(){

            public boolean onInfo(MediaPlayer mediaPlayer, int n5, int n6) {
                if (n5 != 701) {
                    if (n5 == 702 && mediaPlayer.isPlaying()) {
                        AudioPlayer.this.execEvents("play", "");
                    }
                } else {
                    AudioPlayer.this.execEvents("waiting", "");
                }
                return false;
            }
        });
        audioPlayer.mMediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mediaPlayer, int n5, int n6) {
                int n7 = 0;
                String string2 = null;
                if (n5 != 1) {
                    if (n5 == 100) {
                        n7 = 1303;
                        string2 = AudioPlayer.this.mWebview.getContext().getString(R.string.dcloud_audio_abnormal_rebuild);
                    }
                } else {
                    n7 = -99;
                    string2 = DOMException.MSG_UNKNOWN_ERROR;
                }
                if (n6 != -1010) {
                    if (n6 != -1007) {
                        if (n6 != -1004) {
                            if (n6 == -110) {
                                n7 = -1302;
                                string2 = DOMException.MSG_AUDIO_ERROR_TIMED_OUT;
                            }
                        } else {
                            n7 = -5;
                            string2 = "IO Error";
                        }
                    } else {
                        n7 = -1301;
                        string2 = DOMException.MSG_AUDIO_ERROR_MALFORMED;
                    }
                } else {
                    n7 = -3;
                    string2 = DOMException.MSG_NOT_SUPPORT;
                }
                if (n7 != 0) {
                    6 v02 = this;
                    v02.AudioPlayer.this.failCallback(n7, string2);
                    v02.AudioPlayer.this.execEvents("error", DOMException.toJSON(n7, string2));
                }
                return true;
            }
        });
        audioPlayer.mMediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mediaPlayer) {
                AudioPlayer.this.execEvents("ended", "");
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setSrc(String object) {
        Exception exception2;
        block15: {
            block12: {
                boolean bl;
                block16: {
                    block13: {
                        block14: {
                            File file;
                            Context context;
                            try {
                                if (((String)object).startsWith("content://")) {
                                    object = Uri.parse((String)object);
                                    this.mMediaPlayer.setDataSource((Context)this.mWebview.getActivity(), (Uri)object);
                                    break block12;
                                }
                                bl = false;
                                if (PdrUtil.isNetPath((String)object)) break block13;
                                AudioPlayer audioPlayer = this;
                                object = audioPlayer._app.checkPrivateDirAndCopy2Temp((String)object);
                                object = audioPlayer._app.convert2AbsFullPath(this.mWebview.obtainFullUrl(), (String)object);
                                context = DCLoudApplicationImpl.self().getContext();
                                if (!FileUtil.needMediaStoreOpenFile(context) || FileUtil.checkPrivatePath(context, (String)object)) break block14;
                            }
                            catch (Exception exception2) {
                                break block15;
                            }
                            File file2 = file;
                            if (!new File((String)object).exists() || (context = FileUtil.getFileUri(context, file2, MediaStore.Audio.Media.EXTERNAL_CONTENT_URI)) == null) break block14;
                            this.mMediaPlayer.setDataSource((Context)this.mWebview.getActivity(), (Uri)context);
                            bl = true;
                        }
                        if (!bl) {
                            Object object2;
                            if (((String)object).startsWith("/android_asset/")) {
                                object2 = ((String)object).replace("/android_asset/", "");
                            } else if (((String)object).startsWith("android_asset/")) {
                                object2 = object = ((String)object).replace("android_asset/", "");
                            }
                            if (!PdrUtil.isDeviceRootDir((String)object)) {
                                AudioPlayer audioPlayer = this;
                                Object object3 = object = audioPlayer.mWebview.getActivity().getAssets().openFd((String)object);
                                object = object3.getFileDescriptor();
                                long l5 = object3.getStartOffset();
                                long l6 = object3.getLength();
                                audioPlayer.mMediaPlayer.setDataSource((FileDescriptor)object, l5, l6);
                                audioPlayer.isCanplay = false;
                                audioPlayer.mMediaPlayer.prepareAsync();
                                return;
                            }
                        }
                        break block16;
                    }
                    object = URLDecoder.decode((String)object, "utf-8");
                }
                if (!bl) {
                    AudioPlayer audioPlayer = this;
                    audioPlayer.mMediaPlayer.reset();
                    audioPlayer.mMediaPlayer.setDataSource((String)object);
                }
            }
            this.isCanplay = false;
            this.mMediaPlayer.prepareAsync();
            return;
        }
        this.stop();
        this.failCallback(-5, exception2.getMessage());
        this.execEvents("error", DOMException.toJSON(-5, exception2.getMessage()));
    }

    static AudioPlayer createAudioPlayer(JSONObject jSONObject, IWebview iWebview) {
        return new AudioPlayer(jSONObject, iWebview);
    }

    private void successCallback() {
        JSUtil.excCallbackSuccess(this.mWebview, this.mFunId, "");
    }

    private void startPlay() {
        AudioPlayer audioPlayer = this;
        audioPlayer.requestAudioFocus();
        audioPlayer.isPrepared = true;
        audioPlayer.mMediaPlayer.start();
        audioPlayer.setSpeed();
        audioPlayer.execEvents("play", "");
        audioPlayer.isPlay = false;
    }

    private void setSpeed() {
        block7: {
            float f5;
            float f6;
            JSONObject jSONObject = audioPlayer2.params;
            if (jSONObject == null) break block7;
            try {
                f6 = Float.parseFloat(jSONObject.optString("playbackRate"));
            }
            catch (Exception exception) {}
            if (!(f5 > 0.0f)) break block7;
            MediaPlayer mediaPlayer = audioPlayer2.mMediaPlayer;
            if (mediaPlayer == null) break block7;
            if (Build.VERSION.SDK_INT < 23) break block7;
            AudioPlayer audioPlayer = audioPlayer2;
            AudioPlayer audioPlayer2 = mediaPlayer.getPlaybackParams();
            audioPlayer2.setSpeed(f6);
            audioPlayer.mMediaPlayer.setPlaybackParams((PlaybackParams)audioPlayer2);
            return;
        }
    }

    static /* synthetic */ int access$102(AudioPlayer audioPlayer, int n5) {
        audioPlayer.bufferPercent = n5;
        return n5;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setStyle(JSONObject var1_1) {
        block15: {
            block13: {
                block14: {
                    var2_4 = var1_1.optString("src");
                    if (!PdrUtil.isEmpty(var2_4)) {
                        if (PdrUtil.isEmpty(this.mSrcPath)) {
                            this.mMediaPlayer.reset();
                            this.setSrc(var2_4);
                        } else if (!var2_4.equals(this.mSrcPath)) {
                            this.mMediaPlayer.reset();
                            this.setSrc(var2_4);
                        }
                    }
                    JSONUtil.combinJSONObject(this.params, var1_1);
                    this.mSrcPath = var1_1.optString("src");
                    this.mMediaPlayer.setLooping(this.params.optBoolean("loop"));
                    try {
                        var1_2 = Float.parseFloat(this.params.optString("volume", "1"));
                        this.volume = var1_2;
                    }
                    catch (Exception v0) {}
                    if (!(v1 < 0.0f)) break block14;
                    this.volume = 0.0f;
                    ** GOTO lbl26
                }
                if (!(var1_2 > 1.0f)) ** GOTO lbl26
                this.volume = 1.0f;
lbl26:
                // 3 sources

                v2 = this.volume;
                this.mMediaPlayer.setVolume(v2, v2);
                if (!this.params.has("startTime")) break block13;
                v3 = this.params.optInt("startTime");
                this.startTime = v3 * 1000;
                break block15;
            }
            this.autoplay = this.params.optBoolean("autoplay", false);
        }
        try {
            var1_3 = Float.parseFloat(this.params.optString("playbackRate"));
        }
        catch (Exception v4) {}
        if (!(v5 > 0.0f)) return;
        this.playbackRate(var1_3);
        return;
    }

    String getStyles(String string2) {
        if (PdrUtil.isEmpty(string2)) {
            return JSUtil.wrapJsVar(((AudioPlayer)object).params);
        }
        String string3 = string2;
        string3.getClass();
        int n5 = -1;
        switch (string3.hashCode()) {
            default: {
                break;
            }
            case 1439562083: {
                if (!string2.equals("autoplay")) break;
                n5 = 5;
                break;
            }
            case 1355420059: {
                if (!string2.equals("playbackRate")) break;
                n5 = 4;
                break;
            }
            case 3327652: {
                if (!string2.equals("loop")) break;
                n5 = 3;
                break;
            }
            case 114148: {
                if (!string2.equals("src")) break;
                n5 = 2;
                break;
            }
            case -810883302: {
                if (!string2.equals("volume")) break;
                n5 = 1;
                break;
            }
            case -2129294769: {
                if (!string2.equals("startTime")) break;
                n5 = 0;
            }
        }
        switch (n5) {
            default: {
                if (((AudioPlayer)object).params.has(string2)) {
                    return JSUtil.wrapJsVar(((AudioPlayer)object).params.optString(string2));
                }
                return JSUtil.wrapJsVar("undefined", false);
            }
            case 5: {
                Object object = ((AudioPlayer)object).params.optBoolean("autoplay", false);
                break;
            }
            case 4: {
                Object object;
                if (Build.VERSION.SDK_INT >= 23) {
                    object = Float.valueOf(((AudioPlayer)object).mMediaPlayer.getPlaybackParams().getSpeed());
                    break;
                }
                object = 1;
                break;
            }
            case 3: {
                Object object = ((AudioPlayer)object).mMediaPlayer.isLooping();
                break;
            }
            case 2: {
                Object object = ((AudioPlayer)object).mSrcPath;
                break;
            }
            case 1: {
                Object object = Float.valueOf(((AudioPlayer)object).volume);
                break;
            }
            case 0: {
                int n6 = ((AudioPlayer)object).startTime;
                Object object = n6 < 0 ? (((AudioPlayer)object).params.has("startTime") ? ((AudioPlayer)object).params.optInt("startTime") : 0) : n6 / 1000;
            }
        }
        if (object != null) {
            return JSUtil.wrapJsVar(object.toString());
        }
        return JSUtil.wrapJsVar("undefined", false);
    }

    public void setParams(JSONObject jSONObject) {
        this.params = jSONObject;
    }

    void failCallback(int n5, String string2) {
        String string3 = DOMException.toJSON(n5, string2);
        JSUtil.excCallbackError(this.mWebview, this.mFunId, string3, true);
    }

    void play() {
        block7: {
            if (this.isStoped && !this.mMediaPlayer.isPlaying()) {
                try {
                    this.mMediaPlayer.prepareAsync();
                    this.isStoped = false;
                }
                catch (Exception exception) {
                    AudioPlayer audioPlayer = this;
                    audioPlayer.mSrcPath = "";
                    audioPlayer.setStyle(audioPlayer.params);
                    audioPlayer.isStoped = false;
                }
            }
            this.isPrepared = false;
            this.isPlay = true;
            if (!this.isCanplay) break block7;
            try {
                this.startPlay();
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IllegalStateException illegalStateException) {
                illegalStateException.printStackTrace();
                this.destory();
                this.failCallback(-1, ((Object)illegalStateException).toString());
                this.execEvents("error", DOMException.toJSON(-1, illegalStateException.getMessage()));
            }
        }
    }

    void pause() {
        this.autoplay = false;
        try {
            this.mMediaPlayer.pause();
        }
        catch (Exception exception) {}
        this.execEvents("pause", "");
    }

    void resume() {
        AudioPlayer audioPlayer = this;
        audioPlayer.requestAudioFocus();
        audioPlayer.mMediaPlayer.start();
        audioPlayer.setSpeed();
    }

    void stop() {
        MediaPlayer mediaPlayer = this.mMediaPlayer;
        if (mediaPlayer != null) {
            mediaPlayer.stop();
            this.isStoped = true;
            this.isCanplay = false;
            this.execEvents("stop", "");
            return;
        }
    }

    void destory() {
        MediaPlayer mediaPlayer = this.mMediaPlayer;
        if (mediaPlayer != null) {
            AudioPlayer audioPlayer = this;
            mediaPlayer.stop();
            audioPlayer.mMediaPlayer.release();
            audioPlayer.mWebview.obtainFrameView().removeFrameViewListener(this);
            audioPlayer.mWebview.obtainFrameView().obtainApp().unregisterSysEventListener(this, ISysEventListener.SysEventType.onStop);
            audioPlayer.mMediaPlayer = null;
            mediaPlayer = audioPlayer.mAudioMgr;
            if (mediaPlayer != null) {
                mediaPlayer.abandonAudioFocus(this.mAudioFocusChangeListener);
            }
            this.mAudioMgr = null;
            return;
        }
    }

    void seekTo(int n5) {
        AudioPlayer audioPlayer = this;
        audioPlayer.mMediaPlayer.seekTo(n5);
        audioPlayer.execEvents("seeking", "");
    }

    String getBuffer() {
        int n5 = -1;
        MediaPlayer mediaPlayer = this.mMediaPlayer;
        if (mediaPlayer != null) {
            n5 = this.bufferPercent * mediaPlayer.getDuration() / 100;
        }
        return JSUtil.wrapJsVar(PdrUtil.int2DecimalStr(n5, 1000), false);
    }

    String isPause() {
        boolean bl = true;
        MediaPlayer mediaPlayer = this.mMediaPlayer;
        if (mediaPlayer != null) {
            bl = mediaPlayer.isPlaying() ^ true;
        }
        return JSUtil.wrapJsVar(bl);
    }

    String getVolume() {
        return JSUtil.wrapJsVar(this.volume);
    }

    String getDuration() {
        AudioPlayer audioPlayer = audioPlayer.mMediaPlayer;
        if (audioPlayer != null) {
            int n5 = audioPlayer.getDuration();
            if (n5 < 0) {
                return JSUtil.wrapJsVar("undefined", false);
            }
            return JSUtil.wrapJsVar(PdrUtil.int2DecimalStr(n5, 1000), false);
        }
        return JSUtil.wrapJsVar("undefined", false);
    }

    String getPosition() {
        return JSUtil.wrapJsVar(PdrUtil.int2DecimalStr(this.mMediaPlayer.getCurrentPosition(), 1000), false);
    }

    public boolean isCanMix() {
        return this.isCanMix;
    }

    public void setCanMix(boolean bl) {
        this.needPause = bl;
    }

    void setSessionCategory(String string2) {
        MediaPlayer mediaPlayer;
        if (!PdrUtil.isEmpty(string2) && (mediaPlayer = this.mMediaPlayer) != null && !mediaPlayer.isPlaying()) {
            this.isCanMix = string2.equals("ambient");
            return;
        }
    }

    void addEventListener(String string2, String string3) {
        this.events.put(string2, string3);
    }

    void removeEventListener(String string2) {
        this.events.remove(string2);
    }

    void execEvents(String string2, String string3) {
        String string4 = this.events.get(string2);
        if (!PdrUtil.isEmpty(string4)) {
            int n5 = JSUtil.OK;
            boolean bl = PdrUtil.isEmpty(string3) ^ true;
            JSUtil.execCallback(this.mWebview, string4, string3, n5, bl, true);
        }
        String string5 = string2;
        string5.getClass();
        if (!string5.equals("ended")) {
            if (string2.equals("canplay")) {
                int n6;
                this.isCanplay = true;
                if (this.autoplay) {
                    this.play();
                }
                if (this.isPlay) {
                    this.startPlay();
                }
                if ((n6 = this.startTime) != Integer.MIN_VALUE) {
                    this.mMediaPlayer.seekTo(n6);
                    return;
                }
            }
            return;
        }
        AudioPlayer audioPlayer = this;
        audioPlayer.pause();
        audioPlayer.successCallback();
    }

    @Override
    public Object onCallBack(String string2, Object object) {
        if ((PdrUtil.isEquals(string2, "window_close") || PdrUtil.isEquals(string2, "close")) && object instanceof IWebview) {
            this.destory();
        }
        return null;
    }

    @Override
    public boolean onExecute(ISysEventListener.SysEventType sysEventType, Object object) {
        if (sysEventType == ISysEventListener.SysEventType.onStop) {
            this.destory();
        }
        return false;
    }

    public void playbackRate(float f5) {
        double d6;
        String string2;
        JSONObject jSONObject;
        if (this.params == null) {
            JSONObject jSONObject2;
            JSONObject jSONObject3 = jSONObject2;
            jSONObject2 = new JSONObject();
            this.params = jSONObject3;
        }
        try {
            jSONObject = this.params;
            string2 = "playbackRate";
            d6 = f5;
        }
        catch (JSONException jSONException) {}
        jSONObject.put(string2, d6);
        MediaPlayer mediaPlayer = this.mMediaPlayer;
        if (mediaPlayer != null && mediaPlayer.isPlaying()) {
            this.setSpeed();
        }
    }
}

