/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.dcloudimageloader.core;

import android.graphics.Bitmap;
import android.os.Handler;
import com.nostra13.dcloudimageloader.cache.disc.DiscCacheAware;
import com.nostra13.dcloudimageloader.core.DisplayBitmapTask;
import com.nostra13.dcloudimageloader.core.DisplayImageOptions;
import com.nostra13.dcloudimageloader.core.ImageLoaderConfiguration;
import com.nostra13.dcloudimageloader.core.ImageLoaderEngine;
import com.nostra13.dcloudimageloader.core.ImageLoadingInfo;
import com.nostra13.dcloudimageloader.core.assist.FailReason;
import com.nostra13.dcloudimageloader.core.assist.ImageLoadingListener;
import com.nostra13.dcloudimageloader.core.assist.ImageScaleType;
import com.nostra13.dcloudimageloader.core.assist.ImageSize;
import com.nostra13.dcloudimageloader.core.assist.LoadedFrom;
import com.nostra13.dcloudimageloader.core.assist.ViewScaleType;
import com.nostra13.dcloudimageloader.core.decode.ImageDecoder;
import com.nostra13.dcloudimageloader.core.decode.ImageDecodingInfo;
import com.nostra13.dcloudimageloader.core.download.ImageDownloader;
import com.nostra13.dcloudimageloader.core.imageaware.ImageAware;
import com.nostra13.dcloudimageloader.utils.IoUtils;
import com.nostra13.dcloudimageloader.utils.L;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

final class LoadAndDisplayImageTask
implements Runnable {
    private static final String LOG_WAITING_FOR_RESUME = "ImageLoader is paused. Waiting...  [%s]";
    private static final String LOG_RESUME_AFTER_PAUSE = ".. Resume loading [%s]";
    private static final String LOG_DELAY_BEFORE_LOADING = "Delay %d ms before loading...  [%s]";
    private static final String LOG_START_DISPLAY_IMAGE_TASK = "Start display image task [%s]";
    private static final String LOG_WAITING_FOR_IMAGE_LOADED = "Image already is loading. Waiting... [%s]";
    private static final String LOG_GET_IMAGE_FROM_MEMORY_CACHE_AFTER_WAITING = "...Get cached bitmap from memory after waiting. [%s]";
    private static final String LOG_LOAD_IMAGE_FROM_NETWORK = "Load image from network [%s]";
    private static final String LOG_LOAD_IMAGE_FROM_DISC_CACHE = "Load image from disc cache [%s]";
    private static final String LOG_PREPROCESS_IMAGE = "PreProcess image before caching in memory [%s]";
    private static final String LOG_POSTPROCESS_IMAGE = "PostProcess image before displaying [%s]";
    private static final String LOG_CACHE_IMAGE_IN_MEMORY = "Cache image in memory [%s]";
    private static final String LOG_CACHE_IMAGE_ON_DISC = "Cache image on disc [%s]";
    private static final String LOG_PROCESS_IMAGE_BEFORE_CACHE_ON_DISC = "Process image before cache on disc [%s]";
    private static final String LOG_TASK_CANCELLED_IMAGEAWARE_REUSED = "ImageAware is reused for another image. Task is cancelled. [%s]";
    private static final String LOG_TASK_CANCELLED_IMAGEAWARE_COLLECTED = "ImageAware was collected by GC. Task is cancelled. [%s]";
    private static final String LOG_TASK_INTERRUPTED = "Task was interrupted [%s]";
    private static final String ERROR_PRE_PROCESSOR_NULL = "Pre-processor returned null [%s]";
    private static final String ERROR_POST_PROCESSOR_NULL = "Pre-processor returned null [%s]";
    private static final String ERROR_PROCESSOR_FOR_DISC_CACHE_NULL = "Bitmap processor for disc cache returned null [%s]";
    private static final int BUFFER_SIZE = 32768;
    private final ImageLoaderEngine engine;
    private final ImageLoadingInfo imageLoadingInfo;
    private final Handler handler;
    private final ImageLoaderConfiguration configuration;
    private final ImageDownloader downloader;
    private final ImageDownloader networkDeniedDownloader;
    private final ImageDownloader slowNetworkDownloader;
    private final ImageDecoder decoder;
    private final boolean writeLogs;
    final String uri;
    private final String memoryCacheKey;
    final ImageAware imageAware;
    private final ImageSize targetSize;
    final DisplayImageOptions options;
    final ImageLoadingListener listener;
    private LoadedFrom loadedFrom = LoadedFrom.NETWORK;
    private boolean imageAwareCollected = false;

    public LoadAndDisplayImageTask(ImageLoaderEngine engine, ImageLoadingInfo imageLoadingInfo, Handler handler) {
        this.engine = engine;
        this.imageLoadingInfo = imageLoadingInfo;
        this.handler = handler;
        this.configuration = engine.configuration;
        this.downloader = this.configuration.downloader;
        this.networkDeniedDownloader = this.configuration.networkDeniedDownloader;
        this.slowNetworkDownloader = this.configuration.slowNetworkDownloader;
        this.decoder = this.configuration.decoder;
        this.writeLogs = this.configuration.writeLogs;
        this.uri = imageLoadingInfo.uri;
        this.memoryCacheKey = imageLoadingInfo.memoryCacheKey;
        this.imageAware = imageLoadingInfo.imageAware;
        this.targetSize = imageLoadingInfo.targetSize;
        this.options = imageLoadingInfo.options;
        this.listener = imageLoadingInfo.listener;
    }

    @Override
    public void run() {
        if (!this.waitIfPaused() && !this.delayIfNeed()) {
            Bitmap bmp;
            ReentrantLock loadFromUriLock = this.imageLoadingInfo.loadFromUriLock;
            this.log(LOG_START_DISPLAY_IMAGE_TASK);
            if (loadFromUriLock.isLocked()) {
                this.log(LOG_WAITING_FOR_IMAGE_LOADED);
            }
            loadFromUriLock.lock();
            try {
                if (this.checkTaskIsNotActual()) {
                    return;
                }
                bmp = this.configuration.memoryCache.get(this.memoryCacheKey);
                if (bmp == null) {
                    bmp = this.tryLoadBitmap();
                    if (this.imageAwareCollected) {
                        return;
                    }
                    if (bmp == null) {
                        return;
                    }
                    if (this.checkTaskIsNotActual() || this.checkTaskIsInterrupted()) {
                        return;
                    }
                    if (this.options.shouldPreProcess()) {
                        this.log(LOG_PREPROCESS_IMAGE);
                        bmp = this.options.getPreProcessor().process(bmp);
                        if (bmp == null) {
                            L.e("Pre-processor returned null [%s]", new Object[0]);
                        }
                    }
                    if (bmp != null && this.options.isCacheInMemory()) {
                        this.log(LOG_CACHE_IMAGE_IN_MEMORY);
                        this.configuration.memoryCache.put(this.memoryCacheKey, bmp);
                    }
                } else {
                    this.loadedFrom = LoadedFrom.MEMORY_CACHE;
                    this.log(LOG_GET_IMAGE_FROM_MEMORY_CACHE_AFTER_WAITING);
                }
                if (bmp != null && this.options.shouldPostProcess()) {
                    this.log(LOG_POSTPROCESS_IMAGE);
                    bmp = this.options.getPostProcessor().process(bmp);
                    if (bmp == null) {
                        L.e("Pre-processor returned null [%s]", this.memoryCacheKey);
                    }
                }
            }
            finally {
                loadFromUriLock.unlock();
            }
            if (!this.checkTaskIsNotActual() && !this.checkTaskIsInterrupted()) {
                DisplayBitmapTask displayBitmapTask = new DisplayBitmapTask(bmp, this.imageLoadingInfo, this.engine, this.loadedFrom);
                displayBitmapTask.setLoggingEnabled(this.writeLogs);
                if (this.options.isSyncLoading()) {
                    displayBitmapTask.run();
                } else {
                    this.handler.post((Runnable)displayBitmapTask);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitIfPaused() {
        AtomicBoolean pause;
        AtomicBoolean atomicBoolean = pause = this.engine.getPause();
        synchronized (atomicBoolean) {
            if (pause.get()) {
                this.log(LOG_WAITING_FOR_RESUME);
                try {
                    pause.wait();
                }
                catch (InterruptedException var5) {
                    L.e(LOG_TASK_INTERRUPTED, this.memoryCacheKey);
                    return true;
                }
                this.log(LOG_RESUME_AFTER_PAUSE);
            }
        }
        return this.checkTaskIsNotActual();
    }

    private boolean delayIfNeed() {
        if (this.options.shouldDelayBeforeLoading()) {
            this.log(LOG_DELAY_BEFORE_LOADING, this.options.getDelayBeforeLoading(), this.memoryCacheKey);
            try {
                Thread.sleep(this.options.getDelayBeforeLoading());
            }
            catch (InterruptedException var2) {
                L.e(LOG_TASK_INTERRUPTED, this.memoryCacheKey);
                return true;
            }
            return this.checkTaskIsNotActual();
        }
        return false;
    }

    private boolean checkTaskIsNotActual() {
        return this.checkViewCollected() || this.checkViewReused();
    }

    private boolean checkViewCollected() {
        if (this.imageAware.isCollected()) {
            this.imageAwareCollected = true;
            this.log(LOG_TASK_CANCELLED_IMAGEAWARE_COLLECTED);
            this.fireCancelEvent();
            return true;
        }
        return false;
    }

    private boolean checkViewReused() {
        boolean imageAwareWasReused;
        String currentCacheKey = this.engine.getLoadingUriForView(this.imageAware);
        boolean bl = imageAwareWasReused = !this.memoryCacheKey.equals(currentCacheKey);
        if (imageAwareWasReused) {
            this.log(LOG_TASK_CANCELLED_IMAGEAWARE_REUSED);
            this.fireCancelEvent();
        }
        return imageAwareWasReused;
    }

    private boolean checkTaskIsInterrupted() {
        boolean interrupted = Thread.interrupted();
        if (interrupted) {
            this.log(LOG_TASK_INTERRUPTED);
        }
        return interrupted;
    }

    private Bitmap tryLoadBitmap() {
        File imageFile = this.getImageFileInDiscCache();
        Bitmap bitmap = null;
        try {
            if (imageFile.exists()) {
                this.log(LOG_LOAD_IMAGE_FROM_DISC_CACHE);
                this.loadedFrom = LoadedFrom.DISC_CACHE;
                bitmap = this.decodeImage(ImageDownloader.Scheme.FILE.wrap(imageFile.getAbsolutePath()));
                if (this.imageAwareCollected) {
                    return null;
                }
            }
            if (bitmap == null || bitmap.getWidth() <= 0 || bitmap.getHeight() <= 0) {
                String e;
                this.log(LOG_LOAD_IMAGE_FROM_NETWORK);
                this.loadedFrom = LoadedFrom.NETWORK;
                String string = e = this.options.isCacheOnDisc() ? this.tryCacheImageOnDisc(imageFile) : this.uri;
                if (!this.checkTaskIsNotActual()) {
                    bitmap = this.decodeImage(e);
                    if (this.imageAwareCollected) {
                        return null;
                    }
                    if (bitmap == null || bitmap.getWidth() <= 0 || bitmap.getHeight() <= 0) {
                        this.fireFailEvent(FailReason.FailType.DECODING_ERROR, null);
                    }
                }
            }
        }
        catch (IllegalStateException var4) {
            this.fireFailEvent(FailReason.FailType.NETWORK_DENIED, null);
        }
        catch (IOException var5) {
            L.e(var5);
            this.fireFailEvent(FailReason.FailType.IO_ERROR, var5);
            if (imageFile.exists()) {
                imageFile.delete();
            }
        }
        catch (OutOfMemoryError var6) {
            L.e(var6);
            this.fireFailEvent(FailReason.FailType.OUT_OF_MEMORY, var6);
        }
        catch (Throwable var7) {
            L.e(var7);
            this.fireFailEvent(FailReason.FailType.UNKNOWN, var7);
        }
        return bitmap;
    }

    private File getImageFileInDiscCache() {
        DiscCacheAware discCache = this.configuration.discCache;
        File imageFile = discCache.get(this.uri);
        File cacheDir = imageFile.getParentFile();
        if (!(cacheDir != null && (cacheDir.exists() || cacheDir.mkdirs()) || (cacheDir = (imageFile = this.configuration.reserveDiscCache.get(this.uri)).getParentFile()) == null || cacheDir.exists())) {
            cacheDir.mkdirs();
        }
        return imageFile;
    }

    private Bitmap decodeImage(String imageUri) throws IOException {
        if (this.checkViewCollected()) {
            return null;
        }
        ViewScaleType viewScaleType = this.imageAware.getScaleType();
        if (viewScaleType == null) {
            return null;
        }
        ImageDecodingInfo decodingInfo = new ImageDecodingInfo(this.memoryCacheKey, imageUri, this.targetSize, viewScaleType, this.getDownloader(), this.options);
        return this.decoder.decode(decodingInfo);
    }

    private String tryCacheImageOnDisc(File targetFile) {
        this.log(LOG_CACHE_IMAGE_ON_DISC);
        try {
            int e = this.configuration.maxImageWidthForDiscCache;
            int height = this.configuration.maxImageHeightForDiscCache;
            boolean saved = false;
            if (e > 0 || height > 0) {
                saved = this.downloadSizedImage(targetFile, e, height);
            }
            if (!saved) {
                this.downloadImage(targetFile);
            }
            this.configuration.discCache.put(this.uri, targetFile);
            return ImageDownloader.Scheme.FILE.wrap(targetFile.getAbsolutePath());
        }
        catch (IOException var5) {
            L.e(var5);
            if (targetFile.exists()) {
                targetFile.delete();
            }
            return this.uri;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadSizedImage(File targetFile, int maxWidth, int maxHeight) throws IOException {
        boolean savedSuccessfully;
        ImageSize targetImageSize = new ImageSize(maxWidth, maxHeight);
        DisplayImageOptions specialOptions = new DisplayImageOptions.Builder().cloneFrom(this.options).imageScaleType(ImageScaleType.IN_SAMPLE_INT).build();
        ImageDecodingInfo decodingInfo = new ImageDecodingInfo(this.memoryCacheKey, this.uri, targetImageSize, ViewScaleType.FIT_INSIDE, this.getDownloader(), specialOptions);
        Bitmap bmp = this.decoder.decode(decodingInfo);
        if (bmp == null) {
            return false;
        }
        if (this.configuration.processorForDiscCache != null) {
            this.log(LOG_PROCESS_IMAGE_BEFORE_CACHE_ON_DISC);
            bmp = this.configuration.processorForDiscCache.process(bmp);
            if (bmp == null) {
                L.e(ERROR_PROCESSOR_FOR_DISC_CACHE_NULL, this.memoryCacheKey);
                return false;
            }
        }
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(targetFile), 1195);
        try {
            savedSuccessfully = bmp.compress(this.configuration.imageCompressFormatForDiscCache, this.configuration.imageQualityForDiscCache, (OutputStream)os);
        }
        finally {
            IoUtils.closeSilently(os);
        }
        bmp.recycle();
        return savedSuccessfully;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadImage(File targetFile) throws IOException {
        InputStream is = this.getDownloader().getStream(this.uri, this.options.getExtraForDownloader());
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(targetFile), 1195);
            try {
                IoUtils.copyStream(is, os);
            }
            finally {
                IoUtils.closeSilently(os);
            }
        }
        finally {
            IoUtils.closeSilently(is);
        }
    }

    private void fireFailEvent(final FailReason.FailType failType, final Throwable failCause) {
        if (!Thread.interrupted()) {
            if (this.options.isSyncLoading()) {
                this.listener.onLoadingFailed(this.uri, this.imageAware.getWrappedView(), new FailReason(failType, failCause));
            } else {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (LoadAndDisplayImageTask.this.options.shouldShowImageOnFail()) {
                            LoadAndDisplayImageTask.this.imageAware.setImageDrawable(LoadAndDisplayImageTask.this.options.getImageOnFail(((LoadAndDisplayImageTask)LoadAndDisplayImageTask.this).configuration.resources));
                        }
                        LoadAndDisplayImageTask.this.listener.onLoadingFailed(LoadAndDisplayImageTask.this.uri, LoadAndDisplayImageTask.this.imageAware.getWrappedView(), new FailReason(failType, failCause));
                    }
                });
            }
        }
    }

    private void fireCancelEvent() {
        if (!Thread.interrupted()) {
            if (this.options.isSyncLoading()) {
                this.listener.onLoadingCancelled(this.uri, this.imageAware.getWrappedView());
            } else {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        LoadAndDisplayImageTask.this.listener.onLoadingCancelled(LoadAndDisplayImageTask.this.uri, LoadAndDisplayImageTask.this.imageAware.getWrappedView());
                    }
                });
            }
        }
    }

    private ImageDownloader getDownloader() {
        ImageDownloader d = this.engine.isNetworkDenied() ? this.networkDeniedDownloader : (this.engine.isSlowNetwork() ? this.slowNetworkDownloader : this.downloader);
        return d;
    }

    String getLoadingUri() {
        return this.uri;
    }

    private void log(String message) {
        if (this.writeLogs) {
            L.d(message, this.memoryCacheKey);
        }
    }

    private void log(String message, Object ... args) {
        if (this.writeLogs) {
            L.d(message, args);
        }
    }
}

