/*
 * Decompiled with CFR 0.152.
 */
package com.dmcbig.mediapicker.utils;

import android.content.Context;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Locale;

public class FileUtils {
    private static final String JPEG_FILE_PREFIX = "IMG_";
    private static final String JPEG_FILE_SUFFIX = ".jpg";
    private static final String EXTERNAL_STORAGE_PERMISSION = "android.permission.WRITE_EXTERNAL_STORAGE";
    private static final long MB = 0x100000L;

    public static File createTmpFile(Context context) throws IOException {
        File file;
        if (TextUtils.equals((CharSequence)Environment.getExternalStorageState(), (CharSequence)"mounted")) {
            file = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM);
            if (!file.exists() && !(file = Environment.getExternalStoragePublicDirectory((String)(Environment.DIRECTORY_DCIM + "/Camera"))).exists()) {
                file = FileUtils.getCacheDirectory(context, true);
            }
        } else {
            file = FileUtils.getCacheDirectory(context, true);
        }
        return File.createTempFile(JPEG_FILE_PREFIX, JPEG_FILE_SUFFIX, file);
    }

    public static File getCacheDirectory(Context context) {
        return FileUtils.getCacheDirectory(context, true);
    }

    public static String getRealPathFromURI(Context context, Uri uri) {
        if ((context = context.getContentResolver().query(uri, null, null, null, null)) == null) {
            return uri.getPath();
        }
        Context context2 = context;
        context2.moveToFirst();
        String string2 = context2.getString(context2.getColumnIndex("_data"));
        context.close();
        return string2;
    }

    public static File getCacheDirectory(Context object, boolean bl) {
        String string2;
        File file = null;
        try {
            string2 = Environment.getExternalStorageState();
        }
        catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            string2 = "";
        }
        catch (NullPointerException nullPointerException) {
            string2 = "";
        }
        if (bl && "mounted".equals(string2) && FileUtils.hasExternalStoragePermission(object)) {
            file = FileUtils.getExternalCacheDir(object);
        }
        if (file == null) {
            file = object.getCacheDir();
        }
        if (file == null) {
            File file2;
            object = "/data/data/" + object.getPackageName() + "/cache/";
            file = file2;
            file2 = new File((String)object);
        }
        return file;
    }

    public static File getIndividualCacheDirectory(Context object, String string2) {
        File file;
        object = FileUtils.getCacheDirectory(object);
        File file2 = file;
        if (!new File((File)object, string2).exists() && !file2.mkdir()) {
            return object;
        }
        return file2;
    }

    private static File getExternalCacheDir(Context context) {
        File file;
        File file2;
        File file3 = file2;
        file2 = new File(new File(Environment.getExternalStorageDirectory(), "Android"), "data");
        File file4 = file;
        if (!new File(new File(file3, context.getPackageName()), "cache").exists()) {
            File file5;
            if (!file4.mkdirs()) {
                return null;
            }
            try {
                file5 = file4;
                new File(file4, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {}
            return file5;
        }
        return file4;
    }

    private static boolean hasExternalStoragePermission(Context context) {
        return context.checkCallingOrSelfPermission(EXTERNAL_STORAGE_PERMISSION) == 0;
    }

    public static String fileSize(long l5) {
        DecimalFormat decimalFormat;
        if (l5 <= 0L) {
            return "0";
        }
        String[] stringArray = new String[5];
        String[] stringArray2 = stringArray;
        stringArray[0] = "B";
        stringArray[1] = "kB";
        stringArray[2] = "MB";
        stringArray[3] = "GB";
        stringArray[4] = "TB";
        double d6 = l5;
        int n5 = (int)(Math.log10(d6) / Math.log10(1024.0));
        DecimalFormat decimalFormat2 = decimalFormat;
        double d7 = d6;
        decimalFormat2("#,##0.#");
        d6 = n5;
        return decimalFormat.format(d7 / Math.pow(1024.0, d6)) + " " + stringArray2[n5];
    }

    public static String getMimeType(Context object, Uri uri) {
        if ("content".equals(uri.getScheme())) {
            object = MimeTypeMap.getSingleton().getExtensionFromMimeType(object.getContentResolver().getType(uri));
            if (TextUtils.isEmpty((CharSequence)object)) {
                return MimeTypeMap.getFileExtensionFromUrl((String)Uri.fromFile((File)new File(uri.getPath())).toString());
            }
            return object;
        }
        String string2 = MimeTypeMap.getFileExtensionFromUrl((String)Uri.fromFile((File)new File(uri.getPath())).toString());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return MimeTypeMap.getSingleton().getExtensionFromMimeType(object.getContentResolver().getType(uri));
        }
        return string2;
    }

    public static String getMimeTypeByFileName(String string2) {
        String string3 = string2;
        int n5 = string3.lastIndexOf(".");
        return string3.substring(n5, string3.length());
    }

    public String getSizeByUnit(double d6) {
        if (d6 == 0.0) {
            return "0K";
        }
        if (d6 >= 1048576.0) {
            double d7 = d6 / 1048576.0;
            Double d8 = d7;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = d8;
            return String.format(Locale.US, "%.1f", objectArray2) + "M";
        }
        double d9 = d6 / 1024.0;
        Double d10 = d9;
        Object[] objectArray = new Object[1];
        Object[] objectArray3 = objectArray;
        objectArray[0] = d10;
        return String.format(Locale.US, "%.1f", objectArray3) + "K";
    }
}

