/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.common.ui.blur;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.text.TextUtils;
import android.view.Choreographer;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import io.dcloud.common.adapter.util.MessageHandler;
import io.dcloud.common.ui.blur.AppEventForBlurManager;
import io.dcloud.common.ui.blur.BlurCanvas;
import io.dcloud.common.ui.blur.BlurManager;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.TitleNViewUtil;
import java.lang.ref.WeakReference;

public class DCBlurDraweeView
extends FrameLayout
implements AppEventForBlurManager.OnAppChangedCallBack {
    public static final String AUTOMATICALLY = "automatically";
    public static final String SEMI_AUTOMATICALLY = "semi-automatic";
    public static final String STATIC = "static";
    public static final String NONE = "none";
    public static final String DARK = "dark";
    public static final String EXTRALIGHT = "extralight";
    public static final String LIGHT = "light";
    private final String TAG;
    private float mDownscaleFactor = 0.2f;
    private int mBlurRadius = 15;
    private int mFPS = 60;
    private float mCornerRadius = 0.0f;
    private float mAlpha = Float.NaN;
    private boolean mRunning;
    private boolean mAttachedToWindow;
    private ImageView mImageView;
    private WeakReference<View> mRootView;
    private boolean isBlur = false;
    private int mGravityType = 17;
    private String mBlurState = "static";
    private String mBlurEffect = "none";
    private long mPostTime = 1500L;
    private BlurLayoutChangeCallBack mChangeCB;
    private Choreographer.FrameCallback invalidationLoop;
    private int postDelayTime;
    private Choreographer.FrameCallback postInvalidationLoop;
    private Runnable removePostDelayed;
    private float mOverlayColorAlpha;

    public DCBlurDraweeView(@NonNull Context object) {
        super(object);
        Runnable runnable;
        Choreographer.FrameCallback frameCallback;
        Choreographer.FrameCallback frameCallback2;
        this.TAG = "DCBlurDraweeView";
        object = frameCallback2;
        frameCallback2 = new Choreographer.FrameCallback(){

            public void doFrame(long l5) {
                if (!BaseInfo.sDoingAnimation) {
                    DCBlurDraweeView.this.invalidate();
                }
                1 v02 = this;
                Choreographer.getInstance().postFrameCallbackDelayed((Choreographer.FrameCallback)v02, (long)(1000 / v02.DCBlurDraweeView.this.mFPS));
            }
        };
        this.invalidationLoop = object;
        this.postDelayTime = 50;
        object = frameCallback;
        frameCallback = new Choreographer.FrameCallback(){

            public void doFrame(long l5) {
                if (DCBlurDraweeView.this.mRunning) {
                    return;
                }
                if (!BaseInfo.sDoingAnimation) {
                    DCBlurDraweeView.this.invalidate();
                }
                2 v02 = this;
                Choreographer.getInstance().postFrameCallbackDelayed((Choreographer.FrameCallback)v02, (long)v02.DCBlurDraweeView.this.postDelayTime);
            }
        };
        this.postInvalidationLoop = object;
        object = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                Choreographer.getInstance().removeFrameCallback(DCBlurDraweeView.this.postInvalidationLoop);
            }
        };
        this.removePostDelayed = object;
        this.mOverlayColorAlpha = 0.6f;
    }

    public DCBlurDraweeView(@NonNull Context object, boolean bl, String string2) {
        super(object);
        Runnable runnable;
        Choreographer.FrameCallback frameCallback;
        Choreographer.FrameCallback frameCallback2;
        this.TAG = "DCBlurDraweeView";
        object = frameCallback2;
        frameCallback2 = new /* invalid duplicate definition of identical inner class */;
        this.invalidationLoop = object;
        this.postDelayTime = 50;
        object = frameCallback;
        frameCallback = new /* invalid duplicate definition of identical inner class */;
        this.postInvalidationLoop = object;
        object = runnable;
        runnable = new /* invalid duplicate definition of identical inner class */;
        this.removePostDelayed = object;
        this.mOverlayColorAlpha = 0.6f;
        this.isBlur = bl;
        this.mBlurState = string2;
        if (bl) {
            this.initImageView();
            return;
        }
    }

    private void initImageView() {
        ImageView imageView = this.mImageView;
        if (imageView == null) {
            this.mImageView = new ImageView(this.getContext());
        } else if (imageView.getParent() == null) {
            ((ViewGroup)this.mImageView.getParent()).removeView((View)this.mImageView);
        }
        DCBlurDraweeView dCBlurDraweeView = this;
        dCBlurDraweeView.mImageView.setScaleType(ImageView.ScaleType.FIT_XY);
        dCBlurDraweeView.addView((View)dCBlurDraweeView.mImageView, 0);
        dCBlurDraweeView.setCornerRadius(dCBlurDraweeView.mCornerRadius);
    }

    private void startBlur() {
        if (!this.mRunning && this.isBlur && this.mFPS > 0 && !this.mBlurState.equals(STATIC)) {
            this.mRunning = true;
            Choreographer.getInstance().removeFrameCallback(this.postInvalidationLoop);
            Choreographer.getInstance().postFrameCallback(this.invalidationLoop);
            return;
        }
    }

    private void pauseBlur() {
        if (this.mRunning && this.isBlur) {
            this.mRunning = false;
            Choreographer.getInstance().removeFrameCallback(this.invalidationLoop);
            return;
        }
    }

    private int getOverlayColor() {
        String string2 = this.mBlurEffect;
        string2.getClass();
        int n5 = -1;
        switch (string2.hashCode()) {
            default: {
                break;
            }
            case 759540486: {
                if (!string2.equals(EXTRALIGHT)) break;
                n5 = 2;
                break;
            }
            case 102970646: {
                if (!string2.equals(LIGHT)) break;
                n5 = 1;
                break;
            }
            case 3075958: {
                if (!string2.equals(DARK)) break;
                n5 = 0;
            }
        }
        switch (n5) {
            default: {
                return 0;
            }
            case 2: {
                return Color.parseColor((String)TitleNViewUtil.changeColorAlpha("#FFFFFF", this.mOverlayColorAlpha));
            }
            case 1: {
                return Color.parseColor((String)TitleNViewUtil.changeColorAlpha("#F8F8F8", this.mOverlayColorAlpha));
            }
            case 0: 
        }
        return Color.parseColor((String)TitleNViewUtil.changeColorAlpha("#454545", this.mOverlayColorAlpha));
    }

    private Bitmap getDownscaledBitmapForView(View view, Rect rect, float f5, int n5) throws Exception {
        float f6 = f5;
        float f7 = 0.5f;
        float f8 = f6 / 0.5f;
        if (f6 >= f7) {
            f8 = 1.0f;
        } else {
            f5 = f7;
        }
        Rect rect2 = rect;
        int n6 = (int)((float)rect2.width() * f5);
        int n7 = (int)((float)rect2.height() * f5);
        if (view.getWidth() > 0 && view.getHeight() > 0 && n6 > 0 && n7 > 0) {
            Paint paint;
            Canvas canvas;
            Canvas canvas2;
            Matrix matrix;
            BlurCanvas blurCanvas;
            int n8;
            Rect rect3 = rect;
            float f9 = (float)(-rect3.left) * f5;
            float f10 = (float)(-rect3.top + n5) * f5;
            int n9 = dCBlurDraweeView.mGravityType;
            if (n9 != 17) {
                if (n9 != 48) {
                    n8 = (int)((float)(rect.height() + n5) * f5);
                } else {
                    n8 = (int)((float)(rect.height() + n5) * f5);
                    f10 -= (float)n5 * f5;
                }
            } else {
                n8 = (int)((float)(rect.height() + n5 * 2) * f5);
            }
            dCBlurDraweeView.setViewVisibility(4);
            Bitmap.Config config = Bitmap.Config.ARGB_8888;
            Bitmap bitmap = Bitmap.createBitmap((int)n6, (int)n8, (Bitmap.Config)config);
            BlurCanvas blurCanvas2 = blurCanvas;
            View view2 = view;
            BlurCanvas blurCanvas3 = blurCanvas2;
            blurCanvas3(bitmap);
            view = matrix;
            float f11 = f5;
            view();
            view.postScale(f11, f11);
            matrix.postTranslate(f9, f10);
            blurCanvas3.setMatrix(matrix);
            view2.draw((Canvas)blurCanvas3);
            blurCanvas.drawColor(dCBlurDraweeView.getOverlayColor());
            blurCanvas.save();
            dCBlurDraweeView.setViewVisibility(0);
            float f12 = n6;
            int n10 = (int)(f12 * f8);
            float f13 = n8;
            int n11 = (int)(f13 * f8);
            config = Bitmap.createBitmap((int)n10, (int)n11, (Bitmap.Config)config);
            Canvas canvas3 = canvas2 = canvas;
            canvas3((Bitmap)config);
            Matrix matrix2 = new Matrix();
            matrix2.setScale((float)n10 / f12, (float)n11 / f13);
            canvas3.setMatrix(matrix2);
            canvas2.drawColor(dCBlurDraweeView.getBlurBGColor());
            DCBlurDraweeView dCBlurDraweeView = paint;
            new Paint().setFlags(3);
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, (Paint)dCBlurDraweeView);
            bitmap.recycle();
            return config;
        }
        throw new Exception("No screen available (width or height = 0)");
    }

    private void setViewVisibility(int n5) {
        DCBlurDraweeView dCBlurDraweeView = blurLayoutChangeCallBack;
        dCBlurDraweeView.setVisibility(n5);
        BlurLayoutChangeCallBack blurLayoutChangeCallBack = dCBlurDraweeView.mChangeCB;
        if (blurLayoutChangeCallBack != null) {
            blurLayoutChangeCallBack.setVisibility(n5);
            return;
        }
    }

    private View getActivityView() {
        try {
            return ((Activity)this.getContext()).getWindow().getDecorView().findViewById(0x1020002);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    private Point getPositionInScreen() {
        DCBlurDraweeView dCBlurDraweeView = dCBlurDraweeView2;
        DCBlurDraweeView dCBlurDraweeView2 = dCBlurDraweeView.getPositionInScreen((View)dCBlurDraweeView);
        return new Point((int)((PointF)dCBlurDraweeView2).x, (int)((PointF)dCBlurDraweeView2).y);
    }

    private PointF getPositionInScreen(View view) {
        ViewGroup viewGroup;
        block4: {
            if (this.getParent() == null) {
                return new PointF();
            }
            if (this.mRootView.get() != null && view == this.mRootView.get()) {
                return new PointF();
            }
            try {
                viewGroup = (ViewGroup)view.getParent();
                if (viewGroup != null) break block4;
            }
            catch (Exception exception) {
                return new PointF();
            }
            return new PointF();
        }
        PointF pointF = this.getPositionInScreen((View)viewGroup);
        View view2 = view;
        float f5 = view2.getX();
        pointF.offset(f5, view2.getY());
        return pointF;
    }

    public void setBlurLayoutChangeCallBack(BlurLayoutChangeCallBack blurLayoutChangeCallBack) {
        this.mChangeCB = blurLayoutChangeCallBack;
    }

    public void setBlur(boolean bl) {
        this.isBlur = bl;
        if (bl && this.mImageView == null) {
            this.initImageView();
            return;
        }
    }

    public void setContentFocusable(boolean bl) {
        String string2 = this.mBlurState;
        string2.getClass();
        int n5 = -1;
        switch (string2.hashCode()) {
            default: {
                break;
            }
            case 1977933731: {
                if (!string2.equals(AUTOMATICALLY)) break;
                n5 = 2;
                break;
            }
            case 1030681228: {
                if (!string2.equals(SEMI_AUTOMATICALLY)) break;
                n5 = 1;
                break;
            }
            case -892481938: {
                if (!string2.equals(STATIC)) break;
                n5 = 0;
            }
        }
        switch (n5) {
            default: {
                return;
            }
            case 2: {
                if (bl) {
                    this.startBlur();
                    return;
                }
                this.pauseBlur();
                return;
            }
            case 1: {
                if (bl) {
                    AppEventForBlurManager.addEventChangedCallBack(this);
                    return;
                }
                AppEventForBlurManager.removeEventChangedCallBack(this);
                return;
            }
            case 0: 
        }
        DCBlurDraweeView dCBlurDraweeView = this;
        AppEventForBlurManager.removeEventChangedCallBack(dCBlurDraweeView);
        dCBlurDraweeView.pauseBlur();
    }

    public void postInvalidate(long l5) {
        if (!this.mRunning && this.isBlur) {
            DCBlurDraweeView dCBlurDraweeView = this;
            MessageHandler.removeCallbacks(dCBlurDraweeView.removePostDelayed);
            Choreographer.getInstance().removeFrameCallback(this.postInvalidationLoop);
            Choreographer.getInstance().postFrameCallback(this.postInvalidationLoop);
            MessageHandler.postDelayed(dCBlurDraweeView.removePostDelayed, l5 + 10L);
            return;
        }
    }

    protected void onSizeChanged(int n5, int n6, int n7, int n8) {
        DCBlurDraweeView dCBlurDraweeView = this;
        super.onSizeChanged(n5, n6, n7, n8);
        if (dCBlurDraweeView.isBlur) {
            DCBlurDraweeView dCBlurDraweeView2 = this;
            dCBlurDraweeView2.postInvalidate(dCBlurDraweeView2.mPostTime);
            return;
        }
    }

    public void invalidate() {
        Bitmap bitmap;
        DCBlurDraweeView dCBlurDraweeView = this;
        super.invalidate();
        if (dCBlurDraweeView.mAttachedToWindow && this.mImageView != null && this.isBlur && (bitmap = this.makeBlur()) != null) {
            this.mImageView.setImageBitmap(bitmap);
            return;
        }
    }

    protected void onAttachedToWindow() {
        DCBlurDraweeView dCBlurDraweeView = this;
        super.onAttachedToWindow();
        dCBlurDraweeView.mAttachedToWindow = true;
        if (dCBlurDraweeView.isBlur) {
            String string2 = this.mBlurState;
            string2.getClass();
            int n5 = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 1977933731: {
                    if (!string2.equals(AUTOMATICALLY)) break;
                    n5 = 2;
                    break;
                }
                case 1030681228: {
                    if (!string2.equals(SEMI_AUTOMATICALLY)) break;
                    n5 = 1;
                    break;
                }
                case -892481938: {
                    if (!string2.equals(STATIC)) break;
                    n5 = 0;
                }
            }
            switch (n5) {
                default: {
                    break;
                }
                case 2: {
                    DCBlurDraweeView dCBlurDraweeView2 = this;
                    AppEventForBlurManager.removeEventChangedCallBack(dCBlurDraweeView2);
                    dCBlurDraweeView2.startBlur();
                    return;
                }
                case 1: {
                    DCBlurDraweeView dCBlurDraweeView3 = this;
                    dCBlurDraweeView3.postInvalidate(dCBlurDraweeView3.mPostTime);
                    AppEventForBlurManager.addEventChangedCallBack(dCBlurDraweeView3);
                    return;
                }
                case 0: {
                    DCBlurDraweeView dCBlurDraweeView4 = this;
                    dCBlurDraweeView4.postInvalidate(dCBlurDraweeView4.mPostTime);
                    AppEventForBlurManager.removeEventChangedCallBack(dCBlurDraweeView4);
                    return;
                }
            }
        }
    }

    protected void onDetachedFromWindow() {
        DCBlurDraweeView dCBlurDraweeView = this;
        super.onDetachedFromWindow();
        dCBlurDraweeView.mAttachedToWindow = false;
        dCBlurDraweeView.pauseBlur();
        AppEventForBlurManager.removeEventChangedCallBack(dCBlurDraweeView);
    }

    public void setCornerRadius(float f5) {
        this.mCornerRadius = f5;
        this.invalidate();
    }

    public void setBlurRadius(int n5) {
        if (n5 < 0) {
            n5 = 15;
        } else if (n5 > 25) {
            n5 = 25;
        }
        this.mBlurRadius = n5;
        this.invalidate();
    }

    public void setGravityType(int n5) {
        this.mGravityType = n5;
    }

    public void setFPS(int n5) {
        if (this.mRunning) {
            this.pauseBlur();
        }
        this.mFPS = n5;
    }

    public void setDownscaleFactor(float f5) {
        this.mDownscaleFactor = f5;
        this.invalidate();
    }

    public void setRootView(View view) {
        WeakReference<View> weakReference;
        WeakReference<View> weakReference2 = ((DCBlurDraweeView)((Object)weakReference3)).mRootView;
        if (weakReference2 != null && weakReference2.get() != null) {
            ((DCBlurDraweeView)((Object)weakReference3)).mRootView.clear();
        }
        DCBlurDraweeView dCBlurDraweeView = weakReference3;
        WeakReference<View> weakReference3 = weakReference;
        weakReference = new WeakReference<View>(view);
        dCBlurDraweeView.mRootView = weakReference3;
    }

    public void setBlurState(String string2) {
        this.mBlurState = string2;
    }

    public void setBlurEffect(String string2) {
        this.mBlurEffect = string2;
        if (!this.isBlur && this.mBlurState.equals(NONE)) {
            DCBlurDraweeView dCBlurDraweeView = this;
            dCBlurDraweeView.setBackgroundColor(dCBlurDraweeView.getBlurBGColor());
            return;
        }
        this.setBackgroundColor(0);
    }

    public void setOverlayColorAlpha(float f5) {
        this.mOverlayColorAlpha = f5;
    }

    public int getBlurBGColor() {
        String string2 = ((DCBlurDraweeView)((Object)string2)).mBlurEffect;
        string2.getClass();
        int n5 = -1;
        switch (string2.hashCode()) {
            default: {
                break;
            }
            case 759540486: {
                if (!string2.equals(EXTRALIGHT)) break;
                n5 = 2;
                break;
            }
            case 102970646: {
                if (!string2.equals(LIGHT)) break;
                n5 = 1;
                break;
            }
            case 3075958: {
                if (!string2.equals(DARK)) break;
                n5 = 0;
            }
        }
        switch (n5) {
            default: {
                return 0;
            }
            case 2: {
                return Color.parseColor((String)"#F2FFFFFF");
            }
            case 1: {
                return Color.parseColor((String)"#F2F8F8F8");
            }
            case 0: 
        }
        return Color.parseColor((String)"#F2454545");
    }

    public Bitmap makeBlur() {
        block10: {
            Bitmap bitmap;
            block11: {
                int n5;
                Bitmap bitmap2;
                int n6;
                int n7;
                block14: {
                    boolean bl;
                    int n8;
                    block12: {
                        block13: {
                            Rect rect;
                            Rect rect2;
                            if (this.getContext() == null || this.isInEditMode() || !this.isBlur) break block10;
                            Point point = this.mRootView;
                            if (point == null || point.get() == null) {
                                Point point2;
                                point = point2;
                                this.mRootView = new WeakReference(this.getActivityView());
                                if (point.get() == null) {
                                    return null;
                                }
                            }
                            DCBlurDraweeView dCBlurDraweeView = this;
                            dCBlurDraweeView.getLocationOnScreen(new int[2]);
                            point = dCBlurDraweeView.getPositionInScreen();
                            Rect rect3 = rect2;
                            if (!dCBlurDraweeView.getGlobalVisibleRect(new Rect())) {
                                return null;
                            }
                            DCBlurDraweeView dCBlurDraweeView2 = this;
                            n8 = dCBlurDraweeView2.getHeight();
                            n7 = dCBlurDraweeView2.getWidth();
                            bl = rect3.height() >= n8;
                            n6 = bl ? this.mBlurRadius : 0;
                            DCBlurDraweeView dCBlurDraweeView3 = this;
                            bitmap = null;
                            View view = (View)dCBlurDraweeView3.mRootView.get();
                            Rect rect4 = rect;
                            Point point3 = point;
                            Point point4 = point3;
                            int n9 = point3.x;
                            int n10 = point4.y;
                            int n11 = n9;
                            n9 += n7;
                            n8 = n10 + n8;
                            rect = new Rect(n11, n10, n9, n8);
                            float f5 = dCBlurDraweeView3.mDownscaleFactor;
                            try {
                                bitmap = dCBlurDraweeView3.getDownscaledBitmapForView(view, rect4, f5, n6);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            if (bitmap == null) break block11;
                            bitmap2 = BlurManager.getInstance().processNatively(bitmap, this.mBlurRadius, false);
                            n8 = (int)((float)n6 * this.mDownscaleFactor);
                            n7 = bl ? n8 : 0;
                            n6 = bl ? bitmap2.getHeight() - n8 * 2 : bitmap2.getHeight();
                            n5 = this.mGravityType;
                            if (n5 == 17) break block12;
                            if (n5 == 48) break block13;
                            if (n5 == 80) break block12;
                            break block14;
                        }
                        n7 = 5;
                        n6 = (bl ? bitmap2.getHeight() - n8 : bitmap2.getHeight()) - n7;
                        break block14;
                    }
                    n6 = bl ? (n5 = bitmap2.getHeight() - n8 * 2) : (n5 = bitmap2.getHeight());
                }
                Bitmap bitmap3 = bitmap2;
                n5 = bitmap3.getWidth();
                bitmap = Bitmap.createBitmap((Bitmap)bitmap3, (int)0, (int)n7, (int)n5, (int)n6);
            }
            return bitmap;
        }
        return null;
    }

    @Override
    public void onContentScrollStart() {
        this.startBlur();
    }

    @Override
    public void onContentScrollEnd() {
        this.pauseBlur();
    }

    @Override
    public void onSplashclosed() {
        DCBlurDraweeView dCBlurDraweeView = this;
        dCBlurDraweeView.postInvalidate(dCBlurDraweeView.mPostTime);
    }

    public boolean checkBlurEffect(String string2) {
        return !TextUtils.isEmpty((CharSequence)string2) && (string2.equals(LIGHT) || string2.equals(DARK) || string2.equals(EXTRALIGHT));
    }

    public static interface BlurLayoutChangeCallBack {
        public void setVisibility(int var1);
    }
}

