/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.dcloudimageloader.core.decode;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.media.ExifInterface;
import android.os.Build;
import com.nostra13.dcloudimageloader.core.assist.ImageScaleType;
import com.nostra13.dcloudimageloader.core.assist.ImageSize;
import com.nostra13.dcloudimageloader.core.decode.ImageDecoder;
import com.nostra13.dcloudimageloader.core.decode.ImageDecodingInfo;
import com.nostra13.dcloudimageloader.core.download.ImageDownloader;
import com.nostra13.dcloudimageloader.utils.ImageSizeUtils;
import com.nostra13.dcloudimageloader.utils.IoUtils;
import com.nostra13.dcloudimageloader.utils.L;
import java.io.IOException;
import java.io.InputStream;

public class BaseImageDecoder
implements ImageDecoder {
    protected static final String LOG_SUBSAMPLE_IMAGE = "Subsample original image (%1$s) to %2$s (scale = %3$d) [%4$s]";
    protected static final String LOG_SCALE_IMAGE = "Scale subsampled image (%1$s) to %2$s (scale = %3$.5f) [%4$s]";
    protected static final String LOG_ROTATE_IMAGE = "Rotate image on %1$d\u00b0 [%2$s]";
    protected static final String LOG_FLIP_IMAGE = "Flip image horizontally [%s]";
    protected static final String ERROR_NO_IMAGE_STREAM = "No stream for image [%s]";
    protected static final String ERROR_CANT_DECODE_IMAGE = "Image can't be decoded [%s]";
    protected final boolean loggingEnabled;

    public BaseImageDecoder(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    @Override
    public Bitmap decode(ImageDecodingInfo decodingInfo) throws IOException {
        InputStream imageStream = this.getImageStream(decodingInfo);
        ImageFileInfo imageInfo = this.defineImageSizeAndRotation(imageStream, decodingInfo);
        BitmapFactory.Options decodingOptions = this.prepareDecodingOptions(imageInfo.imageSize, decodingInfo);
        Bitmap decodedBitmap = this.decodeStream(imageStream = this.resetStream(imageStream, decodingInfo), decodingOptions);
        if (decodedBitmap == null) {
            L.e(ERROR_CANT_DECODE_IMAGE, decodingInfo.getImageKey());
        } else {
            decodedBitmap = this.considerExactScaleAndOrientaiton(decodedBitmap, decodingInfo, imageInfo.exif.rotation, imageInfo.exif.flipHorizontal);
        }
        return decodedBitmap;
    }

    protected InputStream getImageStream(ImageDecodingInfo decodingInfo) throws IOException {
        return decodingInfo.getDownloader().getStream(decodingInfo.getImageUri(), decodingInfo.getExtraForDownloader());
    }

    protected ImageFileInfo defineImageSizeAndRotation(InputStream imageStream, ImageDecodingInfo decodingInfo) throws IOException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)imageStream, (Rect)null, (BitmapFactory.Options)options);
        String imageUri = decodingInfo.getImageUri();
        ExifInfo exif = decodingInfo.shouldConsiderExifParams() && this.canDefineExifParams(imageUri, options.outMimeType) ? this.defineExifOrientation(imageUri) : new ExifInfo();
        return new ImageFileInfo(new ImageSize(options.outWidth, options.outHeight, exif.rotation), exif);
    }

    private boolean canDefineExifParams(String imageUri, String mimeType) {
        return Build.VERSION.SDK_INT >= 5 && "image/jpeg".equalsIgnoreCase(mimeType) && ImageDownloader.Scheme.ofUri(imageUri) == ImageDownloader.Scheme.FILE;
    }

    protected ExifInfo defineExifOrientation(String imageUri) {
        int rotation = 0;
        boolean flip = false;
        try {
            ExifInterface e = new ExifInterface(ImageDownloader.Scheme.FILE.crop(imageUri));
            int exifOrientation = e.getAttributeInt("Orientation", 1);
            switch (exifOrientation) {
                case 2: {
                    flip = true;
                }
                case 1: {
                    rotation = 0;
                    break;
                }
                case 4: {
                    flip = true;
                }
                case 3: {
                    rotation = 180;
                    break;
                }
                case 5: {
                    flip = true;
                }
                case 8: {
                    rotation = 270;
                    break;
                }
                case 7: {
                    flip = true;
                }
                case 6: {
                    rotation = 90;
                }
            }
        }
        catch (IOException var6) {
            L.w("Can't read EXIF tags from file [%s]", imageUri);
        }
        return new ExifInfo(rotation, flip);
    }

    protected BitmapFactory.Options prepareDecodingOptions(ImageSize imageSize, ImageDecodingInfo decodingInfo) {
        ImageScaleType scaleType = decodingInfo.getImageScaleType();
        ImageSize targetSize = decodingInfo.getTargetSize();
        int scale = 1;
        if (scaleType != ImageScaleType.NONE) {
            boolean decodingOptions = scaleType == ImageScaleType.IN_SAMPLE_POWER_OF_2;
            scale = ImageSizeUtils.computeImageSampleSize(imageSize, targetSize, decodingInfo.getViewScaleType(), decodingOptions);
            if (this.loggingEnabled) {
                L.d(LOG_SUBSAMPLE_IMAGE, imageSize, imageSize.scaleDown(scale), scale, decodingInfo.getImageKey());
            }
        }
        BitmapFactory.Options decodingOptions1 = decodingInfo.getDecodingOptions();
        decodingOptions1.inSampleSize = scale;
        return decodingOptions1;
    }

    protected InputStream resetStream(InputStream imageStream, ImageDecodingInfo decodingInfo) throws IOException {
        try {
            imageStream.reset();
        }
        catch (IOException var4) {
            imageStream = this.getImageStream(decodingInfo);
        }
        return imageStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bitmap decodeStream(InputStream imageStream, BitmapFactory.Options decodingOptions) throws IOException {
        Bitmap var3;
        try {
            var3 = BitmapFactory.decodeStream((InputStream)imageStream, (Rect)null, (BitmapFactory.Options)decodingOptions);
        }
        finally {
            IoUtils.closeSilently(imageStream);
        }
        return var3;
    }

    protected Bitmap considerExactScaleAndOrientaiton(Bitmap subsampledBitmap, ImageDecodingInfo decodingInfo, int rotation, boolean flipHorizontal) {
        Bitmap finalBitmap1;
        ImageSize finalBitmap;
        float scale;
        Matrix m = new Matrix();
        ImageScaleType scaleType = decodingInfo.getImageScaleType();
        if ((scaleType == ImageScaleType.EXACTLY || scaleType == ImageScaleType.EXACTLY_STRETCHED) && Float.compare(scale = ImageSizeUtils.computeImageScale(finalBitmap = new ImageSize(subsampledBitmap.getWidth(), subsampledBitmap.getHeight(), rotation), decodingInfo.getTargetSize(), decodingInfo.getViewScaleType(), scaleType == ImageScaleType.EXACTLY_STRETCHED), 1.0f) != 0) {
            m.setScale(scale, scale);
            if (this.loggingEnabled) {
                L.d(LOG_SCALE_IMAGE, finalBitmap, finalBitmap.scale(scale), Float.valueOf(scale), decodingInfo.getImageKey());
            }
        }
        if (flipHorizontal) {
            m.postScale(-1.0f, 1.0f);
            if (this.loggingEnabled) {
                L.d(LOG_FLIP_IMAGE, decodingInfo.getImageKey());
            }
        }
        if (rotation != 0) {
            m.postRotate((float)rotation);
            if (this.loggingEnabled) {
                L.d("Rotate image on %1$d\ufffd\ufffd [%2$s]", rotation, decodingInfo.getImageKey());
            }
        }
        if ((finalBitmap1 = Bitmap.createBitmap((Bitmap)subsampledBitmap, (int)0, (int)0, (int)subsampledBitmap.getWidth(), (int)subsampledBitmap.getHeight(), (Matrix)m, (boolean)true)) != subsampledBitmap) {
            subsampledBitmap.recycle();
        }
        return finalBitmap1;
    }

    protected static class ExifInfo {
        public final int rotation;
        public final boolean flipHorizontal;

        protected ExifInfo() {
            this.rotation = 0;
            this.flipHorizontal = false;
        }

        protected ExifInfo(int rotation, boolean flipHorizontal) {
            this.rotation = rotation;
            this.flipHorizontal = flipHorizontal;
        }
    }

    protected static class ImageFileInfo {
        public final ImageSize imageSize;
        public final ExifInfo exif;

        protected ImageFileInfo(ImageSize imageSize, ExifInfo exif) {
            this.imageSize = imageSize;
            this.exif = exif;
        }
    }
}

