/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.datamatrix.decoder;

import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.datamatrix.decoder.Version;

final class BitMatrixParser {
    private final BitMatrix mappingBitMatrix;
    private final BitMatrix readMappingMatrix;
    private final Version version;

    BitMatrixParser(BitMatrix bitMatrix) throws FormatException {
        int n5 = bitMatrix.getHeight();
        if (n5 >= 8 && n5 <= 144 && (n5 & 1) == 0) {
            ((BitMatrixParser)((Object)bitMatrix2)).version = BitMatrixParser.readVersion(bitMatrix);
            BitMatrix bitMatrix2 = ((BitMatrixParser)((Object)bitMatrix2)).extractDataRegion(bitMatrix);
            v0.mappingBitMatrix = bitMatrix2;
            BitMatrix bitMatrix3 = bitMatrix2;
            int n6 = bitMatrix3.getWidth();
            v0.readMappingMatrix = new BitMatrix(n6, bitMatrix3.getHeight());
            return;
        }
        throw FormatException.getFormatInstance();
    }

    private static Version readVersion(BitMatrix bitMatrix) throws FormatException {
        return Version.getVersionForDimensions(bitMatrix.getHeight(), bitMatrix.getWidth());
    }

    Version getVersion() {
        return this.version;
    }

    byte[] readCodewords() throws FormatException {
        BitMatrixParser bitMatrixParser = this;
        byte[] byArray = new byte[bitMatrixParser.version.getTotalCodewords()];
        int n5 = 0;
        int n6 = 4;
        int n7 = 0;
        int n8 = bitMatrixParser.mappingBitMatrix.getHeight();
        int n9 = bitMatrixParser.mappingBitMatrix.getWidth();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        do {
            int n10;
            if (n6 == n8 && n7 == 0 && !bl) {
                byArray[n5++] = (byte)this.readCorner1(n8, n9);
                n6 -= 2;
                n7 += 2;
                bl = true;
                continue;
            }
            int n11 = n8 - 2;
            if (n6 == n11 && n7 == 0 && (n9 & 3) != 0 && !bl2) {
                byArray[n5++] = (byte)this.readCorner2(n8, n9);
                n6 -= 2;
                n7 += 2;
                bl2 = true;
                continue;
            }
            if (n6 == n8 + 4 && n7 == 2 && (n9 & 7) == 0 && !bl3) {
                byArray[n5++] = (byte)this.readCorner3(n8, n9);
                n6 -= 2;
                n7 += 2;
                bl3 = true;
                continue;
            }
            if (n6 == n11 && n7 == 0 && (n9 & 7) == 4 && !bl4) {
                byArray[n5++] = (byte)this.readCorner4(n8, n9);
                n6 -= 2;
                n7 += 2;
                bl4 = true;
                continue;
            }
            while (true) {
                if (n6 < n8 && n7 >= 0 && !this.readMappingMatrix.get(n7, n6)) {
                    byArray[n5++] = (byte)this.readUtah(n6, n7, n8, n9);
                }
                n11 = n6 + -2;
                n10 = n7 + 2;
                if (n11 < 0 || n10 >= n9) break;
                n7 = n10;
                n6 = n11;
            }
            --n6;
            n7 += 5;
            while (true) {
                if (n6 >= 0 && n7 < n9 && !this.readMappingMatrix.get(n7, n6)) {
                    byArray[n5++] = (byte)this.readUtah(n6, n7, n8, n9);
                }
                n11 = n6 + 2;
                n10 = n7 + -2;
                if (n11 >= n8 || n10 < 0) break;
                n7 = n10;
                n6 = n11;
            }
            n6 += 5;
            --n7;
        } while (n6 < n8 || n7 < n9);
        if (n5 == this.version.getTotalCodewords()) {
            return byArray;
        }
        throw FormatException.getFormatInstance();
    }

    boolean readModule(int n5, int n6, int n7, int n8) {
        if (n5 < 0) {
            n5 += n7;
            n6 += 4 - (n7 + 4 & 7);
        }
        if (n6 < 0) {
            n6 += n8;
            n5 += 4 - (n8 + 4 & 7);
        }
        BitMatrixParser bitMatrixParser = this;
        bitMatrixParser.readMappingMatrix.set(n6, n5);
        return bitMatrixParser.mappingBitMatrix.get(n6, n5);
    }

    int readUtah(int n5, int n6, int n7, int n8) {
        int n9 = n5 - 2;
        int n10 = n6 - 2;
        int n11 = this.readModule(n9, n10, n7, n8) << 1;
        int n12 = n6 - 1;
        if (this.readModule(n9, n12, n7, n8)) {
            n11 |= 1;
        }
        n9 = n11 << 1;
        n11 = n5 - 1;
        if (this.readModule(n11, n10, n7, n8)) {
            n9 |= 1;
        }
        n9 <<= 1;
        if (this.readModule(n11, n12, n7, n8)) {
            n9 |= 1;
        }
        n9 <<= 1;
        if (this.readModule(n11, n6, n7, n8)) {
            n9 |= 1;
        }
        n9 <<= 1;
        if (this.readModule(n5, n10, n7, n8)) {
            n9 |= 1;
        }
        n9 <<= 1;
        if (this.readModule(n5, n12, n7, n8)) {
            n9 |= 1;
        }
        int n13 = n9 << 1;
        if (this.readModule(n5, n6, n7, n8)) {
            return n13 | 1;
        }
        return n13;
    }

    int readCorner1(int n5, int n6) {
        BitMatrixParser bitMatrixParser = this;
        int n7 = n5 - 1;
        int n8 = bitMatrixParser.readModule(n7, 0, n5, n6) << 1;
        if (bitMatrixParser.readModule(n7, 1, n5, n6)) {
            n8 |= 1;
        }
        int n9 = n7;
        n7 = n8 << 1;
        if (this.readModule(n9, 2, n5, n6)) {
            n7 |= 1;
        }
        n7 <<= 1;
        if (this.readModule(0, n6 - 2, n5, n6)) {
            n7 |= 1;
        }
        n7 <<= 1;
        n8 = n6 - 1;
        if (this.readModule(0, n8, n5, n6)) {
            n7 |= 1;
        }
        n7 <<= 1;
        if (this.readModule(1, n8, n5, n6)) {
            n7 |= 1;
        }
        n7 <<= 1;
        if (this.readModule(2, n8, n5, n6)) {
            n7 |= 1;
        }
        int n10 = n7 << 1;
        if (this.readModule(3, n8, n5, n6)) {
            return n10 | 1;
        }
        return n10;
    }

    int readCorner2(int n5, int n6) {
        int n7 = this.readModule(n5 - 3, 0, n5, n6) << 1;
        if (this.readModule(n5 - 2, 0, n5, n6)) {
            n7 |= 1;
        }
        n7 <<= 1;
        if (this.readModule(n5 - 1, 0, n5, n6)) {
            n7 |= 1;
        }
        n7 <<= 1;
        if (this.readModule(0, n6 - 4, n5, n6)) {
            n7 |= 1;
        }
        n7 <<= 1;
        if (this.readModule(0, n6 - 3, n5, n6)) {
            n7 |= 1;
        }
        n7 <<= 1;
        if (this.readModule(0, n6 - 2, n5, n6)) {
            n7 |= 1;
        }
        n7 <<= 1;
        int n8 = n6 - 1;
        if (this.readModule(0, n8, n5, n6)) {
            n7 |= 1;
        }
        int n9 = n7 << 1;
        if (this.readModule(1, n8, n5, n6)) {
            return n9 | 1;
        }
        return n9;
    }

    int readCorner3(int n5, int n6) {
        int n7 = n5 - 1;
        int n8 = this.readModule(n7, 0, n5, n6) << 1;
        int n9 = n6 - 1;
        if (this.readModule(n7, n9, n5, n6)) {
            n8 |= 1;
        }
        n7 = n8 << 1;
        n8 = n6 - 3;
        if (this.readModule(0, n8, n5, n6)) {
            n7 |= 1;
        }
        n7 <<= 1;
        int n10 = n6 - 2;
        if (this.readModule(0, n10, n5, n6)) {
            n7 |= 1;
        }
        n7 <<= 1;
        if (this.readModule(0, n9, n5, n6)) {
            n7 |= 1;
        }
        n7 <<= 1;
        if (this.readModule(1, n8, n5, n6)) {
            n7 |= 1;
        }
        n7 <<= 1;
        if (this.readModule(1, n10, n5, n6)) {
            n7 |= 1;
        }
        int n11 = n7 << 1;
        if (this.readModule(1, n9, n5, n6)) {
            return n11 | 1;
        }
        return n11;
    }

    int readCorner4(int n5, int n6) {
        int n7 = this.readModule(n5 - 3, 0, n5, n6) << 1;
        if (this.readModule(n5 - 2, 0, n5, n6)) {
            n7 |= 1;
        }
        n7 <<= 1;
        if (this.readModule(n5 - 1, 0, n5, n6)) {
            n7 |= 1;
        }
        n7 <<= 1;
        if (this.readModule(0, n6 - 2, n5, n6)) {
            n7 |= 1;
        }
        n7 <<= 1;
        int n8 = n6 - 1;
        if (this.readModule(0, n8, n5, n6)) {
            n7 |= 1;
        }
        n7 <<= 1;
        if (this.readModule(1, n8, n5, n6)) {
            n7 |= 1;
        }
        n7 <<= 1;
        if (this.readModule(2, n8, n5, n6)) {
            n7 |= 1;
        }
        int n9 = n7 << 1;
        if (this.readModule(3, n8, n5, n6)) {
            return n9 | 1;
        }
        return n9;
    }

    BitMatrix extractDataRegion(BitMatrix bitMatrix) {
        BitMatrixParser bitMatrixParser = this;
        int n5 = bitMatrixParser.version.getSymbolSizeRows();
        int n6 = bitMatrixParser.version.getSymbolSizeColumns();
        if (bitMatrix.getHeight() == n5) {
            BitMatrix bitMatrix2;
            int n7 = n6;
            int n8 = n5;
            n5 = this.version.getDataRegionSizeRows();
            int n9 = this.version.getDataRegionSizeColumns();
            n6 = n8 / n5;
            int n10 = n7 / n9;
            int n11 = n6 * n5;
            int n12 = n10 * n9;
            BitMatrix bitMatrix3 = bitMatrix2;
            bitMatrix2 = new BitMatrix(n12, n11);
            for (n11 = 0; n11 < n6; ++n11) {
                n12 = n11 * n5;
                for (int i5 = 0; i5 < n10; ++i5) {
                    int n13 = i5 * n9;
                    for (int i6 = 0; i6 < n5; ++i6) {
                        int n14 = n11 * (n5 + 2) + 1 + i6;
                        int n15 = n12 + i6;
                        for (int i7 = 0; i7 < n9; ++i7) {
                            if (!bitMatrix.get(i5 * (n9 + 2) + 1 + i7, n14)) continue;
                            bitMatrix3.set(n13 + i7, n15);
                        }
                    }
                }
            }
            return bitMatrix3;
        }
        throw new IllegalArgumentException("Dimension of bitMarix must match the version size");
    }
}

