/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.uts;

import io.dcloud.uts.NumberKt;
import io.dcloud.uts.UTSNumber;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b*\n\u0002\u0010\u0011\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0018\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0007J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\b\u0010!\u001a\u00020\u0004H\u0007J\u0012\u0010!\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\"\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0010\u0010#\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0010\u0010%\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0010\u0010&\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0010\u0010'\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0018\u0010(\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0007J\u0010\u0010)\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0010\u0010*\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0010\u0010+\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0010\u0010,\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J!\u0010-\u001a\u00020\u00042\u0012\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040/\"\u00020\u0004H\u0007\u00a2\u0006\u0002\u00100J!\u00101\u001a\u00020\u00042\u0012\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040/\"\u00020\u0004H\u0007\u00a2\u0006\u0002\u00100J\u0018\u00102\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0007J\b\u00103\u001a\u00020\u0004H\u0007J\u0010\u00104\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0010\u00105\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0010\u00106\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0010\u00107\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0010\u00108\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0010\u00109\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0010\u0010:\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0010\u0010;\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006\u00a8\u0006<"}, d2={"Lio/dcloud/uts/Math;", "", "()V", "E", "", "getE", "()Ljava/lang/Number;", "LN10", "getLN10", "LN2", "getLN2", "LOG10E", "getLOG10E", "LOG2E", "getLOG2E", "PI", "getPI", "SQRT1_2", "getSQRT1_2", "SQRT2", "getSQRT2", "abs", "x", "acos", "acosh", "asin", "asinh", "atan", "atan2", "y", "atanh", "cbrt", "ceil", "clz32", "cos", "cosh", "exp", "expm1", "floor", "fround", "hypot", "log", "log10", "log1p", "log2", "max", "values", "", "([Ljava/lang/Number;)Ljava/lang/Number;", "min", "pow", "random", "round", "sign", "sin", "sinh", "sqrt", "tan", "tanh", "trunc", "utsplugin_release"})
@SourceDebugExtension(value={"SMAP\nMath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Math.kt\nio/dcloud/uts/Math\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,438:1\n13579#2,2:439\n13579#2,2:441\n*S KotlinDebug\n*F\n+ 1 Math.kt\nio/dcloud/uts/Math\n*L\n337#1:439,2\n355#1:441,2\n*E\n"})
public final class Math {
    @NotNull
    public static final Math INSTANCE = new Math();
    @NotNull
    private static final Number E = java.lang.Math.E;
    @NotNull
    private static final Number PI = java.lang.Math.PI;
    @NotNull
    private static final Number LN10 = 2.302585092994046;
    @NotNull
    private static final Number LN2 = 0.6931471805599453;
    @NotNull
    private static final Number LOG10E = 0.4342944819032518;
    @NotNull
    private static final Number LOG2E = 1.4426950408889634;
    @NotNull
    private static final Number SQRT1_2 = 0.7071067811865476;
    @NotNull
    private static final Number SQRT2 = 1.4142135623730951;

    private Math() {
    }

    @NotNull
    public final Number getE() {
        return E;
    }

    @NotNull
    public final Number getPI() {
        return PI;
    }

    @NotNull
    public final Number getLN10() {
        return LN10;
    }

    @NotNull
    public final Number getLN2() {
        return LN2;
    }

    @NotNull
    public final Number getLOG10E() {
        return LOG10E;
    }

    @NotNull
    public final Number getLOG2E() {
        return LOG2E;
    }

    @NotNull
    public final Number getSQRT1_2() {
        return SQRT1_2;
    }

    @NotNull
    public final Number getSQRT2() {
        return SQRT2;
    }

    @JvmStatic
    @NotNull
    public static final Number abs(@NotNull Number x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Number number = x;
        Double absValue = number instanceof Double ? (Number)java.lang.Math.abs(x.doubleValue()) : (Number)(number instanceof Float ? (Number)Float.valueOf(java.lang.Math.abs(x.floatValue())) : (Number)(number instanceof Integer ? (Number)java.lang.Math.abs(x.intValue()) : (Number)(number instanceof Long ? (Number)java.lang.Math.abs(x.longValue()) : (Number)(number instanceof Byte ? (Number)java.lang.Math.abs(x.intValue()) : (Number)(number instanceof Short ? (Number)java.lang.Math.abs(x.intValue()) : (Number)java.lang.Math.abs(x.doubleValue()))))));
        return absValue;
    }

    @JvmStatic
    @NotNull
    public static final Number acos(@NotNull Number x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Double aCosValue = x instanceof Float ? (Number)Float.valueOf((float)java.lang.Math.acos(x.floatValue())) : (Number)java.lang.Math.acos(x.doubleValue());
        return NumberKt.UTSNumber(aCosValue);
    }

    @JvmStatic
    @NotNull
    public static final Number acosh(@NotNull Number x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Double aCoshValue = x instanceof Float ? (Number)Float.valueOf((float)MathKt.acosh((double)x.floatValue())) : (Number)MathKt.acosh((double)x.doubleValue());
        return NumberKt.UTSNumber(aCoshValue);
    }

    @JvmStatic
    @NotNull
    public static final Number asin(@NotNull Number x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Double aSinValue = x instanceof Float ? (Number)Float.valueOf((float)java.lang.Math.asin(x.floatValue())) : (Number)java.lang.Math.asin(x.doubleValue());
        return NumberKt.UTSNumber(aSinValue);
    }

    @JvmStatic
    @NotNull
    public static final Number asinh(@NotNull Number x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Double aSinHValue = x instanceof Float ? (Number)Float.valueOf((float)MathKt.asinh((double)x.floatValue())) : (Number)MathKt.asinh((double)x.doubleValue());
        return NumberKt.UTSNumber(aSinHValue);
    }

    @JvmStatic
    @NotNull
    public static final Number atan(@NotNull Number x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Double aTanValue = x instanceof Float ? (Number)Float.valueOf((float)java.lang.Math.atan(x.floatValue())) : (Number)java.lang.Math.atan(x.doubleValue());
        return NumberKt.UTSNumber(aTanValue);
    }

    @JvmStatic
    @NotNull
    public static final Number atanh(@NotNull Number x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Double aTanHValue = x instanceof Float ? (Number)Float.valueOf((float)MathKt.atanh((double)x.floatValue())) : (Number)MathKt.atanh((double)x.doubleValue());
        return NumberKt.UTSNumber(aTanHValue);
    }

    @JvmStatic
    @NotNull
    public static final Number atan2(@NotNull Number x, @NotNull Number y) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        double doubleRet = java.lang.Math.atan2(x.doubleValue(), y.doubleValue());
        return NumberKt.UTSNumber(doubleRet);
    }

    @JvmStatic
    @NotNull
    public static final Number cbrt(@NotNull Number x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        double doubleRet = java.lang.Math.pow(x.doubleValue(), 0.3333333333333333);
        return NumberKt.UTSNumber(doubleRet);
    }

    @JvmStatic
    @NotNull
    public static final Number ceil(@NotNull Number x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        if (Intrinsics.areEqual((Object)x, (Object)NumberKt.getNaN())) {
            return x;
        }
        Double ceilDouble = x instanceof Float ? (Number)Float.valueOf((float)java.lang.Math.ceil(x.floatValue())) : (Number)java.lang.Math.ceil(x.doubleValue());
        Long doubleRet = NumberKt.compareTo(ceilDouble, Integer.MAX_VALUE) > 0 || NumberKt.compareTo(ceilDouble, Integer.MIN_VALUE) < 0 ? (Number)((Number)ceilDouble).longValue() : (Number)((Number)ceilDouble).intValue();
        return doubleRet;
    }

    @JvmStatic
    @NotNull
    public static final Number clz32() {
        return 32;
    }

    @JvmStatic
    @NotNull
    public static final Number clz32(@Nullable Number x) {
        if (x == null || Intrinsics.areEqual((Object)UTSNumber.INSTANCE.getNaN(), (Object)x) || Intrinsics.areEqual((Object)UTSNumber.INSTANCE.getPOSITIVE_INFINITY(), (Object)x) || Intrinsics.areEqual((Object)UTSNumber.INSTANCE.getNEGATIVE_INFINITY(), (Object)x) || Intrinsics.areEqual((Object)UTSNumber.INSTANCE.getMAX_VALUE(), (Object)x) || Intrinsics.areEqual((Object)UTSNumber.INSTANCE.getMIN_VALUE(), (Object)x)) {
            return 32;
        }
        int offsetInt = UInt.constructor-impl((int)x.intValue());
        if (offsetInt == UInt.constructor-impl((int)0)) {
            return 32;
        }
        String binaryStr = NumberKt.toString((long)offsetInt & 0xFFFFFFFFL, (Number)2);
        return 32 - binaryStr.length();
    }

    @JvmStatic
    @NotNull
    public static final Number cos(@NotNull Number x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        if (x instanceof Float) {
            return Float.valueOf((float)java.lang.Math.cos(x.floatValue()));
        }
        return java.lang.Math.cos(x.doubleValue());
    }

    @JvmStatic
    @NotNull
    public static final Number cosh(@NotNull Number x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        if (x instanceof Float) {
            return Float.valueOf((float)java.lang.Math.cosh(x.floatValue()));
        }
        return java.lang.Math.cosh(x.doubleValue());
    }

    @JvmStatic
    @NotNull
    public static final Number exp(@NotNull Number x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        if (x instanceof Float) {
            return Float.valueOf((float)java.lang.Math.exp(x.floatValue()));
        }
        return java.lang.Math.exp(x.doubleValue());
    }

    @JvmStatic
    @NotNull
    public static final Number expm1(@NotNull Number x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        if (x instanceof Float) {
            return Float.valueOf((float)java.lang.Math.expm1(x.floatValue()));
        }
        return java.lang.Math.expm1(x.doubleValue());
    }

    @JvmStatic
    @NotNull
    public static final Number floor(@NotNull Number x) {
        Double floorDouble;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Number number = floorDouble = x instanceof Float ? (Number)Float.valueOf((float)java.lang.Math.floor(x.floatValue())) : (Number)java.lang.Math.floor(x.doubleValue());
        if (NumberKt.compareTo(floorDouble, Integer.MAX_VALUE) > 0 || NumberKt.compareTo(floorDouble, Integer.MIN_VALUE) < 0) {
            return ((Number)floorDouble).longValue();
        }
        return ((Number)floorDouble).intValue();
    }

    @JvmStatic
    @NotNull
    public static final Number fround(@NotNull Number x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return Float.valueOf(x.floatValue());
    }

    @JvmStatic
    @NotNull
    public static final Number hypot(@NotNull Number x, @NotNull Number y) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        if (x instanceof Float && y instanceof Float) {
            return Float.valueOf((float)java.lang.Math.hypot(x.floatValue(), y.floatValue()));
        }
        return java.lang.Math.hypot(x.doubleValue(), y.doubleValue());
    }

    @JvmStatic
    @NotNull
    public static final Number log(@NotNull Number x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return java.lang.Math.log(x.doubleValue());
    }

    @JvmStatic
    @NotNull
    public static final Number log10(@NotNull Number x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return java.lang.Math.log10(x.doubleValue());
    }

    @JvmStatic
    @NotNull
    public static final Number log1p(@NotNull Number x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return java.lang.Math.log(NumberKt.plus(x, 1).doubleValue());
    }

    @JvmStatic
    @NotNull
    public static final Number log2(@NotNull Number x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return MathKt.log2((double)x.doubleValue());
    }

    @JvmStatic
    @NotNull
    public static final Number max(Number ... values2) {
        Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
        if (ArraysKt.contains((Object[])values2, (Object)UTSNumber.INSTANCE.getNaN())) {
            return UTSNumber.INSTANCE.getNaN();
        }
        if (values2.length == 0) {
            return -1;
        }
        Number maxNum = null;
        maxNum = values2[0];
        Number[] $this$forEach$iv = values2;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Number element$iv;
            Number it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (NumberKt.compareTo(it, maxNum) <= 0) continue;
            maxNum = it;
        }
        return maxNum;
    }

    @JvmStatic
    @NotNull
    public static final Number min(Number ... values2) {
        Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
        if (ArraysKt.contains((Object[])values2, (Object)UTSNumber.INSTANCE.getNaN())) {
            return UTSNumber.INSTANCE.getNaN();
        }
        if (values2.length == 0) {
            return 0;
        }
        Number minNum = null;
        minNum = values2[0];
        Number[] $this$forEach$iv = values2;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Number element$iv;
            Number it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (NumberKt.compareTo(it, minNum) >= 0) continue;
            minNum = it;
        }
        return minNum;
    }

    @JvmStatic
    @NotNull
    public static final Number pow(@NotNull Number x, @NotNull Number y) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        return java.lang.Math.pow(x.doubleValue(), y.doubleValue());
    }

    @JvmStatic
    @NotNull
    public static final Number random() {
        return Random.Default.nextDouble();
    }

    @JvmStatic
    @NotNull
    public static final Number round(@NotNull Number x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        if (Intrinsics.areEqual((Object)x, (Object)UTSNumber.INSTANCE.getNaN()) || Intrinsics.areEqual((Object)x, (Object)UTSNumber.INSTANCE.getPOSITIVE_INFINITY()) || Intrinsics.areEqual((Object)x, (Object)UTSNumber.INSTANCE.getNEGATIVE_INFINITY()) || Intrinsics.areEqual((Object)x, (Object)UTSNumber.INSTANCE.getMAX_VALUE())) {
            return x;
        }
        double roundDouble = x.doubleValue();
        if (roundDouble > 2.147483647E9 || roundDouble < -2.147483648E9) {
            return MathKt.roundToLong((double)roundDouble);
        }
        return MathKt.roundToInt((double)roundDouble);
    }

    @JvmStatic
    @NotNull
    public static final Number sign(@NotNull Number x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        if (NumberKt.compareTo(x, 0) < 0) {
            return -1;
        }
        if (Intrinsics.areEqual((Object)x, (Object)0)) {
            return 0;
        }
        return 1;
    }

    @JvmStatic
    @NotNull
    public static final Number sin(@NotNull Number x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return java.lang.Math.sin(x.doubleValue());
    }

    @JvmStatic
    @NotNull
    public static final Number sinh(@NotNull Number x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return java.lang.Math.sinh(x.doubleValue());
    }

    @JvmStatic
    @NotNull
    public static final Number sqrt(@NotNull Number x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return java.lang.Math.sqrt(x.doubleValue());
    }

    @JvmStatic
    @NotNull
    public static final Number tan(@NotNull Number x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return java.lang.Math.tan(x.doubleValue());
    }

    @JvmStatic
    @NotNull
    public static final Number tanh(@NotNull Number x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return java.lang.Math.tanh(x.doubleValue());
    }

    @JvmStatic
    @NotNull
    public static final Number trunc(@NotNull Number x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return x.intValue();
    }
}

