/*
 * Decompiled with CFR 0.152.
 */
package androidtranscoder.format;

import android.media.MediaFormat;
import androidtranscoder.format.MediaFormatStrategy;

class Android720pFormatStrategy
implements MediaFormatStrategy {
    public static final int AUDIO_BITRATE_AS_IS = -1;
    public static final int AUDIO_CHANNELS_AS_IS = -1;
    private static final String TAG = "720pFormatStrategy";
    private static final int LONGER_LENGTH = 1280;
    private static final int SHORTER_LENGTH = 720;
    private static final int DEFAULT_VIDEO_BITRATE = 8000000;
    private int mVideoBitrate;
    private final int mAudioBitrate;
    private final int mAudioChannels;
    private int compressLevel;
    private double resolution;

    public Android720pFormatStrategy(int n5, double d6) {
        this.mAudioBitrate = 128000;
        this.mAudioChannels = 1;
        this.compressLevel = n5;
        this.resolution = d6;
    }

    @Override
    public MediaFormat createVideoOutputFormat(MediaFormat mediaFormat) {
        MediaFormat mediaFormat2 = mediaFormat;
        int n5 = mediaFormat2.getInteger("width");
        int n6 = mediaFormat2.getInteger("height");
        double d6 = this.resolution;
        if (d6 == 1.0) {
            int n7 = this.compressLevel;
            if (n7 == 1) {
                n5 = (int)((double)n5 * 0.8);
                n6 = (int)((double)n6 * 0.8);
            } else if (n7 == 2) {
                n5 = (int)((double)n5 * 0.5);
                n6 = (int)((double)n6 * 0.5);
            } else {
                n5 = (int)((double)n5 * 0.3);
                n6 = (int)((double)n6 * 0.3);
            }
        } else {
            n5 = (int)((double)n5 * d6);
            n6 = (int)((double)n6 * d6);
        }
        if (n5 % 2 > 0) {
            ++n5;
        }
        if (n6 % 2 > 0) {
            ++n6;
        }
        this.mVideoBitrate = n5 * n6;
        MediaFormat mediaFormat3 = MediaFormat.createVideoFormat((String)"video/avc", (int)n5, (int)n6);
        mediaFormat3.setInteger("bitrate", this.mVideoBitrate);
        mediaFormat3.setInteger("frame-rate", 25);
        mediaFormat3.setInteger("i-frame-interval", 3);
        mediaFormat3.setInteger("color-format", 2130708361);
        return mediaFormat3;
    }

    @Override
    public MediaFormat createAudioOutputFormat(MediaFormat mediaFormat) {
        if (this.mAudioBitrate != -1 && this.mAudioChannels != -1) {
            int n5 = mediaFormat.getInteger("sample-rate");
            int n6 = this.mAudioChannels;
            MediaFormat mediaFormat2 = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)n5, (int)n6);
            mediaFormat2.setInteger("aac-profile", 2);
            mediaFormat2.setInteger("bitrate", this.mAudioBitrate);
            return mediaFormat2;
        }
        return null;
    }
}

