/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.ChecksumException;
import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.Result;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.common.BitArray;
import com.dcloud.zxing2.oned.OneDReader;
import java.util.Arrays;
import java.util.Map;

public final class Code39Reader
extends OneDReader {
    static final String ALPHABET_STRING = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%";
    private static final String CHECK_DIGIT_STRING = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";
    static final int[] CHARACTER_ENCODINGS;
    static final int ASTERISK_ENCODING;
    private final boolean usingCheckDigit;
    private final boolean extendedMode;
    private final StringBuilder decodeRowResult;
    private final int[] counters;

    public Code39Reader() {
        this(false);
    }

    public Code39Reader(boolean bl) {
        this(bl, false);
    }

    public Code39Reader(boolean bl, boolean bl2) {
        Code39Reader code39Reader = this;
        this.usingCheckDigit = bl;
        code39Reader.extendedMode = bl2;
        code39Reader.decodeRowResult = new StringBuilder(20);
        code39Reader.counters = new int[9];
    }

    private static int[] findAsteriskPattern(BitArray bitArray, int[] nArray) throws NotFoundException {
        int n5;
        int n6 = bitArray.getSize();
        int n7 = 0;
        int n8 = 0;
        int n9 = nArray.length;
        int n10 = n8;
        int n11 = n7;
        n7 = n5;
        n8 = n11;
        int n12 = n10;
        for (n5 = (v90935).getNextSet(0); n5 < n6; ++n5) {
            if ((bitArray.get(n5) ^ n12) != 0) {
                nArray[n8] = nArray[n8] + 1;
                continue;
            }
            int n13 = n9 - 1;
            if (n8 == n13) {
                if (Code39Reader.toNarrowWidePattern(nArray) == ASTERISK_ENCODING && bitArray.isRange(Math.max(0, n7 - (n5 - n7) / 2), n7, false)) {
                    return new int[]{n7, n5};
                }
                int n14 = n13;
                n7 += nArray[0] + nArray[1];
                n13 = n9 - 2;
                System.arraycopy(nArray, 2, nArray, 0, n13);
                nArray[n13] = 0;
                nArray[n14] = 0;
                --n8;
            } else {
                ++n8;
            }
            nArray[n8] = 1;
            n12 ^= 1;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int toNarrowWidePattern(int[] nArray) {
        int n5 = nArray.length;
        int n6 = 0;
        while (true) {
            int n7;
            int n82;
            int n9 = Integer.MAX_VALUE;
            for (int n82 : nArray) {
                if (n82 >= n9 || n82 <= n6) continue;
                n9 = n82;
            }
            n6 = 0;
            int n10 = 0;
            int n11 = 0;
            for (n82 = 0; n82 < n5; ++n82) {
                n7 = nArray[n82];
                if (n7 <= n9) continue;
                int n12 = n10;
                n10 = n11 | 1 << n5 - 1 - n82;
                ++n6;
                n11 = n12 + n7;
                int n13 = n10;
                n10 = n11;
                n11 = n13;
            }
            if (n6 == 3) {
                for (n82 = 0; n82 < n5 && n6 > 0; ++n82) {
                    n7 = nArray[n82];
                    if (n7 <= n9) continue;
                    --n6;
                    if (n7 * 2 < n10) continue;
                    return -1;
                }
                return n11;
            }
            if (n6 <= 3) {
                return -1;
            }
            n6 = n9;
        }
    }

    private static char patternToChar(int n5) throws NotFoundException {
        int n6 = 0;
        while (true) {
            int[] nArray = CHARACTER_ENCODINGS;
            if (n6 >= CHARACTER_ENCODINGS.length) break;
            if (nArray[n6] == n5) {
                return ALPHABET_STRING.charAt(n6);
            }
            ++n6;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static String decodeExtended(CharSequence charSequence) throws FormatException {
        StringBuilder stringBuilder;
        int n5 = charSequence.length();
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(n5);
        for (int i5 = 0; i5 < n5; ++i5) {
            block14: {
                char c6;
                block8: {
                    char c7;
                    block5: {
                        block13: {
                            block12: {
                                block6: {
                                    block11: {
                                        block7: {
                                            block10: {
                                                block9: {
                                                    char c8 = charSequence.charAt(i5);
                                                    if (c8 != '+' && c8 != '$' && c8 != '%' && c8 != '/') {
                                                        stringBuilder2.append(c8);
                                                        continue;
                                                    }
                                                    c7 = charSequence.charAt(++i5);
                                                    c6 = '\u0000';
                                                    if (c8 == '$') break block5;
                                                    if (c8 == '%') break block6;
                                                    if (c8 == '+') break block7;
                                                    if (c8 != '/') break block8;
                                                    if (c7 < 'A' || c7 > 'O') break block9;
                                                    c6 = (char)(c7 - 32);
                                                    break block8;
                                                }
                                                if (c7 != 'Z') break block10;
                                                c6 = (char)58;
                                                break block8;
                                            }
                                            throw FormatException.getFormatInstance();
                                        }
                                        if (c7 < 'A' || c7 > 'Z') break block11;
                                        c6 = (char)(c7 + 32);
                                        break block8;
                                    }
                                    throw FormatException.getFormatInstance();
                                }
                                if (c7 < 'A' || c7 > 'E') break block12;
                                c6 = (char)(c7 - 38);
                                break block8;
                            }
                            if (c7 < 'F' || c7 > 'W') break block13;
                            c6 = (char)(c7 - 11);
                            break block8;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    if (c7 < 'A' || c7 > 'Z') break block14;
                    c6 = (char)(c7 - 64);
                }
                stringBuilder2.append(c6);
                continue;
            }
            throw FormatException.getFormatInstance();
        }
        return stringBuilder2.toString();
    }

    static {
        int[] nArray = new int[44];
        int[] nArray2 = nArray;
        nArray[0] = 52;
        nArray2[1] = 289;
        nArray2[2] = 97;
        nArray2[3] = 352;
        nArray2[4] = 49;
        nArray2[5] = 304;
        nArray2[6] = 112;
        nArray2[7] = 37;
        nArray2[8] = 292;
        nArray2[9] = 100;
        nArray2[10] = 265;
        nArray2[11] = 73;
        nArray2[12] = 328;
        nArray2[13] = 25;
        nArray2[14] = 280;
        nArray2[15] = 88;
        nArray2[16] = 13;
        nArray2[17] = 268;
        nArray2[18] = 76;
        nArray2[19] = 28;
        nArray2[20] = 259;
        nArray2[21] = 67;
        nArray2[22] = 322;
        nArray2[23] = 19;
        nArray2[24] = 274;
        nArray2[25] = 82;
        nArray2[26] = 7;
        nArray2[27] = 262;
        nArray2[28] = 70;
        nArray2[29] = 22;
        nArray2[30] = 385;
        nArray2[31] = 193;
        nArray2[32] = 448;
        nArray2[33] = 145;
        nArray2[34] = 400;
        nArray2[35] = 208;
        nArray2[36] = 133;
        nArray2[37] = 388;
        nArray2[38] = 196;
        nArray2[39] = 148;
        nArray2[40] = 168;
        nArray2[41] = 162;
        nArray2[42] = 138;
        nArray2[43] = 42;
        CHARACTER_ENCODINGS = nArray2;
        ASTERISK_ENCODING = nArray2[39];
    }

    @Override
    public Result decodeRow(int n5, BitArray bitArray, Map<DecodeHintType, ?> object) throws NotFoundException, ChecksumException, FormatException {
        BitArray bitArray2 = bitArray;
        Code39Reader code39Reader = object2;
        object = code39Reader.counters;
        Arrays.fill(code39Reader.counters, 0);
        StringBuilder stringBuilder = code39Reader.decodeRowResult;
        stringBuilder.setLength(0);
        int[] nArray = Code39Reader.findAsteriskPattern(bitArray2, (int[])object);
        int n6 = bitArray2.getNextSet(nArray[1]);
        int n7 = bitArray2.getSize();
        while (true) {
            int n8;
            OneDReader.recordPattern(bitArray, n6, (int[])object);
            int n9 = Code39Reader.toNarrowWidePattern((int[])object);
            if (n9 < 0) break;
            char c6 = Code39Reader.patternToChar(n9);
            n9 = c6;
            stringBuilder.append(c6);
            int n10 = ((Object)object).length;
            int n11 = n6;
            for (n8 = 0; n8 < n10; ++n8) {
                n11 += object[n8];
            }
            int n12 = n9;
            n9 = bitArray.getNextSet(n11);
            if (n12 == 42) {
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2.setLength(stringBuilder2.length() - 1);
                int n13 = 0;
                n10 = ((Object)object).length;
                for (n8 = 0; n8 < n10; ++n8) {
                    n13 += object[n8];
                }
                int n14 = n9 - n6 - n13;
                if (n9 != n7 && n14 * 2 < n13) {
                    throw NotFoundException.getNotFoundInstance();
                }
                if (((Code39Reader)object2).usingCheckDigit) {
                    n14 = stringBuilder.length() - 1;
                    n7 = 0;
                    for (n9 = 0; n9 < n14; ++n9) {
                        n7 += CHECK_DIGIT_STRING.indexOf(((Code39Reader)object2).decodeRowResult.charAt(n9));
                    }
                    if (stringBuilder.charAt(n14) == CHECK_DIGIT_STRING.charAt(n7 % 43)) {
                        stringBuilder.setLength(n14);
                    } else {
                        throw ChecksumException.getChecksumInstance();
                    }
                }
                if (stringBuilder.length() != 0) {
                    ResultPoint resultPoint;
                    ResultPoint resultPoint2;
                    Object object2 = ((Code39Reader)object2).extendedMode ? Code39Reader.decodeExtended(stringBuilder) : stringBuilder.toString();
                    float f5 = (float)(nArray[1] + nArray[0]) / 2.0f;
                    float f6 = (float)n6 + (float)n13 / 2.0f;
                    Object object3 = object2;
                    object2 = resultPoint2;
                    float f7 = n5;
                    resultPoint2 = new ResultPoint(f5, f7);
                    ResultPoint resultPoint3 = resultPoint;
                    resultPoint = new ResultPoint(f6, f7);
                    ResultPoint[] resultPointArray = new ResultPoint[2];
                    ResultPoint[] resultPointArray2 = resultPointArray;
                    resultPointArray[0] = object2;
                    resultPointArray[1] = resultPoint3;
                    object2 = BarcodeFormat.CODE_39;
                    return new Result((String)object3, null, resultPointArray2, (BarcodeFormat)((Object)object2));
                }
                throw NotFoundException.getNotFoundInstance();
            }
            n6 = n9;
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

