/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.EncodeHintType;
import com.dcloud.zxing2.WriterException;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.oned.ITFReader;
import com.dcloud.zxing2.oned.OneDimensionalCodeWriter;
import java.util.Map;

public final class ITFWriter
extends OneDimensionalCodeWriter {
    private static final int[] START_PATTERN = new int[]{1, 1, 1, 1};
    private static final int[] END_PATTERN = new int[]{3, 1, 1};

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n5, int n6, Map<EncodeHintType, ?> map) throws WriterException {
        if (barcodeFormat == BarcodeFormat.ITF) {
            return super.encode(string2, barcodeFormat, n5, n6, map);
        }
        throw new IllegalArgumentException("Can only encode ITF, but got " + (Object)((Object)barcodeFormat));
    }

    @Override
    public boolean[] encode(String string2) {
        int n5 = string2.length();
        if (n5 % 2 == 0) {
            if (n5 <= 80) {
                boolean[] blArray = new boolean[n5 * 9 + 9];
                int n6 = OneDimensionalCodeWriter.appendPattern(blArray, 0, START_PATTERN, true);
                for (int i5 = 0; i5 < n5; i5 += 2) {
                    int n7 = Character.digit(string2.charAt(i5), 10);
                    int n8 = Character.digit(string2.charAt(i5 + 1), 10);
                    int[] nArray = new int[18];
                    for (int i6 = 0; i6 < 5; ++i6) {
                        int n9 = i6 * 2;
                        int[][] nArray2 = ITFReader.PATTERNS;
                        nArray[n9] = nArray2[n7][i6];
                        nArray[++n9] = ITFReader.PATTERNS[n8][i6];
                    }
                    n6 += OneDimensionalCodeWriter.appendPattern(blArray, n6, nArray, true);
                }
                OneDimensionalCodeWriter.appendPattern(blArray, n6, END_PATTERN, true);
                return blArray;
            }
            throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got " + n5);
        }
        throw new IllegalArgumentException("The length of the input should be even");
    }
}

