/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.BinaryBitmap;
import com.dcloud.zxing2.ChecksumException;
import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.Reader;
import com.dcloud.zxing2.Result;
import com.dcloud.zxing2.ResultMetadataType;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.common.DecoderResult;
import com.dcloud.zxing2.multi.MultipleBarcodeReader;
import com.dcloud.zxing2.pdf417.PDF417ResultMetadata;
import com.dcloud.zxing2.pdf417.decoder.PDF417ScanningDecoder;
import com.dcloud.zxing2.pdf417.detector.Detector;
import com.dcloud.zxing2.pdf417.detector.PDF417DetectorResult;
import java.util.ArrayList;
import java.util.Map;

public final class PDF417Reader
implements Reader,
MultipleBarcodeReader {
    private static Result[] decode(BinaryBitmap object, Map<DecodeHintType, ?> object2, boolean bl) throws NotFoundException, FormatException, ChecksumException {
        ArrayList arrayList;
        BinaryBitmap binaryBitmap = object;
        object = arrayList;
        arrayList = new ArrayList();
        object2 = Detector.detect(binaryBitmap, object2, bl);
        for (Object object3 : ((PDF417DetectorResult)object2).getPoints()) {
            Result result;
            Object object4 = object3[4];
            Object object5 = object3[5];
            Object object6 = object3[6];
            ResultPoint resultPoint = object3[7];
            int n5 = PDF417Reader.getMinCodewordWidth(object3);
            int n6 = PDF417Reader.getMaxCodewordWidth(object3);
            DecoderResult decoderResult = PDF417ScanningDecoder.decode(((PDF417DetectorResult)object2).getBits(), (ResultPoint)object4, (ResultPoint)object5, (ResultPoint)object6, resultPoint, n5, n6);
            object4 = decoderResult;
            object5 = result;
            Object object7 = object4;
            Object object8 = object4;
            object4 = ((DecoderResult)object8).getText();
            object6 = ((DecoderResult)object8).getRawBytes();
            Object object9 = object4;
            object4 = BarcodeFormat.PDF_417;
            ((Result)object5)((String)object9, (byte[])object6, (ResultPoint[])object3, (BarcodeFormat)((Object)object4));
            object3 = ResultMetadataType.ERROR_CORRECTION_LEVEL;
            result.putMetadata((ResultMetadataType)((Object)object3), ((DecoderResult)object7).getECLevel());
            object3 = (PDF417ResultMetadata)decoderResult.getOther();
            if (object3 != null) {
                ((Result)object5).putMetadata(ResultMetadataType.PDF417_EXTRA_METADATA, object3);
            }
            object.add(object5);
        }
        Object object10 = object;
        return object10.toArray(new Result[object10.size()]);
    }

    private static int getMaxWidth(ResultPoint resultPoint, ResultPoint resultPoint2) {
        if (resultPoint != null && resultPoint2 != null) {
            return (int)Math.abs(resultPoint.getX() - resultPoint2.getX());
        }
        return 0;
    }

    private static int getMinWidth(ResultPoint resultPoint, ResultPoint resultPoint2) {
        if (resultPoint != null && resultPoint2 != null) {
            return (int)Math.abs(resultPoint.getX() - resultPoint2.getX());
        }
        return Integer.MAX_VALUE;
    }

    private static int getMaxCodewordWidth(ResultPoint[] resultPointArray) {
        return Math.max(Math.max(PDF417Reader.getMaxWidth(resultPointArray[0], resultPointArray[4]), PDF417Reader.getMaxWidth(resultPointArray[6], resultPointArray[2]) * 17 / 18), Math.max(PDF417Reader.getMaxWidth(resultPointArray[1], resultPointArray[5]), PDF417Reader.getMaxWidth(resultPointArray[7], resultPointArray[3]) * 17 / 18));
    }

    private static int getMinCodewordWidth(ResultPoint[] resultPointArray) {
        return Math.min(Math.min(PDF417Reader.getMinWidth(resultPointArray[0], resultPointArray[4]), PDF417Reader.getMinWidth(resultPointArray[6], resultPointArray[2]) * 17 / 18), Math.min(PDF417Reader.getMinWidth(resultPointArray[1], resultPointArray[5]), PDF417Reader.getMinWidth(resultPointArray[7], resultPointArray[3]) * 17 / 18));
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException, FormatException, ChecksumException {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap, Map<DecodeHintType, ?> map) throws NotFoundException, FormatException, ChecksumException {
        Object object = PDF417Reader.decode(binaryBitmap, map, false);
        if (object != null && ((Result[])object).length != 0 && (object = object[0]) != null) {
            return object;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    public Result[] decodeMultiple(BinaryBitmap binaryBitmap) throws NotFoundException {
        return this.decodeMultiple(binaryBitmap, null);
    }

    @Override
    public Result[] decodeMultiple(BinaryBitmap binaryBitmap, Map<DecodeHintType, ?> map) throws NotFoundException {
        try {
            return PDF417Reader.decode(binaryBitmap, map, true);
        }
        catch (ChecksumException checksumException) {
        }
        catch (FormatException formatException) {}
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    public void reset() {
    }
}

