/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import androidx.annotation.Nullable;
import dc.squareup.okio.AsyncTimeout;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSink;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.RealBufferedSink;
import dc.squareup.okio.RealBufferedSource;
import dc.squareup.okio.Segment;
import dc.squareup.okio.SegmentPool;
import dc.squareup.okio.Sink;
import dc.squareup.okio.Source;
import dc.squareup.okio.Timeout;
import dc.squareup.okio.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Okio {
    static final Logger logger = Logger.getLogger(Okio.class.getName());

    private Okio() {
    }

    public static BufferedSource buffer(Source source) {
        return new RealBufferedSource(source);
    }

    public static BufferedSink buffer(Sink sink) {
        return new RealBufferedSink(sink);
    }

    public static Sink sink(OutputStream outputStream) {
        return Okio.sink(outputStream, new Timeout());
    }

    private static Sink sink(final OutputStream outputStream, final Timeout timeout) {
        if (outputStream != null) {
            if (timeout != null) {
                return new Sink(){

                    @Override
                    public void write(Buffer buffer, long l5) throws IOException {
                        Util.checkOffsetAndCount(buffer.size, 0L, l5);
                        while (l5 > 0L) {
                            timeout.throwIfReached();
                            Segment segment = buffer.head;
                            int n5 = (int)Math.min(l5, (long)(segment.limit - segment.pos));
                            Segment segment2 = segment;
                            byte[] byArray = segment2.data;
                            outputStream.write(byArray, segment2.pos, n5);
                            int n6 = segment.pos + n5;
                            long l6 = l5;
                            segment.pos = n6;
                            l5 = n5;
                            long l7 = l6 - l5;
                            buffer.size -= l5;
                            if (n6 == segment.limit) {
                                buffer.head = segment.pop();
                                SegmentPool.recycle(segment);
                            }
                            l5 = l7;
                        }
                    }

                    @Override
                    public void flush() throws IOException {
                        outputStream.flush();
                    }

                    @Override
                    public void close() throws IOException {
                        outputStream.close();
                    }

                    @Override
                    public Timeout timeout() {
                        return timeout;
                    }

                    public String toString() {
                        return "sink(" + outputStream + ")";
                    }
                };
            }
            throw new IllegalArgumentException("timeout == null");
        }
        throw new IllegalArgumentException("out == null");
    }

    public static Sink sink(Socket socket) throws IOException {
        if (socket != null) {
            if (socket.getOutputStream() != null) {
                AsyncTimeout asyncTimeout = Okio.timeout(socket);
                return asyncTimeout.sink(Okio.sink(socket.getOutputStream(), asyncTimeout));
            }
            throw new IOException("socket's output stream == null");
        }
        throw new IllegalArgumentException("socket == null");
    }

    public static Source source(InputStream inputStream) {
        return Okio.source(inputStream, new Timeout());
    }

    private static Source source(final InputStream inputStream, final Timeout timeout) {
        if (inputStream != null) {
            if (timeout != null) {
                return new Source(){

                    /*
                     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public long read(Buffer buffer, long l5) throws IOException {
                        AssertionError assertionError2;
                        block6: {
                            int n5;
                            block7: {
                                long l6;
                                long l7;
                                2 v02;
                                if (l5 < 0L) throw new IllegalArgumentException("byteCount < 0: " + l5);
                                if (l5 == 0L) {
                                    return 0L;
                                }
                                try {
                                    v02 = segment;
                                    l7 = l5;
                                    segment.timeout.throwIfReached();
                                    Segment segment = buffer.writableSegment(1);
                                    l6 = 8192 - segment.limit;
                                }
                                catch (AssertionError assertionError2) {
                                    break block6;
                                }
                                {
                                    n5 = (int)Math.min(l7, l6);
                                    Segment segment = segment;
                                    byte[] byArray = segment.data;
                                    n5 = v02.inputStream.read(byArray, segment.limit, n5);
                                    if (n5 != -1) break block7;
                                }
                                if (segment.pos != segment.limit) return -1L;
                                buffer.head = segment.pop();
                                SegmentPool.recycle(segment);
                                return -1L;
                            }
                            segment.limit += n5;
                            long l8 = buffer.size;
                            long l9 = n5;
                            {
                                buffer.size = l8 + l9;
                                return l9;
                            }
                        }
                        if (!Okio.isAndroidGetsocknameError(assertionError2)) throw assertionError2;
                        throw new IOException((Throwable)((Object)assertionError2));
                    }

                    @Override
                    public void close() throws IOException {
                        inputStream.close();
                    }

                    @Override
                    public Timeout timeout() {
                        return timeout;
                    }

                    public String toString() {
                        return "source(" + inputStream + ")";
                    }
                };
            }
            throw new IllegalArgumentException("timeout == null");
        }
        throw new IllegalArgumentException("in == null");
    }

    public static Source source(File file) throws FileNotFoundException {
        if (file != null) {
            return Okio.source(new FileInputStream(file));
        }
        throw new IllegalArgumentException("file == null");
    }

    public static Source source(Path path, OpenOption ... openOptionArray) throws IOException {
        if (path != null) {
            return Okio.source(Files.newInputStream(path, openOptionArray));
        }
        throw new IllegalArgumentException("path == null");
    }

    public static Sink sink(File file) throws FileNotFoundException {
        if (file != null) {
            return Okio.sink(new FileOutputStream(file));
        }
        throw new IllegalArgumentException("file == null");
    }

    public static Sink appendingSink(File file) throws FileNotFoundException {
        if (file != null) {
            return Okio.sink(new FileOutputStream(file, true));
        }
        throw new IllegalArgumentException("file == null");
    }

    public static Sink sink(Path path, OpenOption ... openOptionArray) throws IOException {
        if (path != null) {
            return Okio.sink(Files.newOutputStream(path, openOptionArray));
        }
        throw new IllegalArgumentException("path == null");
    }

    public static Sink blackhole() {
        return new Sink(){

            @Override
            public void write(Buffer buffer, long l5) throws IOException {
                buffer.skip(l5);
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public Timeout timeout() {
                return Timeout.NONE;
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    public static Source source(Socket socket) throws IOException {
        if (socket != null) {
            if (socket.getInputStream() != null) {
                AsyncTimeout asyncTimeout = Okio.timeout(socket);
                return asyncTimeout.source(Okio.source(socket.getInputStream(), asyncTimeout));
            }
            throw new IOException("socket's input stream == null");
        }
        throw new IllegalArgumentException("socket == null");
    }

    private static AsyncTimeout timeout(final Socket socket) {
        return new AsyncTimeout(){

            @Override
            protected IOException newTimeoutException(@Nullable IOException iOException) {
                SocketTimeoutException socketTimeoutException;
                SocketTimeoutException socketTimeoutException2 = socketTimeoutException;
                socketTimeoutException = new SocketTimeoutException("timeout");
                if (iOException != null) {
                    SocketTimeoutException socketTimeoutException3 = socketTimeoutException2;
                    socketTimeoutException3.initCause(iOException);
                    return socketTimeoutException3;
                }
                return socketTimeoutException2;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            protected void timedOut() {
                Exception exception2;
                block3: {
                    try {
                        socket.close();
                        return;
                    }
                    catch (AssertionError assertionError) {
                    }
                    catch (Exception exception2) {
                        break block3;
                    }
                    if (!Okio.isAndroidGetsocknameError(assertionError)) throw assertionError;
                    logger.log(Level.WARNING, "Failed to close timed out socket " + socket, (Throwable)((Object)assertionError));
                    return;
                }
                logger.log(Level.WARNING, "Failed to close timed out socket " + socket, exception2);
            }
        };
    }

    static boolean isAndroidGetsocknameError(AssertionError assertionError) {
        return ((Throwable)((Object)assertionError)).getCause() != null && ((Throwable)((Object)assertionError)).getMessage() != null && ((Throwable)((Object)assertionError)).getMessage().contains("getsockname failed");
    }
}

