/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.common.DHInterface.message;

import io.dcloud.common.DHInterface.message.AbsActionObserver;
import io.dcloud.common.DHInterface.message.EnumUniqueID;
import io.dcloud.common.DHInterface.message.action.AppOnConfigChangedAction;
import io.dcloud.common.DHInterface.message.action.AppOnCreateAction;
import io.dcloud.common.DHInterface.message.action.AppOnTrimMemoryAction;
import io.dcloud.common.DHInterface.message.action.BadgeSyncAction;
import io.dcloud.common.DHInterface.message.action.IAction;
import io.dcloud.common.DHInterface.message.action.PermissionRequestAction;
import io.dcloud.common.DHInterface.message.action.WebActivityOnDestroyAction;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;

public class ActionBus {
    private static ActionBus instance = new ActionBus();
    Set<Class<? extends IAction>> supportMessageType;
    Map<EnumUniqueID, AbsActionObserver> observers;

    public static ActionBus getInstance() {
        return instance;
    }

    private ActionBus() {
        ActionBus actionBus = this;
        actionBus.supportMessageType = new CopyOnWriteArraySet<Class<? extends IAction>>();
        actionBus.observers = new ConcurrentHashMap<EnumUniqueID, AbsActionObserver>();
        actionBus.supportMessageType.add(BadgeSyncAction.class);
        actionBus.supportMessageType.add(AppOnTrimMemoryAction.class);
        actionBus.supportMessageType.add(AppOnConfigChangedAction.class);
        actionBus.supportMessageType.add(AppOnCreateAction.class);
        actionBus.supportMessageType.add(WebActivityOnDestroyAction.class);
        actionBus.supportMessageType.add(PermissionRequestAction.class);
    }

    public boolean sendToBus(IAction iAction) {
        if (iAction == null) {
            return false;
        }
        if (!((ActionBus)this).supportMessageType.contains(iAction.getClass())) {
            return false;
        }
        for (AbsActionObserver absActionObserver : ((ActionBus)this).observers.values()) {
            if (absActionObserver == null) continue;
            absActionObserver.handleMessage(iAction);
        }
        return true;
    }

    public boolean observeAction(AbsActionObserver absActionObserver) {
        if (absActionObserver == null) {
            return false;
        }
        if (this.observers.containsKey((Object)absActionObserver.getObserverUniqueID())) {
            return false;
        }
        this.observers.put(absActionObserver.getObserverUniqueID(), absActionObserver);
        return true;
    }

    public void stopObserve(EnumUniqueID enumUniqueID) {
        this.observers.remove((Object)enumUniqueID);
    }
}

