/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.statemachine.CodingStateMachine;
import org.mozilla.universalchardet.prober.statemachine.SMModel;
import org.mozilla.universalchardet.prober.statemachine.UTF8SMModel;

public class UTF8Prober
extends CharsetProber {
    public static final float ONE_CHAR_PROB = 0.5f;
    private static final SMModel smModel = new UTF8SMModel();
    private CodingStateMachine codingSM;
    private CharsetProber.ProbingState state;
    private int numOfMBChar;

    public UTF8Prober() {
        UTF8Prober uTF8Prober = this;
        uTF8Prober.numOfMBChar = 0;
        uTF8Prober.codingSM = new CodingStateMachine(smModel);
        uTF8Prober.reset();
    }

    @Override
    public String getCharSetName() {
        return Constants.CHARSET_UTF_8;
    }

    @Override
    public CharsetProber.ProbingState handleData(byte[] byArray, int n5, int n6) {
        n6 = n5 + n6;
        while (n5 < n6) {
            int n7 = this.codingSM.nextState(byArray[n5]);
            if (n7 == 1) {
                this.state = CharsetProber.ProbingState.NOT_ME;
                break;
            }
            if (n7 == 2) {
                this.state = CharsetProber.ProbingState.FOUND_IT;
                break;
            }
            if (n7 == 0 && this.codingSM.getCurrentCharLen() >= 2) {
                ++this.numOfMBChar;
            }
            ++n5;
        }
        if (this.state == CharsetProber.ProbingState.DETECTING && this.getConfidence() > 0.95f) {
            this.state = CharsetProber.ProbingState.FOUND_IT;
        }
        return this.state;
    }

    @Override
    public CharsetProber.ProbingState getState() {
        return this.state;
    }

    @Override
    public void reset() {
        this.codingSM.reset();
        this.numOfMBChar = 0;
        this.state = CharsetProber.ProbingState.DETECTING;
    }

    @Override
    public float getConfidence() {
        float f5 = 0.99f;
        if (this.numOfMBChar < 6) {
            for (int i5 = 0; i5 < this.numOfMBChar; ++i5) {
                f5 *= 0.5f;
            }
            return 1.0f - f5;
        }
        return 0.99f;
    }

    @Override
    public void setOption() {
    }
}

