/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2;

import com.dcloud.zxing2.LuminanceSource;

public final class RGBLuminanceSource
extends LuminanceSource {
    private final byte[] luminances;
    private final int dataWidth;
    private final int dataHeight;
    private final int left;
    private final int top;

    public RGBLuminanceSource(int n5, int n6, int[] nArray) {
        RGBLuminanceSource rGBLuminanceSource = this;
        super(n5, n6);
        this.dataWidth = n5;
        rGBLuminanceSource.dataHeight = n6;
        rGBLuminanceSource.left = 0;
        rGBLuminanceSource.top = 0;
        this.luminances = new byte[n5 * n6];
        for (int i5 = 0; i5 < n6; ++i5) {
            int n7 = i5 * n5;
            for (int i6 = 0; i6 < n5; ++i6) {
                int n8 = n7 + i6;
                int n9 = nArray[n8];
                int n10 = n9 >> 16 & 0xFF;
                int n11 = n9;
                n9 = n11 >> 8 & 0xFF;
                int n12 = n11 & 0xFF;
                this.luminances[n8] = n10 == n9 && n9 == n12 ? (byte)n10 : (byte)((n10 + n9 * 2 + n12) / 4);
            }
        }
    }

    private RGBLuminanceSource(byte[] byArray, int n5, int n6, int n7, int n8, int n9, int n10) {
        super(n9, n10);
        if (n7 + n9 <= n5 && n8 + n10 <= n6) {
            RGBLuminanceSource rGBLuminanceSource = this;
            rGBLuminanceSource.luminances = byArray;
            rGBLuminanceSource.dataWidth = n5;
            rGBLuminanceSource.dataHeight = n6;
            rGBLuminanceSource.left = n7;
            rGBLuminanceSource.top = n8;
            return;
        }
        throw new IllegalArgumentException("Crop rectangle does not fit within image data.");
    }

    @Override
    public byte[] getRow(int n5, byte[] byArray) {
        if (n5 >= 0 && n5 < this.getHeight()) {
            int n6 = this.getWidth();
            if (byArray == null || byArray.length < n6) {
                byArray = new byte[n6];
            }
            int n7 = (n5 + this.top) * this.dataWidth + this.left;
            System.arraycopy(this.luminances, n7, byArray, 0, n6);
            return byArray;
        }
        throw new IllegalArgumentException("Requested row is outside the image: " + n5);
    }

    @Override
    public byte[] getMatrix() {
        int n5 = this.getWidth();
        RGBLuminanceSource rGBLuminanceSource = this;
        int n6 = rGBLuminanceSource.getHeight();
        int n7 = rGBLuminanceSource.dataWidth;
        if (n5 == n7 && n6 == this.dataHeight) {
            return this.luminances;
        }
        int n8 = n7;
        int n9 = n5 * n6;
        byte[] byArray = new byte[n9];
        n7 = this.top * n7 + this.left;
        if (n5 == n8) {
            System.arraycopy(this.luminances, n7, byArray, 0, n9);
            return byArray;
        }
        byte[] byArray2 = this.luminances;
        for (int i5 = 0; i5 < n6; ++i5) {
            System.arraycopy(byArray2, n7, byArray, i5 * n5, n5);
            n7 += this.dataWidth;
        }
        return byArray;
    }

    @Override
    public boolean isCropSupported() {
        return true;
    }

    @Override
    public LuminanceSource crop(int n5, int n6, int n7, int n8) {
        RGBLuminanceSource rGBLuminanceSource = this;
        byte[] byArray = rGBLuminanceSource.luminances;
        int n9 = rGBLuminanceSource.dataWidth;
        int n10 = rGBLuminanceSource.dataHeight;
        RGBLuminanceSource rGBLuminanceSource2 = this;
        int n11 = rGBLuminanceSource2.left + n5;
        n5 = rGBLuminanceSource2.top + n6;
        return new RGBLuminanceSource(byArray, n9, n10, n11, n5, n7, n8);
    }
}

