/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.aztec.encoder;

import com.dcloud.zxing2.aztec.encoder.AztecCode;
import com.dcloud.zxing2.aztec.encoder.HighLevelEncoder;
import com.dcloud.zxing2.common.BitArray;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.common.reedsolomon.GenericGF;
import com.dcloud.zxing2.common.reedsolomon.ReedSolomonEncoder;

public final class Encoder {
    public static final int DEFAULT_EC_PERCENT = 33;
    public static final int DEFAULT_AZTEC_LAYERS = 0;
    private static final int MAX_NB_BITS = 32;
    private static final int MAX_NB_BITS_COMPACT = 4;
    private static final int[] WORD_SIZE;

    private Encoder() {
    }

    public static AztecCode encode(byte[] byArray) {
        return Encoder.encode(byArray, 33, 0);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static AztecCode encode(byte[] var0, int var1_4, int var2_6) {
        block17: {
            block18: {
                block19: {
                    v0 = new HighLevelEncoder(var0 /* !! */ ).encode();
                    var0 /* !! */  = (byte[])v0;
                    var1_4 = v0.getSize() * var1_4 / 100 + 11;
                    var3_10 = v0.getSize() + var1_4;
                    if (var2_6 == 0) break block17;
                    var3_10 = var2_6 < 0 ? 1 : 0;
                    var4_11 = Math.abs(var2_6);
                    if (var4_11 > (var5_13 = var3_10 != 0 ? 4 : 32)) break block18;
                    var0_1 = Encoder.totalBitsInLayer(var4_11, (boolean)var3_10);
                    var2_6 = Encoder.WORD_SIZE[var4_11];
                    var5_13 = var0_1 - var0_1 % var2_6;
                    var6_14 = Encoder.stuffBits((BitArray)var0 /* !! */ , var2_6);
                    if (var6_14.getSize() + var1_4 > var5_13) break block19;
                    if (var3_10 != 0 && var6_14.getSize() > var2_6 * 64) {
                        throw new IllegalArgumentException("Data to large for user specified layer");
                    }
                    ** GOTO lbl44
                }
                throw new IllegalArgumentException("Data to large for user specified layer");
            }
            var0 /* !! */  = (byte[])var2_6;
            v1 = new Object[1];
            var1_5 = v1;
            v1[0] = var0 /* !! */ ;
            throw new IllegalArgumentException(String.format("Illegal value %s for layers", var1_5));
        }
        var2_6 = 0;
        var4_12 = null;
        for (var5_13 = 0; var5_13 <= 32; ++var5_13) {
            var6_15 = var5_13 <= 3 ? 1 : 0;
            var7_17 = var6_15 != 0 ? var5_13 + 1 : var5_13;
            var8_19 = Encoder.totalBitsInLayer(var7_17, (boolean)var6_15);
            if (var3_10 > var8_19) continue;
            var9_20 = Encoder.WORD_SIZE[var7_17];
            if (var2_6 != var9_20) {
                var4_12 = var2_7 = Encoder.stuffBits((BitArray)var0 /* !! */ , var9_20);
                var2_6 = var9_20;
            }
            v2 = var8_19;
            var9_20 = v2 - v2 % var2_6;
            if (var6_15 != 0 && var4_12.getSize() > var2_6 * 64 || var4_12.getSize() + var1_4 > var9_20) continue;
            var4_11 = var7_17;
            var3_10 = var6_15;
            var0_1 = var8_19;
            var6_14 = var4_12;
lbl44:
            // 2 sources

            v3 = var3_10;
            v4 = var6_14;
            var0_2 = Encoder.generateCheckWords(v4, var0_1, var2_6);
            var1_4 = v4.getSize() / var2_6;
            var2_8 = Encoder.generateModeMessage((boolean)v3, var4_11, var1_4);
            var5_13 = v3 != 0 ? var4_11 * 4 + 11 : var4_11 * 4 + 14;
            var6_14 = new int[var5_13];
            if (var3_10 != 0) {
                var7_17 = 0;
                while (var7_17 < var5_13) {
                    v5 = var7_17++;
                    var6_14[v5] = v5;
                }
                var8_19 = var5_13;
            } else {
                var7_17 = var5_13 / 2;
                var8_19 = var5_13 + 1 + (var7_17 - 1) / 15 * 2;
                var9_20 = var8_19 / 2;
                for (var10_21 = 0; var10_21 < var7_17; ++var10_21) {
                    v6 = var10_21;
                    var11_22 = v6 + v6 / 15;
                    var12_23 = var7_17 - v6 - 1;
                    var6_14[var12_23] = var9_20 - var11_22 - 1;
                    var12_23 = var7_17 + var10_21;
                    var6_14[var12_23] = var9_20 + var11_22 + 1;
                }
            }
            var7_18 = v7;
            v7 = new BitMatrix(var8_19);
            var10_21 = 0;
            for (var9_20 = 0; var9_20 < var4_11; ++var9_20) {
                var11_22 = var3_10 != 0 ? (var4_11 - var9_20) * 4 + 9 : (var4_11 - var9_20) * 4 + 12;
                for (var12_23 = 0; var12_23 < var11_22; ++var12_23) {
                    var13_24 = var12_23 * 2;
                    for (var14_25 = 0; var14_25 < 2; ++var14_25) {
                        if (var0_2.get(var10_21 + var13_24 + var14_25)) {
                            v8 = var9_20 * 2;
                            var15_26 /* !! */  = v8;
                            var15_26 /* !! */  = (int)var6_14[var15_26 /* !! */  + var14_25];
                            var7_18.set(var15_26 /* !! */ , (int)var6_14[v8 + var12_23]);
                        }
                        if (var0_2.get(var10_21 + var11_22 * 2 + var13_24 + var14_25)) {
                            var15_26 /* !! */  = var9_20 * 2;
                            var16_27 /* !! */  = var6_14[var15_26 /* !! */  + var12_23];
                            var7_18.set((int)var16_27 /* !! */ , (int)var6_14[var5_13 - 1 - var15_26 /* !! */  - var14_25]);
                        }
                        if (var0_2.get(var10_21 + var11_22 * 4 + var13_24 + var14_25)) {
                            v9 = var5_13 - 1 - var9_20 * 2;
                            var15_26 /* !! */  = v9;
                            var15_26 /* !! */  = (int)var6_14[var15_26 /* !! */  - var14_25];
                            var7_18.set(var15_26 /* !! */ , (int)var6_14[v9 - var12_23]);
                        }
                        if (!var0_2.get(var10_21 + var11_22 * 6 + var13_24 + var14_25)) continue;
                        var15_26 /* !! */  = var5_13 - 1;
                        v10 = var9_20 * 2;
                        var16_27 /* !! */  = v10;
                        var15_26 /* !! */  = (int)var6_14[var15_26 /* !! */  - var16_27 /* !! */  - var12_23];
                        var7_18.set(var15_26 /* !! */ , (int)var6_14[v10 + var14_25]);
                    }
                }
                var10_21 += var11_22 * 8;
            }
            Encoder.drawModeMessage(var7_18, (boolean)var3_10, var8_19, var2_8);
            if (var3_10 != 0) {
                Encoder.drawBullsEye(var7_18, var8_19 / 2, 5);
            } else {
                var0_3 = var8_19 / 2;
                Encoder.drawBullsEye(var7_18, var0_3, 7);
                var2_9 = 0;
                var6_16 = 0;
                while (var2_9 < var5_13 / 2 - 1) {
                    for (var9_20 = var0_3 & 1; var9_20 < var8_19; var9_20 += 2) {
                        v11 = var7_18;
                        var10_21 = var0_3 - var6_16;
                        var7_18.set(var10_21, var9_20);
                        var11_22 = var0_3 + var6_16;
                        v11.set(var11_22, var9_20);
                        v11.set(var9_20, var10_21);
                        v11.set(var9_20, var11_22);
                    }
                    var2_9 += 15;
                    var6_16 += 16;
                }
            }
            v12 = new AztecCode();
            v12.setCompact((boolean)var3_10);
            v12.setSize(var8_19);
            v12.setLayers(var4_11);
            v12.setCodeWords(var1_4);
            v12.setMatrix(var7_18);
            return v12;
        }
        throw new IllegalArgumentException("Data too large for an Aztec code");
    }

    private static void drawBullsEye(BitMatrix bitMatrix, int n5, int n6) {
        int n7;
        for (n7 = 0; n7 < n6; n7 += 2) {
            int n8;
            int n9;
            for (int i5 = n8 = n5 - n7; i5 <= (n9 = n5 + n7); ++i5) {
                BitMatrix bitMatrix2 = bitMatrix;
                bitMatrix2.set(i5, n8);
                bitMatrix2.set(i5, n9);
                bitMatrix2.set(n8, i5);
                bitMatrix2.set(n9, i5);
            }
        }
        int n10 = n5;
        BitMatrix bitMatrix3 = bitMatrix;
        bitMatrix3.set(n5 -= n6, n5);
        n7 = n5 + 1;
        bitMatrix3.set(n7, n5);
        bitMatrix3.set(n5, n7);
        n6 = n10 + n6;
        BitMatrix bitMatrix4 = bitMatrix;
        bitMatrix4.set(n6, n5);
        bitMatrix4.set(n6, n7);
        bitMatrix.set(n6, n6 - 1);
    }

    static BitArray generateModeMessage(boolean bl, int n5, int n6) {
        BitArray bitArray;
        BitArray bitArray2 = bitArray;
        bitArray = new BitArray();
        if (bl) {
            BitArray bitArray3 = bitArray2;
            bitArray2.appendBits(n5 - 1, 2);
            bitArray3.appendBits(n6 - 1, 6);
            return Encoder.generateCheckWords(bitArray3, 28, 4);
        }
        BitArray bitArray4 = bitArray2;
        bitArray2.appendBits(n5 - 1, 5);
        bitArray4.appendBits(n6 - 1, 11);
        return Encoder.generateCheckWords(bitArray4, 40, 4);
    }

    /*
     * WARNING - void declaration
     */
    private static void drawModeMessage(BitMatrix bitMatrix, boolean bl, int n5, BitArray bitArray) {
        void var3_4;
        int n6;
        void var1_2 = n6 / 2;
        if (bl) {
            for (n6 = 0; n6 < 7; ++n6) {
                void n7 = var1_2 - 3 + n6;
                if (var3_4.get(n6)) {
                    bitMatrix.set((int)n7, (int)(var1_2 - 5));
                }
                if (var3_4.get(n6 + 7)) {
                    bitMatrix.set((int)(var1_2 + 5), (int)n7);
                }
                if (var3_4.get(20 - n6)) {
                    bitMatrix.set((int)n7, (int)(var1_2 + 5));
                }
                if (!var3_4.get(27 - n6)) continue;
                bitMatrix.set((int)(var1_2 - 5), (int)n7);
            }
        } else {
            for (n6 = 0; n6 < 10; ++n6) {
                void var4_6 = var1_2 - 5 + n6 + n6 / 5;
                if (var3_4.get(n6)) {
                    bitMatrix.set((int)var4_6, (int)(var1_2 - 7));
                }
                if (var3_4.get(n6 + 10)) {
                    bitMatrix.set((int)(var1_2 + 7), (int)var4_6);
                }
                if (var3_4.get(29 - n6)) {
                    bitMatrix.set((int)var4_6, (int)(var1_2 + 7));
                }
                if (!var3_4.get(39 - n6)) continue;
                bitMatrix.set((int)(var1_2 - 7), (int)var4_6);
            }
        }
    }

    private static BitArray generateCheckWords(BitArray bitArray, int n5, int n6) {
        BitArray bitArray2;
        ReedSolomonEncoder reedSolomonEncoder;
        int n7 = bitArray.getSize() / n6;
        ReedSolomonEncoder reedSolomonEncoder2 = reedSolomonEncoder;
        reedSolomonEncoder = new ReedSolomonEncoder(Encoder.getGF(n6));
        int n8 = n5 / n6;
        int[] nArray = Encoder.bitsToWords(bitArray, n6, n8);
        reedSolomonEncoder2.encode(nArray, n8 - n7);
        n7 = n5 % n6;
        BitArray bitArray3 = bitArray2;
        new BitArray().appendBits(0, n7);
        n7 = nArray.length;
        for (int i5 = 0; i5 < n7; ++i5) {
            bitArray3.appendBits(nArray[i5], n6);
        }
        return bitArray3;
    }

    private static int[] bitsToWords(BitArray bitArray, int n5, int n6) {
        int[] nArray = new int[n6];
        int n7 = bitArray.getSize() / n5;
        for (int i5 = 0; i5 < n7; ++i5) {
            int n8 = 0;
            for (int i6 = 0; i6 < n5; ++i6) {
                int n9 = bitArray.get(i5 * n5 + i6) ? 1 << n5 - i6 - 1 : 0;
                n8 |= n9;
            }
            nArray[i5] = n8;
        }
        return nArray;
    }

    private static GenericGF getGF(int n5) {
        if (n5 != 4) {
            if (n5 != 6) {
                if (n5 != 8) {
                    if (n5 != 10) {
                        if (n5 == 12) {
                            return GenericGF.AZTEC_DATA_12;
                        }
                        throw new IllegalArgumentException("Unsupported word size " + n5);
                    }
                    return GenericGF.AZTEC_DATA_10;
                }
                return GenericGF.AZTEC_DATA_8;
            }
            return GenericGF.AZTEC_DATA_6;
        }
        return GenericGF.AZTEC_PARAM;
    }

    static BitArray stuffBits(BitArray bitArray, int n5) {
        BitArray bitArray2;
        BitArray bitArray3 = bitArray2;
        bitArray2 = new BitArray();
        int n6 = bitArray.getSize();
        int n7 = (1 << n5) - 2;
        for (int i5 = 0; i5 < n6; i5 += n5) {
            int n8;
            int n9 = 0;
            for (n8 = 0; n8 < n5; ++n8) {
                int n10 = i5 + n8;
                if (n10 < n6 && !bitArray.get(n10)) continue;
                n9 |= 1 << n5 - 1 - n8;
            }
            n8 = n9 & n7;
            if (n8 == n7) {
                bitArray3.appendBits(n8, n5);
                --i5;
                continue;
            }
            if (n8 == 0) {
                bitArray3.appendBits(n9 | 1, n5);
                --i5;
                continue;
            }
            bitArray3.appendBits(n9, n5);
        }
        return bitArray3;
    }

    private static int totalBitsInLayer(int n5, boolean bl) {
        return ((bl ? 88 : 112) + n5 * 16) * n5;
    }

    static {
        int[] nArray = new int[33];
        int[] nArray2 = nArray;
        nArray[0] = 4;
        nArray2[1] = 6;
        nArray2[2] = 6;
        nArray2[3] = 8;
        nArray2[4] = 8;
        nArray2[5] = 8;
        nArray2[6] = 8;
        nArray2[7] = 8;
        nArray2[8] = 8;
        nArray2[9] = 10;
        nArray2[10] = 10;
        nArray2[11] = 10;
        nArray2[12] = 10;
        nArray2[13] = 10;
        nArray2[14] = 10;
        nArray2[15] = 10;
        nArray2[16] = 10;
        nArray2[17] = 10;
        nArray2[18] = 10;
        nArray2[19] = 10;
        nArray2[20] = 10;
        nArray2[21] = 10;
        nArray2[22] = 10;
        nArray2[23] = 12;
        nArray2[24] = 12;
        nArray2[25] = 12;
        nArray2[26] = 12;
        nArray2[27] = 12;
        nArray2[28] = 12;
        nArray2[29] = 12;
        nArray2[30] = 12;
        nArray2[31] = 12;
        nArray2[32] = 12;
        WORD_SIZE = nArray2;
    }
}

