/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.common;

public final class PerspectiveTransform {
    private final float a11;
    private final float a12;
    private final float a13;
    private final float a21;
    private final float a22;
    private final float a23;
    private final float a31;
    private final float a32;
    private final float a33;

    private PerspectiveTransform(float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13) {
        this.a11 = f5;
        this.a12 = f8;
        this.a13 = f11;
        this.a21 = f6;
        this.a22 = f9;
        this.a23 = f12;
        this.a31 = f7;
        this.a32 = f10;
        this.a33 = f13;
    }

    public static PerspectiveTransform quadrilateralToQuadrilateral(float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18, float f19, float f20) {
        PerspectiveTransform perspectiveTransform = PerspectiveTransform.quadrilateralToSquare(f5, f6, f7, f8, f9, f10, f11, f12);
        return PerspectiveTransform.squareToQuadrilateral(f13, f14, f15, f16, f17, f18, f19, f20).times(perspectiveTransform);
    }

    public static PerspectiveTransform squareToQuadrilateral(float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        float f13;
        float f14 = f5 - f7 + f9 - f11;
        float f15 = f6 - f8 + f10 - f12;
        if (f14 == 0.0f && f15 == 0.0f) {
            float f16 = f10;
            float f17 = f9;
            f9 = f7 - f5;
            f7 = f17 - f7;
            f10 = f8 - f6;
            f8 = f16 - f8;
            return new PerspectiveTransform(f9, f7, f5, f10, f8, f6, 0.0f, 0.0f, 1.0f);
        }
        float f18 = f7 - f9;
        float f19 = f13 = f18;
        float f20 = f10;
        f9 = f11 - f9;
        f10 = f8 - f10;
        f13 = f12 - f20;
        float f21 = f19 * f13 - f9 * f10;
        f9 = (f14 * f13 - f9 * f15) / f21;
        f10 = (f18 * f15 - f14 * f10) / f21;
        f7 = f7 - f5 + f9 * f7;
        f11 = f11 - f5 + f10 * f11;
        f8 = f8 - f6 + f9 * f8;
        f12 = f12 - f6 + f10 * f12;
        return new PerspectiveTransform(f7, f11, f5, f8, f12, f6, f9, f10, 1.0f);
    }

    public static PerspectiveTransform quadrilateralToSquare(float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        return PerspectiveTransform.squareToQuadrilateral(f5, f6, f7, f8, f9, f10, f11, f12).buildAdjoint();
    }

    public void transformPoints(float[] fArray) {
        PerspectiveTransform perspectiveTransform = this;
        int n5 = fArray.length;
        float f5 = perspectiveTransform.a11;
        float f6 = perspectiveTransform.a12;
        float f7 = perspectiveTransform.a13;
        float f8 = perspectiveTransform.a21;
        float f9 = perspectiveTransform.a22;
        float f10 = perspectiveTransform.a23;
        float f11 = perspectiveTransform.a31;
        float f12 = perspectiveTransform.a32;
        float f13 = perspectiveTransform.a33;
        for (int i5 = 0; i5 < n5; i5 += 2) {
            float f14 = fArray[i5];
            int n6 = i5 + 1;
            float f15 = fArray[n6];
            float f16 = f7 * f14 + f10 * f15 + f13;
            fArray[i5] = (f5 * f14 + f8 * f15 + f11) / f16;
            fArray[n6] = (f6 * f14 + f9 * f15 + f12) / f16;
        }
    }

    public void transformPoints(float[] fArray, float[] fArray2) {
        int n5 = fArray.length;
        for (int i5 = 0; i5 < n5; ++i5) {
            PerspectiveTransform perspectiveTransform = this;
            float f5 = fArray[i5];
            float f6 = fArray2[i5];
            float f7 = perspectiveTransform.a13 * f5 + this.a23 * f6 + this.a33;
            fArray[i5] = (perspectiveTransform.a11 * f5 + this.a21 * f6 + this.a31) / f7;
            fArray2[i5] = (this.a12 * f5 + this.a22 * f6 + this.a32) / f7;
        }
    }

    PerspectiveTransform buildAdjoint() {
        PerspectiveTransform perspectiveTransform = this;
        float f5 = perspectiveTransform.a22;
        float f6 = this.a33;
        float f7 = f5 * f6;
        float f8 = perspectiveTransform.a23;
        float f9 = f7;
        f7 = this.a32;
        float f10 = f9 - f8 * f7;
        float f11 = this.a31;
        float f12 = f8 * f11;
        float f13 = perspectiveTransform.a21;
        f12 -= f13 * f6;
        float f14 = f13 * f7 - f5 * f11;
        float f15 = perspectiveTransform.a13;
        float f16 = this.a12;
        float f17 = f15 * f7 - f16 * f6;
        float f18 = perspectiveTransform.a11;
        float f19 = f5;
        f6 = f18 * f6 - f15 * f11;
        f7 = f16 * f11 - f18 * f7;
        f5 = f16 * f8 - f15 * f5;
        f8 = f15 * f13 - f18 * f8;
        f16 = f18 * f19 - f16 * f13;
        return new PerspectiveTransform(f10, f12, f14, f17, f6, f7, f5, f8, f16);
    }

    PerspectiveTransform times(PerspectiveTransform perspectiveTransform) {
        float f5;
        float f6;
        PerspectiveTransform perspectiveTransform2 = this;
        float f7 = perspectiveTransform2.a11;
        float f8 = f6 = f7;
        float f9 = f6;
        f6 = perspectiveTransform.a11;
        float f10 = this.a21;
        float f11 = perspectiveTransform.a12;
        float f12 = this.a31;
        float f13 = perspectiveTransform.a13;
        float f14 = f9 * f6 + f10 * f11 + f12 * f13;
        float f15 = perspectiveTransform.a21;
        float f16 = perspectiveTransform.a22;
        float f17 = perspectiveTransform.a23;
        float f18 = f8 * f15 + f10 * f16 + f12 * f17;
        float f19 = perspectiveTransform.a31;
        float f20 = f10;
        f10 = perspectiveTransform.a32;
        float f21 = perspectiveTransform.a33;
        f12 = f7 * f19 + f20 * f10 + f12 * f21;
        float f22 = perspectiveTransform2.a12;
        float f23 = f5 = f22;
        float f24 = f5 * f6;
        f5 = this.a22;
        float f25 = this.a32;
        float f26 = f24 + f5 * f11 + f25 * f13;
        float f27 = f23 * f15 + f5 * f16 + f25 * f17;
        f5 = f22 * f19 + f5 * f10 + f25 * f21;
        f25 = perspectiveTransform2.a13;
        float f28 = f25 * f6;
        f6 = this.a23;
        float f29 = this.a33;
        f11 = f28 + f6 * f11 + f29 * f13;
        f13 = f25 * f15 + f6 * f16 + f29 * f17;
        f29 = f25 * f19 + f6 * f10 + f29 * f21;
        return new PerspectiveTransform(f14, f18, f12, f26, f27, f5, f11, f13, f29);
    }
}

