/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.http2;

import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.http2.ErrorCode;
import dc.squareup.okhttp3.internal.http2.Header;
import dc.squareup.okhttp3.internal.http2.Hpack;
import dc.squareup.okhttp3.internal.http2.Http2;
import dc.squareup.okhttp3.internal.http2.Settings;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.ByteString;
import dc.squareup.okio.Source;
import dc.squareup.okio.Timeout;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

final class Http2Reader
implements Closeable {
    static final Logger logger = Logger.getLogger(Http2.class.getName());
    private final BufferedSource source;
    private final ContinuationSource continuation;
    private final boolean client;
    final Hpack.Reader hpackReader;

    Http2Reader(BufferedSource object, boolean bl) {
        Hpack.Reader reader;
        ContinuationSource continuationSource;
        closeable.source = object;
        closeable.client = bl;
        Closeable closeable = continuationSource;
        continuationSource = new ContinuationSource((BufferedSource)object);
        v1.continuation = closeable;
        object = reader;
        reader = new Hpack.Reader(4096, (Source)closeable);
        v1.hpackReader = object;
    }

    private void readHeaders(Handler handler, int n5, byte by, int n6) throws IOException {
        if (n6 != 0) {
            boolean bl = (by & 1) != 0;
            short s5 = (by & 8) != 0 ? (short)(((Http2Reader)((Object)list)).source.readByte() & 0xFF) : (short)0;
            if ((by & 0x20) != 0) {
                ((Http2Reader)((Object)list)).readPriority(handler, n6);
                n5 -= 5;
            }
            List<Header> list = ((Http2Reader)((Object)list)).readHeaderBlock(Http2Reader.lengthWithoutPadding(n5, by, s5), s5, by, n6);
            handler.headers(bl, n6, -1, list);
            return;
        }
        throw Http2.ioException("PROTOCOL_ERROR: TYPE_HEADERS streamId == 0", new Object[0]);
    }

    private List<Header> readHeaderBlock(int n5, short s5, byte by, int n6) throws IOException {
        Http2Reader http2Reader = closeable;
        Closeable closeable = http2Reader.continuation;
        ((ContinuationSource)closeable).left = n5;
        ((ContinuationSource)closeable).length = n5;
        ((ContinuationSource)closeable).padding = s5;
        ((ContinuationSource)closeable).flags = by;
        http2Reader.continuation.streamId = n6;
        http2Reader.hpackReader.readHeaders();
        return http2Reader.hpackReader.getAndResetHeaderList();
    }

    private void readData(Handler handler, int n5, byte by, int n6) throws IOException {
        if (n6 != 0) {
            boolean bl = (by & 1) != 0;
            if ((by & 0x20) == 0) {
                short s5 = (by & 8) != 0 ? (short)(this.source.readByte() & 0xFF) : (short)0;
                int n7 = Http2Reader.lengthWithoutPadding(n5, by, s5);
                handler.data(bl, n6, this.source, n7);
                this.source.skip(s5);
                return;
            }
            throw Http2.ioException("PROTOCOL_ERROR: FLAG_COMPRESSED without SETTINGS_COMPRESS_DATA", new Object[0]);
        }
        throw Http2.ioException("PROTOCOL_ERROR: TYPE_DATA streamId == 0", new Object[0]);
    }

    private void readPriority(Handler objectArray, int n5, byte by, int n6) throws IOException {
        if (n5 == 5) {
            if (n6 != 0) {
                ((Http2Reader)((Object)n7)).readPriority((Handler)objectArray, n6);
                return;
            }
            throw Http2.ioException("TYPE_PRIORITY streamId == 0", new Object[0]);
        }
        Integer n7 = n5;
        Object[] objectArray2 = new Object[1];
        objectArray = objectArray2;
        objectArray2[0] = n7;
        throw Http2.ioException("TYPE_PRIORITY length: %d != 5", objectArray);
    }

    private void readPriority(Handler handler, int n5) throws IOException {
        int n6 = this.source.readInt();
        boolean bl = (n6 & Integer.MIN_VALUE) != 0;
        int n7 = n6 & Integer.MAX_VALUE;
        handler.priority(n5, n7, (this.source.readByte() & 0xFF) + 1, bl);
    }

    private void readRstStream(Handler objectArray, int n5, byte by, int n6) throws IOException {
        if (n5 == 4) {
            if (n6 != 0) {
                int n7 = ((Http2Reader)((Object)n9)).source.readInt();
                ErrorCode errorCode = ErrorCode.fromHttp2(n7);
                if (errorCode != null) {
                    objectArray.rstStream(n6, errorCode);
                    return;
                }
                Integer n8 = n7;
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = n8;
                throw Http2.ioException("TYPE_RST_STREAM unexpected error code: %d", objectArray);
            }
            throw Http2.ioException("TYPE_RST_STREAM streamId == 0", new Object[0]);
        }
        Integer n9 = n5;
        Object[] objectArray3 = new Object[1];
        objectArray = objectArray3;
        objectArray3[0] = n9;
        throw Http2.ioException("TYPE_RST_STREAM length: %d != 4", objectArray);
    }

    private void readSettings(Handler objectArray, int n5, byte by, int n6) throws IOException {
        if (n6 == 0) {
            Object object;
            if ((by & 1) != 0) {
                if (n5 == 0) {
                    objectArray.ackSettings();
                    return;
                }
                throw Http2.ioException("FRAME_SIZE_ERROR ack frame should be empty!", new Object[0]);
            }
            if (n5 % 6 == 0) {
                Settings settings;
                Settings settings2 = settings;
                settings = new Settings();
                for (n6 = 0; n6 < n5; n6 += 6) {
                    int n7 = ((Http2Reader)object).source.readShort() & 0xFFFF;
                    int n8 = ((Http2Reader)object).source.readInt();
                    switch (n7) {
                        default: {
                            break;
                        }
                        case 5: {
                            if (n8 >= 16384 && n8 <= 0xFFFFFF) break;
                            object = n8;
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = object;
                            throw Http2.ioException("PROTOCOL_ERROR SETTINGS_MAX_FRAME_SIZE: %s", objectArray);
                        }
                        case 4: {
                            n7 = 7;
                            if (n8 >= 0) break;
                            throw Http2.ioException("PROTOCOL_ERROR SETTINGS_INITIAL_WINDOW_SIZE > 2^31 - 1", new Object[0]);
                        }
                        case 3: {
                            n7 = 4;
                            break;
                        }
                        case 2: {
                            if (n8 == 0 || n8 == 1) break;
                            throw Http2.ioException("PROTOCOL_ERROR SETTINGS_ENABLE_PUSH != 0 or 1", new Object[0]);
                        }
                    }
                    settings2.set(n7, n8);
                }
                objectArray.settings(false, settings2);
                return;
            }
            object = n5;
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = object;
            throw Http2.ioException("TYPE_SETTINGS length %% 6 != 0: %s", objectArray);
        }
        throw Http2.ioException("TYPE_SETTINGS streamId != 0", new Object[0]);
    }

    private void readPushPromise(Handler handler, int n5, byte by, int n6) throws IOException {
        if (n6 != 0) {
            short s5 = (by & 8) != 0 ? (short)(this.source.readByte() & 0xFF) : (short)0;
            int n7 = this.source.readInt() & Integer.MAX_VALUE;
            handler.pushPromise(n6, n7, this.readHeaderBlock(Http2Reader.lengthWithoutPadding(n5 + -4, by, s5), s5, by, n6));
            return;
        }
        throw Http2.ioException("PROTOCOL_ERROR: TYPE_PUSH_PROMISE streamId == 0", new Object[0]);
    }

    private void readPing(Handler objectArray, int n5, byte by, int n6) throws IOException {
        if (n5 == 8) {
            if (n6 == 0) {
                Integer n7 = n9;
                int n8 = ((Http2Reader)((Object)n7)).source.readInt();
                n5 = ((Http2Reader)((Object)n7)).source.readInt();
                by = (by & 1) != 0 ? (byte)1 : 0;
                objectArray.ping(by != 0, n8, n5);
                return;
            }
            throw Http2.ioException("TYPE_PING streamId != 0", new Object[0]);
        }
        Integer n9 = n5;
        Object[] objectArray2 = new Object[1];
        objectArray = objectArray2;
        objectArray2[0] = n9;
        throw Http2.ioException("TYPE_PING length != 8: %s", objectArray);
    }

    private void readGoAway(Handler objectArray, int n5, byte by, int n6) throws IOException {
        Object object;
        if (n5 >= 8) {
            if (n6 == 0) {
                Http2Reader http2Reader = object;
                by = (byte)http2Reader.source.readInt();
                n6 = http2Reader.source.readInt();
                n5 -= 8;
                ErrorCode errorCode = ErrorCode.fromHttp2(n6);
                if (errorCode != null) {
                    ByteString byteString = ByteString.EMPTY;
                    if (n5 > 0) {
                        byteString = ((Http2Reader)object).source.readByteString(n5);
                    }
                    objectArray.goAway(by, errorCode, byteString);
                    return;
                }
                object = n6;
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = object;
                throw Http2.ioException("TYPE_GOAWAY unexpected error code: %d", objectArray);
            }
            throw Http2.ioException("TYPE_GOAWAY streamId != 0", new Object[0]);
        }
        object = n5;
        Object[] objectArray3 = new Object[1];
        objectArray = objectArray3;
        objectArray3[0] = object;
        throw Http2.ioException("TYPE_GOAWAY length < 8: %s", objectArray);
    }

    private void readWindowUpdate(Handler objectArray, int n5, byte by, int n6) throws IOException {
        Object object;
        if (n5 == 4) {
            long l5 = (long)((Http2Reader)object).source.readInt() & Integer.MAX_VALUE;
            if (l5 != 0L) {
                objectArray.windowUpdate(n6, l5);
                return;
            }
            object = l5;
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = object;
            throw Http2.ioException("windowSizeIncrement was 0", objectArray);
        }
        object = n5;
        Object[] objectArray3 = new Object[1];
        objectArray = objectArray3;
        objectArray3[0] = object;
        throw Http2.ioException("TYPE_WINDOW_UPDATE length !=4: %s", objectArray);
    }

    static int readMedium(BufferedSource bufferedSource) throws IOException {
        return (bufferedSource.readByte() & 0xFF) << 16 | (bufferedSource.readByte() & 0xFF) << 8 | bufferedSource.readByte() & 0xFF;
    }

    static int lengthWithoutPadding(int n5, byte by, short s5) throws IOException {
        if ((by & 8) != 0) {
            --n5;
        }
        if (s5 <= n5) {
            return (short)(n5 - s5);
        }
        Short s6 = s5;
        Integer n6 = n5;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = s6;
        objectArray[1] = n6;
        throw Http2.ioException("PROTOCOL_ERROR padding %s > remaining length %s", objectArray2);
    }

    public void readConnectionPreface(Handler objectArray) throws IOException {
        Object object;
        block8: {
            block7: {
                block6: {
                    if (!((Http2Reader)object).client) break block6;
                    if (!((Http2Reader)object).nextFrame(true, (Handler)objectArray)) {
                        throw Http2.ioException("Required SETTINGS preface not received", new Object[0]);
                    }
                    break block7;
                }
                object = Http2.CONNECTION_PREFACE;
                objectArray = ((Http2Reader)object).source.readByteString(((ByteString)object).size());
                Object object2 = logger;
                if (((Logger)object2).isLoggable(Level.FINE)) {
                    Logger logger = object2;
                    object2 = objectArray.hex();
                    Object[] objectArray2 = new Object[1];
                    Object[] objectArray3 = objectArray2;
                    objectArray2[0] = object2;
                    logger.fine(Util.format("<< CONNECTION %s", objectArray3));
                }
                if (!((ByteString)object).equals(objectArray)) break block8;
            }
            return;
        }
        object = objectArray.utf8();
        Object[] objectArray4 = new Object[1];
        objectArray = objectArray4;
        objectArray4[0] = object;
        throw Http2.ioException("Expected a connection header but was %s", objectArray);
    }

    public boolean nextFrame(boolean n5, Handler handler) throws IOException {
        Object object;
        int n6;
        block15: {
            int n7;
            try {
                Http2Reader http2Reader = object;
                http2Reader.source.require(9L);
                n6 = Http2Reader.readMedium(http2Reader.source);
                if (n6 < 0 || n6 > 16384) break block15;
                n7 = n5;
            }
            catch (IOException iOException) {
                return false;
            }
            n5 = (byte)(((Http2Reader)object).source.readByte() & 0xFF);
            if (n7 != 0 && n5 != 4) {
                object = (byte)n5;
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = object;
                throw Http2.ioException("Expected a SETTINGS frame but was %s", objectArray2);
            }
            Object object2 = object;
            byte by = (byte)(((Http2Reader)object2).source.readByte() & 0xFF);
            int n8 = ((Http2Reader)object2).source.readInt() & Integer.MAX_VALUE;
            Logger logger = Http2Reader.logger;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(Http2.frameLog(true, n8, n6, (byte)n5, by));
            }
            switch (n5) {
                default: {
                    ((Http2Reader)object).source.skip(n6);
                    break;
                }
                case 8: {
                    super.readWindowUpdate(handler, n6, by, n8);
                    break;
                }
                case 7: {
                    super.readGoAway(handler, n6, by, n8);
                    break;
                }
                case 6: {
                    super.readPing(handler, n6, by, n8);
                    break;
                }
                case 5: {
                    super.readPushPromise(handler, n6, by, n8);
                    break;
                }
                case 4: {
                    super.readSettings(handler, n6, by, n8);
                    break;
                }
                case 3: {
                    super.readRstStream(handler, n6, by, n8);
                    break;
                }
                case 2: {
                    super.readPriority(handler, n6, by, n8);
                    break;
                }
                case 1: {
                    super.readHeaders(handler, n6, by, n8);
                    break;
                }
                case 0: {
                    super.readData(handler, n6, by, n8);
                }
            }
            return true;
        }
        object = n6;
        Object[] objectArray = new Object[1];
        Object[] objectArray3 = objectArray;
        objectArray[0] = object;
        throw Http2.ioException("FRAME_SIZE_ERROR: %s", objectArray3);
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    static final class ContinuationSource
    implements Source {
        private final BufferedSource source;
        int length;
        byte flags;
        int streamId;
        int left;
        short padding;

        ContinuationSource(BufferedSource bufferedSource) {
            this.source = bufferedSource;
        }

        private void readContinuationHeader() throws IOException {
            int n5;
            int by;
            ContinuationSource continuationSource = this;
            int n6 = continuationSource.streamId;
            continuationSource.left = by = Http2Reader.readMedium(continuationSource.source);
            continuationSource.length = by;
            byte by2 = (byte)(continuationSource.source.readByte() & 0xFF);
            continuationSource.flags = (byte)(continuationSource.source.readByte() & 0xFF);
            Logger n7 = logger;
            if (n7.isLoggable(Level.FINE)) {
                ContinuationSource continuationSource2 = this;
                int n8 = continuationSource2.streamId;
                int n9 = continuationSource2.length;
                byte by3 = continuationSource2.flags;
                n7.fine(Http2.frameLog(true, n8, n9, by2, by3));
            }
            this.streamId = n5 = this.source.readInt() & Integer.MAX_VALUE;
            if (by2 == 9) {
                if (n5 == n6) {
                    return;
                }
                throw Http2.ioException("TYPE_CONTINUATION streamId changed", new Object[0]);
            }
            Byte by3 = by2;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = by3;
            throw Http2.ioException("%s != TYPE_CONTINUATION", objectArray2);
        }

        @Override
        public long read(Buffer buffer, long l5) throws IOException {
            int n5;
            while ((n5 = this.left) == 0) {
                ContinuationSource continuationSource = this;
                continuationSource.source.skip(this.padding);
                continuationSource.padding = 0;
                if ((continuationSource.flags & 4) != 0) {
                    return -1L;
                }
                this.readContinuationHeader();
            }
            long l6 = this.source.read(buffer, Math.min(l5, (long)n5));
            if (l6 == -1L) {
                return -1L;
            }
            this.left = (int)((long)this.left - l6);
            return l6;
        }

        @Override
        public Timeout timeout() {
            return this.source.timeout();
        }

        @Override
        public void close() throws IOException {
        }
    }

    static interface Handler {
        public void data(boolean var1, int var2, BufferedSource var3, int var4) throws IOException;

        public void headers(boolean var1, int var2, int var3, List<Header> var4);

        public void rstStream(int var1, ErrorCode var2);

        public void settings(boolean var1, Settings var2);

        public void ackSettings();

        public void ping(boolean var1, int var2, int var3);

        public void goAway(int var1, ErrorCode var2, ByteString var3);

        public void windowUpdate(int var1, long var2);

        public void priority(int var1, int var2, int var3, boolean var4);

        public void pushPromise(int var1, int var2, List<Header> var3) throws IOException;

        public void alternateService(int var1, String var2, ByteString var3, String var4, int var5, long var6);
    }
}

