/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Looper;
import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.collection.LruCache;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.IWXConfigAdapter;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;

public class WXUtils {
    static final LruCache<String, Integer> sCache = new LruCache(64);
    public static final char PERCENT = '%';
    private static final int HUNDRED = 100;
    private static final long sInterval = System.currentTimeMillis() - SystemClock.uptimeMillis();

    public static LruCache getCache() {
        return sCache;
    }

    public static boolean isUiThread() {
        return Thread.currentThread().getId() == Looper.getMainLooper().getThread().getId();
    }

    public static boolean isUndefined(float f) {
        return Float.isNaN(f);
    }

    public static float getFloatByViewport(Object object, float f) {
        return WXUtils.floatByViewport(object, f);
    }

    public static float getFloatByViewport(Object object, int n) {
        return WXUtils.floatByViewport(object, n);
    }

    private static float floatByViewport(Object object, float f) {
        String string2;
        block19: {
            block15: {
                block20: {
                    NumberFormatException numberFormatException4;
                    block18: {
                        block21: {
                            NumberFormatException numberFormatException22;
                            block17: {
                                if (object == null) {
                                    return Float.NaN;
                                }
                                string2 = object.toString().trim();
                                if ("auto".equals(string2) || "undefined".equals(string2) || TextUtils.isEmpty((CharSequence)string2)) break block19;
                                if (string2.endsWith("wx")) {
                                    try {
                                        return WXUtils.transferWx(string2, f);
                                    }
                                    catch (Exception exception) {
                                        WXLogUtils.e("Argument error! value is " + object, exception);
                                        break block15;
                                    }
                                    catch (NumberFormatException numberFormatException3) {
                                        WXLogUtils.e("Argument format error! value is " + object, numberFormatException3);
                                        break block15;
                                    }
                                }
                                if (!string2.endsWith("px")) break block20;
                                if (string2.length() <= 3 || !string2.endsWith("rpx") && !string2.endsWith("upx")) break block21;
                                int n = string2.length();
                                try {
                                    return WXUtils.transferRpxAndUpx(string2.substring(0, n - 3), 750.0f);
                                }
                                catch (Exception exception) {
                                }
                                catch (NumberFormatException numberFormatException22) {
                                    break block17;
                                }
                                WXLogUtils.e("Argument error! value is " + object, exception);
                                break block15;
                            }
                            WXLogUtils.e("Argument format error! value is " + object, numberFormatException22);
                            break block15;
                        }
                        String string3 = string2;
                        int n = 0;
                        try {
                            return Float.parseFloat(string3.substring(n, string3.indexOf("px")));
                        }
                        catch (Exception exception) {
                        }
                        catch (NumberFormatException numberFormatException4) {
                            break block18;
                        }
                        WXLogUtils.e("Argument error! value is " + object, exception);
                        break block15;
                    }
                    WXLogUtils.e("Argument format error! value is " + object, numberFormatException4);
                    break block15;
                }
                try {
                    return Float.parseFloat(string2);
                }
                catch (Exception exception) {
                    WXLogUtils.e("Argument error! value is " + object, exception);
                }
                catch (NumberFormatException numberFormatException) {
                    WXLogUtils.e("Argument format error! value is " + object, numberFormatException);
                }
            }
            return Float.NaN;
        }
        WXLogUtils.e("Argument Warning ! value is " + string2 + "And default Value:" + Float.NaN);
        return Float.NaN;
    }

    public static float getFloat(Object object) {
        return WXUtils.getFloat(object, Float.valueOf(Float.NaN)).floatValue();
    }

    public static Float getFloat(Object object, @Nullable Float f) {
        String string2;
        block19: {
            block18: {
                NumberFormatException numberFormatException5;
                block17: {
                    block21: {
                        NumberFormatException numberFormatException22;
                        block16: {
                            block22: {
                                NumberFormatException numberFormatException32;
                                block15: {
                                    block20: {
                                        NumberFormatException numberFormatException42;
                                        block13: {
                                            if (object == null) break block18;
                                            string2 = object.toString().trim();
                                            if ("auto".equals(string2) || "undefined".equals(string2) || TextUtils.isEmpty((CharSequence)string2)) break block19;
                                            if (!string2.endsWith("wx")) break block20;
                                            try {
                                                return Float.valueOf(WXUtils.transferWx(string2, 750.0f));
                                            }
                                            catch (Exception exception) {
                                            }
                                            catch (NumberFormatException numberFormatException42) {
                                                break block13;
                                            }
                                            WXLogUtils.e("Argument error! value is " + object, exception);
                                            break block18;
                                        }
                                        WXLogUtils.e("Argument format error! value is " + object, numberFormatException42);
                                        break block18;
                                    }
                                    if (!string2.endsWith("px")) break block21;
                                    if (string2.length() <= 3 || !string2.endsWith("rpx") && !string2.endsWith("upx")) break block22;
                                    int n = string2.length();
                                    try {
                                        return Float.valueOf(WXUtils.transferRpxAndUpx(string2.substring(0, n - 3), 750.0f));
                                    }
                                    catch (Exception exception) {
                                    }
                                    catch (NumberFormatException numberFormatException32) {
                                        break block15;
                                    }
                                    WXLogUtils.e("Argument error! value is " + object, exception);
                                    break block18;
                                }
                                WXLogUtils.e("Argument format error! value is " + object, numberFormatException32);
                                break block18;
                            }
                            String string3 = string2;
                            int n = 0;
                            try {
                                return Float.valueOf(Float.parseFloat(string3.substring(n, string3.indexOf("px"))));
                            }
                            catch (Exception exception) {
                            }
                            catch (NumberFormatException numberFormatException22) {
                                break block16;
                            }
                            WXLogUtils.e("Argument error! value is " + object, exception);
                            break block18;
                        }
                        WXLogUtils.e("Argument format error! value is " + object, numberFormatException22);
                        break block18;
                    }
                    try {
                        return Float.valueOf(Float.parseFloat(string2));
                    }
                    catch (Exception exception) {
                    }
                    catch (NumberFormatException numberFormatException5) {
                        break block17;
                    }
                    WXLogUtils.e("Argument error! value is " + object, exception);
                    break block18;
                }
                WXLogUtils.e("Argument format error! value is " + object, numberFormatException5);
            }
            return f;
        }
        WXLogUtils.e("Argument Warning ! value is " + string2 + "And default Value:" + Float.NaN);
        return f;
    }

    private static float transferWx(String string2, float f) {
        if (string2 == null) {
            return 0.0f;
        }
        if (string2.endsWith("wx")) {
            String string3 = string2;
            string2 = string3.substring(0, string3.indexOf("wx"));
        }
        return WXEnvironment.sApplication.getResources().getDisplayMetrics().density * Float.parseFloat(string2) * f / (float)WXViewUtils.getScreenWidth();
    }

    private static float transferRpxAndUpx(String string2, float f) {
        if (string2 == null) {
            return 0.0f;
        }
        if (string2.endsWith("rpx")) {
            String string3 = string2;
            string2 = string3.substring(0, string3.indexOf("rpx"));
        } else if (string2.endsWith("upx")) {
            String string4 = string2;
            string2 = string4.substring(0, string4.indexOf("upx"));
        }
        return WXEnvironment.getViewProt() / f * Float.parseFloat(string2);
    }

    public static float fastGetFloat(String string2, float f) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            int n;
            boolean bl = true;
            int n2 = 0;
            if (string2.charAt(0) == '-') {
                bl = false;
                n2 = 1;
            } else if (string2.charAt(0) == '+') {
                n2 = 1;
            }
            float f2 = 0.0f;
            while (n2 < string2.length() && (n = string2.charAt(n2)) >= 48 && n <= 57) {
                f2 = f2 * 10.0f + (float)n - 48.0f;
                ++n2;
            }
            if (n2 < string2.length() && string2.charAt(n2) == '.') {
                char c;
                ++n2;
                n = 10;
                int n3 = 0;
                while (n2 < string2.length() && (float)n3 < f && (c = string2.charAt(n2)) >= '0' && c <= '9') {
                    f2 += (float)(c - 48) / (float)n;
                    n *= 10;
                    ++n2;
                    ++n3;
                }
            }
            if (!bl) {
                return f2 * -1.0f;
            }
            return f2;
        }
        return 0.0f;
    }

    public static float fastGetFloat(String string2) {
        return WXUtils.fastGetFloat(string2, 2.1474836E9f);
    }

    public static int parseInt(String string2) {
        block4: {
            if (TextUtils.isEmpty((CharSequence)string2)) break block4;
            if (string2.contains(".")) break block4;
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                if (!WXEnvironment.isApkDebugable()) break block4;
                WXLogUtils.e(WXLogUtils.getStackTrace(numberFormatException));
            }
        }
        return 0;
    }

    public static int parseInt(Object object) {
        return WXUtils.parseInt(String.valueOf(object));
    }

    public static float parseFloat(Object object) {
        return WXUtils.parseFloat(String.valueOf(object));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static float parseFloat(String string2) {
        NumberFormatException numberFormatException2;
        block3: {
            try {
                if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.equals((CharSequence)string2, (CharSequence)"null")) {
                    return Float.parseFloat(string2);
                }
            }
            catch (NumberFormatException numberFormatException2) {
                break block3;
            }
            if (!WXEnvironment.isApkDebugable()) return 0.0f;
            WXLogUtils.e("WXUtils parseFloat illegal value is " + string2);
            return 0.0f;
        }
        if (!WXEnvironment.isApkDebugable()) return 0.0f;
        WXLogUtils.e(WXLogUtils.getStackTrace(numberFormatException2));
        return 0.0f;
    }

    public static int getInt(Object object) {
        return WXUtils.getInteger(object, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Integer getInteger(@Nullable Object object, @Nullable Integer n) {
        String string2;
        block39: {
            block36: {
                NumberFormatException numberFormatException5;
                block34: {
                    Exception exception5;
                    block33: {
                        block32: {
                            Integer n2;
                            block26: {
                                block37: {
                                    NumberFormatException numberFormatException22;
                                    block31: {
                                        Exception exception22;
                                        block30: {
                                            Object object2;
                                            block29: {
                                                block38: {
                                                    NumberFormatException numberFormatException32;
                                                    block28: {
                                                        block35: {
                                                            NumberFormatException numberFormatException42;
                                                            block27: {
                                                                if (object == null) {
                                                                    return n;
                                                                }
                                                                string2 = object.toString().trim();
                                                                object2 = (Integer)sCache.get((Object)string2);
                                                                if (object2 != null) {
                                                                    return object2;
                                                                }
                                                                object2 = "";
                                                                if (string2.length() >= 2) {
                                                                    String string3 = string2;
                                                                    int n3 = string3.length() - 2;
                                                                    object2 = string3.substring(n3, string3.length());
                                                                }
                                                                if (!TextUtils.equals((CharSequence)"wx", (CharSequence)object2)) break block35;
                                                                if (WXEnvironment.isApkDebugable()) {
                                                                    WXLogUtils.w("the value of " + object + " use wx unit, which will be not supported soon after.");
                                                                }
                                                                try {
                                                                    n2 = (int)WXUtils.transferWx(string2, 750.0f);
                                                                    break block26;
                                                                }
                                                                catch (Exception exception3) {
                                                                }
                                                                catch (NumberFormatException numberFormatException42) {
                                                                    break block27;
                                                                }
                                                                WXLogUtils.e("Argument error! value is " + object, exception3);
                                                                break block36;
                                                            }
                                                            WXLogUtils.e("Argument format error! value is " + object, numberFormatException42);
                                                            break block36;
                                                        }
                                                        if (!TextUtils.equals((CharSequence)"px", (CharSequence)object2)) break block37;
                                                        if (string2.length() <= 3 || !string2.endsWith("rpx") && !string2.endsWith("upx")) break block38;
                                                        try {
                                                            n2 = (int)WXUtils.transferRpxAndUpx(string2.substring(0, string2.length() - 3), 750.0f);
                                                            break block26;
                                                        }
                                                        catch (Exception exception4) {
                                                        }
                                                        catch (NumberFormatException numberFormatException32) {
                                                            break block28;
                                                        }
                                                        WXLogUtils.e("Argument error! value is " + object, exception4);
                                                        break block36;
                                                    }
                                                    WXLogUtils.e("Argument format error! value is " + object, numberFormatException32);
                                                    break block36;
                                                }
                                                object2 = string2.substring(0, string2.length() - 2);
                                                if (TextUtils.isEmpty((CharSequence)object2) || !((String)object2).contains(".")) break block29;
                                                int n4 = (int)WXUtils.parseFloat((String)object2);
                                                try {
                                                    n2 = n4;
                                                    break block26;
                                                }
                                                catch (Exception exception22) {
                                                    break block30;
                                                }
                                                catch (NumberFormatException numberFormatException22) {
                                                    break block31;
                                                }
                                            }
                                            n2 = Integer.parseInt((String)object2);
                                            break block26;
                                        }
                                        WXLogUtils.e("Argument error! value is " + object, exception22);
                                        break block36;
                                    }
                                    WXLogUtils.e("Argument format error! value is " + object, numberFormatException22);
                                    break block36;
                                }
                                try {
                                    if (!TextUtils.isEmpty((CharSequence)string2)) {
                                        n2 = string2.contains(".") ? Integer.valueOf((int)WXUtils.parseFloat(string2)) : Integer.valueOf(Integer.parseInt(string2));
                                    }
                                    break block32;
                                }
                                catch (Exception exception5) {
                                    break block33;
                                }
                                catch (NumberFormatException numberFormatException5) {
                                    break block34;
                                }
                            }
                            object = n2;
                            break block39;
                        }
                        if (WXEnvironment.isApkDebugable()) {
                            WXLogUtils.e("Argument value is null, df is" + n);
                        }
                        break block36;
                    }
                    WXLogUtils.e("Argument error! value is " + object, exception5);
                    break block36;
                }
                WXLogUtils.e("Argument format error! value is " + object, numberFormatException5);
            }
            object = n;
        }
        if (object != null && !((Integer)object).equals(n)) {
            sCache.put((Object)string2, object);
        }
        return object;
    }

    @Deprecated
    public static long getLong(Object object) {
        long l;
        block16: {
            String string2;
            block20: {
                NumberFormatException numberFormatException4;
                block19: {
                    block21: {
                        NumberFormatException numberFormatException22;
                        block18: {
                            if (object == null) {
                                return 0L;
                            }
                            l = 0L;
                            string2 = object.toString().trim();
                            if (string2.endsWith("wx")) {
                                if (WXEnvironment.isApkDebugable()) {
                                    WXLogUtils.w("the value of " + object + " use wx unit, which will be not supported soon after.");
                                }
                                try {
                                    return (long)WXUtils.transferWx(string2, 750.0f);
                                }
                                catch (Exception exception) {
                                    WXLogUtils.e("Argument error! value is " + object, exception);
                                    break block16;
                                }
                                catch (NumberFormatException numberFormatException3) {
                                    WXLogUtils.e("Argument format error! value is " + object, numberFormatException3);
                                    break block16;
                                }
                            }
                            if (!string2.endsWith("px")) break block20;
                            if (string2.length() <= 3 || !string2.endsWith("rpx") && !string2.endsWith("upx")) break block21;
                            int n = string2.length();
                            try {
                                return (long)WXUtils.transferRpxAndUpx(string2.substring(0, n - 3), 750.0f);
                            }
                            catch (Exception exception) {
                            }
                            catch (NumberFormatException numberFormatException22) {
                                break block18;
                            }
                            WXLogUtils.e("Argument error! value is " + object, exception);
                            break block16;
                        }
                        WXLogUtils.e("Argument format error! value is " + object, numberFormatException22);
                        break block16;
                    }
                    String string3 = string2;
                    int n = 0;
                    try {
                        return Long.parseLong(string3.substring(n, string3.indexOf("px")));
                    }
                    catch (Exception exception) {
                    }
                    catch (NumberFormatException numberFormatException4) {
                        break block19;
                    }
                    WXLogUtils.e("Argument error! value is " + object, exception);
                    break block16;
                }
                WXLogUtils.e("Argument format error! value is " + object, numberFormatException4);
                break block16;
            }
            try {
                return Long.parseLong(string2);
            }
            catch (Exception exception) {
                WXLogUtils.e("Argument error! value is " + object, exception);
            }
            catch (NumberFormatException numberFormatException) {
                WXLogUtils.e("Argument format error! value is " + object, numberFormatException);
            }
        }
        return l;
    }

    @Deprecated
    public static double getDouble(Object object) {
        double d;
        block16: {
            String string2;
            block20: {
                NumberFormatException numberFormatException4;
                block19: {
                    block21: {
                        NumberFormatException numberFormatException22;
                        block18: {
                            if (object == null) {
                                return 0.0;
                            }
                            d = 0.0;
                            string2 = object.toString().trim();
                            if (string2.endsWith("wx")) {
                                if (WXEnvironment.isApkDebugable()) {
                                    WXLogUtils.w("the value of " + object + " use wx unit, which will be not supported soon after.");
                                }
                                try {
                                    return WXUtils.transferWx(string2, 750.0f);
                                }
                                catch (Exception exception) {
                                    WXLogUtils.e("Argument error! value is " + object, exception);
                                    break block16;
                                }
                                catch (NumberFormatException numberFormatException3) {
                                    WXLogUtils.e("Argument format error! value is " + object, numberFormatException3);
                                    break block16;
                                }
                            }
                            if (!string2.endsWith("px")) break block20;
                            if (string2.length() <= 3 || !string2.endsWith("rpx") && !string2.endsWith("upx")) break block21;
                            int n = string2.length();
                            try {
                                return WXUtils.transferRpxAndUpx(string2.substring(0, n - 3), 750.0f);
                            }
                            catch (Exception exception) {
                            }
                            catch (NumberFormatException numberFormatException22) {
                                break block18;
                            }
                            WXLogUtils.e("Argument error! value is " + object, exception);
                            break block16;
                        }
                        WXLogUtils.e("Argument format error! value is " + object, numberFormatException22);
                        break block16;
                    }
                    String string3 = string2;
                    int n = 0;
                    try {
                        return Double.parseDouble(string3.substring(n, string3.indexOf("px")));
                    }
                    catch (Exception exception) {
                    }
                    catch (NumberFormatException numberFormatException4) {
                        break block19;
                    }
                    WXLogUtils.e("Argument error! value is " + object, exception);
                    break block16;
                }
                WXLogUtils.e("Argument format error! value is " + object, numberFormatException4);
                break block16;
            }
            try {
                return Double.parseDouble(string2);
            }
            catch (Exception exception) {
                WXLogUtils.e("Argument error! value is " + object, exception);
            }
            catch (NumberFormatException numberFormatException) {
                WXLogUtils.e("Argument format error! value is " + object, numberFormatException);
            }
        }
        return d;
    }

    @Deprecated
    public static boolean isTabletDevice() {
        try {
            return (WXEnvironment.getApplication().getResources().getConfiguration().screenLayout & 0xF) >= 3;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Boolean getBoolean(@Nullable Object object, @Nullable Boolean bl) {
        if (object != null) {
            if (TextUtils.equals((CharSequence)"false", (CharSequence)object.toString())) {
                return Boolean.FALSE;
            }
            if (TextUtils.equals((CharSequence)"true", (CharSequence)object.toString())) {
                return Boolean.TRUE;
            }
        }
        return bl;
    }

    public static long getAvailMemory(Context context) {
        ActivityManager.MemoryInfo memoryInfo;
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        context = memoryInfo;
        activityManager.getMemoryInfo(new ActivityManager.MemoryInfo());
        WXLogUtils.w("app AvailMemory ---->>>" + context.availMem / 0x100000L);
        return context.availMem / 0x100000L;
    }

    public static String getString(@Nullable Object object, @Nullable String string2) {
        if (object == null) {
            return string2;
        }
        if (object instanceof String) {
            return (String)object;
        }
        return object.toString();
    }

    public static int parseUnitOrPercent(String string2, int n) {
        int n2 = string2.lastIndexOf(37);
        if (n2 != -1) {
            return WXUtils.parsePercent(string2.substring(0, n2), n);
        }
        return WXUtils.parseInt(string2);
    }

    private static int parsePercent(String string2, int n) {
        return (int)(Float.parseFloat(string2) / 100.0f * (float)n);
    }

    public static String getBundleBanner(String string2) {
        StringBuilder stringBuilder;
        int n = string2.indexOf("/*!");
        if (n == -1) {
            return null;
        }
        int n2 = WXUtils.indexLineBreak(string2, n += 3);
        if (n2 == -1) {
            return null;
        }
        String string3 = string2;
        int n3 = Integer.parseInt(string3.substring(n, n2));
        int n4 = n2 + 1;
        CharSequence charSequence = string3.substring(n4, n4 + n3);
        n = ((String)charSequence).lastIndexOf("!*/");
        if (n == -1) {
            return null;
        }
        String string4 = ((String)charSequence).substring(0, n);
        charSequence = stringBuilder;
        stringBuilder = new StringBuilder();
        String[] stringArray = WXUtils.splitLineBreak(string4);
        n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            ((StringBuilder)charSequence).append(stringArray[i].replaceFirst("\\*", ""));
        }
        return ((StringBuilder)charSequence).toString();
    }

    private static int indexLineBreak(String string2, int n) {
        int n2 = string2.indexOf("\r", n);
        if (n2 == -1) {
            n2 = string2.indexOf("\n", n);
        }
        if (n2 == -1) {
            return string2.indexOf("\r\n", n);
        }
        return n2;
    }

    private static String[] splitLineBreak(String string2) {
        String[] stringArray = string2.split("\r");
        if (stringArray.length == 1) {
            stringArray = string2.split("\n");
        }
        if (stringArray.length == 1) {
            return string2.split("\r\n");
        }
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getNumberInt(Object object, int n) {
        if (object == null) {
            return n;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        try {
            String string2 = object.toString();
            if (string2.indexOf(46) >= 0) {
                return (int)Float.parseFloat(object.toString());
            }
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public static boolean checkGreyConfig(String string2, String string3, String string4) {
        IWXConfigAdapter iWXConfigAdapter = WXSDKManager.getInstance().getWxConfigAdapter();
        if (iWXConfigAdapter == null) {
            return false;
        }
        double d = Math.random() * 100.0;
        double d2 = 100.0;
        try {
            d2 = Double.valueOf(iWXConfigAdapter.getConfig(string2, string3, string4));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d < d2;
    }

    public static long getFixUnixTime() {
        return sInterval + SystemClock.uptimeMillis();
    }
}

