/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417.decoder;

import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.common.BitMatrix;

final class BoundingBox {
    private BitMatrix image;
    private ResultPoint topLeft;
    private ResultPoint bottomLeft;
    private ResultPoint topRight;
    private ResultPoint bottomRight;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;

    BoundingBox(BitMatrix bitMatrix, ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4) throws NotFoundException {
        if (resultPoint == null && resultPoint3 == null || resultPoint2 == null && resultPoint4 == null || resultPoint != null && resultPoint2 == null || resultPoint3 != null && resultPoint4 == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        this.init(bitMatrix, resultPoint, resultPoint2, resultPoint3, resultPoint4);
    }

    BoundingBox(BoundingBox object) {
        BoundingBox boundingBox = bitMatrix;
        BoundingBox boundingBox2 = object;
        BitMatrix bitMatrix = boundingBox2.image;
        object = boundingBox2.topLeft;
        ResultPoint resultPoint = boundingBox2.bottomLeft;
        ResultPoint resultPoint2 = boundingBox2.topRight;
        ResultPoint resultPoint3 = boundingBox2.bottomRight;
        boundingBox.init(bitMatrix, (ResultPoint)object, resultPoint, resultPoint2, resultPoint3);
    }

    private void init(BitMatrix bitMatrix, ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4) {
        this.image = bitMatrix;
        this.topLeft = resultPoint;
        this.bottomLeft = resultPoint2;
        this.topRight = resultPoint3;
        this.bottomRight = resultPoint4;
        this.calculateMinMaxValues();
    }

    static BoundingBox merge(BoundingBox object, BoundingBox object2) throws NotFoundException {
        if (object == null) {
            return object2;
        }
        if (object2 == null) {
            return object;
        }
        BoundingBox boundingBox = object2;
        BoundingBox boundingBox2 = object;
        object = boundingBox2.image;
        object2 = boundingBox2.topLeft;
        ResultPoint resultPoint = boundingBox2.bottomLeft;
        ResultPoint resultPoint2 = boundingBox.topRight;
        ResultPoint resultPoint3 = boundingBox.bottomRight;
        return new BoundingBox((BitMatrix)object, (ResultPoint)object2, resultPoint, resultPoint2, resultPoint3);
    }

    private void calculateMinMaxValues() {
        if (this.topLeft == null) {
            ResultPoint resultPoint;
            ResultPoint resultPoint2;
            ResultPoint resultPoint3 = resultPoint2;
            resultPoint2 = new ResultPoint(0.0f, this.topRight.getY());
            this.topLeft = resultPoint3;
            resultPoint3 = resultPoint;
            resultPoint = new ResultPoint(0.0f, this.bottomRight.getY());
            this.bottomLeft = resultPoint3;
        } else if (this.topRight == null) {
            ResultPoint resultPoint;
            ResultPoint resultPoint4;
            ResultPoint resultPoint5 = resultPoint4;
            resultPoint4 = new ResultPoint(this.image.getWidth() - 1, this.topLeft.getY());
            this.topRight = resultPoint5;
            resultPoint5 = resultPoint;
            resultPoint = new ResultPoint(this.image.getWidth() - 1, this.bottomLeft.getY());
            this.bottomRight = resultPoint5;
        }
        this.minX = (int)Math.min(this.topLeft.getX(), this.bottomLeft.getX());
        this.maxX = (int)Math.max(this.topRight.getX(), this.bottomRight.getX());
        this.minY = (int)Math.min(this.topLeft.getY(), this.topRight.getY());
        this.maxY = (int)Math.max(this.bottomLeft.getY(), this.bottomRight.getY());
    }

    BoundingBox addMissingRows(int n5, int n6, boolean bl) throws NotFoundException {
        BoundingBox boundingBox = this;
        ResultPoint resultPoint = boundingBox.topLeft;
        ResultPoint resultPoint2 = boundingBox.bottomLeft;
        ResultPoint resultPoint3 = boundingBox.topRight;
        ResultPoint resultPoint4 = boundingBox.bottomRight;
        if (n5 > 0) {
            ResultPoint resultPoint5;
            ResultPoint resultPoint6 = bl ? resultPoint : resultPoint3;
            n5 = (int)resultPoint6.getY() - n5;
            if (n5 < 0) {
                n5 = 0;
            }
            ResultPoint resultPoint7 = resultPoint5;
            float f5 = resultPoint6.getX();
            resultPoint5 = new ResultPoint(f5, n5);
            if (bl) {
                resultPoint = resultPoint7;
            } else {
                resultPoint3 = resultPoint7;
            }
        }
        if (n6 > 0) {
            ResultPoint resultPoint8;
            ResultPoint resultPoint9 = bl ? this.bottomLeft : this.bottomRight;
            n6 = (int)resultPoint9.getY() + n6;
            if (n6 >= this.image.getHeight()) {
                n6 = this.image.getHeight() - 1;
            }
            ResultPoint resultPoint10 = resultPoint8;
            float f6 = resultPoint9.getX();
            resultPoint8 = new ResultPoint(f6, n6);
            if (bl) {
                resultPoint2 = resultPoint10;
            } else {
                resultPoint4 = resultPoint10;
            }
        }
        this.calculateMinMaxValues();
        return new BoundingBox(this.image, resultPoint, resultPoint2, resultPoint3, resultPoint4);
    }

    int getMinX() {
        return this.minX;
    }

    int getMaxX() {
        return this.maxX;
    }

    int getMinY() {
        return this.minY;
    }

    int getMaxY() {
        return this.maxY;
    }

    ResultPoint getTopLeft() {
        return this.topLeft;
    }

    ResultPoint getTopRight() {
        return this.topRight;
    }

    ResultPoint getBottomLeft() {
        return this.bottomLeft;
    }

    ResultPoint getBottomRight() {
        return this.bottomRight;
    }
}

