/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417.encoder;

import com.dcloud.zxing2.WriterException;
import com.dcloud.zxing2.pdf417.encoder.BarcodeMatrix;
import com.dcloud.zxing2.pdf417.encoder.BarcodeRow;
import com.dcloud.zxing2.pdf417.encoder.Compaction;
import com.dcloud.zxing2.pdf417.encoder.PDF417ErrorCorrection;
import com.dcloud.zxing2.pdf417.encoder.PDF417HighLevelEncoder;
import java.nio.charset.Charset;

public final class PDF417 {
    private static final int START_PATTERN = 130728;
    private static final int STOP_PATTERN = 260649;
    private static final int[][] CODEWORD_TABLE;
    private static final float PREFERRED_RATIO = 3.0f;
    private static final float DEFAULT_MODULE_WIDTH = 0.357f;
    private static final float HEIGHT = 2.0f;
    private BarcodeMatrix barcodeMatrix;
    private boolean compact;
    private Compaction compaction;
    private Charset encoding;
    private int minCols;
    private int maxCols;
    private int maxRows;
    private int minRows;

    public PDF417() {
        this(false);
    }

    public PDF417(boolean bl) {
        PDF417 pDF417 = this;
        pDF417.compact = bl;
        pDF417.compaction = Compaction.AUTO;
        pDF417.encoding = null;
        pDF417.minCols = 2;
        pDF417.maxCols = 30;
        pDF417.maxRows = 30;
        pDF417.minRows = 2;
    }

    private static int calculateNumberOfRows(int n5, int n6, int n7) {
        int n8 = (n6 = (n5 = n5 + 1 + n6) / n7) + 1;
        if (n7 * n8 >= n5 + n7) {
            return n6;
        }
        return n8;
    }

    private static int getNumberOfPadCodewords(int n5, int n6, int n7, int n8) {
        if ((n6 = n7 * n8 - n6) > n5 + 1) {
            return n6 - n5 - 1;
        }
        return 0;
    }

    private static void encodeChar(int n5, int n6, BarcodeRow barcodeRow) {
        int n7 = 1 << n6 - 1;
        int n8 = (n5 & n7) != 0 ? 1 : 0;
        int n9 = 0;
        for (int i5 = 0; i5 < n6; ++i5) {
            int n10 = (n5 & n7) != 0 ? 1 : 0;
            if (n8 == n10) {
                ++n9;
            } else {
                barcodeRow.addBar(n8 != 0, n9);
                n9 = n8 = 1;
                n8 = n10;
            }
            n7 >>= 1;
        }
        barcodeRow.addBar(n8 != 0, n9);
    }

    private void encodeLowLevel(CharSequence charSequence, int n5, int n6, int n7, BarcodeMatrix barcodeMatrix) {
        int n8 = 0;
        for (int i5 = 0; i5 < n6; ++i5) {
            BarcodeRow barcodeRow;
            int n9;
            int n10;
            int n11 = i5 % 3;
            BarcodeMatrix barcodeMatrix2 = barcodeMatrix;
            barcodeMatrix2.startRow();
            BarcodeRow barcodeRow2 = barcodeMatrix2.getCurrentRow();
            PDF417.encodeChar(130728, 17, barcodeRow2);
            if (n11 == 0) {
                int n12 = i5 / 3 * 30;
                n10 = n12 + (n6 - 1) / 3;
                n9 = n12 + (n5 - 1);
            } else if (n11 == 1) {
                int n13 = i5 / 3 * 30;
                n10 = n13 + n7 * 3;
                int n14 = n6 - 1;
                n10 += n14 % 3;
                n9 = n13 + n14 / 3;
            } else {
                int n15 = i5 / 3 * 30;
                n10 = n15 + (n5 - 1);
                n9 = n15 + n7 * 3 + (n6 - 1) % 3;
            }
            PDF417.encodeChar(CODEWORD_TABLE[n11][n10], 17, barcodeMatrix.getCurrentRow());
            for (n10 = 0; n10 < n5; ++n10) {
                PDF417.encodeChar(CODEWORD_TABLE[n11][charSequence.charAt(n8)], 17, barcodeMatrix.getCurrentRow());
                ++n8;
            }
            if (this.compact) {
                barcodeRow = barcodeMatrix.getCurrentRow();
                PDF417.encodeChar(260649, 1, barcodeRow);
                continue;
            }
            PDF417.encodeChar(CODEWORD_TABLE[n11][n9], 17, barcodeMatrix.getCurrentRow());
            barcodeRow = barcodeMatrix.getCurrentRow();
            PDF417.encodeChar(260649, 18, barcodeRow);
        }
    }

    private int[] determineDimensions(int n5, int n6) throws WriterException {
        int n7;
        float f5 = 0.0f;
        int[] nArray = null;
        for (int i5 = this.minCols; i5 <= this.maxCols && (n7 = PDF417.calculateNumberOfRows(n5, n6, i5)) >= this.minRows; ++i5) {
            if (n7 > this.maxRows) continue;
            float f6 = (float)(i5 * 17 + 69) * 0.357f / ((float)n7 * 2.0f);
            if (nArray != null && Math.abs(f6 - 3.0f) > Math.abs(f5 - 3.0f)) continue;
            int[] nArray2 = new int[2];
            int[] nArray3 = nArray2;
            nArray2[0] = i5;
            nArray2[1] = n7;
            nArray = nArray3;
            f5 = f6;
        }
        if (nArray == null && PDF417.calculateNumberOfRows(n5, n6, this.minCols) < (n5 = this.minRows)) {
            int[] nArray4 = new int[2];
            nArray = nArray4;
            nArray4[0] = this.minCols;
            nArray4[1] = n5;
        }
        if (nArray != null) {
            return nArray;
        }
        throw new WriterException("Unable to fit message in columns");
    }

    static {
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[929];
        int[] nArray2 = nArray;
        nArray[0] = 120256;
        nArray2[1] = 125680;
        nArray2[2] = 128380;
        nArray2[3] = 120032;
        nArray2[4] = 125560;
        nArray2[5] = 128318;
        nArray2[6] = 108736;
        nArray2[7] = 119920;
        nArray2[8] = 108640;
        nArray2[9] = 86080;
        nArray2[10] = 108592;
        nArray2[11] = 86048;
        nArray2[12] = 110016;
        nArray2[13] = 120560;
        nArray2[14] = 125820;
        nArray2[15] = 109792;
        nArray2[16] = 120440;
        nArray2[17] = 125758;
        nArray2[18] = 88256;
        nArray2[19] = 109680;
        nArray2[20] = 88160;
        nArray2[21] = 89536;
        nArray2[22] = 110320;
        nArray2[23] = 120700;
        nArray2[24] = 89312;
        nArray2[25] = 110200;
        nArray2[26] = 120638;
        nArray2[27] = 89200;
        nArray2[28] = 110140;
        nArray2[29] = 89840;
        nArray2[30] = 110460;
        nArray2[31] = 89720;
        nArray2[32] = 110398;
        nArray2[33] = 89980;
        nArray2[34] = 128506;
        nArray2[35] = 119520;
        nArray2[36] = 125304;
        nArray2[37] = 128190;
        nArray2[38] = 107712;
        nArray2[39] = 119408;
        nArray2[40] = 125244;
        nArray2[41] = 107616;
        nArray2[42] = 119352;
        nArray2[43] = 84032;
        nArray2[44] = 107568;
        nArray2[45] = 119324;
        nArray2[46] = 84000;
        nArray2[47] = 107544;
        nArray2[48] = 83984;
        nArray2[49] = 108256;
        nArray2[50] = 119672;
        nArray2[51] = 125374;
        nArray2[52] = 85184;
        nArray2[53] = 108144;
        nArray2[54] = 119612;
        nArray2[55] = 85088;
        nArray2[56] = 108088;
        nArray2[57] = 119582;
        nArray2[58] = 85040;
        nArray2[59] = 108060;
        nArray2[60] = 85728;
        nArray2[61] = 108408;
        nArray2[62] = 119742;
        nArray2[63] = 85616;
        nArray2[64] = 108348;
        nArray2[65] = 85560;
        nArray2[66] = 108318;
        nArray2[67] = 85880;
        nArray2[68] = 108478;
        nArray2[69] = 85820;
        nArray2[70] = 85790;
        nArray2[71] = 107200;
        nArray2[72] = 119152;
        nArray2[73] = 125116;
        nArray2[74] = 107104;
        nArray2[75] = 119096;
        nArray2[76] = 125086;
        nArray2[77] = 83008;
        nArray2[78] = 107056;
        nArray2[79] = 119068;
        nArray2[80] = 82976;
        nArray2[81] = 107032;
        nArray2[82] = 82960;
        nArray2[83] = 82952;
        nArray2[84] = 83648;
        nArray2[85] = 107376;
        nArray2[86] = 119228;
        nArray2[87] = 83552;
        nArray2[88] = 107320;
        nArray2[89] = 119198;
        nArray2[90] = 83504;
        nArray2[91] = 107292;
        nArray2[92] = 83480;
        nArray2[93] = 83468;
        nArray2[94] = 83824;
        nArray2[95] = 107452;
        nArray2[96] = 83768;
        nArray2[97] = 107422;
        nArray2[98] = 83740;
        nArray2[99] = 83900;
        nArray2[100] = 106848;
        nArray2[101] = 118968;
        nArray2[102] = 125022;
        nArray2[103] = 82496;
        nArray2[104] = 106800;
        nArray2[105] = 118940;
        nArray2[106] = 82464;
        nArray2[107] = 106776;
        nArray2[108] = 118926;
        nArray2[109] = 82448;
        nArray2[110] = 106764;
        nArray2[111] = 82440;
        nArray2[112] = 106758;
        nArray2[113] = 82784;
        nArray2[114] = 106936;
        nArray2[115] = 119006;
        nArray2[116] = 82736;
        nArray2[117] = 106908;
        nArray2[118] = 82712;
        nArray2[119] = 106894;
        nArray2[120] = 82700;
        nArray2[121] = 82694;
        nArray2[122] = 106974;
        nArray2[123] = 82830;
        nArray2[124] = 82240;
        nArray2[125] = 106672;
        nArray2[126] = 118876;
        nArray2[127] = 82208;
        nArray2[128] = 106648;
        nArray2[129] = 118862;
        nArray2[130] = 82192;
        nArray2[131] = 106636;
        nArray2[132] = 82184;
        nArray2[133] = 106630;
        nArray2[134] = 82180;
        nArray2[135] = 82352;
        nArray2[136] = 82328;
        nArray2[137] = 82316;
        nArray2[138] = 82080;
        nArray2[139] = 118830;
        nArray2[140] = 106572;
        nArray2[141] = 106566;
        nArray2[142] = 82050;
        nArray2[143] = 117472;
        nArray2[144] = 124280;
        nArray2[145] = 127678;
        nArray2[146] = 103616;
        nArray2[147] = 117360;
        nArray2[148] = 124220;
        nArray2[149] = 103520;
        nArray2[150] = 117304;
        nArray2[151] = 124190;
        nArray2[152] = 75840;
        nArray2[153] = 103472;
        nArray2[154] = 75808;
        nArray2[155] = 104160;
        nArray2[156] = 117624;
        nArray2[157] = 124350;
        nArray2[158] = 76992;
        nArray2[159] = 104048;
        nArray2[160] = 117564;
        nArray2[161] = 76896;
        nArray2[162] = 103992;
        nArray2[163] = 76848;
        nArray2[164] = 76824;
        nArray2[165] = 77536;
        nArray2[166] = 104312;
        nArray2[167] = 117694;
        nArray2[168] = 77424;
        nArray2[169] = 104252;
        nArray2[170] = 77368;
        nArray2[171] = 77340;
        nArray2[172] = 77688;
        nArray2[173] = 104382;
        nArray2[174] = 77628;
        nArray2[175] = 77758;
        nArray2[176] = 121536;
        nArray2[177] = 126320;
        nArray2[178] = 128700;
        nArray2[179] = 121440;
        nArray2[180] = 126264;
        nArray2[181] = 128670;
        nArray2[182] = 111680;
        nArray2[183] = 121392;
        nArray2[184] = 126236;
        nArray2[185] = 111648;
        nArray2[186] = 121368;
        nArray2[187] = 126222;
        nArray2[188] = 111632;
        nArray2[189] = 121356;
        nArray2[190] = 103104;
        nArray2[191] = 117104;
        nArray2[192] = 124092;
        nArray2[193] = 112320;
        nArray2[194] = 103008;
        nArray2[195] = 117048;
        nArray2[196] = 124062;
        nArray2[197] = 112224;
        nArray2[198] = 121656;
        nArray2[199] = 126366;
        nArray2[200] = 93248;
        nArray2[201] = 74784;
        nArray2[202] = 102936;
        nArray2[203] = 117006;
        nArray2[204] = 93216;
        nArray2[205] = 112152;
        nArray2[206] = 93200;
        nArray2[207] = 75456;
        nArray2[208] = 103280;
        nArray2[209] = 117180;
        nArray2[210] = 93888;
        nArray2[211] = 75360;
        nArray2[212] = 103224;
        nArray2[213] = 117150;
        nArray2[214] = 93792;
        nArray2[215] = 112440;
        nArray2[216] = 121758;
        nArray2[217] = 93744;
        nArray2[218] = 75288;
        nArray2[219] = 93720;
        nArray2[220] = 75632;
        nArray2[221] = 103356;
        nArray2[222] = 94064;
        nArray2[223] = 75576;
        nArray2[224] = 103326;
        nArray2[225] = 94008;
        nArray2[226] = 112542;
        nArray2[227] = 93980;
        nArray2[228] = 75708;
        nArray2[229] = 94140;
        nArray2[230] = 75678;
        nArray2[231] = 94110;
        nArray2[232] = 121184;
        nArray2[233] = 126136;
        nArray2[234] = 128606;
        nArray2[235] = 111168;
        nArray2[236] = 121136;
        nArray2[237] = 126108;
        nArray2[238] = 111136;
        nArray2[239] = 121112;
        nArray2[240] = 126094;
        nArray2[241] = 111120;
        nArray2[242] = 121100;
        nArray2[243] = 111112;
        nArray2[244] = 111108;
        nArray2[245] = 102752;
        nArray2[246] = 116920;
        nArray2[247] = 123998;
        nArray2[248] = 111456;
        nArray2[249] = 102704;
        nArray2[250] = 116892;
        nArray2[251] = 91712;
        nArray2[252] = 74272;
        nArray2[253] = 121244;
        nArray2[254] = 116878;
        nArray2[255] = 91680;
        nArray2[256] = 74256;
        nArray2[257] = 102668;
        nArray2[258] = 91664;
        nArray2[259] = 111372;
        nArray2[260] = 102662;
        nArray2[261] = 74244;
        nArray2[262] = 74592;
        nArray2[263] = 102840;
        nArray2[264] = 116958;
        nArray2[265] = 92000;
        nArray2[266] = 74544;
        nArray2[267] = 102812;
        nArray2[268] = 91952;
        nArray2[269] = 111516;
        nArray2[270] = 102798;
        nArray2[271] = 91928;
        nArray2[272] = 74508;
        nArray2[273] = 74502;
        nArray2[274] = 74680;
        nArray2[275] = 102878;
        nArray2[276] = 92088;
        nArray2[277] = 74652;
        nArray2[278] = 92060;
        nArray2[279] = 74638;
        nArray2[280] = 92046;
        nArray2[281] = 92126;
        nArray2[282] = 110912;
        nArray2[283] = 121008;
        nArray2[284] = 126044;
        nArray2[285] = 110880;
        nArray2[286] = 120984;
        nArray2[287] = 126030;
        nArray2[288] = 110864;
        nArray2[289] = 120972;
        nArray2[290] = 110856;
        nArray2[291] = 120966;
        nArray2[292] = 110852;
        nArray2[293] = 110850;
        nArray2[294] = 74048;
        nArray2[295] = 102576;
        nArray2[296] = 116828;
        nArray2[297] = 90944;
        nArray2[298] = 74016;
        nArray2[299] = 102552;
        nArray2[300] = 116814;
        nArray2[301] = 90912;
        nArray2[302] = 111000;
        nArray2[303] = 121038;
        nArray2[304] = 90896;
        nArray2[305] = 73992;
        nArray2[306] = 102534;
        nArray2[307] = 90888;
        nArray2[308] = 110982;
        nArray2[309] = 90884;
        nArray2[310] = 74160;
        nArray2[311] = 102620;
        nArray2[312] = 91056;
        nArray2[313] = 74136;
        nArray2[314] = 102606;
        nArray2[315] = 91032;
        nArray2[316] = 111054;
        nArray2[317] = 91020;
        nArray2[318] = 74118;
        nArray2[319] = 91014;
        nArray2[320] = 91100;
        nArray2[321] = 91086;
        nArray2[322] = 110752;
        nArray2[323] = 120920;
        nArray2[324] = 125998;
        nArray2[325] = 110736;
        nArray2[326] = 120908;
        nArray2[327] = 110728;
        nArray2[328] = 120902;
        nArray2[329] = 110724;
        nArray2[330] = 110722;
        nArray2[331] = 73888;
        nArray2[332] = 102488;
        nArray2[333] = 116782;
        nArray2[334] = 90528;
        nArray2[335] = 73872;
        nArray2[336] = 102476;
        nArray2[337] = 90512;
        nArray2[338] = 110796;
        nArray2[339] = 102470;
        nArray2[340] = 90504;
        nArray2[341] = 73860;
        nArray2[342] = 90500;
        nArray2[343] = 73858;
        nArray2[344] = 73944;
        nArray2[345] = 90584;
        nArray2[346] = 90572;
        nArray2[347] = 90566;
        nArray2[348] = 120876;
        nArray2[349] = 120870;
        nArray2[350] = 110658;
        nArray2[351] = 102444;
        nArray2[352] = 73800;
        nArray2[353] = 90312;
        nArray2[354] = 90308;
        nArray2[355] = 90306;
        nArray2[356] = 101056;
        nArray2[357] = 116080;
        nArray2[358] = 123580;
        nArray2[359] = 100960;
        nArray2[360] = 116024;
        nArray2[361] = 70720;
        nArray2[362] = 100912;
        nArray2[363] = 115996;
        nArray2[364] = 70688;
        nArray2[365] = 100888;
        nArray2[366] = 70672;
        nArray2[367] = 70664;
        nArray2[368] = 71360;
        nArray2[369] = 101232;
        nArray2[370] = 116156;
        nArray2[371] = 71264;
        nArray2[372] = 101176;
        nArray2[373] = 116126;
        nArray2[374] = 71216;
        nArray2[375] = 101148;
        nArray2[376] = 71192;
        nArray2[377] = 71180;
        nArray2[378] = 71536;
        nArray2[379] = 101308;
        nArray2[380] = 71480;
        nArray2[381] = 101278;
        nArray2[382] = 71452;
        nArray2[383] = 71612;
        nArray2[384] = 71582;
        nArray2[385] = 118112;
        nArray2[386] = 124600;
        nArray2[387] = 127838;
        nArray2[388] = 105024;
        nArray2[389] = 118064;
        nArray2[390] = 124572;
        nArray2[391] = 104992;
        nArray2[392] = 118040;
        nArray2[393] = 124558;
        nArray2[394] = 104976;
        nArray2[395] = 118028;
        nArray2[396] = 104968;
        nArray2[397] = 118022;
        nArray2[398] = 100704;
        nArray2[399] = 115896;
        nArray2[400] = 123486;
        nArray2[401] = 105312;
        nArray2[402] = 100656;
        nArray2[403] = 115868;
        nArray2[404] = 79424;
        nArray2[405] = 70176;
        nArray2[406] = 118172;
        nArray2[407] = 115854;
        nArray2[408] = 79392;
        nArray2[409] = 105240;
        nArray2[410] = 100620;
        nArray2[411] = 79376;
        nArray2[412] = 70152;
        nArray2[413] = 79368;
        nArray2[414] = 70496;
        nArray2[415] = 100792;
        nArray2[416] = 115934;
        nArray2[417] = 79712;
        nArray2[418] = 70448;
        nArray2[419] = 118238;
        nArray2[420] = 79664;
        nArray2[421] = 105372;
        nArray2[422] = 100750;
        nArray2[423] = 79640;
        nArray2[424] = 70412;
        nArray2[425] = 79628;
        nArray2[426] = 70584;
        nArray2[427] = 100830;
        nArray2[428] = 79800;
        nArray2[429] = 70556;
        nArray2[430] = 79772;
        nArray2[431] = 70542;
        nArray2[432] = 70622;
        nArray2[433] = 79838;
        nArray2[434] = 122176;
        nArray2[435] = 126640;
        nArray2[436] = 128860;
        nArray2[437] = 122144;
        nArray2[438] = 126616;
        nArray2[439] = 128846;
        nArray2[440] = 122128;
        nArray2[441] = 126604;
        nArray2[442] = 122120;
        nArray2[443] = 126598;
        nArray2[444] = 122116;
        nArray2[445] = 104768;
        nArray2[446] = 117936;
        nArray2[447] = 124508;
        nArray2[448] = 113472;
        nArray2[449] = 104736;
        nArray2[450] = 126684;
        nArray2[451] = 124494;
        nArray2[452] = 113440;
        nArray2[453] = 122264;
        nArray2[454] = 126670;
        nArray2[455] = 113424;
        nArray2[456] = 104712;
        nArray2[457] = 117894;
        nArray2[458] = 113416;
        nArray2[459] = 122246;
        nArray2[460] = 104706;
        nArray2[461] = 69952;
        nArray2[462] = 100528;
        nArray2[463] = 115804;
        nArray2[464] = 78656;
        nArray2[465] = 69920;
        nArray2[466] = 100504;
        nArray2[467] = 115790;
        nArray2[468] = 96064;
        nArray2[469] = 78624;
        nArray2[470] = 104856;
        nArray2[471] = 117966;
        nArray2[472] = 96032;
        nArray2[473] = 113560;
        nArray2[474] = 122318;
        nArray2[475] = 100486;
        nArray2[476] = 96016;
        nArray2[477] = 78600;
        nArray2[478] = 104838;
        nArray2[479] = 96008;
        nArray2[480] = 69890;
        nArray2[481] = 70064;
        nArray2[482] = 100572;
        nArray2[483] = 78768;
        nArray2[484] = 70040;
        nArray2[485] = 100558;
        nArray2[486] = 96176;
        nArray2[487] = 78744;
        nArray2[488] = 104910;
        nArray2[489] = 96152;
        nArray2[490] = 113614;
        nArray2[491] = 70022;
        nArray2[492] = 78726;
        nArray2[493] = 70108;
        nArray2[494] = 78812;
        nArray2[495] = 70094;
        nArray2[496] = 96220;
        nArray2[497] = 78798;
        nArray2[498] = 122016;
        nArray2[499] = 126552;
        nArray2[500] = 128814;
        nArray2[501] = 122000;
        nArray2[502] = 126540;
        nArray2[503] = 121992;
        nArray2[504] = 126534;
        nArray2[505] = 121988;
        nArray2[506] = 121986;
        nArray2[507] = 104608;
        nArray2[508] = 117848;
        nArray2[509] = 124462;
        nArray2[510] = 113056;
        nArray2[511] = 104592;
        nArray2[512] = 126574;
        nArray2[513] = 113040;
        nArray2[514] = 122060;
        nArray2[515] = 117830;
        nArray2[516] = 113032;
        nArray2[517] = 104580;
        nArray2[518] = 113028;
        nArray2[519] = 104578;
        nArray2[520] = 113026;
        nArray2[521] = 69792;
        nArray2[522] = 100440;
        nArray2[523] = 115758;
        nArray2[524] = 78240;
        nArray2[525] = 69776;
        nArray2[526] = 100428;
        nArray2[527] = 95136;
        nArray2[528] = 78224;
        nArray2[529] = 104652;
        nArray2[530] = 100422;
        nArray2[531] = 95120;
        nArray2[532] = 113100;
        nArray2[533] = 69764;
        nArray2[534] = 95112;
        nArray2[535] = 78212;
        nArray2[536] = 69762;
        nArray2[537] = 78210;
        nArray2[538] = 69848;
        nArray2[539] = 100462;
        nArray2[540] = 78296;
        nArray2[541] = 69836;
        nArray2[542] = 95192;
        nArray2[543] = 78284;
        nArray2[544] = 69830;
        nArray2[545] = 95180;
        nArray2[546] = 78278;
        nArray2[547] = 69870;
        nArray2[548] = 95214;
        nArray2[549] = 121936;
        nArray2[550] = 126508;
        nArray2[551] = 121928;
        nArray2[552] = 126502;
        nArray2[553] = 121924;
        nArray2[554] = 121922;
        nArray2[555] = 104528;
        nArray2[556] = 117804;
        nArray2[557] = 112848;
        nArray2[558] = 104520;
        nArray2[559] = 117798;
        nArray2[560] = 112840;
        nArray2[561] = 121958;
        nArray2[562] = 112836;
        nArray2[563] = 104514;
        nArray2[564] = 112834;
        nArray2[565] = 69712;
        nArray2[566] = 100396;
        nArray2[567] = 78032;
        nArray2[568] = 69704;
        nArray2[569] = 100390;
        nArray2[570] = 94672;
        nArray2[571] = 78024;
        nArray2[572] = 104550;
        nArray2[573] = 94664;
        nArray2[574] = 112870;
        nArray2[575] = 69698;
        nArray2[576] = 94660;
        nArray2[577] = 78018;
        nArray2[578] = 94658;
        nArray2[579] = 78060;
        nArray2[580] = 94700;
        nArray2[581] = 94694;
        nArray2[582] = 126486;
        nArray2[583] = 121890;
        nArray2[584] = 117782;
        nArray2[585] = 104484;
        nArray2[586] = 104482;
        nArray2[587] = 69672;
        nArray2[588] = 77928;
        nArray2[589] = 94440;
        nArray2[590] = 69666;
        nArray2[591] = 77922;
        nArray2[592] = 99680;
        nArray2[593] = 68160;
        nArray2[594] = 99632;
        nArray2[595] = 68128;
        nArray2[596] = 99608;
        nArray2[597] = 115342;
        nArray2[598] = 68112;
        nArray2[599] = 99596;
        nArray2[600] = 68104;
        nArray2[601] = 99590;
        nArray2[602] = 68448;
        nArray2[603] = 99768;
        nArray2[604] = 115422;
        nArray2[605] = 68400;
        nArray2[606] = 99740;
        nArray2[607] = 68376;
        nArray2[608] = 99726;
        nArray2[609] = 68364;
        nArray2[610] = 68358;
        nArray2[611] = 68536;
        nArray2[612] = 99806;
        nArray2[613] = 68508;
        nArray2[614] = 68494;
        nArray2[615] = 68574;
        nArray2[616] = 101696;
        nArray2[617] = 116400;
        nArray2[618] = 123740;
        nArray2[619] = 101664;
        nArray2[620] = 116376;
        nArray2[621] = 101648;
        nArray2[622] = 116364;
        nArray2[623] = 101640;
        nArray2[624] = 116358;
        nArray2[625] = 101636;
        nArray2[626] = 67904;
        nArray2[627] = 99504;
        nArray2[628] = 115292;
        nArray2[629] = 72512;
        nArray2[630] = 67872;
        nArray2[631] = 116444;
        nArray2[632] = 115278;
        nArray2[633] = 72480;
        nArray2[634] = 101784;
        nArray2[635] = 116430;
        nArray2[636] = 72464;
        nArray2[637] = 67848;
        nArray2[638] = 99462;
        nArray2[639] = 72456;
        nArray2[640] = 101766;
        nArray2[641] = 67842;
        nArray2[642] = 68016;
        nArray2[643] = 99548;
        nArray2[644] = 72624;
        nArray2[645] = 67992;
        nArray2[646] = 99534;
        nArray2[647] = 72600;
        nArray2[648] = 101838;
        nArray2[649] = 72588;
        nArray2[650] = 67974;
        nArray2[651] = 68060;
        nArray2[652] = 72668;
        nArray2[653] = 68046;
        nArray2[654] = 72654;
        nArray2[655] = 118432;
        nArray2[656] = 124760;
        nArray2[657] = 127918;
        nArray2[658] = 118416;
        nArray2[659] = 124748;
        nArray2[660] = 118408;
        nArray2[661] = 124742;
        nArray2[662] = 118404;
        nArray2[663] = 118402;
        nArray2[664] = 101536;
        nArray2[665] = 116312;
        nArray2[666] = 105888;
        nArray2[667] = 101520;
        nArray2[668] = 116300;
        nArray2[669] = 105872;
        nArray2[670] = 118476;
        nArray2[671] = 116294;
        nArray2[672] = 105864;
        nArray2[673] = 101508;
        nArray2[674] = 105860;
        nArray2[675] = 101506;
        nArray2[676] = 105858;
        nArray2[677] = 67744;
        nArray2[678] = 99416;
        nArray2[679] = 72096;
        nArray2[680] = 67728;
        nArray2[681] = 116334;
        nArray2[682] = 80800;
        nArray2[683] = 72080;
        nArray2[684] = 101580;
        nArray2[685] = 99398;
        nArray2[686] = 80784;
        nArray2[687] = 105932;
        nArray2[688] = 67716;
        nArray2[689] = 80776;
        nArray2[690] = 72068;
        nArray2[691] = 67714;
        nArray2[692] = 72066;
        nArray2[693] = 67800;
        nArray2[694] = 99438;
        nArray2[695] = 72152;
        nArray2[696] = 67788;
        nArray2[697] = 80856;
        nArray2[698] = 72140;
        nArray2[699] = 67782;
        nArray2[700] = 80844;
        nArray2[701] = 72134;
        nArray2[702] = 67822;
        nArray2[703] = 72174;
        nArray2[704] = 80878;
        nArray2[705] = 126800;
        nArray2[706] = 128940;
        nArray2[707] = 126792;
        nArray2[708] = 128934;
        nArray2[709] = 126788;
        nArray2[710] = 126786;
        nArray2[711] = 118352;
        nArray2[712] = 124716;
        nArray2[713] = 122576;
        nArray2[714] = 126828;
        nArray2[715] = 124710;
        nArray2[716] = 122568;
        nArray2[717] = 126822;
        nArray2[718] = 122564;
        nArray2[719] = 118338;
        nArray2[720] = 122562;
        nArray2[721] = 101456;
        nArray2[722] = 116268;
        nArray2[723] = 105680;
        nArray2[724] = 101448;
        nArray2[725] = 116262;
        nArray2[726] = 114128;
        nArray2[727] = 105672;
        nArray2[728] = 118374;
        nArray2[729] = 114120;
        nArray2[730] = 122598;
        nArray2[731] = 101442;
        nArray2[732] = 114116;
        nArray2[733] = 105666;
        nArray2[734] = 114114;
        nArray2[735] = 67664;
        nArray2[736] = 99372;
        nArray2[737] = 71888;
        nArray2[738] = 67656;
        nArray2[739] = 99366;
        nArray2[740] = 80336;
        nArray2[741] = 71880;
        nArray2[742] = 101478;
        nArray2[743] = 97232;
        nArray2[744] = 80328;
        nArray2[745] = 105702;
        nArray2[746] = 67650;
        nArray2[747] = 97224;
        nArray2[748] = 114150;
        nArray2[749] = 71874;
        nArray2[750] = 97220;
        nArray2[751] = 67692;
        nArray2[752] = 71916;
        nArray2[753] = 67686;
        nArray2[754] = 80364;
        nArray2[755] = 71910;
        nArray2[756] = 97260;
        nArray2[757] = 80358;
        nArray2[758] = 97254;
        nArray2[759] = 126760;
        nArray2[760] = 128918;
        nArray2[761] = 126756;
        nArray2[762] = 126754;
        nArray2[763] = 118312;
        nArray2[764] = 124694;
        nArray2[765] = 122472;
        nArray2[766] = 126774;
        nArray2[767] = 122468;
        nArray2[768] = 118306;
        nArray2[769] = 122466;
        nArray2[770] = 101416;
        nArray2[771] = 116246;
        nArray2[772] = 105576;
        nArray2[773] = 101412;
        nArray2[774] = 113896;
        nArray2[775] = 105572;
        nArray2[776] = 101410;
        nArray2[777] = 113892;
        nArray2[778] = 105570;
        nArray2[779] = 113890;
        nArray2[780] = 67624;
        nArray2[781] = 99350;
        nArray2[782] = 71784;
        nArray2[783] = 101430;
        nArray2[784] = 80104;
        nArray2[785] = 71780;
        nArray2[786] = 67618;
        nArray2[787] = 96744;
        nArray2[788] = 80100;
        nArray2[789] = 71778;
        nArray2[790] = 96740;
        nArray2[791] = 80098;
        nArray2[792] = 96738;
        nArray2[793] = 71798;
        nArray2[794] = 96758;
        nArray2[795] = 126738;
        nArray2[796] = 122420;
        nArray2[797] = 122418;
        nArray2[798] = 105524;
        nArray2[799] = 113780;
        nArray2[800] = 113778;
        nArray2[801] = 71732;
        nArray2[802] = 79988;
        nArray2[803] = 96500;
        nArray2[804] = 96498;
        nArray2[805] = 66880;
        nArray2[806] = 66848;
        nArray2[807] = 98968;
        nArray2[808] = 66832;
        nArray2[809] = 66824;
        nArray2[810] = 66820;
        nArray2[811] = 66992;
        nArray2[812] = 66968;
        nArray2[813] = 66956;
        nArray2[814] = 66950;
        nArray2[815] = 67036;
        nArray2[816] = 67022;
        nArray2[817] = 100000;
        nArray2[818] = 99984;
        nArray2[819] = 115532;
        nArray2[820] = 99976;
        nArray2[821] = 115526;
        nArray2[822] = 99972;
        nArray2[823] = 99970;
        nArray2[824] = 66720;
        nArray2[825] = 98904;
        nArray2[826] = 69024;
        nArray2[827] = 100056;
        nArray2[828] = 98892;
        nArray2[829] = 69008;
        nArray2[830] = 100044;
        nArray2[831] = 69000;
        nArray2[832] = 100038;
        nArray2[833] = 68996;
        nArray2[834] = 66690;
        nArray2[835] = 68994;
        nArray2[836] = 66776;
        nArray2[837] = 98926;
        nArray2[838] = 69080;
        nArray2[839] = 100078;
        nArray2[840] = 69068;
        nArray2[841] = 66758;
        nArray2[842] = 69062;
        nArray2[843] = 66798;
        nArray2[844] = 69102;
        nArray2[845] = 116560;
        nArray2[846] = 116552;
        nArray2[847] = 116548;
        nArray2[848] = 116546;
        nArray2[849] = 99920;
        nArray2[850] = 102096;
        nArray2[851] = 116588;
        nArray2[852] = 115494;
        nArray2[853] = 102088;
        nArray2[854] = 116582;
        nArray2[855] = 102084;
        nArray2[856] = 99906;
        nArray2[857] = 102082;
        nArray2[858] = 66640;
        nArray2[859] = 68816;
        nArray2[860] = 66632;
        nArray2[861] = 98854;
        nArray2[862] = 73168;
        nArray2[863] = 68808;
        nArray2[864] = 66628;
        nArray2[865] = 73160;
        nArray2[866] = 68804;
        nArray2[867] = 66626;
        nArray2[868] = 73156;
        nArray2[869] = 68802;
        nArray2[870] = 66668;
        nArray2[871] = 68844;
        nArray2[872] = 66662;
        nArray2[873] = 73196;
        nArray2[874] = 68838;
        nArray2[875] = 73190;
        nArray2[876] = 124840;
        nArray2[877] = 124836;
        nArray2[878] = 124834;
        nArray2[879] = 116520;
        nArray2[880] = 118632;
        nArray2[881] = 124854;
        nArray2[882] = 118628;
        nArray2[883] = 116514;
        nArray2[884] = 118626;
        nArray2[885] = 99880;
        nArray2[886] = 115478;
        nArray2[887] = 101992;
        nArray2[888] = 116534;
        nArray2[889] = 106216;
        nArray2[890] = 101988;
        nArray2[891] = 99874;
        nArray2[892] = 106212;
        nArray2[893] = 101986;
        nArray2[894] = 106210;
        nArray2[895] = 66600;
        nArray2[896] = 98838;
        nArray2[897] = 68712;
        nArray2[898] = 99894;
        nArray2[899] = 72936;
        nArray2[900] = 68708;
        nArray2[901] = 66594;
        nArray2[902] = 81384;
        nArray2[903] = 72932;
        nArray2[904] = 68706;
        nArray2[905] = 81380;
        nArray2[906] = 72930;
        nArray2[907] = 66614;
        nArray2[908] = 68726;
        nArray2[909] = 72950;
        nArray2[910] = 81398;
        nArray2[911] = 128980;
        nArray2[912] = 128978;
        nArray2[913] = 124820;
        nArray2[914] = 126900;
        nArray2[915] = 124818;
        nArray2[916] = 126898;
        nArray2[917] = 116500;
        nArray2[918] = 118580;
        nArray2[919] = 116498;
        nArray2[920] = 122740;
        nArray2[921] = 118578;
        nArray2[922] = 122738;
        nArray2[923] = 99860;
        nArray2[924] = 101940;
        nArray2[925] = 99858;
        nArray2[926] = 106100;
        nArray2[927] = 101938;
        nArray2[928] = 114420;
        nArrayArray[0] = nArray2;
        int[] nArray3 = new int[929];
        nArray2 = nArray3;
        nArray3[0] = 128352;
        nArray2[1] = 129720;
        nArray2[2] = 125504;
        nArray2[3] = 128304;
        nArray2[4] = 129692;
        nArray2[5] = 125472;
        nArray2[6] = 128280;
        nArray2[7] = 129678;
        nArray2[8] = 125456;
        nArray2[9] = 128268;
        nArray2[10] = 125448;
        nArray2[11] = 128262;
        nArray2[12] = 125444;
        nArray2[13] = 125792;
        nArray2[14] = 128440;
        nArray2[15] = 129758;
        nArray2[16] = 120384;
        nArray2[17] = 125744;
        nArray2[18] = 128412;
        nArray2[19] = 120352;
        nArray2[20] = 125720;
        nArray2[21] = 128398;
        nArray2[22] = 120336;
        nArray2[23] = 125708;
        nArray2[24] = 120328;
        nArray2[25] = 125702;
        nArray2[26] = 120324;
        nArray2[27] = 120672;
        nArray2[28] = 125880;
        nArray2[29] = 128478;
        nArray2[30] = 110144;
        nArray2[31] = 120624;
        nArray2[32] = 125852;
        nArray2[33] = 110112;
        nArray2[34] = 120600;
        nArray2[35] = 125838;
        nArray2[36] = 110096;
        nArray2[37] = 120588;
        nArray2[38] = 110088;
        nArray2[39] = 120582;
        nArray2[40] = 110084;
        nArray2[41] = 110432;
        nArray2[42] = 120760;
        nArray2[43] = 125918;
        nArray2[44] = 89664;
        nArray2[45] = 110384;
        nArray2[46] = 120732;
        nArray2[47] = 89632;
        nArray2[48] = 110360;
        nArray2[49] = 120718;
        nArray2[50] = 89616;
        nArray2[51] = 110348;
        nArray2[52] = 89608;
        nArray2[53] = 110342;
        nArray2[54] = 89952;
        nArray2[55] = 110520;
        nArray2[56] = 120798;
        nArray2[57] = 89904;
        nArray2[58] = 110492;
        nArray2[59] = 89880;
        nArray2[60] = 110478;
        nArray2[61] = 89868;
        nArray2[62] = 90040;
        nArray2[63] = 110558;
        nArray2[64] = 90012;
        nArray2[65] = 89998;
        nArray2[66] = 125248;
        nArray2[67] = 128176;
        nArray2[68] = 129628;
        nArray2[69] = 125216;
        nArray2[70] = 128152;
        nArray2[71] = 129614;
        nArray2[72] = 125200;
        nArray2[73] = 128140;
        nArray2[74] = 125192;
        nArray2[75] = 128134;
        nArray2[76] = 125188;
        nArray2[77] = 125186;
        nArray2[78] = 119616;
        nArray2[79] = 125360;
        nArray2[80] = 128220;
        nArray2[81] = 119584;
        nArray2[82] = 125336;
        nArray2[83] = 128206;
        nArray2[84] = 119568;
        nArray2[85] = 125324;
        nArray2[86] = 119560;
        nArray2[87] = 125318;
        nArray2[88] = 119556;
        nArray2[89] = 119554;
        nArray2[90] = 108352;
        nArray2[91] = 119728;
        nArray2[92] = 125404;
        nArray2[93] = 108320;
        nArray2[94] = 119704;
        nArray2[95] = 125390;
        nArray2[96] = 108304;
        nArray2[97] = 119692;
        nArray2[98] = 108296;
        nArray2[99] = 119686;
        nArray2[100] = 108292;
        nArray2[101] = 108290;
        nArray2[102] = 85824;
        nArray2[103] = 108464;
        nArray2[104] = 119772;
        nArray2[105] = 85792;
        nArray2[106] = 108440;
        nArray2[107] = 119758;
        nArray2[108] = 85776;
        nArray2[109] = 108428;
        nArray2[110] = 85768;
        nArray2[111] = 108422;
        nArray2[112] = 85764;
        nArray2[113] = 85936;
        nArray2[114] = 108508;
        nArray2[115] = 85912;
        nArray2[116] = 108494;
        nArray2[117] = 85900;
        nArray2[118] = 85894;
        nArray2[119] = 85980;
        nArray2[120] = 85966;
        nArray2[121] = 125088;
        nArray2[122] = 128088;
        nArray2[123] = 129582;
        nArray2[124] = 125072;
        nArray2[125] = 128076;
        nArray2[126] = 125064;
        nArray2[127] = 128070;
        nArray2[128] = 125060;
        nArray2[129] = 125058;
        nArray2[130] = 119200;
        nArray2[131] = 125144;
        nArray2[132] = 128110;
        nArray2[133] = 119184;
        nArray2[134] = 125132;
        nArray2[135] = 119176;
        nArray2[136] = 125126;
        nArray2[137] = 119172;
        nArray2[138] = 119170;
        nArray2[139] = 107424;
        nArray2[140] = 119256;
        nArray2[141] = 125166;
        nArray2[142] = 107408;
        nArray2[143] = 119244;
        nArray2[144] = 107400;
        nArray2[145] = 119238;
        nArray2[146] = 107396;
        nArray2[147] = 107394;
        nArray2[148] = 83872;
        nArray2[149] = 107480;
        nArray2[150] = 119278;
        nArray2[151] = 83856;
        nArray2[152] = 107468;
        nArray2[153] = 83848;
        nArray2[154] = 107462;
        nArray2[155] = 83844;
        nArray2[156] = 83842;
        nArray2[157] = 83928;
        nArray2[158] = 107502;
        nArray2[159] = 83916;
        nArray2[160] = 83910;
        nArray2[161] = 83950;
        nArray2[162] = 125008;
        nArray2[163] = 128044;
        nArray2[164] = 125000;
        nArray2[165] = 128038;
        nArray2[166] = 124996;
        nArray2[167] = 124994;
        nArray2[168] = 118992;
        nArray2[169] = 125036;
        nArray2[170] = 118984;
        nArray2[171] = 125030;
        nArray2[172] = 118980;
        nArray2[173] = 118978;
        nArray2[174] = 106960;
        nArray2[175] = 119020;
        nArray2[176] = 106952;
        nArray2[177] = 119014;
        nArray2[178] = 106948;
        nArray2[179] = 106946;
        nArray2[180] = 82896;
        nArray2[181] = 106988;
        nArray2[182] = 82888;
        nArray2[183] = 106982;
        nArray2[184] = 82884;
        nArray2[185] = 82882;
        nArray2[186] = 82924;
        nArray2[187] = 82918;
        nArray2[188] = 124968;
        nArray2[189] = 128022;
        nArray2[190] = 124964;
        nArray2[191] = 124962;
        nArray2[192] = 118888;
        nArray2[193] = 124982;
        nArray2[194] = 118884;
        nArray2[195] = 118882;
        nArray2[196] = 106728;
        nArray2[197] = 118902;
        nArray2[198] = 106724;
        nArray2[199] = 106722;
        nArray2[200] = 82408;
        nArray2[201] = 106742;
        nArray2[202] = 82404;
        nArray2[203] = 82402;
        nArray2[204] = 124948;
        nArray2[205] = 124946;
        nArray2[206] = 118836;
        nArray2[207] = 118834;
        nArray2[208] = 106612;
        nArray2[209] = 106610;
        nArray2[210] = 124224;
        nArray2[211] = 127664;
        nArray2[212] = 129372;
        nArray2[213] = 124192;
        nArray2[214] = 127640;
        nArray2[215] = 129358;
        nArray2[216] = 124176;
        nArray2[217] = 127628;
        nArray2[218] = 124168;
        nArray2[219] = 127622;
        nArray2[220] = 124164;
        nArray2[221] = 124162;
        nArray2[222] = 117568;
        nArray2[223] = 124336;
        nArray2[224] = 127708;
        nArray2[225] = 117536;
        nArray2[226] = 124312;
        nArray2[227] = 127694;
        nArray2[228] = 117520;
        nArray2[229] = 124300;
        nArray2[230] = 117512;
        nArray2[231] = 124294;
        nArray2[232] = 117508;
        nArray2[233] = 117506;
        nArray2[234] = 104256;
        nArray2[235] = 117680;
        nArray2[236] = 124380;
        nArray2[237] = 104224;
        nArray2[238] = 117656;
        nArray2[239] = 124366;
        nArray2[240] = 104208;
        nArray2[241] = 117644;
        nArray2[242] = 104200;
        nArray2[243] = 117638;
        nArray2[244] = 104196;
        nArray2[245] = 104194;
        nArray2[246] = 77632;
        nArray2[247] = 104368;
        nArray2[248] = 117724;
        nArray2[249] = 77600;
        nArray2[250] = 104344;
        nArray2[251] = 117710;
        nArray2[252] = 77584;
        nArray2[253] = 104332;
        nArray2[254] = 77576;
        nArray2[255] = 104326;
        nArray2[256] = 77572;
        nArray2[257] = 77744;
        nArray2[258] = 104412;
        nArray2[259] = 77720;
        nArray2[260] = 104398;
        nArray2[261] = 77708;
        nArray2[262] = 77702;
        nArray2[263] = 77788;
        nArray2[264] = 77774;
        nArray2[265] = 128672;
        nArray2[266] = 129880;
        nArray2[267] = 93168;
        nArray2[268] = 128656;
        nArray2[269] = 129868;
        nArray2[270] = 92664;
        nArray2[271] = 128648;
        nArray2[272] = 129862;
        nArray2[273] = 92412;
        nArray2[274] = 128644;
        nArray2[275] = 128642;
        nArray2[276] = 124064;
        nArray2[277] = 127576;
        nArray2[278] = 129326;
        nArray2[279] = 126368;
        nArray2[280] = 124048;
        nArray2[281] = 129902;
        nArray2[282] = 126352;
        nArray2[283] = 128716;
        nArray2[284] = 127558;
        nArray2[285] = 126344;
        nArray2[286] = 124036;
        nArray2[287] = 126340;
        nArray2[288] = 124034;
        nArray2[289] = 126338;
        nArray2[290] = 117152;
        nArray2[291] = 124120;
        nArray2[292] = 127598;
        nArray2[293] = 121760;
        nArray2[294] = 117136;
        nArray2[295] = 124108;
        nArray2[296] = 121744;
        nArray2[297] = 126412;
        nArray2[298] = 124102;
        nArray2[299] = 121736;
        nArray2[300] = 117124;
        nArray2[301] = 121732;
        nArray2[302] = 117122;
        nArray2[303] = 121730;
        nArray2[304] = 103328;
        nArray2[305] = 117208;
        nArray2[306] = 124142;
        nArray2[307] = 112544;
        nArray2[308] = 103312;
        nArray2[309] = 117196;
        nArray2[310] = 112528;
        nArray2[311] = 121804;
        nArray2[312] = 117190;
        nArray2[313] = 112520;
        nArray2[314] = 103300;
        nArray2[315] = 112516;
        nArray2[316] = 103298;
        nArray2[317] = 112514;
        nArray2[318] = 75680;
        nArray2[319] = 103384;
        nArray2[320] = 117230;
        nArray2[321] = 94112;
        nArray2[322] = 75664;
        nArray2[323] = 103372;
        nArray2[324] = 94096;
        nArray2[325] = 112588;
        nArray2[326] = 103366;
        nArray2[327] = 94088;
        nArray2[328] = 75652;
        nArray2[329] = 94084;
        nArray2[330] = 75650;
        nArray2[331] = 75736;
        nArray2[332] = 103406;
        nArray2[333] = 94168;
        nArray2[334] = 75724;
        nArray2[335] = 94156;
        nArray2[336] = 75718;
        nArray2[337] = 94150;
        nArray2[338] = 75758;
        nArray2[339] = 128592;
        nArray2[340] = 129836;
        nArray2[341] = 91640;
        nArray2[342] = 128584;
        nArray2[343] = 129830;
        nArray2[344] = 91388;
        nArray2[345] = 128580;
        nArray2[346] = 91262;
        nArray2[347] = 128578;
        nArray2[348] = 123984;
        nArray2[349] = 127532;
        nArray2[350] = 126160;
        nArray2[351] = 123976;
        nArray2[352] = 127526;
        nArray2[353] = 126152;
        nArray2[354] = 128614;
        nArray2[355] = 126148;
        nArray2[356] = 123970;
        nArray2[357] = 126146;
        nArray2[358] = 116944;
        nArray2[359] = 124012;
        nArray2[360] = 121296;
        nArray2[361] = 116936;
        nArray2[362] = 124006;
        nArray2[363] = 121288;
        nArray2[364] = 126182;
        nArray2[365] = 121284;
        nArray2[366] = 116930;
        nArray2[367] = 121282;
        nArray2[368] = 102864;
        nArray2[369] = 116972;
        nArray2[370] = 111568;
        nArray2[371] = 102856;
        nArray2[372] = 116966;
        nArray2[373] = 111560;
        nArray2[374] = 121318;
        nArray2[375] = 111556;
        nArray2[376] = 102850;
        nArray2[377] = 111554;
        nArray2[378] = 74704;
        nArray2[379] = 102892;
        nArray2[380] = 92112;
        nArray2[381] = 74696;
        nArray2[382] = 102886;
        nArray2[383] = 92104;
        nArray2[384] = 111590;
        nArray2[385] = 92100;
        nArray2[386] = 74690;
        nArray2[387] = 92098;
        nArray2[388] = 74732;
        nArray2[389] = 92140;
        nArray2[390] = 74726;
        nArray2[391] = 92134;
        nArray2[392] = 128552;
        nArray2[393] = 129814;
        nArray2[394] = 90876;
        nArray2[395] = 128548;
        nArray2[396] = 90750;
        nArray2[397] = 128546;
        nArray2[398] = 123944;
        nArray2[399] = 127510;
        nArray2[400] = 126056;
        nArray2[401] = 128566;
        nArray2[402] = 126052;
        nArray2[403] = 123938;
        nArray2[404] = 126050;
        nArray2[405] = 116840;
        nArray2[406] = 123958;
        nArray2[407] = 121064;
        nArray2[408] = 116836;
        nArray2[409] = 121060;
        nArray2[410] = 116834;
        nArray2[411] = 121058;
        nArray2[412] = 102632;
        nArray2[413] = 116854;
        nArray2[414] = 111080;
        nArray2[415] = 121078;
        nArray2[416] = 111076;
        nArray2[417] = 102626;
        nArray2[418] = 111074;
        nArray2[419] = 74216;
        nArray2[420] = 102646;
        nArray2[421] = 91112;
        nArray2[422] = 74212;
        nArray2[423] = 91108;
        nArray2[424] = 74210;
        nArray2[425] = 91106;
        nArray2[426] = 74230;
        nArray2[427] = 91126;
        nArray2[428] = 128532;
        nArray2[429] = 90494;
        nArray2[430] = 128530;
        nArray2[431] = 123924;
        nArray2[432] = 126004;
        nArray2[433] = 123922;
        nArray2[434] = 126002;
        nArray2[435] = 116788;
        nArray2[436] = 120948;
        nArray2[437] = 116786;
        nArray2[438] = 120946;
        nArray2[439] = 102516;
        nArray2[440] = 110836;
        nArray2[441] = 102514;
        nArray2[442] = 110834;
        nArray2[443] = 73972;
        nArray2[444] = 90612;
        nArray2[445] = 73970;
        nArray2[446] = 90610;
        nArray2[447] = 128522;
        nArray2[448] = 123914;
        nArray2[449] = 125978;
        nArray2[450] = 116762;
        nArray2[451] = 120890;
        nArray2[452] = 102458;
        nArray2[453] = 110714;
        nArray2[454] = 123552;
        nArray2[455] = 127320;
        nArray2[456] = 129198;
        nArray2[457] = 123536;
        nArray2[458] = 127308;
        nArray2[459] = 123528;
        nArray2[460] = 127302;
        nArray2[461] = 123524;
        nArray2[462] = 123522;
        nArray2[463] = 116128;
        nArray2[464] = 123608;
        nArray2[465] = 127342;
        nArray2[466] = 116112;
        nArray2[467] = 123596;
        nArray2[468] = 116104;
        nArray2[469] = 123590;
        nArray2[470] = 116100;
        nArray2[471] = 116098;
        nArray2[472] = 101280;
        nArray2[473] = 116184;
        nArray2[474] = 123630;
        nArray2[475] = 101264;
        nArray2[476] = 116172;
        nArray2[477] = 101256;
        nArray2[478] = 116166;
        nArray2[479] = 101252;
        nArray2[480] = 101250;
        nArray2[481] = 71584;
        nArray2[482] = 101336;
        nArray2[483] = 116206;
        nArray2[484] = 71568;
        nArray2[485] = 101324;
        nArray2[486] = 71560;
        nArray2[487] = 101318;
        nArray2[488] = 71556;
        nArray2[489] = 71554;
        nArray2[490] = 71640;
        nArray2[491] = 101358;
        nArray2[492] = 71628;
        nArray2[493] = 71622;
        nArray2[494] = 71662;
        nArray2[495] = 127824;
        nArray2[496] = 129452;
        nArray2[497] = 79352;
        nArray2[498] = 127816;
        nArray2[499] = 129446;
        nArray2[500] = 79100;
        nArray2[501] = 127812;
        nArray2[502] = 78974;
        nArray2[503] = 127810;
        nArray2[504] = 123472;
        nArray2[505] = 127276;
        nArray2[506] = 124624;
        nArray2[507] = 123464;
        nArray2[508] = 127270;
        nArray2[509] = 124616;
        nArray2[510] = 127846;
        nArray2[511] = 124612;
        nArray2[512] = 123458;
        nArray2[513] = 124610;
        nArray2[514] = 115920;
        nArray2[515] = 123500;
        nArray2[516] = 118224;
        nArray2[517] = 115912;
        nArray2[518] = 123494;
        nArray2[519] = 118216;
        nArray2[520] = 124646;
        nArray2[521] = 118212;
        nArray2[522] = 115906;
        nArray2[523] = 118210;
        nArray2[524] = 100816;
        nArray2[525] = 115948;
        nArray2[526] = 105424;
        nArray2[527] = 100808;
        nArray2[528] = 115942;
        nArray2[529] = 105416;
        nArray2[530] = 118246;
        nArray2[531] = 105412;
        nArray2[532] = 100802;
        nArray2[533] = 105410;
        nArray2[534] = 70608;
        nArray2[535] = 100844;
        nArray2[536] = 79824;
        nArray2[537] = 70600;
        nArray2[538] = 100838;
        nArray2[539] = 79816;
        nArray2[540] = 105446;
        nArray2[541] = 79812;
        nArray2[542] = 70594;
        nArray2[543] = 79810;
        nArray2[544] = 70636;
        nArray2[545] = 79852;
        nArray2[546] = 70630;
        nArray2[547] = 79846;
        nArray2[548] = 129960;
        nArray2[549] = 95728;
        nArray2[550] = 113404;
        nArray2[551] = 129956;
        nArray2[552] = 95480;
        nArray2[553] = 113278;
        nArray2[554] = 129954;
        nArray2[555] = 95356;
        nArray2[556] = 95294;
        nArray2[557] = 127784;
        nArray2[558] = 129430;
        nArray2[559] = 78588;
        nArray2[560] = 128872;
        nArray2[561] = 129974;
        nArray2[562] = 95996;
        nArray2[563] = 78462;
        nArray2[564] = 128868;
        nArray2[565] = 127778;
        nArray2[566] = 95870;
        nArray2[567] = 128866;
        nArray2[568] = 123432;
        nArray2[569] = 127254;
        nArray2[570] = 124520;
        nArray2[571] = 123428;
        nArray2[572] = 126696;
        nArray2[573] = 128886;
        nArray2[574] = 123426;
        nArray2[575] = 126692;
        nArray2[576] = 124514;
        nArray2[577] = 126690;
        nArray2[578] = 115816;
        nArray2[579] = 123446;
        nArray2[580] = 117992;
        nArray2[581] = 115812;
        nArray2[582] = 122344;
        nArray2[583] = 117988;
        nArray2[584] = 115810;
        nArray2[585] = 122340;
        nArray2[586] = 117986;
        nArray2[587] = 122338;
        nArray2[588] = 100584;
        nArray2[589] = 115830;
        nArray2[590] = 104936;
        nArray2[591] = 100580;
        nArray2[592] = 113640;
        nArray2[593] = 104932;
        nArray2[594] = 100578;
        nArray2[595] = 113636;
        nArray2[596] = 104930;
        nArray2[597] = 113634;
        nArray2[598] = 70120;
        nArray2[599] = 100598;
        nArray2[600] = 78824;
        nArray2[601] = 70116;
        nArray2[602] = 96232;
        nArray2[603] = 78820;
        nArray2[604] = 70114;
        nArray2[605] = 96228;
        nArray2[606] = 78818;
        nArray2[607] = 96226;
        nArray2[608] = 70134;
        nArray2[609] = 78838;
        nArray2[610] = 129940;
        nArray2[611] = 94968;
        nArray2[612] = 113022;
        nArray2[613] = 129938;
        nArray2[614] = 94844;
        nArray2[615] = 94782;
        nArray2[616] = 127764;
        nArray2[617] = 78206;
        nArray2[618] = 128820;
        nArray2[619] = 127762;
        nArray2[620] = 95102;
        nArray2[621] = 128818;
        nArray2[622] = 123412;
        nArray2[623] = 124468;
        nArray2[624] = 123410;
        nArray2[625] = 126580;
        nArray2[626] = 124466;
        nArray2[627] = 126578;
        nArray2[628] = 115764;
        nArray2[629] = 117876;
        nArray2[630] = 115762;
        nArray2[631] = 122100;
        nArray2[632] = 117874;
        nArray2[633] = 122098;
        nArray2[634] = 100468;
        nArray2[635] = 104692;
        nArray2[636] = 100466;
        nArray2[637] = 113140;
        nArray2[638] = 104690;
        nArray2[639] = 113138;
        nArray2[640] = 69876;
        nArray2[641] = 78324;
        nArray2[642] = 69874;
        nArray2[643] = 95220;
        nArray2[644] = 78322;
        nArray2[645] = 95218;
        nArray2[646] = 129930;
        nArray2[647] = 94588;
        nArray2[648] = 94526;
        nArray2[649] = 127754;
        nArray2[650] = 128794;
        nArray2[651] = 123402;
        nArray2[652] = 124442;
        nArray2[653] = 126522;
        nArray2[654] = 115738;
        nArray2[655] = 117818;
        nArray2[656] = 121978;
        nArray2[657] = 100410;
        nArray2[658] = 104570;
        nArray2[659] = 112890;
        nArray2[660] = 69754;
        nArray2[661] = 78074;
        nArray2[662] = 94714;
        nArray2[663] = 94398;
        nArray2[664] = 123216;
        nArray2[665] = 127148;
        nArray2[666] = 123208;
        nArray2[667] = 127142;
        nArray2[668] = 123204;
        nArray2[669] = 123202;
        nArray2[670] = 115408;
        nArray2[671] = 123244;
        nArray2[672] = 115400;
        nArray2[673] = 123238;
        nArray2[674] = 115396;
        nArray2[675] = 115394;
        nArray2[676] = 99792;
        nArray2[677] = 115436;
        nArray2[678] = 99784;
        nArray2[679] = 115430;
        nArray2[680] = 99780;
        nArray2[681] = 99778;
        nArray2[682] = 68560;
        nArray2[683] = 99820;
        nArray2[684] = 68552;
        nArray2[685] = 99814;
        nArray2[686] = 68548;
        nArray2[687] = 68546;
        nArray2[688] = 68588;
        nArray2[689] = 68582;
        nArray2[690] = 127400;
        nArray2[691] = 129238;
        nArray2[692] = 72444;
        nArray2[693] = 127396;
        nArray2[694] = 72318;
        nArray2[695] = 127394;
        nArray2[696] = 123176;
        nArray2[697] = 127126;
        nArray2[698] = 123752;
        nArray2[699] = 123172;
        nArray2[700] = 123748;
        nArray2[701] = 123170;
        nArray2[702] = 123746;
        nArray2[703] = 115304;
        nArray2[704] = 123190;
        nArray2[705] = 116456;
        nArray2[706] = 115300;
        nArray2[707] = 116452;
        nArray2[708] = 115298;
        nArray2[709] = 116450;
        nArray2[710] = 99560;
        nArray2[711] = 115318;
        nArray2[712] = 101864;
        nArray2[713] = 99556;
        nArray2[714] = 101860;
        nArray2[715] = 99554;
        nArray2[716] = 101858;
        nArray2[717] = 68072;
        nArray2[718] = 99574;
        nArray2[719] = 72680;
        nArray2[720] = 68068;
        nArray2[721] = 72676;
        nArray2[722] = 68066;
        nArray2[723] = 72674;
        nArray2[724] = 68086;
        nArray2[725] = 72694;
        nArray2[726] = 129492;
        nArray2[727] = 80632;
        nArray2[728] = 105854;
        nArray2[729] = 129490;
        nArray2[730] = 80508;
        nArray2[731] = 80446;
        nArray2[732] = 127380;
        nArray2[733] = 72062;
        nArray2[734] = 127924;
        nArray2[735] = 127378;
        nArray2[736] = 80766;
        nArray2[737] = 127922;
        nArray2[738] = 123156;
        nArray2[739] = 123700;
        nArray2[740] = 123154;
        nArray2[741] = 124788;
        nArray2[742] = 123698;
        nArray2[743] = 124786;
        nArray2[744] = 115252;
        nArray2[745] = 116340;
        nArray2[746] = 115250;
        nArray2[747] = 118516;
        nArray2[748] = 116338;
        nArray2[749] = 118514;
        nArray2[750] = 99444;
        nArray2[751] = 101620;
        nArray2[752] = 99442;
        nArray2[753] = 105972;
        nArray2[754] = 101618;
        nArray2[755] = 105970;
        nArray2[756] = 67828;
        nArray2[757] = 72180;
        nArray2[758] = 67826;
        nArray2[759] = 80884;
        nArray2[760] = 72178;
        nArray2[761] = 80882;
        nArray2[762] = 97008;
        nArray2[763] = 114044;
        nArray2[764] = 96888;
        nArray2[765] = 113982;
        nArray2[766] = 96828;
        nArray2[767] = 96798;
        nArray2[768] = 129482;
        nArray2[769] = 80252;
        nArray2[770] = 130010;
        nArray2[771] = 97148;
        nArray2[772] = 80190;
        nArray2[773] = 97086;
        nArray2[774] = 127370;
        nArray2[775] = 127898;
        nArray2[776] = 128954;
        nArray2[777] = 123146;
        nArray2[778] = 123674;
        nArray2[779] = 124730;
        nArray2[780] = 126842;
        nArray2[781] = 115226;
        nArray2[782] = 116282;
        nArray2[783] = 118394;
        nArray2[784] = 122618;
        nArray2[785] = 99386;
        nArray2[786] = 101498;
        nArray2[787] = 105722;
        nArray2[788] = 114170;
        nArray2[789] = 67706;
        nArray2[790] = 71930;
        nArray2[791] = 80378;
        nArray2[792] = 96632;
        nArray2[793] = 113854;
        nArray2[794] = 96572;
        nArray2[795] = 96542;
        nArray2[796] = 80062;
        nArray2[797] = 96702;
        nArray2[798] = 96444;
        nArray2[799] = 96414;
        nArray2[800] = 96350;
        nArray2[801] = 123048;
        nArray2[802] = 123044;
        nArray2[803] = 123042;
        nArray2[804] = 115048;
        nArray2[805] = 123062;
        nArray2[806] = 115044;
        nArray2[807] = 115042;
        nArray2[808] = 99048;
        nArray2[809] = 115062;
        nArray2[810] = 99044;
        nArray2[811] = 99042;
        nArray2[812] = 67048;
        nArray2[813] = 99062;
        nArray2[814] = 67044;
        nArray2[815] = 67042;
        nArray2[816] = 67062;
        nArray2[817] = 127188;
        nArray2[818] = 68990;
        nArray2[819] = 127186;
        nArray2[820] = 123028;
        nArray2[821] = 123316;
        nArray2[822] = 123026;
        nArray2[823] = 123314;
        nArray2[824] = 114996;
        nArray2[825] = 115572;
        nArray2[826] = 114994;
        nArray2[827] = 115570;
        nArray2[828] = 98932;
        nArray2[829] = 100084;
        nArray2[830] = 98930;
        nArray2[831] = 100082;
        nArray2[832] = 66804;
        nArray2[833] = 69108;
        nArray2[834] = 66802;
        nArray2[835] = 69106;
        nArray2[836] = 129258;
        nArray2[837] = 73084;
        nArray2[838] = 73022;
        nArray2[839] = 127178;
        nArray2[840] = 127450;
        nArray2[841] = 123018;
        nArray2[842] = 123290;
        nArray2[843] = 123834;
        nArray2[844] = 114970;
        nArray2[845] = 115514;
        nArray2[846] = 116602;
        nArray2[847] = 98874;
        nArray2[848] = 99962;
        nArray2[849] = 102138;
        nArray2[850] = 66682;
        nArray2[851] = 68858;
        nArray2[852] = 73210;
        nArray2[853] = 81272;
        nArray2[854] = 106174;
        nArray2[855] = 81212;
        nArray2[856] = 81182;
        nArray2[857] = 72894;
        nArray2[858] = 81342;
        nArray2[859] = 97648;
        nArray2[860] = 114364;
        nArray2[861] = 97592;
        nArray2[862] = 114334;
        nArray2[863] = 97564;
        nArray2[864] = 97550;
        nArray2[865] = 81084;
        nArray2[866] = 97724;
        nArray2[867] = 81054;
        nArray2[868] = 97694;
        nArray2[869] = 97464;
        nArray2[870] = 114270;
        nArray2[871] = 97436;
        nArray2[872] = 97422;
        nArray2[873] = 80990;
        nArray2[874] = 97502;
        nArray2[875] = 97372;
        nArray2[876] = 97358;
        nArray2[877] = 97326;
        nArray2[878] = 114868;
        nArray2[879] = 114866;
        nArray2[880] = 98676;
        nArray2[881] = 98674;
        nArray2[882] = 66292;
        nArray2[883] = 66290;
        nArray2[884] = 123098;
        nArray2[885] = 114842;
        nArray2[886] = 115130;
        nArray2[887] = 98618;
        nArray2[888] = 99194;
        nArray2[889] = 66170;
        nArray2[890] = 67322;
        nArray2[891] = 69310;
        nArray2[892] = 73404;
        nArray2[893] = 73374;
        nArray2[894] = 81592;
        nArray2[895] = 106334;
        nArray2[896] = 81564;
        nArray2[897] = 81550;
        nArray2[898] = 73310;
        nArray2[899] = 81630;
        nArray2[900] = 97968;
        nArray2[901] = 114524;
        nArray2[902] = 97944;
        nArray2[903] = 114510;
        nArray2[904] = 97932;
        nArray2[905] = 97926;
        nArray2[906] = 81500;
        nArray2[907] = 98012;
        nArray2[908] = 81486;
        nArray2[909] = 97998;
        nArray2[910] = 97880;
        nArray2[911] = 114478;
        nArray2[912] = 97868;
        nArray2[913] = 97862;
        nArray2[914] = 81454;
        nArray2[915] = 97902;
        nArray2[916] = 97836;
        nArray2[917] = 97830;
        nArray2[918] = 69470;
        nArray2[919] = 73564;
        nArray2[920] = 73550;
        nArray2[921] = 81752;
        nArray2[922] = 106414;
        nArray2[923] = 81740;
        nArray2[924] = 81734;
        nArray2[925] = 73518;
        nArray2[926] = 81774;
        nArray2[927] = 81708;
        nArray2[928] = 81702;
        nArrayArray[1] = nArray2;
        int[] nArray4 = new int[929];
        nArray2 = nArray4;
        nArray4[0] = 109536;
        nArray2[1] = 120312;
        nArray2[2] = 86976;
        nArray2[3] = 109040;
        nArray2[4] = 120060;
        nArray2[5] = 86496;
        nArray2[6] = 108792;
        nArray2[7] = 119934;
        nArray2[8] = 86256;
        nArray2[9] = 108668;
        nArray2[10] = 86136;
        nArray2[11] = 129744;
        nArray2[12] = 89056;
        nArray2[13] = 110072;
        nArray2[14] = 129736;
        nArray2[15] = 88560;
        nArray2[16] = 109820;
        nArray2[17] = 129732;
        nArray2[18] = 88312;
        nArray2[19] = 109694;
        nArray2[20] = 129730;
        nArray2[21] = 88188;
        nArray2[22] = 128464;
        nArray2[23] = 129772;
        nArray2[24] = 89592;
        nArray2[25] = 128456;
        nArray2[26] = 129766;
        nArray2[27] = 89340;
        nArray2[28] = 128452;
        nArray2[29] = 89214;
        nArray2[30] = 128450;
        nArray2[31] = 125904;
        nArray2[32] = 128492;
        nArray2[33] = 125896;
        nArray2[34] = 128486;
        nArray2[35] = 125892;
        nArray2[36] = 125890;
        nArray2[37] = 120784;
        nArray2[38] = 125932;
        nArray2[39] = 120776;
        nArray2[40] = 125926;
        nArray2[41] = 120772;
        nArray2[42] = 120770;
        nArray2[43] = 110544;
        nArray2[44] = 120812;
        nArray2[45] = 110536;
        nArray2[46] = 120806;
        nArray2[47] = 110532;
        nArray2[48] = 84928;
        nArray2[49] = 108016;
        nArray2[50] = 119548;
        nArray2[51] = 84448;
        nArray2[52] = 107768;
        nArray2[53] = 119422;
        nArray2[54] = 84208;
        nArray2[55] = 107644;
        nArray2[56] = 84088;
        nArray2[57] = 107582;
        nArray2[58] = 84028;
        nArray2[59] = 129640;
        nArray2[60] = 85488;
        nArray2[61] = 108284;
        nArray2[62] = 129636;
        nArray2[63] = 85240;
        nArray2[64] = 108158;
        nArray2[65] = 129634;
        nArray2[66] = 85116;
        nArray2[67] = 85054;
        nArray2[68] = 128232;
        nArray2[69] = 129654;
        nArray2[70] = 85756;
        nArray2[71] = 128228;
        nArray2[72] = 85630;
        nArray2[73] = 128226;
        nArray2[74] = 125416;
        nArray2[75] = 128246;
        nArray2[76] = 125412;
        nArray2[77] = 125410;
        nArray2[78] = 119784;
        nArray2[79] = 125430;
        nArray2[80] = 119780;
        nArray2[81] = 119778;
        nArray2[82] = 108520;
        nArray2[83] = 119798;
        nArray2[84] = 108516;
        nArray2[85] = 108514;
        nArray2[86] = 83424;
        nArray2[87] = 107256;
        nArray2[88] = 119166;
        nArray2[89] = 83184;
        nArray2[90] = 107132;
        nArray2[91] = 83064;
        nArray2[92] = 107070;
        nArray2[93] = 83004;
        nArray2[94] = 82974;
        nArray2[95] = 129588;
        nArray2[96] = 83704;
        nArray2[97] = 107390;
        nArray2[98] = 129586;
        nArray2[99] = 83580;
        nArray2[100] = 83518;
        nArray2[101] = 128116;
        nArray2[102] = 83838;
        nArray2[103] = 128114;
        nArray2[104] = 125172;
        nArray2[105] = 125170;
        nArray2[106] = 119284;
        nArray2[107] = 119282;
        nArray2[108] = 107508;
        nArray2[109] = 107506;
        nArray2[110] = 82672;
        nArray2[111] = 106876;
        nArray2[112] = 82552;
        nArray2[113] = 106814;
        nArray2[114] = 82492;
        nArray2[115] = 82462;
        nArray2[116] = 129562;
        nArray2[117] = 82812;
        nArray2[118] = 82750;
        nArray2[119] = 128058;
        nArray2[120] = 125050;
        nArray2[121] = 119034;
        nArray2[122] = 82296;
        nArray2[123] = 106686;
        nArray2[124] = 82236;
        nArray2[125] = 82206;
        nArray2[126] = 82366;
        nArray2[127] = 82108;
        nArray2[128] = 82078;
        nArray2[129] = 76736;
        nArray2[130] = 103920;
        nArray2[131] = 117500;
        nArray2[132] = 76256;
        nArray2[133] = 103672;
        nArray2[134] = 117374;
        nArray2[135] = 76016;
        nArray2[136] = 103548;
        nArray2[137] = 75896;
        nArray2[138] = 103486;
        nArray2[139] = 75836;
        nArray2[140] = 129384;
        nArray2[141] = 77296;
        nArray2[142] = 104188;
        nArray2[143] = 129380;
        nArray2[144] = 77048;
        nArray2[145] = 104062;
        nArray2[146] = 129378;
        nArray2[147] = 76924;
        nArray2[148] = 76862;
        nArray2[149] = 127720;
        nArray2[150] = 129398;
        nArray2[151] = 77564;
        nArray2[152] = 127716;
        nArray2[153] = 77438;
        nArray2[154] = 127714;
        nArray2[155] = 124392;
        nArray2[156] = 127734;
        nArray2[157] = 124388;
        nArray2[158] = 124386;
        nArray2[159] = 117736;
        nArray2[160] = 124406;
        nArray2[161] = 117732;
        nArray2[162] = 117730;
        nArray2[163] = 104424;
        nArray2[164] = 117750;
        nArray2[165] = 104420;
        nArray2[166] = 104418;
        nArray2[167] = 112096;
        nArray2[168] = 121592;
        nArray2[169] = 126334;
        nArray2[170] = 92608;
        nArray2[171] = 111856;
        nArray2[172] = 121468;
        nArray2[173] = 92384;
        nArray2[174] = 111736;
        nArray2[175] = 121406;
        nArray2[176] = 92272;
        nArray2[177] = 111676;
        nArray2[178] = 92216;
        nArray2[179] = 111646;
        nArray2[180] = 92188;
        nArray2[181] = 75232;
        nArray2[182] = 103160;
        nArray2[183] = 117118;
        nArray2[184] = 93664;
        nArray2[185] = 74992;
        nArray2[186] = 103036;
        nArray2[187] = 93424;
        nArray2[188] = 112252;
        nArray2[189] = 102974;
        nArray2[190] = 93304;
        nArray2[191] = 74812;
        nArray2[192] = 93244;
        nArray2[193] = 74782;
        nArray2[194] = 93214;
        nArray2[195] = 129332;
        nArray2[196] = 75512;
        nArray2[197] = 103294;
        nArray2[198] = 129908;
        nArray2[199] = 129330;
        nArray2[200] = 93944;
        nArray2[201] = 75388;
        nArray2[202] = 129906;
        nArray2[203] = 93820;
        nArray2[204] = 75326;
        nArray2[205] = 93758;
        nArray2[206] = 127604;
        nArray2[207] = 75646;
        nArray2[208] = 128756;
        nArray2[209] = 127602;
        nArray2[210] = 94078;
        nArray2[211] = 128754;
        nArray2[212] = 124148;
        nArray2[213] = 126452;
        nArray2[214] = 124146;
        nArray2[215] = 126450;
        nArray2[216] = 117236;
        nArray2[217] = 121844;
        nArray2[218] = 117234;
        nArray2[219] = 121842;
        nArray2[220] = 103412;
        nArray2[221] = 103410;
        nArray2[222] = 91584;
        nArray2[223] = 111344;
        nArray2[224] = 121212;
        nArray2[225] = 91360;
        nArray2[226] = 111224;
        nArray2[227] = 121150;
        nArray2[228] = 91248;
        nArray2[229] = 111164;
        nArray2[230] = 91192;
        nArray2[231] = 111134;
        nArray2[232] = 91164;
        nArray2[233] = 91150;
        nArray2[234] = 74480;
        nArray2[235] = 102780;
        nArray2[236] = 91888;
        nArray2[237] = 74360;
        nArray2[238] = 102718;
        nArray2[239] = 91768;
        nArray2[240] = 111422;
        nArray2[241] = 91708;
        nArray2[242] = 74270;
        nArray2[243] = 91678;
        nArray2[244] = 129306;
        nArray2[245] = 74620;
        nArray2[246] = 129850;
        nArray2[247] = 92028;
        nArray2[248] = 74558;
        nArray2[249] = 91966;
        nArray2[250] = 127546;
        nArray2[251] = 128634;
        nArray2[252] = 124026;
        nArray2[253] = 126202;
        nArray2[254] = 116986;
        nArray2[255] = 121338;
        nArray2[256] = 102906;
        nArray2[257] = 90848;
        nArray2[258] = 110968;
        nArray2[259] = 121022;
        nArray2[260] = 90736;
        nArray2[261] = 110908;
        nArray2[262] = 90680;
        nArray2[263] = 110878;
        nArray2[264] = 90652;
        nArray2[265] = 90638;
        nArray2[266] = 74104;
        nArray2[267] = 102590;
        nArray2[268] = 91000;
        nArray2[269] = 74044;
        nArray2[270] = 90940;
        nArray2[271] = 74014;
        nArray2[272] = 90910;
        nArray2[273] = 74174;
        nArray2[274] = 91070;
        nArray2[275] = 90480;
        nArray2[276] = 110780;
        nArray2[277] = 90424;
        nArray2[278] = 110750;
        nArray2[279] = 90396;
        nArray2[280] = 90382;
        nArray2[281] = 73916;
        nArray2[282] = 90556;
        nArray2[283] = 73886;
        nArray2[284] = 90526;
        nArray2[285] = 90296;
        nArray2[286] = 110686;
        nArray2[287] = 90268;
        nArray2[288] = 90254;
        nArray2[289] = 73822;
        nArray2[290] = 90334;
        nArray2[291] = 90204;
        nArray2[292] = 90190;
        nArray2[293] = 71136;
        nArray2[294] = 101112;
        nArray2[295] = 116094;
        nArray2[296] = 70896;
        nArray2[297] = 100988;
        nArray2[298] = 70776;
        nArray2[299] = 100926;
        nArray2[300] = 70716;
        nArray2[301] = 70686;
        nArray2[302] = 129204;
        nArray2[303] = 71416;
        nArray2[304] = 101246;
        nArray2[305] = 129202;
        nArray2[306] = 71292;
        nArray2[307] = 71230;
        nArray2[308] = 127348;
        nArray2[309] = 71550;
        nArray2[310] = 127346;
        nArray2[311] = 123636;
        nArray2[312] = 123634;
        nArray2[313] = 116212;
        nArray2[314] = 116210;
        nArray2[315] = 101364;
        nArray2[316] = 101362;
        nArray2[317] = 79296;
        nArray2[318] = 105200;
        nArray2[319] = 118140;
        nArray2[320] = 79072;
        nArray2[321] = 105080;
        nArray2[322] = 118078;
        nArray2[323] = 78960;
        nArray2[324] = 105020;
        nArray2[325] = 78904;
        nArray2[326] = 104990;
        nArray2[327] = 78876;
        nArray2[328] = 78862;
        nArray2[329] = 70384;
        nArray2[330] = 100732;
        nArray2[331] = 79600;
        nArray2[332] = 70264;
        nArray2[333] = 100670;
        nArray2[334] = 79480;
        nArray2[335] = 105278;
        nArray2[336] = 79420;
        nArray2[337] = 70174;
        nArray2[338] = 79390;
        nArray2[339] = 129178;
        nArray2[340] = 70524;
        nArray2[341] = 129466;
        nArray2[342] = 79740;
        nArray2[343] = 70462;
        nArray2[344] = 79678;
        nArray2[345] = 127290;
        nArray2[346] = 127866;
        nArray2[347] = 123514;
        nArray2[348] = 124666;
        nArray2[349] = 115962;
        nArray2[350] = 118266;
        nArray2[351] = 100858;
        nArray2[352] = 113376;
        nArray2[353] = 122232;
        nArray2[354] = 126654;
        nArray2[355] = 95424;
        nArray2[356] = 113264;
        nArray2[357] = 122172;
        nArray2[358] = 95328;
        nArray2[359] = 113208;
        nArray2[360] = 122142;
        nArray2[361] = 95280;
        nArray2[362] = 113180;
        nArray2[363] = 95256;
        nArray2[364] = 113166;
        nArray2[365] = 95244;
        nArray2[366] = 78560;
        nArray2[367] = 104824;
        nArray2[368] = 117950;
        nArray2[369] = 95968;
        nArray2[370] = 78448;
        nArray2[371] = 104764;
        nArray2[372] = 95856;
        nArray2[373] = 113468;
        nArray2[374] = 104734;
        nArray2[375] = 95800;
        nArray2[376] = 78364;
        nArray2[377] = 95772;
        nArray2[378] = 78350;
        nArray2[379] = 95758;
        nArray2[380] = 70008;
        nArray2[381] = 100542;
        nArray2[382] = 78712;
        nArray2[383] = 69948;
        nArray2[384] = 96120;
        nArray2[385] = 78652;
        nArray2[386] = 69918;
        nArray2[387] = 96060;
        nArray2[388] = 78622;
        nArray2[389] = 96030;
        nArray2[390] = 70078;
        nArray2[391] = 78782;
        nArray2[392] = 96190;
        nArray2[393] = 94912;
        nArray2[394] = 113008;
        nArray2[395] = 122044;
        nArray2[396] = 94816;
        nArray2[397] = 112952;
        nArray2[398] = 122014;
        nArray2[399] = 94768;
        nArray2[400] = 112924;
        nArray2[401] = 94744;
        nArray2[402] = 112910;
        nArray2[403] = 94732;
        nArray2[404] = 94726;
        nArray2[405] = 78192;
        nArray2[406] = 104636;
        nArray2[407] = 95088;
        nArray2[408] = 78136;
        nArray2[409] = 104606;
        nArray2[410] = 95032;
        nArray2[411] = 113054;
        nArray2[412] = 95004;
        nArray2[413] = 78094;
        nArray2[414] = 94990;
        nArray2[415] = 69820;
        nArray2[416] = 78268;
        nArray2[417] = 69790;
        nArray2[418] = 95164;
        nArray2[419] = 78238;
        nArray2[420] = 95134;
        nArray2[421] = 94560;
        nArray2[422] = 112824;
        nArray2[423] = 121950;
        nArray2[424] = 94512;
        nArray2[425] = 112796;
        nArray2[426] = 94488;
        nArray2[427] = 112782;
        nArray2[428] = 94476;
        nArray2[429] = 94470;
        nArray2[430] = 78008;
        nArray2[431] = 104542;
        nArray2[432] = 94648;
        nArray2[433] = 77980;
        nArray2[434] = 94620;
        nArray2[435] = 77966;
        nArray2[436] = 94606;
        nArray2[437] = 69726;
        nArray2[438] = 78046;
        nArray2[439] = 94686;
        nArray2[440] = 94384;
        nArray2[441] = 112732;
        nArray2[442] = 94360;
        nArray2[443] = 112718;
        nArray2[444] = 94348;
        nArray2[445] = 94342;
        nArray2[446] = 77916;
        nArray2[447] = 94428;
        nArray2[448] = 77902;
        nArray2[449] = 94414;
        nArray2[450] = 94296;
        nArray2[451] = 112686;
        nArray2[452] = 94284;
        nArray2[453] = 94278;
        nArray2[454] = 77870;
        nArray2[455] = 94318;
        nArray2[456] = 94252;
        nArray2[457] = 94246;
        nArray2[458] = 68336;
        nArray2[459] = 99708;
        nArray2[460] = 68216;
        nArray2[461] = 99646;
        nArray2[462] = 68156;
        nArray2[463] = 68126;
        nArray2[464] = 68476;
        nArray2[465] = 68414;
        nArray2[466] = 127162;
        nArray2[467] = 123258;
        nArray2[468] = 115450;
        nArray2[469] = 99834;
        nArray2[470] = 72416;
        nArray2[471] = 101752;
        nArray2[472] = 116414;
        nArray2[473] = 72304;
        nArray2[474] = 101692;
        nArray2[475] = 72248;
        nArray2[476] = 101662;
        nArray2[477] = 72220;
        nArray2[478] = 72206;
        nArray2[479] = 67960;
        nArray2[480] = 99518;
        nArray2[481] = 72568;
        nArray2[482] = 67900;
        nArray2[483] = 72508;
        nArray2[484] = 67870;
        nArray2[485] = 72478;
        nArray2[486] = 68030;
        nArray2[487] = 72638;
        nArray2[488] = 80576;
        nArray2[489] = 105840;
        nArray2[490] = 118460;
        nArray2[491] = 80480;
        nArray2[492] = 105784;
        nArray2[493] = 118430;
        nArray2[494] = 80432;
        nArray2[495] = 105756;
        nArray2[496] = 80408;
        nArray2[497] = 105742;
        nArray2[498] = 80396;
        nArray2[499] = 80390;
        nArray2[500] = 72048;
        nArray2[501] = 101564;
        nArray2[502] = 80752;
        nArray2[503] = 71992;
        nArray2[504] = 101534;
        nArray2[505] = 80696;
        nArray2[506] = 71964;
        nArray2[507] = 80668;
        nArray2[508] = 71950;
        nArray2[509] = 80654;
        nArray2[510] = 67772;
        nArray2[511] = 72124;
        nArray2[512] = 67742;
        nArray2[513] = 80828;
        nArray2[514] = 72094;
        nArray2[515] = 80798;
        nArray2[516] = 114016;
        nArray2[517] = 122552;
        nArray2[518] = 126814;
        nArray2[519] = 96832;
        nArray2[520] = 113968;
        nArray2[521] = 122524;
        nArray2[522] = 96800;
        nArray2[523] = 113944;
        nArray2[524] = 122510;
        nArray2[525] = 96784;
        nArray2[526] = 113932;
        nArray2[527] = 96776;
        nArray2[528] = 113926;
        nArray2[529] = 96772;
        nArray2[530] = 80224;
        nArray2[531] = 105656;
        nArray2[532] = 118366;
        nArray2[533] = 97120;
        nArray2[534] = 80176;
        nArray2[535] = 105628;
        nArray2[536] = 97072;
        nArray2[537] = 114076;
        nArray2[538] = 105614;
        nArray2[539] = 97048;
        nArray2[540] = 80140;
        nArray2[541] = 97036;
        nArray2[542] = 80134;
        nArray2[543] = 97030;
        nArray2[544] = 71864;
        nArray2[545] = 101470;
        nArray2[546] = 80312;
        nArray2[547] = 71836;
        nArray2[548] = 97208;
        nArray2[549] = 80284;
        nArray2[550] = 71822;
        nArray2[551] = 97180;
        nArray2[552] = 80270;
        nArray2[553] = 97166;
        nArray2[554] = 67678;
        nArray2[555] = 71902;
        nArray2[556] = 80350;
        nArray2[557] = 97246;
        nArray2[558] = 96576;
        nArray2[559] = 113840;
        nArray2[560] = 122460;
        nArray2[561] = 96544;
        nArray2[562] = 113816;
        nArray2[563] = 122446;
        nArray2[564] = 96528;
        nArray2[565] = 113804;
        nArray2[566] = 96520;
        nArray2[567] = 113798;
        nArray2[568] = 96516;
        nArray2[569] = 96514;
        nArray2[570] = 80048;
        nArray2[571] = 105564;
        nArray2[572] = 96688;
        nArray2[573] = 80024;
        nArray2[574] = 105550;
        nArray2[575] = 96664;
        nArray2[576] = 113870;
        nArray2[577] = 96652;
        nArray2[578] = 80006;
        nArray2[579] = 96646;
        nArray2[580] = 71772;
        nArray2[581] = 80092;
        nArray2[582] = 71758;
        nArray2[583] = 96732;
        nArray2[584] = 80078;
        nArray2[585] = 96718;
        nArray2[586] = 96416;
        nArray2[587] = 113752;
        nArray2[588] = 122414;
        nArray2[589] = 96400;
        nArray2[590] = 113740;
        nArray2[591] = 96392;
        nArray2[592] = 113734;
        nArray2[593] = 96388;
        nArray2[594] = 96386;
        nArray2[595] = 79960;
        nArray2[596] = 105518;
        nArray2[597] = 96472;
        nArray2[598] = 79948;
        nArray2[599] = 96460;
        nArray2[600] = 79942;
        nArray2[601] = 96454;
        nArray2[602] = 71726;
        nArray2[603] = 79982;
        nArray2[604] = 96494;
        nArray2[605] = 96336;
        nArray2[606] = 113708;
        nArray2[607] = 96328;
        nArray2[608] = 113702;
        nArray2[609] = 96324;
        nArray2[610] = 96322;
        nArray2[611] = 79916;
        nArray2[612] = 96364;
        nArray2[613] = 79910;
        nArray2[614] = 96358;
        nArray2[615] = 96296;
        nArray2[616] = 113686;
        nArray2[617] = 96292;
        nArray2[618] = 96290;
        nArray2[619] = 79894;
        nArray2[620] = 96310;
        nArray2[621] = 66936;
        nArray2[622] = 99006;
        nArray2[623] = 66876;
        nArray2[624] = 66846;
        nArray2[625] = 67006;
        nArray2[626] = 68976;
        nArray2[627] = 100028;
        nArray2[628] = 68920;
        nArray2[629] = 99998;
        nArray2[630] = 68892;
        nArray2[631] = 68878;
        nArray2[632] = 66748;
        nArray2[633] = 69052;
        nArray2[634] = 66718;
        nArray2[635] = 69022;
        nArray2[636] = 73056;
        nArray2[637] = 102072;
        nArray2[638] = 116574;
        nArray2[639] = 73008;
        nArray2[640] = 102044;
        nArray2[641] = 72984;
        nArray2[642] = 102030;
        nArray2[643] = 72972;
        nArray2[644] = 72966;
        nArray2[645] = 68792;
        nArray2[646] = 99934;
        nArray2[647] = 73144;
        nArray2[648] = 68764;
        nArray2[649] = 73116;
        nArray2[650] = 68750;
        nArray2[651] = 73102;
        nArray2[652] = 66654;
        nArray2[653] = 68830;
        nArray2[654] = 73182;
        nArray2[655] = 81216;
        nArray2[656] = 106160;
        nArray2[657] = 118620;
        nArray2[658] = 81184;
        nArray2[659] = 106136;
        nArray2[660] = 118606;
        nArray2[661] = 81168;
        nArray2[662] = 106124;
        nArray2[663] = 81160;
        nArray2[664] = 106118;
        nArray2[665] = 81156;
        nArray2[666] = 81154;
        nArray2[667] = 72880;
        nArray2[668] = 101980;
        nArray2[669] = 81328;
        nArray2[670] = 72856;
        nArray2[671] = 101966;
        nArray2[672] = 81304;
        nArray2[673] = 106190;
        nArray2[674] = 81292;
        nArray2[675] = 72838;
        nArray2[676] = 81286;
        nArray2[677] = 68700;
        nArray2[678] = 72924;
        nArray2[679] = 68686;
        nArray2[680] = 81372;
        nArray2[681] = 72910;
        nArray2[682] = 81358;
        nArray2[683] = 114336;
        nArray2[684] = 122712;
        nArray2[685] = 126894;
        nArray2[686] = 114320;
        nArray2[687] = 122700;
        nArray2[688] = 114312;
        nArray2[689] = 122694;
        nArray2[690] = 114308;
        nArray2[691] = 114306;
        nArray2[692] = 81056;
        nArray2[693] = 106072;
        nArray2[694] = 118574;
        nArray2[695] = 97696;
        nArray2[696] = 81040;
        nArray2[697] = 106060;
        nArray2[698] = 97680;
        nArray2[699] = 114380;
        nArray2[700] = 106054;
        nArray2[701] = 97672;
        nArray2[702] = 81028;
        nArray2[703] = 97668;
        nArray2[704] = 81026;
        nArray2[705] = 97666;
        nArray2[706] = 72792;
        nArray2[707] = 101934;
        nArray2[708] = 81112;
        nArray2[709] = 72780;
        nArray2[710] = 97752;
        nArray2[711] = 81100;
        nArray2[712] = 72774;
        nArray2[713] = 97740;
        nArray2[714] = 81094;
        nArray2[715] = 97734;
        nArray2[716] = 68654;
        nArray2[717] = 72814;
        nArray2[718] = 81134;
        nArray2[719] = 97774;
        nArray2[720] = 114256;
        nArray2[721] = 122668;
        nArray2[722] = 114248;
        nArray2[723] = 122662;
        nArray2[724] = 114244;
        nArray2[725] = 114242;
        nArray2[726] = 80976;
        nArray2[727] = 106028;
        nArray2[728] = 97488;
        nArray2[729] = 80968;
        nArray2[730] = 106022;
        nArray2[731] = 97480;
        nArray2[732] = 114278;
        nArray2[733] = 97476;
        nArray2[734] = 80962;
        nArray2[735] = 97474;
        nArray2[736] = 72748;
        nArray2[737] = 81004;
        nArray2[738] = 72742;
        nArray2[739] = 97516;
        nArray2[740] = 80998;
        nArray2[741] = 97510;
        nArray2[742] = 114216;
        nArray2[743] = 122646;
        nArray2[744] = 114212;
        nArray2[745] = 114210;
        nArray2[746] = 80936;
        nArray2[747] = 106006;
        nArray2[748] = 97384;
        nArray2[749] = 80932;
        nArray2[750] = 97380;
        nArray2[751] = 80930;
        nArray2[752] = 97378;
        nArray2[753] = 72726;
        nArray2[754] = 80950;
        nArray2[755] = 97398;
        nArray2[756] = 114196;
        nArray2[757] = 114194;
        nArray2[758] = 80916;
        nArray2[759] = 97332;
        nArray2[760] = 80914;
        nArray2[761] = 97330;
        nArray2[762] = 66236;
        nArray2[763] = 66206;
        nArray2[764] = 67256;
        nArray2[765] = 99166;
        nArray2[766] = 67228;
        nArray2[767] = 67214;
        nArray2[768] = 66142;
        nArray2[769] = 67294;
        nArray2[770] = 69296;
        nArray2[771] = 100188;
        nArray2[772] = 69272;
        nArray2[773] = 100174;
        nArray2[774] = 69260;
        nArray2[775] = 69254;
        nArray2[776] = 67164;
        nArray2[777] = 69340;
        nArray2[778] = 67150;
        nArray2[779] = 69326;
        nArray2[780] = 73376;
        nArray2[781] = 102232;
        nArray2[782] = 116654;
        nArray2[783] = 73360;
        nArray2[784] = 102220;
        nArray2[785] = 73352;
        nArray2[786] = 102214;
        nArray2[787] = 73348;
        nArray2[788] = 73346;
        nArray2[789] = 69208;
        nArray2[790] = 100142;
        nArray2[791] = 73432;
        nArray2[792] = 102254;
        nArray2[793] = 73420;
        nArray2[794] = 69190;
        nArray2[795] = 73414;
        nArray2[796] = 67118;
        nArray2[797] = 69230;
        nArray2[798] = 73454;
        nArray2[799] = 106320;
        nArray2[800] = 118700;
        nArray2[801] = 106312;
        nArray2[802] = 118694;
        nArray2[803] = 106308;
        nArray2[804] = 106306;
        nArray2[805] = 73296;
        nArray2[806] = 102188;
        nArray2[807] = 81616;
        nArray2[808] = 106348;
        nArray2[809] = 102182;
        nArray2[810] = 81608;
        nArray2[811] = 73284;
        nArray2[812] = 81604;
        nArray2[813] = 73282;
        nArray2[814] = 81602;
        nArray2[815] = 69164;
        nArray2[816] = 73324;
        nArray2[817] = 69158;
        nArray2[818] = 81644;
        nArray2[819] = 73318;
        nArray2[820] = 81638;
        nArray2[821] = 122792;
        nArray2[822] = 126934;
        nArray2[823] = 122788;
        nArray2[824] = 122786;
        nArray2[825] = 106280;
        nArray2[826] = 118678;
        nArray2[827] = 114536;
        nArray2[828] = 106276;
        nArray2[829] = 114532;
        nArray2[830] = 106274;
        nArray2[831] = 114530;
        nArray2[832] = 73256;
        nArray2[833] = 102166;
        nArray2[834] = 81512;
        nArray2[835] = 73252;
        nArray2[836] = 98024;
        nArray2[837] = 81508;
        nArray2[838] = 73250;
        nArray2[839] = 98020;
        nArray2[840] = 81506;
        nArray2[841] = 98018;
        nArray2[842] = 69142;
        nArray2[843] = 73270;
        nArray2[844] = 81526;
        nArray2[845] = 98038;
        nArray2[846] = 122772;
        nArray2[847] = 122770;
        nArray2[848] = 106260;
        nArray2[849] = 114484;
        nArray2[850] = 106258;
        nArray2[851] = 114482;
        nArray2[852] = 73236;
        nArray2[853] = 81460;
        nArray2[854] = 73234;
        nArray2[855] = 97908;
        nArray2[856] = 81458;
        nArray2[857] = 97906;
        nArray2[858] = 122762;
        nArray2[859] = 106250;
        nArray2[860] = 114458;
        nArray2[861] = 73226;
        nArray2[862] = 81434;
        nArray2[863] = 97850;
        nArray2[864] = 66396;
        nArray2[865] = 66382;
        nArray2[866] = 67416;
        nArray2[867] = 99246;
        nArray2[868] = 67404;
        nArray2[869] = 67398;
        nArray2[870] = 66350;
        nArray2[871] = 67438;
        nArray2[872] = 69456;
        nArray2[873] = 100268;
        nArray2[874] = 69448;
        nArray2[875] = 100262;
        nArray2[876] = 69444;
        nArray2[877] = 69442;
        nArray2[878] = 67372;
        nArray2[879] = 69484;
        nArray2[880] = 67366;
        nArray2[881] = 69478;
        nArray2[882] = 102312;
        nArray2[883] = 116694;
        nArray2[884] = 102308;
        nArray2[885] = 102306;
        nArray2[886] = 69416;
        nArray2[887] = 100246;
        nArray2[888] = 73576;
        nArray2[889] = 102326;
        nArray2[890] = 73572;
        nArray2[891] = 69410;
        nArray2[892] = 73570;
        nArray2[893] = 67350;
        nArray2[894] = 69430;
        nArray2[895] = 73590;
        nArray2[896] = 118740;
        nArray2[897] = 118738;
        nArray2[898] = 102292;
        nArray2[899] = 106420;
        nArray2[900] = 102290;
        nArray2[901] = 106418;
        nArray2[902] = 69396;
        nArray2[903] = 73524;
        nArray2[904] = 69394;
        nArray2[905] = 81780;
        nArray2[906] = 73522;
        nArray2[907] = 81778;
        nArray2[908] = 118730;
        nArray2[909] = 102282;
        nArray2[910] = 106394;
        nArray2[911] = 69386;
        nArray2[912] = 73498;
        nArray2[913] = 81722;
        nArray2[914] = 66476;
        nArray2[915] = 66470;
        nArray2[916] = 67496;
        nArray2[917] = 99286;
        nArray2[918] = 67492;
        nArray2[919] = 67490;
        nArray2[920] = 66454;
        nArray2[921] = 67510;
        nArray2[922] = 100308;
        nArray2[923] = 100306;
        nArray2[924] = 67476;
        nArray2[925] = 69556;
        nArray2[926] = 67474;
        nArray2[927] = 69554;
        nArray2[928] = 116714;
        nArrayArray[2] = nArray2;
        CODEWORD_TABLE = nArrayArray;
    }

    public BarcodeMatrix getBarcodeMatrix() {
        return this.barcodeMatrix;
    }

    public void generateBarcodeLogic(String string2, int n5) throws WriterException {
        PDF417 pDF417 = object2;
        int n6 = PDF417ErrorCorrection.getErrorCorrectionCodewordCount(n5);
        Object object = pDF417.compaction;
        object = PDF417HighLevelEncoder.encodeHighLevel(string2, object, pDF417.encoding);
        int n7 = ((String)object).length();
        int n8 = n6;
        int n9 = n6;
        int[] nArray = ((PDF417)object2).determineDimensions(n7, n6);
        n6 = nArray[0];
        int n10 = nArray[1];
        int n11 = PDF417.getNumberOfPadCodewords(n7, n9, n6, n10);
        if (n7 + n8 + 1 <= 929) {
            BarcodeMatrix barcodeMatrix;
            StringBuilder stringBuilder;
            int n12 = n7 + n11 + 1;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2(n12);
            stringBuilder2.append((char)n12);
            stringBuilder.append((String)object);
            for (n12 = 0; n12 < n11; ++n12) {
                stringBuilder2.append('\u0384');
            }
            PDF417 pDF4172 = object2;
            Object object2 = stringBuilder2.toString();
            object2 = (String)object2 + PDF417ErrorCorrection.generateErrorCorrection((CharSequence)object2, n5);
            BarcodeMatrix barcodeMatrix2 = barcodeMatrix;
            pDF4172.barcodeMatrix = new BarcodeMatrix(n10, n6);
            pDF4172.encodeLowLevel((CharSequence)object2, n6, n10, n5, barcodeMatrix2);
            return;
        }
        throw new WriterException("Encoded message contains to many code words, message to big (" + string2.length() + " bytes)");
    }

    public void setDimensions(int n5, int n6, int n7, int n8) {
        PDF417 pDF417 = this;
        pDF417.maxCols = n5;
        pDF417.minCols = n6;
        pDF417.maxRows = n7;
        pDF417.minRows = n8;
    }

    public void setCompaction(Compaction compaction) {
        this.compaction = compaction;
    }

    public void setCompact(boolean bl) {
        this.compact = bl;
    }

    public void setEncoding(Charset charset) {
        this.encoding = charset;
    }
}

