/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.qrcode.decoder;

import com.dcloud.zxing2.common.BitMatrix;

abstract class DataMask {
    private static final DataMask[] DATA_MASKS;

    private DataMask() {
    }

    static DataMask forReference(int n5) {
        if (n5 >= 0 && n5 <= 7) {
            return DATA_MASKS[n5];
        }
        throw new IllegalArgumentException();
    }

    static {
        DataMask111 dataMask111;
        DataMask110 dataMask110;
        DataMask101 dataMask101;
        DataMask100 dataMask100;
        DataMask011 dataMask011;
        DataMask010 dataMask010;
        DataMask001 dataMask001;
        DataMask000 dataMask000;
        DataMask000 dataMask0002 = dataMask000;
        dataMask000 = new DataMask000();
        DataMask001 dataMask0012 = dataMask001;
        dataMask001 = new DataMask001();
        DataMask010 dataMask0102 = dataMask010;
        dataMask010 = new DataMask010();
        DataMask011 dataMask0112 = dataMask011;
        dataMask011 = new DataMask011();
        DataMask100 dataMask1002 = dataMask100;
        dataMask100 = new DataMask100();
        DataMask101 dataMask1012 = dataMask101;
        dataMask101 = new DataMask101();
        DataMask110 dataMask1102 = dataMask110;
        dataMask110 = new DataMask110();
        DataMask111 dataMask1112 = dataMask111;
        dataMask111 = new DataMask111();
        DATA_MASKS = new DataMask[]{dataMask0002, dataMask0012, dataMask0102, dataMask0112, dataMask1002, dataMask1012, dataMask1102, dataMask1112};
    }

    final void unmaskBitMatrix(BitMatrix bitMatrix, int n5) {
        for (int i5 = 0; i5 < n5; ++i5) {
            for (int i6 = 0; i6 < n5; ++i6) {
                if (!this.isMasked(i5, i6)) continue;
                bitMatrix.flip(i6, i5);
            }
        }
    }

    abstract boolean isMasked(int var1, int var2);

    private static final class DataMask000
    extends DataMask {
        private DataMask000() {
        }

        @Override
        boolean isMasked(int n5, int n6) {
            return (n5 + n6 & 1) == 0;
        }
    }

    private static final class DataMask001
    extends DataMask {
        private DataMask001() {
        }

        @Override
        boolean isMasked(int n5, int n6) {
            return (n5 & 1) == 0;
        }
    }

    private static final class DataMask010
    extends DataMask {
        private DataMask010() {
        }

        @Override
        boolean isMasked(int n5, int n6) {
            return n6 % 3 == 0;
        }
    }

    private static final class DataMask011
    extends DataMask {
        private DataMask011() {
        }

        @Override
        boolean isMasked(int n5, int n6) {
            return (n5 + n6) % 3 == 0;
        }
    }

    private static final class DataMask100
    extends DataMask {
        private DataMask100() {
        }

        @Override
        boolean isMasked(int n5, int n6) {
            return (n5 / 2 + n6 / 3 & 1) == 0;
        }
    }

    private static final class DataMask101
    extends DataMask {
        private DataMask101() {
        }

        @Override
        boolean isMasked(int n5, int n6) {
            int n7 = n5 * n6;
            return (n7 & 1) + n7 % 3 == 0;
        }
    }

    private static final class DataMask110
    extends DataMask {
        private DataMask110() {
        }

        @Override
        boolean isMasked(int n5, int n6) {
            int n7 = n5 * n6;
            return ((n7 & 1) + n7 % 3 & 1) == 0;
        }
    }

    private static final class DataMask111
    extends DataMask {
        private DataMask111() {
        }

        @Override
        boolean isMasked(int n5, int n6) {
            return ((n5 + n6 & 1) + n5 * n6 % 3 & 1) == 0;
        }
    }
}

