/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXSlider;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.BaseFrameLayout;
import com.taobao.weex.ui.view.WXCircleIndicator;
import com.taobao.weex.ui.view.WXCirclePageAdapter;
import com.taobao.weex.ui.view.WXCircleViewPager;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.List;

public class WXSliderNeighbor
extends WXSlider {
    public static final String NEIGHBOR_SCALE = "neighborScale";
    public static final String NEIGHBOR_ALPHA = "neighborAlpha";
    public static final String NEIGHBOR_SPACE = "neighborSpace";
    public static final String CURRENT_ITEM_SCALE = "currentItemScale";
    private static final int DEFAULT_NEIGHBOR_SPACE = 25;
    private static final float DEFAULT_NEIGHBOR_SCALE = 0.8f;
    private static final float DEFAULT_NEIGHBOR_ALPHA = 0.6f;
    private static final float DEFAULT_CURRENT_ITEM_SCALE = 0.9f;
    private float mNeighborScale = 0.8f;
    private float mNeighborAlpha = 0.6f;
    private float mNeighborSpace = 25.0f;
    private float mCurrentItemScale = 0.9f;
    private ZoomTransformer mCachedTransformer;

    public WXSliderNeighbor(WXSDKInstance wXSDKInstance, WXVContainer wXVContainer, BasicComponentData basicComponentData) {
        super(wXSDKInstance, wXVContainer, basicComponentData);
    }

    private void updateScaleAndAlpha(View view, float f, float f2) {
        if (view != null) {
            if (f >= 0.0f && view.getAlpha() != f) {
                view.setAlpha(f);
            }
            if (f2 >= 0.0f && view.getScaleX() != f2) {
                View view2 = view;
                view2.setScaleX(f2);
                view2.setScaleY(f2);
                return;
            }
        }
    }

    private void updateAdapterScaleAndAlpha(final float f, final float f2) {
        List<View> list = this.mAdapter.getViews();
        int n = this.mViewPager.getCurrentItem();
        if (list.size() > 0) {
            WXSliderNeighbor wXSliderNeighbor = this;
            final View view = list.get(n);
            View view2 = ((ViewGroup)view).getChildAt(0);
            float f3 = wXSliderNeighbor.mCurrentItemScale;
            wXSliderNeighbor.updateScaleAndAlpha(view2, 1.0f, f3);
            if (list.size() >= 2) {
                view.postDelayed(WXThread.secure(new Runnable(){

                    @Override
                    public void run() {
                        2 v0 = this_;
                        2 this_ = v0.view;
                        float f3 = v0.f;
                        float f22 = v0.f2;
                        this_.WXSliderNeighbor.this.updateNeighbor((View)this_, f3, f22);
                    }
                }), 17L);
                int n2 = n == 0 ? list.size() - 1 : n - 1;
                int n3 = n == list.size() - 1 ? 0 : n + 1;
                for (int i = 0; i < this.mAdapter.getRealCount(); ++i) {
                    if (i == n2 || i == n || i == n3) continue;
                    ((ViewGroup)list.get(i)).getChildAt(0).setAlpha(0.0f);
                }
            }
        }
    }

    private void updateNeighbor(View view, float f, float f2) {
        WXSliderNeighbor wXSliderNeighbor = this;
        View view2 = wXSliderNeighbor.mAdapter.getViews();
        int n = wXSliderNeighbor.mViewPager.getCurrentItem();
        float f3 = this.calculateTranslation(view);
        int n2 = n == 0 ? view2.size() - 1 : n - 1;
        View view3 = view2;
        View view4 = view3.get(n2);
        int n3 = n == view3.size() - 1 ? 0 : n + 1;
        View view5 = view2;
        view2 = view5.get(n3);
        if (view5.size() == 2) {
            if (n == 0) {
                this.moveRight(view2, f3, f, f2);
                return;
            }
            if (n == 1) {
                this.moveLeft(view4, f3, f, f2);
                return;
            }
            return;
        }
        WXSliderNeighbor wXSliderNeighbor2 = this;
        wXSliderNeighbor2.moveLeft(view4, f3, f, f2);
        wXSliderNeighbor2.moveRight(view2, f3, f, f2);
    }

    private void moveLeft(View view, float f, float f2, float f3) {
        View view2 = view;
        this.updateScaleAndAlpha(((ViewGroup)view).getChildAt(0), f2, f3);
        view2.setTranslationX(f);
        ((ViewGroup)view2).getChildAt(0).setTranslationX(f);
    }

    private void moveRight(View view, float f, float f2, float f3) {
        this.moveLeft(view, -f, f2, f3);
    }

    private float calculateTranslation(@NonNull View view) {
        if (!(view instanceof ViewGroup)) {
            return 0.0f;
        }
        View view2 = view;
        View view3 = ((ViewGroup)view2).getChildAt(0);
        return ((float)view2.getMeasuredWidth() - (float)view3.getMeasuredWidth() * this.mNeighborScale) / 4.0f + (((float)view.getMeasuredWidth() - (float)view3.getMeasuredWidth() * this.mCurrentItemScale) / 2.0f - WXViewUtils.getRealPxByWidth(this.mNeighborSpace, this.getInstance().getInstanceViewPortWidthWithFloat())) / 2.0f;
    }

    @Override
    public void bindData(WXComponent wXComponent) {
        super.bindData(wXComponent);
    }

    @Override
    protected BaseFrameLayout initComponentHostView(@NonNull Context object) {
        WXCirclePageAdapter wXCirclePageAdapter;
        WXCircleViewPager wXCircleViewPager;
        FrameLayout.LayoutParams layoutParams;
        BaseFrameLayout baseFrameLayout;
        Object object2 = baseFrameLayout;
        WXSliderNeighbor wXSliderNeighbor = this;
        BaseFrameLayout baseFrameLayout2 = object2;
        WXSliderNeighbor wXSliderNeighbor2 = this;
        object2((Context)object);
        object = layoutParams;
        new FrameLayout.LayoutParams((int)-1, (int)-1).gravity = 17;
        Object object3 = object2 = wXCircleViewPager;
        ((WXCircleViewPager)object3)(this.getContext());
        this.mViewPager = object3;
        wXCircleViewPager.setLayoutParams((ViewGroup.LayoutParams)object);
        object = wXCirclePageAdapter;
        wXSliderNeighbor2.mAdapter = new WXCirclePageAdapter();
        wXSliderNeighbor2.mViewPager.setAdapter((PagerAdapter)object);
        baseFrameLayout2.addView((View)wXSliderNeighbor2.mViewPager);
        wXSliderNeighbor.mViewPager.addOnPageChangeListener(this.mPageChangeListener);
        wXSliderNeighbor.mViewPager.setOverScrollMode(2);
        wXSliderNeighbor.registerActivityStateListener();
        wXSliderNeighbor.mViewPager.setPageTransformer(false, this.createTransformer());
        return baseFrameLayout;
    }

    ZoomTransformer createTransformer() {
        if (this.mCachedTransformer == null) {
            ZoomTransformer zoomTransformer;
            ZoomTransformer zoomTransformer2 = zoomTransformer;
            zoomTransformer = new ZoomTransformer();
            this.mCachedTransformer = zoomTransformer2;
        }
        return this.mCachedTransformer;
    }

    @Override
    public void addSubView(View view, final int n) {
        if (view != null && this.mAdapter != null) {
            FrameLayout frameLayout;
            if (view instanceof WXCircleIndicator) {
                return;
            }
            WXSliderNeighbor wXSliderNeighbor = this;
            FrameLayout frameLayout2 = frameLayout;
            View view2 = view;
            frameLayout2(this.getContext());
            new FrameLayout.LayoutParams(-2, -2).gravity = 17;
            view2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
            frameLayout.addView(view2);
            super.addSubView((View)frameLayout, n);
            float f = wXSliderNeighbor.mNeighborAlpha;
            wXSliderNeighbor.updateAdapterScaleAndAlpha(f, wXSliderNeighbor.mNeighborScale);
            wXSliderNeighbor.mViewPager.postDelayed(WXThread.secure(new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    block11: {
                        Throwable throwable2;
                        block10: {
                            block9: {
                                if (WXSliderNeighbor.this.mViewPager.getRealCount() <= 0 || n <= 2) break block9;
                                1 v0 = this;
                                1 v1 = v0;
                                v0.WXSliderNeighbor.this.mViewPager.beginFakeDrag();
                                try {
                                    v1.WXSliderNeighbor.this.mViewPager.fakeDragBy(1.0f);
                                }
                                catch (Throwable throwable2) {
                                    break block10;
                                }
                                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                    break block11;
                                }
                            }
                            try {
                                WXSliderNeighbor.this.mViewPager.endFakeDrag();
                                return;
                            }
                            catch (Exception exception) {
                                return;
                            }
                        }
                        try {
                            WXSliderNeighbor.this.mViewPager.endFakeDrag();
                            throw throwable2;
                        }
                        catch (Exception exception) {}
                        throw throwable2;
                    }
                    WXSliderNeighbor.this.mViewPager.endFakeDrag();
                }
            }), 50L);
            return;
        }
    }

    @WXComponentProp(name="neighborScale")
    public void setNeighborScale(String string2) {
        float f = 0.8f;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                f = Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (this.mNeighborScale != f) {
            this.mNeighborScale = f;
            this.updateAdapterScaleAndAlpha(-1.0f, f);
        }
    }

    @WXComponentProp(name="neighborAlpha")
    public void setNeighborAlpha(String string2) {
        float f = 0.6f;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                f = Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (this.mNeighborAlpha != f) {
            this.mNeighborAlpha = f;
            this.updateAdapterScaleAndAlpha(f, -1.0f);
        }
    }

    @WXComponentProp(name="neighborSpace")
    public void setNeighborSpace(String string2) {
        float f = 25.0f;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                f = Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (this.mNeighborSpace != f) {
            this.mNeighborSpace = f;
        }
    }

    @WXComponentProp(name="currentItemScale")
    public void setCurrentItemScale(String string2) {
        float f = 0.9f;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                f = Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (this.mCurrentItemScale != f) {
            this.mCurrentItemScale = f;
            this.updateAdapterScaleAndAlpha(-1.0f, -1.0f);
        }
    }

    @Override
    protected boolean setProperty(String string2, Object object) {
        String string3 = string2;
        string3.getClass();
        int n = -1;
        switch (string3.hashCode()) {
            default: {
                break;
            }
            case -1013904258: {
                if (!string2.equals(CURRENT_ITEM_SCALE)) break;
                n = 3;
                break;
            }
            case -1746973388: {
                if (!string2.equals(NEIGHBOR_SPACE)) break;
                n = 2;
                break;
            }
            case -1747360392: {
                if (!string2.equals(NEIGHBOR_SCALE)) break;
                n = 1;
                break;
            }
            case -1763701364: {
                if (!string2.equals(NEIGHBOR_ALPHA)) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                return super.setProperty(string2, object);
            }
            case 3: {
                string2 = WXUtils.getString(object, null);
                if (string2 != null) {
                    this.setCurrentItemScale(string2);
                }
                return true;
            }
            case 2: {
                string2 = WXUtils.getString(object, null);
                if (string2 != null) {
                    this.setNeighborSpace(string2);
                }
                return true;
            }
            case 1: {
                string2 = WXUtils.getString(object, null);
                if (string2 != null) {
                    this.setNeighborScale(string2);
                }
                return true;
            }
            case 0: 
        }
        string2 = WXUtils.getString(object, null);
        if (string2 != null) {
            this.setNeighborAlpha(string2);
        }
        return true;
    }

    class ZoomTransformer
    implements ViewPager.PageTransformer {
        ZoomTransformer() {
        }

        public void transformPage(View view, float f) {
            block8: {
                float f2;
                float f3;
                View view2;
                block10: {
                    float f4;
                    int n;
                    block11: {
                        block9: {
                            ZoomTransformer zoomTransformer = this;
                            int n2 = zoomTransformer.WXSliderNeighbor.this.mAdapter.getPagePosition(view);
                            int n3 = zoomTransformer.WXSliderNeighbor.this.mViewPager.getCurrentItem();
                            n = WXSliderNeighbor.this.mAdapter.getRealCount();
                            boolean bl = false;
                            if (n3 != 0 && n3 != n - 1 && Math.abs(n2 - n3) > 1) {
                                bl = true;
                            }
                            if (n3 == 0 && n2 < n - 1 && n2 > 1) {
                                bl = true;
                            }
                            if (n3 == (n3 = n - 1) && n2 < n - 2 && n2 > 0) {
                                bl = true;
                            }
                            if (bl || (view2 = ((ViewGroup)view).getChildAt(0)) == null) break block8;
                            if (f <= (float)(-n + 1)) {
                                f += (float)n;
                            }
                            if (f >= (float)n3) {
                                f -= (float)n;
                            }
                            if (!(f >= -1.0f) || !(f <= 1.0f)) break block8;
                            ZoomTransformer zoomTransformer2 = this;
                            f3 = Math.abs(Math.abs(f) - 1.0f);
                            f2 = zoomTransformer2.WXSliderNeighbor.this.mNeighborScale + f3 * (WXSliderNeighbor.this.mCurrentItemScale - WXSliderNeighbor.this.mNeighborScale);
                            f3 = (1.0f - zoomTransformer2.WXSliderNeighbor.this.mNeighborAlpha) * f3 + WXSliderNeighbor.this.mNeighborAlpha;
                            f4 = zoomTransformer2.WXSliderNeighbor.this.calculateTranslation(view);
                            if (!(f > 0.0f)) break block9;
                            float f5 = -(f * f4);
                            view2.setTranslationX(f5);
                            view.setTranslationX(f5);
                            break block10;
                        }
                        if (f != 0.0f) break block11;
                        view.setTranslationX(0.0f);
                        view2.setTranslationX(0.0f);
                        WXSliderNeighbor wXSliderNeighbor = WXSliderNeighbor.this;
                        wXSliderNeighbor.updateAdapterScaleAndAlpha(wXSliderNeighbor.mNeighborAlpha, WXSliderNeighbor.this.mNeighborScale);
                        break block10;
                    }
                    if (n == 2 && Math.abs(f) == 1.0f) break block8;
                    float f6 = -f * f4;
                    view2.setTranslationX(f6);
                    view.setTranslationX(f6);
                }
                View view3 = view2;
                view3.setScaleX(f2);
                view3.setScaleY(f2);
                view3.setAlpha(f3);
                return;
            }
        }
    }

    public static class Creator
    implements ComponentCreator {
        @Override
        public WXComponent createInstance(WXSDKInstance wXSDKInstance, WXVContainer wXVContainer, BasicComponentData basicComponentData) {
            return new WXSliderNeighbor(wXSDKInstance, wXVContainer, basicComponentData);
        }
    }
}

