/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.EncodeHintType;
import com.dcloud.zxing2.WriterException;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.oned.OneDimensionalCodeWriter;
import com.dcloud.zxing2.oned.UPCEANReader;
import com.dcloud.zxing2.oned.UPCEANWriter;
import java.util.Map;

public final class EAN8Writer
extends UPCEANWriter {
    private static final int CODE_WIDTH = 67;

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n5, int n6, Map<EncodeHintType, ?> map) throws WriterException {
        if (barcodeFormat == BarcodeFormat.EAN_8) {
            return super.encode(string2, barcodeFormat, n5, n6, map);
        }
        throw new IllegalArgumentException("Can only encode EAN_8, but got " + (Object)((Object)barcodeFormat));
    }

    @Override
    public boolean[] encode(String string2) {
        if (string2.length() == 8) {
            boolean[] blArray = new boolean[67];
            Object object = blArray;
            int n5 = OneDimensionalCodeWriter.appendPattern(blArray, 0, UPCEANReader.START_END_PATTERN, true);
            int n6 = 0;
            while (n6 <= 3) {
                n5 += OneDimensionalCodeWriter.appendPattern((boolean[])object, n5, UPCEANReader.L_PATTERNS[Integer.parseInt(string2.substring(n6++, n6))], false);
            }
            n5 += OneDimensionalCodeWriter.appendPattern((boolean[])object, n5, UPCEANReader.MIDDLE_PATTERN, false);
            n6 = 4;
            while (n6 <= 7) {
                n5 += OneDimensionalCodeWriter.appendPattern((boolean[])object, n5, UPCEANReader.L_PATTERNS[Integer.parseInt(string2.substring(n6++, n6))], true);
            }
            Object object2 = object;
            OneDimensionalCodeWriter.appendPattern((boolean[])object2, n5, UPCEANReader.START_END_PATTERN, true);
            return object2;
        }
        throw new IllegalArgumentException("Requested contents should be 8 digits long, but got " + string2.length());
    }
}

