/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.downloader.db;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.dcloud.android.downloader.config.Config;
import com.dcloud.android.downloader.db.DefaultDownloadHelper;
import com.dcloud.android.downloader.db.DownloadDBController;
import com.dcloud.android.downloader.domain.DownloadInfo;
import com.dcloud.android.downloader.domain.DownloadThreadInfo;
import io.dcloud.common.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public final class DefaultDownloadDBController
implements DownloadDBController {
    public static final String[] DOWNLOAD_INFO_COLUMNS = new String[]{"_id", "supportRanges", "createAt", "uri", "location", "path", "size", "progress", "status"};
    public static final String[] DOWNLOAD_THREAD_INFO_COLUMNS = new String[]{"_id", "threadId", "downloadInfoId", "uri", "start", "end", "progress"};
    public static final String SQL_UPDATE_DOWNLOAD_THREAD_INFO;
    public static final String SQL_UPDATE_DOWNLOAD_INFO;
    public static final String SQL_UPDATE_DOWNLOADING_INFO_STATUS;
    private final Context context;
    private final DefaultDownloadHelper dbHelper;
    private final SQLiteDatabase writableDatabase;
    private final SQLiteDatabase readableDatabase;

    public DefaultDownloadDBController(Context context, Config config) {
        DefaultDownloadHelper defaultDownloadHelper;
        DefaultDownloadDBController defaultDownloadDBController = object;
        defaultDownloadDBController.context = context;
        Object object = defaultDownloadHelper;
        defaultDownloadDBController.dbHelper = new DefaultDownloadHelper(context, config);
        defaultDownloadDBController.writableDatabase = object.getWritableDatabase();
        defaultDownloadDBController.readableDatabase = object.getReadableDatabase();
    }

    private void inflateDownloadThreadInfo(Cursor cursor, DownloadThreadInfo downloadThreadInfo) {
        downloadThreadInfo.setId(cursor.getInt(0));
        downloadThreadInfo.setThreadId(cursor.getInt(1));
        downloadThreadInfo.setDownloadInfoId(cursor.getInt(2));
        downloadThreadInfo.setUri(cursor.getString(3));
        downloadThreadInfo.setStart(cursor.getLong(4));
        downloadThreadInfo.setEnd(cursor.getLong(5));
        downloadThreadInfo.setProgress(cursor.getLong(6));
    }

    private void inflateDownloadInfo(Cursor cursor, DownloadInfo downloadInfo) {
        downloadInfo.setId(cursor.getInt(0));
        downloadInfo.setSupportRanges(cursor.getInt(1));
        downloadInfo.setCreateAt(cursor.getLong(2));
        downloadInfo.setUri(cursor.getString(3));
        downloadInfo.setLocation(cursor.getString(4));
        downloadInfo.setPath(cursor.getString(5));
        downloadInfo.setSize(cursor.getLong(6));
        downloadInfo.setProgress(cursor.getLong(7));
        downloadInfo.setStatus(cursor.getInt(8));
    }

    static {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = "download_thread_info";
        SQL_UPDATE_DOWNLOAD_THREAD_INFO = StringUtil.format("REPLACE INTO %s (_id,threadId,downloadInfoId,uri,start,end,progress) VALUES(?,?,?,?,?,?,?);", objectArray2);
        Object[] objectArray3 = new Object[1];
        objectArray2 = objectArray3;
        objectArray3[0] = "download_info";
        SQL_UPDATE_DOWNLOAD_INFO = StringUtil.format("REPLACE INTO %s (_id,supportRanges,createAt,uri,location,path,size,progress,status) VALUES(?,?,?,?,?,?,?,?,?);", objectArray2);
        Object[] objectArray4 = new Object[1];
        objectArray2 = objectArray4;
        objectArray4[0] = "download_info";
        SQL_UPDATE_DOWNLOADING_INFO_STATUS = StringUtil.format("UPDATE %s SET status=? WHERE status!=?;", objectArray2);
    }

    @Override
    public List<DownloadInfo> findAllDownloading() {
        ArrayList arrayList;
        String string2 = String.valueOf(5);
        String[] stringArray = new String[1];
        Object object = stringArray;
        stringArray[0] = string2;
        string2 = this.readableDatabase.query("download_info", DOWNLOAD_INFO_COLUMNS, "status!=?", (String[])object, null, null, "createAt desc");
        object = arrayList;
        arrayList = new ArrayList();
        while (string2.moveToNext()) {
            ArrayList arrayList2;
            DownloadInfo downloadInfo;
            DefaultDownloadDBController defaultDownloadDBController = this;
            DownloadInfo downloadInfo2 = downloadInfo;
            object.add(new DownloadInfo(this.context));
            defaultDownloadDBController.inflateDownloadInfo((Cursor)string2, downloadInfo2);
            Cursor cursor = DOWNLOAD_THREAD_INFO_COLUMNS;
            Object object2 = String.valueOf(downloadInfo2.getId());
            String[] stringArray2 = new String[1];
            Object object3 = stringArray2;
            stringArray2[0] = object2;
            cursor = defaultDownloadDBController.readableDatabase.query("download_thread_info", (String[])cursor, "downloadInfoId=?", object3, null, null, null);
            object2 = arrayList2;
            arrayList2 = new ArrayList();
            while (cursor.moveToNext()) {
                DownloadThreadInfo downloadThreadInfo;
                object3 = downloadThreadInfo;
                downloadThreadInfo = new DownloadThreadInfo();
                object2.add(object3);
                this.inflateDownloadThreadInfo(cursor, (DownloadThreadInfo)object3);
            }
            downloadInfo2.setDownloadThreadInfos((List<DownloadThreadInfo>)object2);
        }
        return object;
    }

    @Override
    public List<DownloadInfo> findAllDownloaded() {
        ArrayList arrayList;
        String string2 = String.valueOf(5);
        String[] stringArray = new String[1];
        Object object = stringArray;
        stringArray[0] = string2;
        string2 = this.readableDatabase.query("download_info", DOWNLOAD_INFO_COLUMNS, "status=?", (String[])object, null, null, "createAt desc");
        object = arrayList;
        arrayList = new ArrayList();
        while (string2.moveToNext()) {
            DownloadInfo downloadInfo;
            DownloadInfo downloadInfo2 = downloadInfo;
            object.add(new DownloadInfo(this.context));
            this.inflateDownloadInfo((Cursor)string2, downloadInfo2);
        }
        return object;
    }

    @Override
    public DownloadInfo findDownloadedInfoById(int n5) {
        Cursor cursor = DOWNLOAD_INFO_COLUMNS;
        Object object = String.valueOf(n5);
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = object;
        if ((cursor = this.readableDatabase.query("download_info", (String[])cursor, "_id=?", stringArray2, null, null, "createAt desc")).moveToNext()) {
            DownloadInfo downloadInfo;
            object = downloadInfo;
            ((DownloadInfo)object)(this.context);
            this.inflateDownloadInfo(cursor, (DownloadInfo)object);
            return downloadInfo;
        }
        return null;
    }

    @Override
    public void pauseAllDownloading() {
        Integer n5 = 4;
        Integer n6 = 5;
        ((DefaultDownloadDBController)((Object)n5)).writableDatabase.execSQL(SQL_UPDATE_DOWNLOADING_INFO_STATUS, new Object[]{n5, n6});
    }

    @Override
    public void createOrUpdate(DownloadInfo serializable) {
        DownloadInfo downloadInfo = serializable;
        Object object = SQL_UPDATE_DOWNLOAD_INFO;
        Integer n5 = downloadInfo.getId();
        Integer n6 = downloadInfo.getSupportRanges();
        Long l5 = downloadInfo.getCreateAt();
        String string2 = downloadInfo.getUri();
        String string3 = downloadInfo.getLocation();
        String string4 = downloadInfo.getPath();
        Object object2 = object;
        DownloadInfo downloadInfo2 = serializable;
        object = downloadInfo2.getSize();
        serializable = Long.valueOf(downloadInfo2.getProgress());
        Integer n7 = downloadInfo2.getStatus();
        Object[] objectArray = new Object[9];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n5;
        objectArray[1] = n6;
        objectArray[2] = l5;
        objectArray[3] = string2;
        objectArray[4] = string3;
        objectArray[5] = string4;
        objectArray[6] = object;
        objectArray[7] = serializable;
        objectArray[8] = n7;
        ((DefaultDownloadDBController)object).writableDatabase.execSQL((String)object2, objectArray2);
    }

    @Override
    public void createOrUpdate(DownloadThreadInfo serializable) {
        DownloadThreadInfo downloadThreadInfo = serializable;
        Object object = SQL_UPDATE_DOWNLOAD_THREAD_INFO;
        Integer n5 = downloadThreadInfo.getId();
        Integer n6 = downloadThreadInfo.getThreadId();
        Integer n7 = downloadThreadInfo.getDownloadInfoId();
        String string2 = downloadThreadInfo.getUri();
        Object object2 = object;
        DownloadThreadInfo downloadThreadInfo2 = serializable;
        object = downloadThreadInfo2.getStart();
        serializable = Long.valueOf(downloadThreadInfo2.getEnd());
        Long l5 = downloadThreadInfo2.getProgress();
        Object[] objectArray = new Object[7];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n5;
        objectArray[1] = n6;
        objectArray[2] = n7;
        objectArray[3] = string2;
        objectArray[4] = object;
        objectArray[5] = serializable;
        objectArray[6] = l5;
        ((DefaultDownloadDBController)object).writableDatabase.execSQL((String)object2, objectArray2);
    }

    @Override
    public void delete(DownloadInfo stringArray) {
        DefaultDownloadDBController defaultDownloadDBController = object;
        Object object = String.valueOf(stringArray.getId());
        String[] stringArray2 = new String[1];
        String[] stringArray3 = stringArray2;
        stringArray2[0] = object;
        defaultDownloadDBController.writableDatabase.delete("download_info", "_id=?", stringArray3);
        object = String.valueOf(stringArray.getId());
        String[] stringArray4 = new String[1];
        stringArray = stringArray4;
        stringArray4[0] = object;
        defaultDownloadDBController.writableDatabase.delete("download_thread_info", "downloadInfoId=?", stringArray);
    }

    @Override
    public void delete(DownloadThreadInfo stringArray) {
        String string2 = String.valueOf(stringArray.getId());
        String[] stringArray2 = new String[1];
        stringArray = stringArray2;
        stringArray2[0] = string2;
        ((DefaultDownloadDBController)((Object)string2)).writableDatabase.delete("download_thread_info", "id=?", stringArray);
    }
}

