/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned.rss.expanded;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.Result;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.common.BitArray;
import com.dcloud.zxing2.oned.OneDReader;
import com.dcloud.zxing2.oned.rss.AbstractRSSReader;
import com.dcloud.zxing2.oned.rss.DataCharacter;
import com.dcloud.zxing2.oned.rss.FinderPattern;
import com.dcloud.zxing2.oned.rss.RSSUtils;
import com.dcloud.zxing2.oned.rss.expanded.BitArrayBuilder;
import com.dcloud.zxing2.oned.rss.expanded.ExpandedPair;
import com.dcloud.zxing2.oned.rss.expanded.ExpandedRow;
import com.dcloud.zxing2.oned.rss.expanded.decoders.AbstractExpandedDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class RSSExpandedReader
extends AbstractRSSReader {
    private static final int[] SYMBOL_WIDEST = new int[]{7, 5, 4, 3, 1};
    private static final int[] EVEN_TOTAL_SUBSET = new int[]{4, 20, 52, 104, 204};
    private static final int[] GSUM = new int[]{0, 348, 1388, 2948, 3988};
    private static final int[][] FINDER_PATTERNS;
    private static final int[][] WEIGHTS;
    private static final int FINDER_PAT_A = 0;
    private static final int FINDER_PAT_B = 1;
    private static final int FINDER_PAT_C = 2;
    private static final int FINDER_PAT_D = 3;
    private static final int FINDER_PAT_E = 4;
    private static final int FINDER_PAT_F = 5;
    private static final int[][] FINDER_PATTERN_SEQUENCES;
    private static final int MAX_PAIRS = 11;
    private final List<ExpandedPair> pairs = new ArrayList<ExpandedPair>(11);
    private final List<ExpandedRow> rows = new ArrayList<ExpandedRow>();
    private final int[] startEnd = new int[2];
    private boolean startFromEven;

    private List<ExpandedPair> checkRows(boolean bl) {
        ArrayList<ExpandedRow> arrayList;
        if (this.rows.size() > 25) {
            this.rows.clear();
            return null;
        }
        this.pairs.clear();
        if (bl) {
            Collections.reverse(this.rows);
        }
        List<ExpandedPair> list = null;
        ArrayList<ExpandedRow> arrayList2 = arrayList;
        try {
            arrayList = new ArrayList<ExpandedRow>();
            list = this.checkRows(arrayList2, 0);
        }
        catch (NotFoundException notFoundException) {}
        if (bl) {
            Collections.reverse(this.rows);
        }
        return list;
    }

    private List<ExpandedPair> checkRows(List<ExpandedRow> list, int n5) throws NotFoundException {
        while (n5 < this.rows.size()) {
            RSSExpandedReader rSSExpandedReader = this;
            ExpandedRow expandedRow = rSSExpandedReader.rows.get(n5);
            rSSExpandedReader.pairs.clear();
            int n6 = list.size();
            for (int i5 = 0; i5 < n6; ++i5) {
                this.pairs.addAll(list.get(i5).getPairs());
            }
            RSSExpandedReader rSSExpandedReader2 = this;
            rSSExpandedReader2.pairs.addAll(expandedRow.getPairs());
            if (RSSExpandedReader.isValidSequence(rSSExpandedReader2.pairs)) {
                ArrayList<ExpandedRow> arrayList;
                if (this.checkChecksum()) {
                    return this.pairs;
                }
                ArrayList<ExpandedRow> arrayList2 = arrayList;
                arrayList2();
                arrayList2.addAll(list);
                arrayList2.add(expandedRow);
                try {
                    return this.checkRows(arrayList, n5 + 1);
                }
                catch (NotFoundException notFoundException) {}
            }
            ++n5;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static boolean isValidSequence(List<ExpandedPair> list) {
        int[][] nArray = FINDER_PATTERN_SEQUENCES;
        int n5 = FINDER_PATTERN_SEQUENCES.length;
        block0: for (int i5 = 0; i5 < n5; ++i5) {
            int[] nArray2 = nArray[i5];
            if (list.size() > nArray2.length) continue;
            for (int i6 = 0; i6 < list.size(); ++i6) {
                if (list.get(i6).getFinderPattern().getValue() == nArray2[i6]) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    private void storeRow(int n5, boolean bl) {
        int n6;
        boolean bl2 = false;
        boolean bl3 = false;
        for (n6 = 0; n6 < this.rows.size(); ++n6) {
            ExpandedRow expandedRow = this.rows.get(n6);
            if (expandedRow.getRowNumber() > n5) {
                bl3 = expandedRow.isEquivalent(this.pairs);
                break;
            }
            bl2 = expandedRow.isEquivalent(this.pairs);
        }
        if (!(bl3 || bl2 || RSSExpandedReader.isPartialRow(this.pairs, this.rows))) {
            ExpandedRow expandedRow;
            RSSExpandedReader rSSExpandedReader = this;
            ExpandedRow expandedRow2 = expandedRow;
            expandedRow = new ExpandedRow(this.pairs, n5, bl);
            rSSExpandedReader.rows.add(n6, expandedRow2);
            RSSExpandedReader.removePartialRows(rSSExpandedReader.pairs, this.rows);
            return;
        }
    }

    private static void removePartialRows(List<ExpandedPair> list, List<ExpandedRow> object) {
        object = object.iterator();
        block0: while (object.hasNext()) {
            ExpandedRow expandedRow = (ExpandedRow)object.next();
            if (expandedRow.getPairs().size() == list.size()) continue;
            block1: for (ExpandedPair expandedPair : expandedRow.getPairs()) {
                Iterator<ExpandedPair> iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (!expandedPair.equals(iterator.next())) continue;
                    continue block1;
                }
                continue block0;
            }
            object.remove();
        }
    }

    private static boolean isPartialRow(Iterable<ExpandedPair> iterable, Iterable<ExpandedRow> object) {
        object = object.iterator();
        block0: while (object.hasNext()) {
            ExpandedRow expandedRow = (ExpandedRow)object.next();
            block1: for (ExpandedPair expandedPair : iterable) {
                Iterator<ExpandedPair> iterator = expandedRow.getPairs().iterator();
                while (iterator.hasNext()) {
                    if (!expandedPair.equals(iterator.next())) continue;
                    continue block1;
                }
                continue block0;
            }
            return true;
        }
        return false;
    }

    static Result constructResult(List<ExpandedPair> object) throws NotFoundException, FormatException {
        List<ExpandedPair> list = object;
        object = AbstractExpandedDecoder.createDecoder(BitArrayBuilder.buildBitArray(list)).parseInformation();
        Object object2 = list.get(0).getFinderPattern().getResultPoints();
        Object object3 = list.get(list.size() - 1).getFinderPattern().getResultPoints();
        Object object4 = object;
        object = object2[0];
        object2 = object2[1];
        object3 = object3[0];
        ResultPoint resultPoint = object3[1];
        ResultPoint[] resultPointArray = new ResultPoint[4];
        ResultPoint[] resultPointArray2 = resultPointArray;
        resultPointArray[0] = object;
        resultPointArray[1] = object2;
        resultPointArray[2] = object3;
        resultPointArray[3] = resultPoint;
        object = BarcodeFormat.RSS_EXPANDED;
        return new Result((String)object4, null, resultPointArray2, (BarcodeFormat)((Object)object));
    }

    private boolean checkChecksum() {
        ExpandedPair expandedPair = this.pairs.get(0);
        DataCharacter dataCharacter = expandedPair.getLeftChar();
        DataCharacter dataCharacter2 = expandedPair.getRightChar();
        if (dataCharacter2 == null) {
            return false;
        }
        int n5 = dataCharacter2.getChecksumPortion();
        int n6 = 2;
        for (int i5 = 1; i5 < this.pairs.size(); ++i5) {
            ExpandedPair expandedPair2 = this.pairs.get(i5);
            n5 += expandedPair2.getLeftChar().getChecksumPortion();
            int n7 = n6 + 1;
            DataCharacter dataCharacter3 = expandedPair2.getRightChar();
            if (dataCharacter3 != null) {
                n5 += dataCharacter3.getChecksumPortion();
                n6 += 2;
                continue;
            }
            n6 = n7;
        }
        int n8 = n5 % 211;
        return (n6 - 4) * 211 + n8 == dataCharacter.getValue();
    }

    private static int getNextSecondBar(BitArray bitArray, int n5) {
        if (bitArray.get(n5)) {
            BitArray bitArray2 = bitArray;
            return bitArray2.getNextSet(bitArray2.getNextUnset(n5));
        }
        BitArray bitArray3 = bitArray;
        return bitArray3.getNextUnset(bitArray3.getNextSet(n5));
    }

    private void findNextPair(BitArray bitArray, List<ExpandedPair> list, int n5) throws NotFoundException {
        int[] nArray = this.getDecodeFinderCounters();
        int[] nArray2 = nArray;
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        int n6 = bitArray.getSize();
        if (n5 < 0) {
            if (list.isEmpty()) {
                n5 = 0;
            } else {
                List<ExpandedPair> list2 = list;
                n5 = list2.get(list2.size() - 1).getFinderPattern().getStartEnd()[1];
            }
        }
        boolean bl = list.size() % 2 != 0;
        if (this.startFromEven) {
            bl ^= true;
        }
        int n7 = 0;
        while (n5 < n6) {
            int n8 = bitArray.get(n5);
            n7 = n8 ^ 1;
            if (n8 != 0) break;
            ++n5;
        }
        int n9 = 0;
        int n10 = n7;
        n7 = n5;
        int n11 = n9;
        n9 = n10;
        while (n5 < n6) {
            if ((bitArray.get(n5) ^ n9) != 0) {
                nArray2[n11] = nArray2[n11] + 1;
            } else {
                if (n11 == 3) {
                    if (bl) {
                        RSSExpandedReader.reverseCounters(nArray2);
                    }
                    if (AbstractRSSReader.isFinderPattern(nArray2)) {
                        this.startEnd[0] = n7;
                        this.startEnd[1] = n5;
                        return;
                    }
                    if (bl) {
                        RSSExpandedReader.reverseCounters(nArray2);
                    }
                    int[] nArray4 = nArray2;
                    nArray4 = nArray2;
                    n7 += nArray2[0] + nArray2[1];
                    nArray4[0] = nArray3[2];
                    nArray4[1] = nArray3[3];
                    nArray3[2] = 0;
                    nArray4[3] = 0;
                    --n11;
                } else {
                    ++n11;
                }
                nArray2[n11] = 1;
                n9 ^= 1;
            }
            ++n5;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static void reverseCounters(int[] nArray) {
        int n5 = nArray.length;
        for (int i5 = 0; i5 < n5 / 2; ++i5) {
            int n6 = nArray[i5];
            int n7 = n5 - i5 - 1;
            nArray[i5] = nArray[n7];
            nArray[n7] = n6;
        }
    }

    private FinderPattern parseFoundFinderPattern(BitArray bitArray, int n5, boolean n6) {
        int n7;
        int n8;
        int n9;
        if (n6 != 0) {
            for (n6 = ((RSSExpandedReader)object).startEnd[0] - 1; n6 >= 0 && !bitArray.get(n6); --n6) {
            }
            n9 = n6 + 1;
            n6 = ((RSSExpandedReader)object).startEnd[0] - n9;
            n8 = ((RSSExpandedReader)object).startEnd[1];
        } else {
            n9 = ((RSSExpandedReader)object).startEnd[0];
            n8 = bitArray.getNextUnset(((RSSExpandedReader)object).startEnd[1] + 1);
            n6 = n8 - ((RSSExpandedReader)object).startEnd[1];
        }
        int[] nArray = ((AbstractRSSReader)object).getDecodeFinderCounters();
        Object object = nArray;
        int n10 = nArray.length - 1;
        System.arraycopy(nArray, 0, object, 1, n10);
        nArray[0] = n6;
        try {
            n7 = AbstractRSSReader.parseFinderValue(nArray, FINDER_PATTERNS);
        }
        catch (NotFoundException notFoundException) {
            return null;
        }
        int[] nArray2 = new int[2];
        int[] nArray3 = nArray2;
        nArray2[0] = n9;
        nArray2[1] = n8;
        return new FinderPattern(n7, nArray3, n9, n8, n5);
    }

    private static boolean isNotA1left(FinderPattern finderPattern, boolean bl, boolean bl2) {
        return finderPattern.getValue() != 0 || !bl || !bl2;
        {
        }
    }

    private void adjustOddEvenCounts(int n5) throws NotFoundException {
        block28: {
            block31: {
                boolean bl;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                block22: {
                    boolean bl5;
                    block29: {
                        block30: {
                            boolean bl6;
                            int n6;
                            int n7;
                            block24: {
                                block27: {
                                    block25: {
                                        block26: {
                                            block19: {
                                                block23: {
                                                    block20: {
                                                        block21: {
                                                            n7 = AbstractRSSReader.count(this.getOddCounts());
                                                            n6 = AbstractRSSReader.count(this.getEvenCounts());
                                                            n5 = n7 + n6 - n5;
                                                            bl6 = (n7 & 1) == 1;
                                                            bl5 = (n6 & 1) == 0;
                                                            bl4 = false;
                                                            bl3 = false;
                                                            if (n7 > 13) {
                                                                bl3 = true;
                                                            } else if (n7 < 4) {
                                                                bl4 = true;
                                                            }
                                                            bl2 = false;
                                                            bl = false;
                                                            if (n6 > 13) {
                                                                bl = true;
                                                            } else if (n6 < 4) {
                                                                bl2 = true;
                                                            }
                                                            if (n5 != 1) break block19;
                                                            if (!bl6) break block20;
                                                            if (bl5) break block21;
                                                            bl3 = true;
                                                            break block22;
                                                        }
                                                        throw NotFoundException.getNotFoundInstance();
                                                    }
                                                    if (!bl5) break block23;
                                                    bl = true;
                                                    break block22;
                                                }
                                                throw NotFoundException.getNotFoundInstance();
                                            }
                                            if (n5 != -1) break block24;
                                            if (!bl6) break block25;
                                            if (bl5) break block26;
                                            bl4 = true;
                                            break block22;
                                        }
                                        throw NotFoundException.getNotFoundInstance();
                                    }
                                    if (!bl5) break block27;
                                    bl2 = true;
                                    break block22;
                                }
                                throw NotFoundException.getNotFoundInstance();
                            }
                            if (n5 != 0) break block28;
                            if (!bl6) break block29;
                            if (!bl5) break block30;
                            if (n7 < n6) {
                                bl4 = true;
                                bl = true;
                            } else {
                                bl3 = true;
                                bl2 = true;
                            }
                            break block22;
                        }
                        throw NotFoundException.getNotFoundInstance();
                    }
                    if (bl5) break block31;
                }
                if (bl4) {
                    if (!bl3) {
                        AbstractRSSReader.increment(this.getOddCounts(), this.getOddRoundingErrors());
                    } else {
                        throw NotFoundException.getNotFoundInstance();
                    }
                }
                if (bl3) {
                    AbstractRSSReader.decrement(this.getOddCounts(), this.getOddRoundingErrors());
                }
                if (bl2) {
                    if (!bl) {
                        AbstractRSSReader.increment(this.getEvenCounts(), this.getOddRoundingErrors());
                    } else {
                        throw NotFoundException.getNotFoundInstance();
                    }
                }
                if (bl) {
                    AbstractRSSReader.decrement(this.getEvenCounts(), this.getEvenRoundingErrors());
                    return;
                }
                return;
            }
            throw NotFoundException.getNotFoundInstance();
        }
        throw NotFoundException.getNotFoundInstance();
    }

    static {
        int[][] nArrayArray = new int[6][];
        int[] nArray = new int[4];
        Object object = nArray;
        nArray[0] = 1;
        nArray[1] = 8;
        nArray[2] = 4;
        nArray[3] = 1;
        nArrayArray[0] = object;
        int[] nArray2 = new int[4];
        object = nArray2;
        nArray2[0] = 3;
        nArray2[1] = 6;
        nArray2[2] = 4;
        nArray2[3] = 1;
        nArrayArray[1] = object;
        int[] nArray3 = new int[4];
        object = nArray3;
        nArray3[0] = 3;
        nArray3[1] = 4;
        nArray3[2] = 6;
        nArray3[3] = 1;
        nArrayArray[2] = object;
        int[] nArray4 = new int[4];
        object = nArray4;
        nArray4[0] = 3;
        nArray4[1] = 2;
        nArray4[2] = 8;
        nArray4[3] = 1;
        nArrayArray[3] = object;
        int[] nArray5 = new int[4];
        object = nArray5;
        nArray5[0] = 2;
        nArray5[1] = 6;
        nArray5[2] = 5;
        nArray5[3] = 1;
        nArrayArray[4] = object;
        int[] nArray6 = new int[4];
        object = nArray6;
        nArray6[0] = 2;
        nArray6[1] = 2;
        nArray6[2] = 9;
        nArray6[3] = 1;
        nArrayArray[5] = object;
        FINDER_PATTERNS = nArrayArray;
        object = new int[23][];
        int[] nArray7 = new int[8];
        int[] nArray8 = nArray7;
        nArray7[0] = 1;
        nArray7[1] = 3;
        nArray7[2] = 9;
        nArray7[3] = 27;
        nArray7[4] = 81;
        nArray7[5] = 32;
        nArray7[6] = 96;
        nArray7[7] = 77;
        object[0] = (int)nArray8;
        int[] nArray9 = new int[8];
        nArray8 = nArray9;
        nArray9[0] = 20;
        nArray9[1] = 60;
        nArray9[2] = 180;
        nArray9[3] = 118;
        nArray9[4] = 143;
        nArray9[5] = 7;
        nArray9[6] = 21;
        nArray9[7] = 63;
        object[1] = (int)nArray8;
        int[] nArray10 = new int[8];
        nArray8 = nArray10;
        nArray10[0] = 189;
        nArray10[1] = 145;
        nArray10[2] = 13;
        nArray10[3] = 39;
        nArray10[4] = 117;
        nArray10[5] = 140;
        nArray10[6] = 209;
        nArray10[7] = 205;
        object[2] = (int)nArray8;
        int[] nArray11 = new int[8];
        nArray8 = nArray11;
        nArray11[0] = 193;
        nArray11[1] = 157;
        nArray11[2] = 49;
        nArray11[3] = 147;
        nArray11[4] = 19;
        nArray11[5] = 57;
        nArray11[6] = 171;
        nArray11[7] = 91;
        object[3] = (int)nArray8;
        int[] nArray12 = new int[8];
        nArray8 = nArray12;
        nArray12[0] = 62;
        nArray12[1] = 186;
        nArray12[2] = 136;
        nArray12[3] = 197;
        nArray12[4] = 169;
        nArray12[5] = 85;
        nArray12[6] = 44;
        nArray12[7] = 132;
        object[4] = (int)nArray8;
        int[] nArray13 = new int[8];
        nArray8 = nArray13;
        nArray13[0] = 185;
        nArray13[1] = 133;
        nArray13[2] = 188;
        nArray13[3] = 142;
        nArray13[4] = 4;
        nArray13[5] = 12;
        nArray13[6] = 36;
        nArray13[7] = 108;
        object[5] = (int)nArray8;
        int[] nArray14 = new int[8];
        nArray8 = nArray14;
        nArray14[0] = 113;
        nArray14[1] = 128;
        nArray14[2] = 173;
        nArray14[3] = 97;
        nArray14[4] = 80;
        nArray14[5] = 29;
        nArray14[6] = 87;
        nArray14[7] = 50;
        object[6] = (int)nArray8;
        int[] nArray15 = new int[8];
        nArray8 = nArray15;
        nArray15[0] = 150;
        nArray15[1] = 28;
        nArray15[2] = 84;
        nArray15[3] = 41;
        nArray15[4] = 123;
        nArray15[5] = 158;
        nArray15[6] = 52;
        nArray15[7] = 156;
        object[7] = (int)nArray8;
        int[] nArray16 = new int[8];
        nArray8 = nArray16;
        nArray16[0] = 46;
        nArray16[1] = 138;
        nArray16[2] = 203;
        nArray16[3] = 187;
        nArray16[4] = 139;
        nArray16[5] = 206;
        nArray16[6] = 196;
        nArray16[7] = 166;
        object[8] = (int)nArray8;
        int[] nArray17 = new int[8];
        nArray8 = nArray17;
        nArray17[0] = 76;
        nArray17[1] = 17;
        nArray17[2] = 51;
        nArray17[3] = 153;
        nArray17[4] = 37;
        nArray17[5] = 111;
        nArray17[6] = 122;
        nArray17[7] = 155;
        object[9] = (int)nArray8;
        int[] nArray18 = new int[8];
        nArray8 = nArray18;
        nArray18[0] = 43;
        nArray18[1] = 129;
        nArray18[2] = 176;
        nArray18[3] = 106;
        nArray18[4] = 107;
        nArray18[5] = 110;
        nArray18[6] = 119;
        nArray18[7] = 146;
        object[10] = (int)nArray8;
        int[] nArray19 = new int[8];
        nArray8 = nArray19;
        nArray19[0] = 16;
        nArray19[1] = 48;
        nArray19[2] = 144;
        nArray19[3] = 10;
        nArray19[4] = 30;
        nArray19[5] = 90;
        nArray19[6] = 59;
        nArray19[7] = 177;
        object[11] = (int)nArray8;
        int[] nArray20 = new int[8];
        nArray8 = nArray20;
        nArray20[0] = 109;
        nArray20[1] = 116;
        nArray20[2] = 137;
        nArray20[3] = 200;
        nArray20[4] = 178;
        nArray20[5] = 112;
        nArray20[6] = 125;
        nArray20[7] = 164;
        object[12] = (int)nArray8;
        int[] nArray21 = new int[8];
        nArray8 = nArray21;
        nArray21[0] = 70;
        nArray21[1] = 210;
        nArray21[2] = 208;
        nArray21[3] = 202;
        nArray21[4] = 184;
        nArray21[5] = 130;
        nArray21[6] = 179;
        nArray21[7] = 115;
        object[13] = (int)nArray8;
        int[] nArray22 = new int[8];
        nArray8 = nArray22;
        nArray22[0] = 134;
        nArray22[1] = 191;
        nArray22[2] = 151;
        nArray22[3] = 31;
        nArray22[4] = 93;
        nArray22[5] = 68;
        nArray22[6] = 204;
        nArray22[7] = 190;
        object[14] = (int)nArray8;
        int[] nArray23 = new int[8];
        nArray8 = nArray23;
        nArray23[0] = 148;
        nArray23[1] = 22;
        nArray23[2] = 66;
        nArray23[3] = 198;
        nArray23[4] = 172;
        nArray23[5] = 94;
        nArray23[6] = 71;
        nArray23[7] = 2;
        object[15] = (int)nArray8;
        int[] nArray24 = new int[8];
        nArray8 = nArray24;
        nArray24[0] = 6;
        nArray24[1] = 18;
        nArray24[2] = 54;
        nArray24[3] = 162;
        nArray24[4] = 64;
        nArray24[5] = 192;
        nArray24[6] = 154;
        nArray24[7] = 40;
        object[16] = (int)nArray8;
        int[] nArray25 = new int[8];
        nArray8 = nArray25;
        nArray25[0] = 120;
        nArray25[1] = 149;
        nArray25[2] = 25;
        nArray25[3] = 75;
        nArray25[4] = 14;
        nArray25[5] = 42;
        nArray25[6] = 126;
        nArray25[7] = 167;
        object[17] = (int)nArray8;
        int[] nArray26 = new int[8];
        nArray8 = nArray26;
        nArray26[0] = 79;
        nArray26[1] = 26;
        nArray26[2] = 78;
        nArray26[3] = 23;
        nArray26[4] = 69;
        nArray26[5] = 207;
        nArray26[6] = 199;
        nArray26[7] = 175;
        object[18] = (int)nArray8;
        int[] nArray27 = new int[8];
        nArray8 = nArray27;
        nArray27[0] = 103;
        nArray27[1] = 98;
        nArray27[2] = 83;
        nArray27[3] = 38;
        nArray27[4] = 114;
        nArray27[5] = 131;
        nArray27[6] = 182;
        nArray27[7] = 124;
        object[19] = (int)nArray8;
        int[] nArray28 = new int[8];
        nArray8 = nArray28;
        nArray28[0] = 161;
        nArray28[1] = 61;
        nArray28[2] = 183;
        nArray28[3] = 127;
        nArray28[4] = 170;
        nArray28[5] = 88;
        nArray28[6] = 53;
        nArray28[7] = 159;
        object[20] = (int)nArray8;
        int[] nArray29 = new int[8];
        nArray8 = nArray29;
        nArray29[0] = 55;
        nArray29[1] = 165;
        nArray29[2] = 73;
        nArray29[3] = 8;
        nArray29[4] = 24;
        nArray29[5] = 72;
        nArray29[6] = 5;
        nArray29[7] = 15;
        object[21] = (int)nArray8;
        int[] nArray30 = new int[8];
        nArray8 = nArray30;
        nArray30[0] = 45;
        nArray30[1] = 135;
        nArray30[2] = 194;
        nArray30[3] = 160;
        nArray30[4] = 58;
        nArray30[5] = 174;
        nArray30[6] = 100;
        nArray30[7] = 89;
        object[22] = (int)nArray8;
        WEIGHTS = (int[][])object;
        int[][] nArrayArray2 = new int[10][];
        int[] nArray31 = new int[2];
        object = nArray31;
        nArray31[0] = 0;
        nArray31[1] = 0;
        nArrayArray2[0] = object;
        int[] nArray32 = new int[3];
        object = nArray32;
        nArray32[0] = 0;
        nArray32[1] = 1;
        nArray32[2] = 1;
        nArrayArray2[1] = object;
        int[] nArray33 = new int[4];
        object = nArray33;
        nArray33[0] = 0;
        nArray33[1] = 2;
        nArray33[2] = 1;
        nArray33[3] = 3;
        nArrayArray2[2] = object;
        int[] nArray34 = new int[5];
        object = nArray34;
        nArray34[0] = 0;
        nArray34[1] = 4;
        nArray34[2] = 1;
        nArray34[3] = 3;
        nArray34[4] = 2;
        nArrayArray2[3] = object;
        int[] nArray35 = new int[6];
        object = nArray35;
        nArray35[0] = 0;
        nArray35[1] = 4;
        nArray35[2] = 1;
        nArray35[3] = 3;
        nArray35[4] = 3;
        nArray35[5] = 5;
        nArrayArray2[4] = object;
        int[] nArray36 = new int[7];
        object = nArray36;
        nArray36[0] = 0;
        nArray36[1] = 4;
        nArray36[2] = 1;
        nArray36[3] = 3;
        nArray36[4] = 4;
        nArray36[5] = 5;
        nArray36[6] = 5;
        nArrayArray2[5] = object;
        int[] nArray37 = new int[8];
        object = nArray37;
        nArray37[0] = 0;
        nArray37[1] = 0;
        nArray37[2] = 1;
        nArray37[3] = 1;
        nArray37[4] = 2;
        nArray37[5] = 2;
        nArray37[6] = 3;
        nArray37[7] = 3;
        nArrayArray2[6] = object;
        int[] nArray38 = new int[9];
        object = nArray38;
        nArray38[0] = 0;
        nArray38[1] = 0;
        nArray38[2] = 1;
        nArray38[3] = 1;
        nArray38[4] = 2;
        nArray38[5] = 2;
        nArray38[6] = 3;
        nArray38[7] = 4;
        nArray38[8] = 4;
        nArrayArray2[7] = object;
        int[] nArray39 = new int[10];
        object = nArray39;
        nArray39[0] = 0;
        nArray39[1] = 0;
        nArray39[2] = 1;
        nArray39[3] = 1;
        nArray39[4] = 2;
        nArray39[5] = 2;
        nArray39[6] = 3;
        nArray39[7] = 4;
        nArray39[8] = 5;
        nArray39[9] = 5;
        nArrayArray2[8] = object;
        int[] nArray40 = new int[11];
        object = nArray40;
        nArray40[0] = 0;
        nArray40[1] = 0;
        nArray40[2] = 1;
        nArray40[3] = 1;
        nArray40[4] = 2;
        nArray40[5] = 3;
        nArray40[6] = 3;
        nArray40[7] = 4;
        nArray40[8] = 4;
        nArray40[9] = 5;
        nArray40[10] = 5;
        nArrayArray2[9] = object;
        FINDER_PATTERN_SEQUENCES = nArrayArray2;
    }

    @Override
    public Result decodeRow(int n5, BitArray bitArray, Map<DecodeHintType, ?> map) throws NotFoundException, FormatException {
        this.pairs.clear();
        this.startFromEven = false;
        try {
            return RSSExpandedReader.constructResult(this.decodeRow2pairs(n5, bitArray));
        }
        catch (NotFoundException notFoundException) {
            this.pairs.clear();
            this.startFromEven = true;
            return RSSExpandedReader.constructResult(this.decodeRow2pairs(n5, bitArray));
        }
    }

    @Override
    public void reset() {
        RSSExpandedReader rSSExpandedReader = this;
        rSSExpandedReader.pairs.clear();
        rSSExpandedReader.rows.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<ExpandedPair> decodeRow2pairs(int n5, BitArray bitArray) throws NotFoundException {
        try {
            while (true) {
                RSSExpandedReader rSSExpandedReader = this;
                ExpandedPair expandedPair = rSSExpandedReader.retrieveNextPair(bitArray, ((RSSExpandedReader)this).pairs, n5);
                rSSExpandedReader.pairs.add(expandedPair);
            }
        }
        catch (NotFoundException notFoundException) {
            if (((RSSExpandedReader)this).pairs.isEmpty()) {
                throw notFoundException;
            }
            if (((RSSExpandedReader)this).checkChecksum()) {
                return ((RSSExpandedReader)this).pairs;
            }
            boolean bl = ((RSSExpandedReader)this).rows.isEmpty();
            ((RSSExpandedReader)this).storeRow(n5, false);
            if (!bl) {
                List<ExpandedPair> list = ((RSSExpandedReader)this).checkRows(false);
                if (list != null) {
                    return list;
                }
                if ((this = ((RSSExpandedReader)this).checkRows(true)) != null) {
                    return this;
                }
            }
            throw NotFoundException.getNotFoundInstance();
        }
    }

    List<ExpandedRow> getRows() {
        return this.rows;
    }

    ExpandedPair retrieveNextPair(BitArray bitArray, List<ExpandedPair> list, int n5) throws NotFoundException {
        Object object;
        FinderPattern finderPattern;
        boolean bl = list.size() % 2 == 0;
        if (((RSSExpandedReader)object).startFromEven) {
            bl ^= true;
        }
        boolean bl2 = true;
        int n6 = -1;
        do {
            RSSExpandedReader rSSExpandedReader = object;
            rSSExpandedReader.findNextPair(bitArray, list, n6);
            finderPattern = rSSExpandedReader.parseFoundFinderPattern(bitArray, n5, bl);
            if (finderPattern == null) {
                n6 = RSSExpandedReader.getNextSecondBar(bitArray, ((RSSExpandedReader)object).startEnd[0]);
                continue;
            }
            bl2 = false;
        } while (bl2);
        DataCharacter dataCharacter = ((RSSExpandedReader)object).decodeDataCharacter(bitArray, finderPattern, bl, true);
        if (!list.isEmpty()) {
            List<ExpandedPair> list2 = list;
            if (list2.get(list2.size() - 1).mustBeLast()) {
                throw NotFoundException.getNotFoundInstance();
            }
        }
        try {
            object = ((RSSExpandedReader)object).decodeDataCharacter(bitArray, finderPattern, bl, false);
        }
        catch (NotFoundException notFoundException) {
            object = null;
        }
        return new ExpandedPair(dataCharacter, (DataCharacter)object, finderPattern, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DataCharacter decodeDataCharacter(BitArray bitArray, FinderPattern finderPattern, boolean bl, boolean bl2) throws NotFoundException {
        int n5;
        int[] nArray = this.getDataCharacterCounters();
        int[] nArray2 = nArray;
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 0;
        nArray[6] = 0;
        nArray[7] = 0;
        if (bl2) {
            OneDReader.recordPatternInReverse(bitArray, finderPattern.getStartEnd()[0], nArray2);
        } else {
            OneDReader.recordPattern(bitArray, finderPattern.getStartEnd()[1], nArray2);
            int n6 = 0;
            for (int i5 = nArray2.length - 1; n6 < i5; ++n6, --i5) {
                int[] nArray3 = nArray2;
                int[] nArray4 = nArray2;
                int n7 = nArray3[n6];
                nArray3[n6] = nArray4[i5];
                nArray4[i5] = n7;
            }
        }
        int n8 = 17;
        float f5 = (float)AbstractRSSReader.count(nArray2) / (float)n8;
        float f6 = (float)(finderPattern.getStartEnd()[1] - finderPattern.getStartEnd()[0]) / 15.0f;
        if (Math.abs(f5 - f6) / f6 > 0.3f) throw NotFoundException.getNotFoundInstance();
        RSSExpandedReader rSSExpandedReader = this;
        int[] nArray5 = rSSExpandedReader.getOddCounts();
        int[] nArray6 = rSSExpandedReader.getEvenCounts();
        float[] fArray = rSSExpandedReader.getOddRoundingErrors();
        float[] fArray2 = rSSExpandedReader.getEvenRoundingErrors();
        for (int i6 = 0; i6 < nArray2.length; ++i6) {
            float f7 = (float)nArray2[i6] * 1.0f / f5;
            int n9 = (int)(f7 + 0.5f);
            if (n9 < 1) {
                if (f7 < 0.3f) throw NotFoundException.getNotFoundInstance();
                n9 = 1;
            } else if (n9 > 8) {
                if (f7 > 8.7f) throw NotFoundException.getNotFoundInstance();
                n9 = 8;
            }
            int n10 = i6;
            int n11 = n10 / 2;
            if ((n10 & 1) == 0) {
                nArray5[n11] = n9;
                fArray[n11] = f7 - (float)n9;
                continue;
            }
            nArray6[n11] = n9;
            fArray2[n11] = f7 - (float)n9;
        }
        this.adjustOddEvenCounts(n8);
        int n12 = finderPattern.getValue() * 4;
        n8 = bl ? 0 : 2;
        n12 = n12 + n8 + (bl2 ^ 1) - 1;
        n8 = 0;
        int n13 = 0;
        for (n5 = nArray5.length - 1; n5 >= 0; --n5) {
            if (RSSExpandedReader.isNotA1left(finderPattern, bl, bl2)) {
                int n14 = n13;
                n13 = WEIGHTS[n12][n5 * 2];
                n13 = n14 + nArray5[n5] * n13;
            }
            n8 += nArray5[n5];
        }
        n5 = 0;
        for (int i7 = nArray6.length - 1; i7 >= 0; --i7) {
            if (!RSSExpandedReader.isNotA1left(finderPattern, bl, bl2)) continue;
            int n15 = n5;
            n5 = WEIGHTS[n12][i7 * 2 + 1];
            n5 = n15 + nArray6[i7] * n5;
        }
        n12 = n13 + n5;
        if ((n8 & 1) != 0 || n8 > 13 || n8 < 4) throw NotFoundException.getNotFoundInstance();
        n8 = (13 - n8) / 2;
        int n16 = SYMBOL_WIDEST[n8];
        int n17 = 9 - n16;
        n17 = RSSUtils.getRSSvalue(nArray6, n17, false);
        int n18 = EVEN_TOTAL_SUBSET[n8];
        n8 = GSUM[n8];
        n8 = RSSUtils.getRSSvalue(nArray5, n16, true) * n18 + n17 + n8;
        return new DataCharacter(n8, n12);
    }
}

