/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3;

import androidx.annotation.Nullable;
import dc.squareup.okhttp3.MediaType;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okio.BufferedSink;
import dc.squareup.okio.ByteString;
import dc.squareup.okio.Okio;
import dc.squareup.okio.Source;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public abstract class RequestBody {
    public static RequestBody create(@Nullable MediaType mediaType, String string2) {
        Charset charset;
        Charset charset2 = Util.UTF_8;
        if (mediaType != null && (charset = mediaType.charset()) != null) {
            charset2 = charset;
        }
        return RequestBody.create(mediaType, string2.getBytes(charset2));
    }

    public static RequestBody createWithBytes(@Nullable MediaType mediaType, byte[] byArray) {
        return RequestBody.create(mediaType, byArray);
    }

    public static RequestBody create(final @Nullable MediaType mediaType, final ByteString byteString) {
        return new RequestBody(){

            @Override
            @Nullable
            public MediaType contentType() {
                return mediaType;
            }

            @Override
            public long contentLength() throws IOException {
                return byteString.size();
            }

            @Override
            public void writeTo(BufferedSink bufferedSink) throws IOException {
                bufferedSink.write(byteString);
            }
        };
    }

    public static RequestBody create(@Nullable MediaType mediaType, byte[] byArray) {
        return RequestBody.create(mediaType, byArray, 0, byArray.length);
    }

    public static RequestBody create(final @Nullable MediaType mediaType, final byte[] byArray, final int n5, final int n6) {
        if (byArray != null) {
            long l5 = n5;
            long l6 = n6;
            Util.checkOffsetAndCount(byArray.length, l5, l6);
            return new RequestBody(){

                @Override
                @Nullable
                public MediaType contentType() {
                    return mediaType;
                }

                @Override
                public long contentLength() {
                    return n6;
                }

                @Override
                public void writeTo(BufferedSink bufferedSink) throws IOException {
                    2 v02 = object;
                    Object object = v02.byArray;
                    int n52 = v02.n5;
                    int n62 = v02.n6;
                    bufferedSink.write((byte[])object, n52, n62);
                }
            };
        }
        throw new NullPointerException("content == null");
    }

    public static RequestBody create(final @Nullable MediaType mediaType, final File file) {
        if (file != null) {
            return new RequestBody(){

                @Override
                @Nullable
                public MediaType contentType() {
                    return mediaType;
                }

                @Override
                public long contentLength() {
                    return file.length();
                }

                @Override
                public void writeTo(BufferedSink bufferedSink) throws IOException {
                    3 v02 = object;
                    Object object = null;
                    try {
                        object = Okio.source(v02.file);
                    }
                    catch (Throwable throwable) {
                        Util.closeQuietly((Closeable)object);
                        throw throwable;
                    }
                    bufferedSink.writeAll((Source)object);
                    Util.closeQuietly((Closeable)object);
                }
            };
        }
        throw new NullPointerException("file == null");
    }

    @Nullable
    public abstract MediaType contentType();

    public long contentLength() throws IOException {
        return -1L;
    }

    public abstract void writeTo(BufferedSink var1) throws IOException;
}

