/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.connection;

import dc.squareup.okhttp3.ConnectionSpec;
import dc.squareup.okhttp3.internal.Internal;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.UnknownServiceException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocket;

public final class ConnectionSpecSelector {
    private final List<ConnectionSpec> connectionSpecs;
    private int nextModeIndex = 0;
    private boolean isFallbackPossible;
    private boolean isFallback;

    public ConnectionSpecSelector(List<ConnectionSpec> list) {
        this.connectionSpecs = list;
    }

    private boolean isFallbackPossible(SSLSocket sSLSocket) {
        for (int i5 = this.nextModeIndex; i5 < this.connectionSpecs.size(); ++i5) {
            if (!this.connectionSpecs.get(i5).isCompatible(sSLSocket)) continue;
            return true;
        }
        return false;
    }

    public ConnectionSpec configureSecureSocket(SSLSocket sSLSocket) throws IOException {
        ConnectionSpec connectionSpec = null;
        int n5 = this.connectionSpecs.size();
        for (int i5 = (v198083).nextModeIndex; i5 < n5; ++i5) {
            ConnectionSpec connectionSpec2 = this.connectionSpecs.get(i5);
            if (!connectionSpec2.isCompatible(sSLSocket)) continue;
            this.nextModeIndex = i5 + 1;
            connectionSpec = connectionSpec2;
            break;
        }
        if (connectionSpec != null) {
            this.isFallbackPossible = this.isFallbackPossible(sSLSocket);
            Internal.instance.apply(connectionSpec, sSLSocket, this.isFallback);
            return connectionSpec;
        }
        throw new UnknownServiceException("Unable to find acceptable protocols. isFallback=" + this.isFallback + ", modes=" + this.connectionSpecs + ", supported protocols=" + Arrays.toString(sSLSocket.getEnabledProtocols()));
    }

    public boolean connectionFailed(IOException iOException) {
        this.isFallback = true;
        if (!this.isFallbackPossible) {
            return false;
        }
        if (iOException instanceof ProtocolException) {
            return false;
        }
        if (iOException instanceof InterruptedIOException) {
            return false;
        }
        boolean bl = iOException instanceof SSLHandshakeException;
        if (bl && iOException.getCause() instanceof CertificateException) {
            return false;
        }
        if (iOException instanceof SSLPeerUnverifiedException) {
            return false;
        }
        return bl || iOException instanceof SSLProtocolException || iOException instanceof SSLException;
        {
        }
    }
}

