/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.http2;

import dc.squareup.okhttp3.Headers;
import dc.squareup.okhttp3.Protocol;
import dc.squareup.okhttp3.internal.NamedRunnable;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.http2.ConnectionShutdownException;
import dc.squareup.okhttp3.internal.http2.ErrorCode;
import dc.squareup.okhttp3.internal.http2.Header;
import dc.squareup.okhttp3.internal.http2.Http2Reader;
import dc.squareup.okhttp3.internal.http2.Http2Stream;
import dc.squareup.okhttp3.internal.http2.Http2Writer;
import dc.squareup.okhttp3.internal.http2.PushObserver;
import dc.squareup.okhttp3.internal.http2.Settings;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSink;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.ByteString;
import dc.squareup.okio.Okio;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class Http2Connection
implements Closeable {
    static final int OKHTTP_CLIENT_WINDOW_SIZE = 0x1000000;
    static final int INTERVAL_PING = 1;
    static final int DEGRADED_PING = 2;
    static final int AWAIT_PING = 3;
    static final long DEGRADED_PONG_TIMEOUT_NS = 1000000000L;
    private static final ExecutorService listenerExecutor;
    static final /* synthetic */ boolean $assertionsDisabled;
    final boolean client;
    final Listener listener;
    final Map<Integer, Http2Stream> streams;
    final String hostname;
    int lastGoodStreamId;
    int nextStreamId;
    private boolean shutdown;
    private final ScheduledExecutorService writerExecutor;
    private final ExecutorService pushExecutor;
    final PushObserver pushObserver;
    private long intervalPingsSent;
    private long intervalPongsReceived;
    private long degradedPingsSent;
    private long degradedPongsReceived;
    private long awaitPingsSent;
    private long awaitPongsReceived;
    private long degradedPongDeadlineNs;
    long unacknowledgedBytesRead;
    long bytesLeftInWriteWindow;
    Settings okHttpSettings;
    final Settings peerSettings;
    final Socket socket;
    final Http2Writer writer;
    final ReaderRunnable readerRunnable;
    final Set<Integer> currentPushRequests;

    Http2Connection(Builder builder) {
        Http2Reader http2Reader;
        ReaderRunnable readerRunnable;
        Http2Writer http2Writer;
        long l5;
        LinkedBlockingQueue linkedBlockingQueue;
        ThreadPoolExecutor threadPoolExecutor;
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
        boolean bl;
        LinkedHashSet<Integer> linkedHashSet;
        Settings settings;
        Settings settings2;
        LinkedHashMap<Integer, Http2Stream> linkedHashMap;
        Builder builder2 = builder;
        Object object = linkedHashMap;
        linkedHashMap = new LinkedHashMap<Integer, Http2Stream>();
        this.streams = object;
        this.intervalPingsSent = 0L;
        this.intervalPongsReceived = 0L;
        this.degradedPingsSent = 0L;
        this.degradedPongsReceived = 0L;
        this.awaitPingsSent = 0L;
        this.awaitPongsReceived = 0L;
        this.degradedPongDeadlineNs = 0L;
        this.unacknowledgedBytesRead = 0L;
        object = settings2;
        settings2 = new Settings();
        this.okHttpSettings = object;
        object = settings;
        settings = new Settings();
        this.peerSettings = object;
        LinkedHashSet<Integer> linkedHashSet2 = linkedHashSet;
        linkedHashSet = new LinkedHashSet<Integer>();
        this.currentPushRequests = linkedHashSet2;
        this.pushObserver = builder2.pushObserver;
        this.client = bl = builder2.client;
        this.listener = builder.listener;
        int n5 = bl ? 1 : 2;
        this.nextStreamId = n5;
        if (bl) {
            this.nextStreamId = n5 + 2;
        }
        if (bl) {
            this.okHttpSettings.set(7, 0x1000000);
        }
        Builder builder3 = builder;
        Object object2 = builder3.hostname;
        this.hostname = object2;
        Object object3 = scheduledThreadPoolExecutor;
        Object[] objectArray = new Object[1];
        Object object4 = objectArray;
        objectArray[0] = object2;
        scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, Util.threadFactory(Util.format("OkHttp %s Writer", object4), false));
        this.writerExecutor = object3;
        if (builder3.pingIntervalMillis != 0) {
            IntervalPingRunnable intervalPingRunnable;
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor2 = object3;
            object3 = intervalPingRunnable;
            intervalPingRunnable = new IntervalPingRunnable(this);
            int n6 = builder.pingIntervalMillis;
            long l6 = n6;
            long l7 = n6;
            TimeUnit timeUnit = TimeUnit.MILLISECONDS;
            scheduledThreadPoolExecutor2.scheduleAtFixedRate((Runnable)object3, l6, l7, timeUnit);
        }
        Object object5 = object;
        object = threadPoolExecutor;
        object3 = TimeUnit.SECONDS;
        object4 = linkedBlockingQueue;
        linkedBlockingQueue = new LinkedBlockingQueue();
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = object2;
        object2 = Util.threadFactory(Util.format("OkHttp %s Push Observer", objectArray3), true);
        threadPoolExecutor = new ThreadPoolExecutor(0, 1, 60L, (TimeUnit)((Object)object3), (BlockingQueue<Runnable>)object4, (ThreadFactory)object2);
        this.pushExecutor = object;
        ((Settings)object5).set(7, 65535);
        ((Settings)object5).set(5, 16384);
        this.bytesLeftInWriteWindow = l5 = (long)((Settings)object5).getInitialWindowSize();
        this.socket = builder.socket;
        object = http2Writer;
        http2Writer = new Http2Writer(builder.sink, bl);
        this.writer = object;
        object = readerRunnable;
        Http2Reader http2Reader2 = http2Reader;
        http2Reader = new Http2Reader(builder.source, bl);
        readerRunnable = new ReaderRunnable(this, http2Reader2);
        this.readerRunnable = object;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private Http2Stream newStream(int var1_1, List<Header> var2_2, boolean var3_3) throws IOException {
        block14: {
            block16: {
                block17: {
                    block15: {
                        v0 = this;
                        var4_4 = var3_3 ^ true;
                        var5_5 = false;
                        var6_6 = v0.writer;
                        // MONITORENTER : var6_6
                        if (v0.nextStreamId > 0x3FFFFFFF) {
                            this.shutdown(ErrorCode.REFUSED_STREAM);
                        }
                        if (this.shutdown) break block14;
                        v1 = var3_3;
                        var3_3 = this.nextStreamId;
                        this.nextStreamId = var3_3 + 2;
                        var7_7 = v2;
                        v2 = new Http2Stream((int)var3_3, this, var4_4, var5_5, null);
                        var5_5 = !v1 || this.bytesLeftInWriteWindow == 0L || var7_7.bytesLeftInWriteWindow == 0L;
                        if (!var7_7.isOpen()) break block15;
                        this.streams.put((int)var3_3, var7_7);
                    }
                    // MONITOREXIT : this
                    if (var1_1 != 0) ** GOTO lbl27
                    this.writer.synStream(var4_4, (int)var3_3, var1_1, var2_2);
                    break block17;
lbl27:
                    // 1 sources

                    if (this.client) break block16;
                    this.writer.pushPromise(var1_1, (int)var3_3, var2_2);
                }
                // MONITOREXIT : var6_6
                if (var5_5 == false) return var7_7;
                this.writer.flush();
                return var7_7;
            }
            throw new IllegalArgumentException("client streams shouldn't have associated stream IDs");
        }
        try {
            throw new ConnectionShutdownException();
        }
        catch (Throwable v4) {}
        throw v4;
    }

    private void failConnection() {
        try {
            ErrorCode errorCode = ErrorCode.PROTOCOL_ERROR;
            this.close(errorCode, errorCode);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private synchronized void pushExecutorExecute(NamedRunnable namedRunnable) {
        if (!this.shutdown) {
            this.pushExecutor.execute(namedRunnable);
            return;
        }
    }

    static /* synthetic */ long access$208(Http2Connection http2Connection) {
        long l5 = http2Connection.intervalPingsSent;
        http2Connection.intervalPingsSent = l5 + 1L;
        return l5;
    }

    static /* synthetic */ boolean access$300(Http2Connection http2Connection) {
        return http2Connection.shutdown;
    }

    static /* synthetic */ ExecutorService access$400() {
        return listenerExecutor;
    }

    static /* synthetic */ long access$108(Http2Connection http2Connection) {
        long l5 = http2Connection.intervalPongsReceived;
        http2Connection.intervalPongsReceived = l5 + 1L;
        return l5;
    }

    static /* synthetic */ long access$608(Http2Connection http2Connection) {
        long l5 = http2Connection.degradedPongsReceived;
        http2Connection.degradedPongsReceived = l5 + 1L;
        return l5;
    }

    static /* synthetic */ long access$708(Http2Connection http2Connection) {
        long l5 = http2Connection.awaitPongsReceived;
        http2Connection.awaitPongsReceived = l5 + 1L;
        return l5;
    }

    static /* synthetic */ boolean access$302(Http2Connection http2Connection, boolean bl) {
        http2Connection.shutdown = bl;
        return bl;
    }

    static {
        SynchronousQueue<Runnable> synchronousQueue;
        $assertionsDisabled = Http2Connection.class.desiredAssertionStatus() ^ true;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        SynchronousQueue<Runnable> synchronousQueue2 = synchronousQueue;
        synchronousQueue = new SynchronousQueue<Runnable>();
        ThreadFactory threadFactory = Util.threadFactory("OkHttp Http2Connection", true);
        listenerExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, timeUnit, synchronousQueue2, threadFactory);
    }

    public Protocol getProtocol() {
        return Protocol.HTTP_2;
    }

    public synchronized int openStreamCount() {
        return this.streams.size();
    }

    synchronized Http2Stream getStream(int n5) {
        return this.streams.get(n5);
    }

    synchronized Http2Stream removeStream(int n5) {
        this.notifyAll();
        return this.streams.remove(n5);
    }

    public synchronized int maxConcurrentStreams() {
        return this.peerSettings.getMaxConcurrentStreams(Integer.MAX_VALUE);
    }

    synchronized void updateConnectionFlowControl(long l5) {
        this.unacknowledgedBytesRead = l5 = this.unacknowledgedBytesRead + l5;
        if (l5 >= (long)(this.okHttpSettings.getInitialWindowSize() / 2)) {
            Http2Connection http2Connection = this;
            long l6 = http2Connection.unacknowledgedBytesRead;
            http2Connection.writeWindowUpdateLater(0, l6);
            http2Connection.unacknowledgedBytesRead = 0L;
            return;
        }
    }

    public Http2Stream pushStream(int n5, List<Header> list, boolean bl) throws IOException {
        if (!this.client) {
            return this.newStream(n5, list, bl);
        }
        throw new IllegalStateException("Client cannot push requests.");
    }

    public Http2Stream newStream(List<Header> list, boolean bl) throws IOException {
        return this.newStream(0, list, bl);
    }

    void writeSynReply(int n5, boolean bl, List<Header> list) throws IOException {
        this.writer.synReply(bl, n5, list);
    }

    /*
     * Exception decompiling
     */
    public void writeData(int var1_1, boolean var2_2, Buffer var3_3, long var4_4) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [7 : 70->95)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void writeSynResetLater(int n5, ErrorCode errorCode) {
        Http2Connection http2Connection;
        int n6;
        Http2Connection http2Connection2;
        1 v32;
        1 v12;
        ScheduledExecutorService scheduledExecutorService;
        try {
            1 v22;
            scheduledExecutorService = ((Http2Connection)((Object)string2)).writerExecutor;
            v12 = v22;
            v32 = v22;
            http2Connection2 = string2;
            n6 = n5;
            http2Connection = string2;
            String string2 = "OkHttp %s stream %d";
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return;
        }
        String string3 = http2Connection.hostname;
        Integer n7 = n6;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string3;
        objectArray[1] = n7;
        v12(string2, objectArray2, n5, errorCode);
        scheduledExecutorService.execute(v32);
    }

    void writeSynReset(int n5, ErrorCode errorCode) throws IOException {
        this.writer.rstStream(n5, errorCode);
    }

    void writeWindowUpdateLater(int n5, long l5) {
        Http2Connection http2Connection;
        int n6;
        Http2Connection http2Connection2;
        2 v32;
        2 v12;
        ScheduledExecutorService scheduledExecutorService;
        try {
            2 v22;
            scheduledExecutorService = ((Http2Connection)((Object)string2)).writerExecutor;
            v12 = v22;
            v32 = v22;
            http2Connection2 = string2;
            n6 = n5;
            http2Connection = string2;
            String string2 = "OkHttp Window Update %s stream %d";
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return;
        }
        String string3 = http2Connection.hostname;
        Integer n7 = n6;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string3;
        objectArray[1] = n7;
        v12(string2, objectArray2, n5, l5);
        scheduledExecutorService.execute(v32);
    }

    void writePing(boolean bl, int n5, int n6) {
        try {
            this.writer.ping(bl, n5, n6);
            return;
        }
        catch (IOException iOException) {
            this.failConnection();
            return;
        }
    }

    void writePingAndAwaitPong() throws InterruptedException {
        Http2Connection http2Connection = this;
        http2Connection.writePing();
        http2Connection.awaitPong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writePing() {
        Http2Connection http2Connection = this;
        synchronized (http2Connection) {
            long l5 = http2Connection.awaitPingsSent;
            http2Connection.awaitPingsSent = l5 + 1L;
            // MONITOREXIT @DISABLED, blocks:[1, 2] lbl7 : MonitorExitStatement: MONITOREXIT : v219205
            http2Connection.writePing(false, 3, 1330343787);
            return;
        }
    }

    synchronized void awaitPong() throws InterruptedException {
        while (this.awaitPongsReceived < this.awaitPingsSent) {
            this.wait();
        }
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void shutdown(ErrorCode errorCode) throws IOException {
        Http2Writer http2Writer;
        block9: {
            Http2Connection http2Connection = this;
            http2Writer = http2Connection.writer;
            // MONITORENTER : http2Writer
            if (!http2Connection.shutdown) break block9;
            Http2Writer http2Writer2 = http2Writer;
            // MONITOREXIT : this
            // MONITOREXIT : http2Writer2
            return;
        }
        Http2Writer http2Writer3 = http2Writer;
        Http2Connection http2Connection = this;
        Http2Connection http2Connection2 = http2Connection;
        http2Connection.shutdown = true;
        int n5 = http2Connection.lastGoodStreamId;
        // MONITOREXIT : http2Connection
        http2Connection2.writer.goAway(n5, errorCode, Util.EMPTY_BYTE_ARRAY);
        // MONITOREXIT : http2Writer3
    }

    @Override
    public void close() throws IOException {
        this.close(ErrorCode.NO_ERROR, ErrorCode.CANCEL);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void close(ErrorCode object, ErrorCode errorCode) throws IOException {
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        Object object2 = object;
        object = null;
        try {
            this.shutdown((ErrorCode)((Object)object2));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Http2Connection http2Connection = this;
        Http2Stream[] http2StreamArray = null;
        synchronized (http2Connection) {
            block17: {
                block16: {
                    int n5;
                    block18: {
                        try {
                            if (!http2Connection.streams.isEmpty()) {
                                Http2Connection http2Connection2 = this;
                                http2StreamArray = http2Connection2.streams.values().toArray(new Http2Stream[this.streams.size()]);
                                http2Connection2.streams.clear();
                            }
                            // ** MonitorExit[this] (shouldn't be in output)
                            if (http2StreamArray == null) break block16;
                        }
                        catch (Throwable throwable) {}
                        n5 = http2StreamArray.length;
                        break block18;
                        // ** MonitorExit[this] (shouldn't be in output)
                        throw throwable;
                    }
                    for (int i5 = 0; i5 < n5; ++i5) {
                        try {
                            http2StreamArray[i5].close(errorCode);
                            continue;
                        }
                        catch (IOException iOException) {
                            if (object == null) continue;
                            object = iOException;
                        }
                    }
                }
                try {
                    this.writer.close();
                }
                catch (IOException iOException) {
                    if (object != null) break block17;
                    object = iOException;
                }
            }
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Http2Connection http2Connection3 = this;
            http2Connection3.writerExecutor.shutdown();
            http2Connection3.pushExecutor.shutdown();
            if (object == null) {
                return;
            }
            throw object;
        }
    }

    public void start() throws IOException {
        this.start(true);
    }

    void start(boolean n5) throws IOException {
        if (n5) {
            Http2Connection http2Connection = this;
            http2Connection.writer.connectionPreface();
            http2Connection.writer.settings(this.okHttpSettings);
            n5 = http2Connection.okHttpSettings.getInitialWindowSize();
            if (n5 != 65535) {
                long l5 = n5 - 65535;
                this.writer.windowUpdate(0, l5);
            }
        }
        new Thread(this.readerRunnable).start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setSettings(Settings settings) throws IOException {
        block9: {
            Http2Connection http2Connection = this;
            Http2Writer http2Writer = http2Connection.writer;
            // MONITORENTER : http2Writer
            if (http2Connection.shutdown) break block9;
            Http2Writer http2Writer2 = http2Writer;
            Http2Connection http2Connection2 = this;
            Http2Connection http2Connection3 = http2Connection2;
            http2Connection2.okHttpSettings.merge(settings);
            // MONITOREXIT : http2Connection2
            http2Connection3.writer.settings(settings);
            // MONITOREXIT : http2Writer2
            return;
        }
        try {
            throw new ConnectionShutdownException();
        }
        catch (Throwable throwable) {}
        throw throwable;
    }

    public synchronized boolean isHealthy(long l5) {
        if (this.shutdown) {
            return false;
        }
        return this.degradedPongsReceived >= this.degradedPingsSent || l5 < this.degradedPongDeadlineNs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void sendDegradedPingLater() {
        Object[] objectArray;
        Object[] objectArray2;
        String string2;
        Http2Connection http2Connection;
        3 v6;
        3 v42;
        ScheduledExecutorService scheduledExecutorService;
        Object[] objectArray3;
        Http2Connection http2Connection2 = objectArray3;
        // MONITORENTER : http2Connection2
        long l5 = objectArray3.degradedPingsSent;
        if (http2Connection2.degradedPongsReceived < l5) {
            // MONITOREXIT : objectArray3
            return;
        }
        Http2Connection http2Connection3 = objectArray3;
        http2Connection3.degradedPingsSent = l5 + 1L;
        http2Connection3.degradedPongDeadlineNs = System.nanoTime() + 1000000000L;
        // MONITOREXIT : http2Connection3
        try {
            3 v5;
            scheduledExecutorService = http2Connection3.writerExecutor;
            v42 = v5;
            v6 = v5;
            Http2Connection http2Connection4 = objectArray3;
            http2Connection = http2Connection4;
            objectArray3 = "OkHttp %s ping";
            string2 = http2Connection4.hostname;
            objectArray2 = objectArray3;
            objectArray = new Object[1];
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return;
        }
        objectArray3 = objectArray;
        objectArray[0] = string2;
        v42((String)objectArray2, objectArray3);
        scheduledExecutorService.execute(v6);
    }

    boolean pushedStream(int n5) {
        return n5 != 0 && (n5 & 1) == 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void pushRequestLater(int n5, List<Header> list) {
        Object[] objectArray;
        Object[] objectArray2;
        Integer n6;
        String string2;
        Http2Connection http2Connection;
        4 v7;
        4 v5;
        Object[] objectArray3;
        Http2Connection http2Connection2 = objectArray3;
        // MONITORENTER : http2Connection2
        if (http2Connection2.currentPushRequests.contains(n5)) {
            Http2Connection http2Connection3 = objectArray3;
            http2Connection3.writeSynResetLater(n5, ErrorCode.PROTOCOL_ERROR);
            // MONITOREXIT : http2Connection3
            return;
        }
        Http2Connection http2Connection4 = objectArray3;
        Http2Connection http2Connection5 = http2Connection4;
        http2Connection4.currentPushRequests.add(n5);
        try {
            4 v6;
            v5 = v6;
            v7 = v6;
            http2Connection = objectArray3;
            Http2Connection http2Connection6 = objectArray3;
            objectArray3 = "OkHttp %s Push Request[%s]";
            string2 = http2Connection6.hostname;
            n6 = n5;
            objectArray2 = objectArray3;
            objectArray = new Object[2];
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return;
        }
        objectArray3 = objectArray;
        objectArray[0] = string2;
        objectArray[1] = n6;
        v5((String)objectArray2, objectArray3, n5, list);
        http2Connection4.pushExecutorExecute(v7);
    }

    void pushHeadersLater(final int n5, final List<Header> list, final boolean bl) {
        NamedRunnable namedRunnable;
        Http2Connection http2Connection;
        try {
            http2Connection = this;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return;
        }
        NamedRunnable namedRunnable2 = namedRunnable;
        int n6 = n5;
        Http2Connection http2Connection2 = this;
        String string2 = "OkHttp %s Push Headers[%s]";
        String string3 = http2Connection2.hostname;
        Integer n7 = n6;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string3;
        objectArray[1] = n7;
        namedRunnable = new NamedRunnable(string2, objectArray2){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void execute() {
                v0 = this;
                var1_1 = v0.n5;
                var2_3 = v0.list;
                var3_4 = v0.bl;
                v1 = Http2Connection.this.pushObserver.onHeaders(var1_1, var2_3, var3_4);
                var1_1 = (int)v1;
                if (!v1) ** GOTO lbl13
                Http2Connection.this.writer.rstStream(n5, ErrorCode.CANCEL);
                {
                    catch (IOException v2) {
                        return;
                    }
lbl13:
                    // 2 sources

                    if (var1_1 != 0) ** GOTO lbl15
                    {
                        if (bl == false) return;
lbl15:
                        // 2 sources

                        var1_2 = Http2Connection.this;
                    }
                    {
                        v3 = this;
                        ** synchronized (var1_2)
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            v3.Http2Connection.this.currentPushRequests.remove(n5);
                        }
                        catch (Throwable v4) {}
                        {
                            throw v4;
                        }
                        return;
                    }
                }
            }
        };
        http2Connection.pushExecutorExecute(namedRunnable2);
    }

    void pushDataLater(final int n5, BufferedSource bufferedSource, int n6, boolean bl) throws IOException {
        Buffer buffer;
        BufferedSource bufferedSource2 = bufferedSource;
        bufferedSource = buffer;
        buffer = new Buffer();
        long l5 = n6;
        bufferedSource2.require(l5);
        bufferedSource2.read((Buffer)bufferedSource, l5);
        if (((Buffer)bufferedSource).size() == l5) {
            NamedRunnable namedRunnable;
            NamedRunnable namedRunnable2 = namedRunnable;
            String string2 = this.hostname;
            Integer n7 = n5;
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string2;
            objectArray[1] = n7;
            namedRunnable = new NamedRunnable("OkHttp %s Push Data[%s]", objectArray2, (Buffer)bufferedSource, n6, bl){
                final /* synthetic */ Buffer val$buffer;
                final /* synthetic */ int val$byteCount;
                final /* synthetic */ boolean val$inFinished;
                {
                    this.val$buffer = buffer;
                    this.val$byteCount = n6;
                    this.val$inFinished = bl;
                    super(string2, objectArray);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void execute() {
                    v0 = this;
                    var1_1 = v0.n5;
                    var2_3 = v0.val$buffer;
                    var3_4 = v0.val$byteCount;
                    var4_5 = v0.val$inFinished;
                    v1 = Http2Connection.this.pushObserver.onData(var1_1, var2_3, var3_4, var4_5);
                    var1_1 = (int)v1;
                    if (v1) {
                        Http2Connection.this.writer.rstStream(n5, ErrorCode.CANCEL);
                    }
                    if (var1_1 != 0) ** GOTO lbl15
                    if (this.val$inFinished == false) return;
lbl15:
                    // 2 sources

                    var1_2 = Http2Connection.this;
                    v2 = this;
                    ** synchronized (var1_2)
lbl-1000:
                    // 1 sources

                    {
                        try {
                            v2.Http2Connection.this.currentPushRequests.remove(n5);
                        }
                        catch (Throwable v3) {
                            // MONITOREXIT @DISABLED, blocks:[7, 9] lbl26 : MonitorExitStatement: MONITOREXIT : var1_2
                            try {
                                throw v3;
                            }
                            catch (IOException v4) {
                                return;
                            }
                        }
                        return;
                    }
                }
            };
            this.pushExecutorExecute(namedRunnable2);
            return;
        }
        throw new IOException(((Buffer)bufferedSource).size() + " != " + n6);
    }

    void pushResetLater(final int n5, final ErrorCode errorCode) {
        NamedRunnable namedRunnable;
        NamedRunnable namedRunnable2 = namedRunnable;
        String string2 = this.hostname;
        Integer n6 = n5;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string2;
        objectArray[1] = n6;
        namedRunnable = new NamedRunnable("OkHttp %s Push Reset[%s]", objectArray2){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                7 v02 = this;
                7 v12 = this;
                int n52 = v12.n5;
                v02.Http2Connection.this.pushObserver.onReset(n52, v12.errorCode);
                Http2Connection http2Connection = v02.Http2Connection.this;
                synchronized (http2Connection) {
                    Http2Connection.this.currentPushRequests.remove(n5);
                    return;
                }
            }
        };
        this.pushExecutorExecute(namedRunnable2);
    }

    public static class Builder {
        Socket socket;
        String hostname;
        BufferedSource source;
        BufferedSink sink;
        Listener listener = Listener.REFUSE_INCOMING_STREAMS;
        PushObserver pushObserver = PushObserver.CANCEL;
        boolean client;
        int pingIntervalMillis;

        public Builder(boolean bl) {
            this.client = bl;
        }

        public Builder socket(Socket closeable) throws IOException {
            Builder builder = string2;
            Socket socket = closeable;
            String string2 = ((InetSocketAddress)socket.getRemoteSocketAddress()).getHostName();
            closeable = Okio.buffer(Okio.source(socket));
            BufferedSink bufferedSink = Okio.buffer(Okio.sink(socket));
            return builder.socket(socket, string2, (BufferedSource)closeable, bufferedSink);
        }

        public Builder socket(Socket socket, String string2, BufferedSource bufferedSource, BufferedSink bufferedSink) {
            this.socket = socket;
            this.hostname = string2;
            this.source = bufferedSource;
            this.sink = bufferedSink;
            return this;
        }

        public Builder listener(Listener listener) {
            this.listener = listener;
            return this;
        }

        public Builder pushObserver(PushObserver pushObserver) {
            this.pushObserver = pushObserver;
            return this;
        }

        public Builder pingIntervalMillis(int n5) {
            this.pingIntervalMillis = n5;
            return this;
        }

        public Http2Connection build() {
            return new Http2Connection(this);
        }
    }

    public static abstract class Listener {
        public static final Listener REFUSE_INCOMING_STREAMS = new Listener(){

            @Override
            public void onStream(Http2Stream http2Stream) throws IOException {
                http2Stream.close(ErrorCode.REFUSED_STREAM);
            }
        };

        public abstract void onStream(Http2Stream var1) throws IOException;

        public void onSettings(Http2Connection http2Connection) {
        }
    }

    final class IntervalPingRunnable
    extends NamedRunnable {
        final /* synthetic */ Http2Connection this$0;

        IntervalPingRunnable(Http2Connection objectArray) {
            IntervalPingRunnable intervalPingRunnable = string2;
            ((IntervalPingRunnable)((Object)string2)).this$0 = objectArray;
            String string2 = objectArray.hostname;
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = string2;
            super("OkHttp %s ping", objectArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void execute() {
            boolean bl;
            block6: {
                IntervalPingRunnable intervalPingRunnable = this;
                Http2Connection http2Connection = intervalPingRunnable.this$0;
                // MONITORENTER : http2Connection
                if (intervalPingRunnable.this$0.intervalPongsReceived < this.this$0.intervalPingsSent) {
                    bl = true;
                    break block6;
                }
                Http2Connection.access$208(this.this$0);
                bl = false;
            }
            if (bl) {
                this.this$0.failConnection();
                return;
            }
            this.this$0.writePing(false, 1, 0);
        }
    }

    class ReaderRunnable
    extends NamedRunnable
    implements Http2Reader.Handler {
        final Http2Reader reader;
        final /* synthetic */ Http2Connection this$0;

        ReaderRunnable(Http2Connection objectArray, Http2Reader http2Reader) {
            ReaderRunnable readerRunnable = string2;
            ((ReaderRunnable)((Object)string2)).this$0 = objectArray;
            String string2 = objectArray.hostname;
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = string2;
            super("OkHttp %s", objectArray);
            readerRunnable.reader = http2Reader;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void execute() {
            block16: {
                block15: {
                    var1_1 = ErrorCode.INTERNAL_ERROR;
                    this.reader.readConnectionPreface(this);
                    while (this.reader.nextFrame(false, this)) {
                    }
                    v0 = this;
                    var2_2 = ErrorCode.NO_ERROR;
                    try {}
                    catch (IOException v1) {}
                    finally {
                        break block15;
                    }
lbl12:
                    // 2 sources

                    while (true) {
                        Util.closeQuietly(this.reader);
                        return;
                    }
                    catch (Throwable var3_4) {
                        var2_2 = var1_1;
                        break block16;
                    }
                    catch (IOException v2) {
                        var2_2 = var1_1;
                        ** GOTO lbl-1000
                    }
                }
                var1_1 = ErrorCode.CANCEL;
                {
                    v0.this$0.close(var2_2, var1_1);
                    ** GOTO lbl12
                }
lbl-1000:
                // 1 sources

                {
                    v3 = this;
                    var1_1 = ErrorCode.PROTOCOL_ERROR;
                }
                {
                    v4 = var1_1;
                    v3.this$0.close(v4, v4);
                    ** continue;
                }
            }
            try {
                this.this$0.close(var2_2, var1_1);
            }
            catch (IOException v5) {}
            Util.closeQuietly(this.reader);
            throw var3_5;
        }

        @Override
        public void data(boolean bl, int n5, BufferedSource bufferedSource, int n6) throws IOException {
            if (this.this$0.pushedStream(n5)) {
                this.this$0.pushDataLater(n5, bufferedSource, n6, bl);
                return;
            }
            Http2Stream http2Stream = this.this$0.getStream(n5);
            if (http2Stream == null) {
                ReaderRunnable readerRunnable = this;
                readerRunnable.this$0.writeSynResetLater(n5, ErrorCode.PROTOCOL_ERROR);
                long l5 = n6;
                readerRunnable.this$0.updateConnectionFlowControl(l5);
                bufferedSource.skip(l5);
                return;
            }
            http2Stream.receiveData(bufferedSource, n6);
            if (bl) {
                http2Stream.receiveFin();
                return;
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void headers(boolean var1_2, int var2_4, int var3_6, List<Header> var4_8) {
            if (this.this$0.pushedStream(var2_4)) {
                this.this$0.pushHeadersLater(var2_4, (List<Header>)var4_8, var1_2);
                return;
            }
            v0 = this;
            var3_7 = v0.this$0;
            synchronized (var3_7) {
                try {
                    var5_9 = v0.this$0.getStream(var2_4);
                    if (var5_9 == null) {
                    }
                    ** GOTO lbl46
                }
                catch (Throwable var0_1) {
                    ** GOTO lbl-1000
                }
                if (Http2Connection.access$300(this.this$0)) {
                    return;
                }
                var5_9 = this.this$0;
                {
                    if (var2_4 <= var5_9.lastGoodStreamId) {
                        return;
                    }
                    if (var2_4 % 2 == var5_9.nextStreamId % 2) {
                        return;
                    }
                    v1 = var3_7;
                    v2 = this;
                    var4_8 = Util.toHeaders(var4_8);
                }
                var5_9 = v3;
                {
                    v3 = new Http2Stream(var2_4, this.this$0, false, var1_2, (Headers)var4_8);
                    v2.this$0.lastGoodStreamId = var2_4;
                    v2.this$0.streams.put(var2_4, (Http2Stream)var5_9);
                }
                {
                    v4 = Http2Connection.access$400();
                    v5 = v6;
                    v7 = v6;
                    v8 = this;
                    v9 = this;
                    this = "OkHttp %s stream %d";
                    var1_3 = v9.this$0.hostname;
                    var2_5 = var2_4;
                    v10 = this;
                    v11 = new Object[2];
                }
                this = v11;
                {
                    v11[0] = var1_3;
                    v11[1] = var2_5;
                    v5((String)v10, this, (Http2Stream)var5_9);
                    v4.execute(v7);
                    // ** MonitorExit[v1] (shouldn't be in output)
                    return;
lbl46:
                    // 1 sources

                    // MONITOREXIT @DISABLED, blocks:[5, 7] lbl48 : MonitorExitStatement: MONITOREXIT : var3_7
                    var5_9.receiveHeaders((List<Header>)var4_8);
                    if (var1_2) {
                        var5_9.receiveFin();
                        return;
                    }
                    return;
                }
lbl-1000:
                // 1 sources

                {
                    throw var0_1;
                }
            }
        }

        @Override
        public void rstStream(int n5, ErrorCode errorCode) {
            if (((ReaderRunnable)((Object)http2Stream)).this$0.pushedStream(n5)) {
                ((ReaderRunnable)((Object)http2Stream)).this$0.pushResetLater(n5, errorCode);
                return;
            }
            Http2Stream http2Stream = ((ReaderRunnable)((Object)http2Stream)).this$0.removeStream(n5);
            if (http2Stream != null) {
                http2Stream.receiveRstStream(errorCode);
                return;
            }
        }

        @Override
        public void settings(boolean bl, Settings settings) {
            ReaderRunnable readerRunnable;
            ReaderRunnable readerRunnable2;
            2 v32;
            2 v12;
            ScheduledExecutorService scheduledExecutorService;
            try {
                2 v22;
                scheduledExecutorService = ((ReaderRunnable)((Object)string2)).this$0.writerExecutor;
                v12 = v22;
                v32 = v22;
                ReaderRunnable readerRunnable3 = string2;
                readerRunnable2 = readerRunnable3;
                readerRunnable = readerRunnable3;
                String string2 = "OkHttp %s ACK Settings";
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                return;
            }
            String string3 = readerRunnable2.this$0.hostname;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string3;
            v12(string2, objectArray2, bl, settings);
            scheduledExecutorService.execute(v32);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void applyAndAckSettings(boolean var1_1, Settings var2_3) {
            block21: {
                block22: {
                    v0 = this;
                    var3_7 = 0L;
                    var1_2 = null;
                    var5_8 = v0.this$0.writer;
                    synchronized (var5_8) {
                        var6_10 = v0.this$0;
                        ** synchronized (var6_10)
                        {
                            catch (Throwable v1) {}
                        }
lbl-1000:
                        // 1 sources

                        {
                            var7_11 = v0.this$0.peerSettings.getInitialWindowSize();
                            if (var1_1) {
                                this.this$0.peerSettings.clear();
                            }
                            v2 = this;
                            v2.this$0.peerSettings.merge(var2_3);
                            var2_4 = v2.this$0.peerSettings.getInitialWindowSize();
                            if (var2_4 == -1 || var2_4 == var7_11) ** GOTO lbl21
                            var3_7 = var2_4 - var7_11;
                            var1_2 = this.this$0.streams.isEmpty() == false ? this.this$0.streams.values().toArray(new Http2Stream[this.this$0.streams.size()]) : null;
lbl21:
                            // 2 sources

                            v3 = this;
                        }
                        var2_5 = v3.this$0;
                        var2_5.writer.applyAndAckSettings(var2_5.peerSettings);
                        ** GOTO lbl33
                        {
                            catch (Throwable v4) {}
                        }
                        throw v4;
                        {
                            ** break block20
                            catch (IOException v5) {}
                            {
                                Http2Connection.access$000(this.this$0);
lbl33:
                                // 2 sources

                                // MONITOREXIT @DISABLED, blocks:[16, 7, 11] lbl36 : MonitorExitStatement: MONITOREXIT : var5_8
                                if (var1_2 == null) break block21;
                            }
                        }
                    }
                    var2_6 = var1_2.length;
                    break block22;
lbl-1000:
                    // 1 sources

                    {
                        throw v1;
                    }
                }
                for (var5_9 = 0; var5_9 < var2_6; ++var5_9) {
                    var6_10 = var1_2[var5_9];
                    synchronized (var6_10) {
                        var6_10.addBytesToWriteWindow(var3_7);
                        continue;
                    }
                }
            }
            v7 = this;
            this = v7.this$0.hostname;
            v8 = new Object[1];
            var1_2 = v8;
            v8[0] = this;
            Http2Connection.access$400().execute(new NamedRunnable("OkHttp %s settings", var1_2){

                @Override
                public void execute() {
                    Http2Connection http2Connection = http2Connection.ReaderRunnable.this.this$0;
                    http2Connection.listener.onSettings(http2Connection);
                }
            });
        }

        @Override
        public void ackSettings() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void ping(boolean var1_1, int var2_3, int var3_4) {
            block7: {
                if (!var1_1) break block7;
                var1_2 = this.this$0;
                synchronized (var1_2) {
                    block9: {
                        block8: {
                            if (var2_3 != 1) break block8;
                            try {
                                v0 = Http2Connection.access$108(this.this$0);
                                ** GOTO lbl20
                            }
                            catch (Throwable v1) {
                                break block9;
                            }
                        }
                        if (var2_3 != 2) ** GOTO lbl14
                        {
                            v0 = Http2Connection.access$608(this.this$0);
                            ** GOTO lbl20
lbl14:
                            // 1 sources

                            if (var2_3 != 3) ** GOTO lbl20
                            v2 = this;
                            v3 = v2;
                            Http2Connection.access$708(v2.this$0);
                        }
                        {
                            v3.this$0.notifyAll();
lbl20:
                            // 4 sources

                            return;
                        }
                    }
                    throw v1;
                }
            }
            try {
                Http2Connection.access$500(this.this$0).execute(new PingRunnable(this.this$0, true, var2_3, var3_4));
                return;
            }
            catch (RejectedExecutionException v4) {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void goAway(int n5, ErrorCode object, ByteString http2StreamArray) {
            ReaderRunnable readerRunnable = this;
            http2StreamArray.size();
            object = readerRunnable.this$0;
            synchronized (object) {
                http2StreamArray = readerRunnable.this$0.streams.values().toArray(new Http2Stream[this.this$0.streams.size()]);
                Object object2 = object;
                Http2Connection.access$302(this.this$0, true);
                // ** MonitorExit[v1 /* !! */ ] (shouldn't be in output)
                for (Http2Stream http2Stream : http2StreamArray) {
                    if (http2Stream.getId() <= n5 || !http2Stream.isLocallyInitiated()) continue;
                    http2Stream.receiveRstStream(ErrorCode.REFUSED_STREAM);
                    this.this$0.removeStream(http2Stream.getId());
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowUpdate(int n5, long l5) {
            if (n5 == 0) {
                Http2Connection http2Connection = ((ReaderRunnable)((Object)http2Stream)).this$0;
                synchronized (http2Connection) {
                    Http2Connection http2Connection2 = ((ReaderRunnable)((Object)http2Stream)).this$0;
                    Http2Connection http2Connection3 = http2Connection2;
                    Http2Connection http2Connection4 = http2Connection2;
                    long l6 = http2Connection2.bytesLeftInWriteWindow;
                    http2Connection4.bytesLeftInWriteWindow = l6 + l5;
                    http2Connection3.notifyAll();
                    return;
                }
            }
            Http2Stream http2Stream = ((ReaderRunnable)((Object)http2Stream)).this$0.getStream(n5);
            if (http2Stream != null) {
                Object object = http2Stream;
                synchronized (object) {
                    ((Http2Stream)object).addBytesToWriteWindow(l5);
                    return;
                }
            }
        }

        @Override
        public void priority(int n5, int n6, int n7, boolean bl) {
        }

        @Override
        public void pushPromise(int n5, int n6, List<Header> list) {
            this.this$0.pushRequestLater(n6, list);
        }

        @Override
        public void alternateService(int n5, String string2, ByteString byteString, String string3, int n6, long l5) {
        }
    }

    final class PingRunnable
    extends NamedRunnable {
        final boolean reply;
        final int payload1;
        final int payload2;
        final /* synthetic */ Http2Connection this$0;

        PingRunnable(Http2Connection object, boolean bl, int n5, int n6) {
            PingRunnable pingRunnable = string2;
            ((PingRunnable)((Object)string2)).this$0 = object;
            String string2 = ((Http2Connection)object).hostname;
            object = n5;
            Integer n7 = n6;
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string2;
            objectArray[1] = object;
            objectArray[2] = n7;
            super("OkHttp %s ping %08x%08x", objectArray2);
            pingRunnable.reply = bl;
            pingRunnable.payload1 = n5;
            pingRunnable.payload2 = n6;
        }

        @Override
        public void execute() {
            PingRunnable pingRunnable = this;
            boolean bl = pingRunnable.reply;
            int n5 = pingRunnable.payload1;
            int n6 = pingRunnable.payload2;
            this.this$0.writePing(bl, n5, n6);
        }
    }
}

