/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.dcloudimageloader.cache.memory.impl;

import android.graphics.Bitmap;
import com.nostra13.dcloudimageloader.cache.memory.MemoryCacheAware;
import java.util.Collection;
import java.util.Comparator;

public class FuzzyKeyMemoryCache
implements MemoryCacheAware {
    private final MemoryCacheAware cache;
    private final Comparator<String> keyComparator;

    public FuzzyKeyMemoryCache(MemoryCacheAware cache, Comparator<String> keyComparator) {
        this.cache = cache;
        this.keyComparator = keyComparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(String key, Bitmap value) {
        MemoryCacheAware memoryCacheAware = this.cache;
        synchronized (memoryCacheAware) {
            String keyToRemove = null;
            for (String cacheKey : this.cache.keys()) {
                if (this.keyComparator.compare(key, cacheKey) != 0) continue;
                keyToRemove = cacheKey;
                break;
            }
            if (keyToRemove != null) {
                this.cache.remove(keyToRemove);
            }
        }
        return this.cache.put(key, value);
    }

    @Override
    public Bitmap get(String key) {
        return this.cache.get(key);
    }

    @Override
    public Bitmap remove(String key) {
        return this.cache.remove(key);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public Collection<String> keys() {
        return this.cache.keys();
    }
}

