/*
 * Decompiled with CFR 0.152.
 */
package tv.cjump.jni;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.util.Log;
import java.lang.reflect.Field;
import tv.cjump.jni.DeviceUtils;

public class NativeBitmapFactory {
    static Field nativeIntField = null;
    static boolean nativeLibLoaded = false;
    static boolean notLoadAgain = false;

    public static boolean isInNativeAlloc() {
        return Build.VERSION.SDK_INT < 11 || nativeLibLoaded && nativeIntField != null;
    }

    public static void loadLibs() {
        if (notLoadAgain) {
            return;
        }
        if (!DeviceUtils.isRealARMArch() && !DeviceUtils.isRealX86Arch()) {
            notLoadAgain = true;
            nativeLibLoaded = false;
            return;
        }
        if (nativeLibLoaded) {
            return;
        }
        try {
            if (Build.VERSION.SDK_INT >= 11 && Build.VERSION.SDK_INT < 23) {
                System.loadLibrary("ndkbitmap");
                nativeLibLoaded = true;
            } else {
                notLoadAgain = true;
                nativeLibLoaded = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            notLoadAgain = true;
            nativeLibLoaded = false;
        }
        catch (Error e) {
            e.printStackTrace();
            notLoadAgain = true;
            nativeLibLoaded = false;
        }
        if (nativeLibLoaded) {
            boolean libInit = NativeBitmapFactory.init();
            if (!libInit) {
                NativeBitmapFactory.release();
                notLoadAgain = true;
                nativeLibLoaded = false;
            } else {
                NativeBitmapFactory.initField();
                boolean confirm = NativeBitmapFactory.testLib();
                if (!confirm) {
                    NativeBitmapFactory.release();
                    notLoadAgain = true;
                    nativeLibLoaded = false;
                }
            }
        }
        Log.e((String)"NativeBitmapFactory", (String)("loaded" + nativeLibLoaded));
    }

    public static void releaseLibs() {
        if (nativeLibLoaded) {
            NativeBitmapFactory.release();
        }
        nativeIntField = null;
        nativeLibLoaded = false;
    }

    static void initField() {
        try {
            nativeIntField = Bitmap.Config.class.getDeclaredField("nativeInt");
            nativeIntField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            nativeIntField = null;
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    private static boolean testLib() {
        if (nativeIntField == null) {
            return false;
        }
        Bitmap bitmap = null;
        Canvas canvas = null;
        try {
            boolean result;
            bitmap = NativeBitmapFactory.createNativeBitmap(2, 2, Bitmap.Config.ARGB_8888, true);
            boolean bl = result = bitmap != null && bitmap.getWidth() == 2 && bitmap.getHeight() == 2;
            if (result) {
                if (Build.VERSION.SDK_INT >= 17 && !bitmap.isPremultiplied()) {
                    bitmap.setPremultiplied(true);
                }
                canvas = new Canvas(bitmap);
                Paint paint = new Paint();
                paint.setColor(-65536);
                paint.setTextSize(20.0f);
                canvas.drawRect(0.0f, 0.0f, (float)bitmap.getWidth(), (float)bitmap.getHeight(), paint);
                canvas.drawText("TestLib", 0.0f, 0.0f, paint);
                if (Build.VERSION.SDK_INT >= 17) {
                    result = bitmap.isPremultiplied();
                }
            }
            boolean bl2 = result;
            return bl2;
        }
        catch (Exception e) {
            Log.e((String)"NativeBitmapFactory", (String)("exception:" + e.toString()));
            boolean bl = false;
            return bl;
        }
        catch (Error e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (bitmap != null) {
                bitmap.recycle();
                bitmap = null;
            }
        }
    }

    public static int getNativeConfig(Bitmap.Config config) {
        try {
            if (nativeIntField == null) {
                return 0;
            }
            return nativeIntField.getInt(config);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static Bitmap createBitmap(int width, int height, Bitmap.Config config) {
        return NativeBitmapFactory.createBitmap(width, height, config, config.equals((Object)Bitmap.Config.ARGB_8888));
    }

    public static void recycle(Bitmap bitmap) {
        bitmap.recycle();
    }

    public static Bitmap createBitmap(int width, int height, Bitmap.Config config, boolean hasAlpha) {
        if (!nativeLibLoaded || nativeIntField == null) {
            return Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        }
        return NativeBitmapFactory.createNativeBitmap(width, height, config, hasAlpha);
    }

    private static Bitmap createNativeBitmap(int width, int height, Bitmap.Config config, boolean hasAlpha) {
        int nativeConfig = NativeBitmapFactory.getNativeConfig(config);
        return Build.VERSION.SDK_INT == 19 ? NativeBitmapFactory.createBitmap19(width, height, nativeConfig, hasAlpha) : NativeBitmapFactory.createBitmap(width, height, nativeConfig, hasAlpha);
    }

    private static native boolean init();

    private static native boolean release();

    private static native Bitmap createBitmap(int var0, int var1, int var2, boolean var3);

    private static native Bitmap createBitmap19(int var0, int var1, int var2, boolean var3);
}

