/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex;

import android.annotation.SuppressLint;
import android.os.Build;
import android.util.Log;
import android.view.Choreographer;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.WXErrorCode;
import java.lang.ref.WeakReference;

public class WeexFrameRateControl {
    private static final long VSYNC_FRAME = 16L;
    private WeakReference<VSyncListener> mListener;
    private final Choreographer mChoreographer;
    private final Choreographer.FrameCallback mVSyncFrameCallback;
    private final Runnable runnable;

    public WeexFrameRateControl(VSyncListener object) {
        Runnable runnable;
        this.mListener = new WeakReference<VSyncListener>((VSyncListener)object);
        if (Build.VERSION.SDK_INT > 15) {
            WeexFrameRateControl weexFrameRateControl = this;
            weexFrameRateControl.mChoreographer = Choreographer.getInstance();
            weexFrameRateControl.mVSyncFrameCallback = new Choreographer.FrameCallback(){

                @SuppressLint(value={"NewApi"})
                public void doFrame(long l) {
                    block3: {
                        VSyncListener vSyncListener;
                        if (WeexFrameRateControl.this.mListener != null && (vSyncListener = (VSyncListener)WeexFrameRateControl.this.mListener.get()) != null) {
                            try {
                                vSyncListener.OnVSync();
                                WeexFrameRateControl.this.mChoreographer.postFrameCallback(WeexFrameRateControl.this.mVSyncFrameCallback);
                                return;
                            }
                            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                                if (!(vSyncListener instanceof WXSDKInstance)) break block3;
                                String string = WXErrorCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getErrorCode();
                                ((WXSDKInstance)((Object)vSyncListener)).onRenderError(string, Log.getStackTraceString((Throwable)unsatisfiedLinkError));
                            }
                        }
                    }
                }
            };
            weexFrameRateControl.runnable = null;
            return;
        }
        WeexFrameRateControl weexFrameRateControl = this;
        object = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                block3: {
                    VSyncListener vSyncListener;
                    if (WeexFrameRateControl.this.mListener != null && (vSyncListener = (VSyncListener)WeexFrameRateControl.this.mListener.get()) != null) {
                        try {
                            vSyncListener.OnVSync();
                            WXSDKManager.getInstance().getWXRenderManager().postOnUiThread(WeexFrameRateControl.this.runnable, 16L);
                            return;
                        }
                        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                            if (!(vSyncListener instanceof WXSDKInstance)) break block3;
                            String string = WXErrorCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getErrorCode();
                            ((WXSDKInstance)((Object)vSyncListener)).onRenderError(string, Log.getStackTraceString((Throwable)unsatisfiedLinkError));
                        }
                    }
                }
            }
        };
        weexFrameRateControl.runnable = object;
        weexFrameRateControl.mChoreographer = null;
        weexFrameRateControl.mVSyncFrameCallback = null;
    }

    @SuppressLint(value={"NewApi"})
    public void start() {
        Choreographer choreographer = this.mChoreographer;
        if (choreographer != null) {
            choreographer.postFrameCallback(this.mVSyncFrameCallback);
            return;
        }
        if (this.runnable != null) {
            WXSDKManager.getInstance().getWXRenderManager().postOnUiThread(this.runnable, 16L);
            return;
        }
    }

    @SuppressLint(value={"NewApi"})
    public void stop() {
        Choreographer choreographer = this.mChoreographer;
        if (choreographer != null) {
            choreographer.removeFrameCallback(this.mVSyncFrameCallback);
            return;
        }
        if (this.runnable != null) {
            WXSDKManager.getInstance().getWXRenderManager().removeTask(this.runnable);
            return;
        }
    }

    public static interface VSyncListener {
        public void OnVSync();
    }
}

