/*
 * Decompiled with CFR 0.152.
 */
package androidtranscoder.engine;

import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import androidtranscoder.engine.InputSurface;
import androidtranscoder.engine.OutputSurface;
import androidtranscoder.engine.QueuedMuxer;
import androidtranscoder.engine.TrackTranscoder;
import java.io.IOException;
import java.nio.ByteBuffer;

public class VideoTrackTranscoder
implements TrackTranscoder {
    private static final String TAG = "VideoTrackTranscoder";
    private static final int DRAIN_STATE_NONE = 0;
    private static final int DRAIN_STATE_SHOULD_RETRY_IMMEDIATELY = 1;
    private static final int DRAIN_STATE_CONSUMED = 2;
    private final MediaExtractor mExtractor;
    private final int mTrackIndex;
    private final MediaFormat mOutputFormat;
    private final QueuedMuxer mMuxer;
    private final MediaCodec.BufferInfo mBufferInfo;
    private MediaCodec mDecoder;
    private MediaCodec mEncoder;
    private ByteBuffer[] mDecoderInputBuffers;
    private ByteBuffer[] mEncoderOutputBuffers;
    private MediaFormat mActualOutputFormat;
    private OutputSurface mDecoderOutputSurfaceWrapper;
    private InputSurface mEncoderInputSurfaceWrapper;
    private boolean mIsExtractorEOS;
    private boolean mIsDecoderEOS;
    private boolean mIsEncoderEOS;
    private boolean mDecoderStarted;
    private boolean mEncoderStarted;
    private long mWrittenPresentationTimeUs;
    private int frameRate;
    int currentSecond;
    int currentFrameCount;

    public VideoTrackTranscoder(MediaExtractor mediaExtractor, int n5, MediaFormat mediaFormat, QueuedMuxer queuedMuxer) {
        MediaCodec.BufferInfo bufferInfo;
        VideoTrackTranscoder videoTrackTranscoder = bufferInfo;
        bufferInfo = new MediaCodec.BufferInfo();
        v1.mBufferInfo = videoTrackTranscoder;
        v1.currentSecond = 0;
        v1.currentFrameCount = 0;
        v1.mExtractor = mediaExtractor;
        v1.mTrackIndex = n5;
        v1.mOutputFormat = mediaFormat;
        v1.mMuxer = queuedMuxer;
    }

    private int drainExtractor(long l5) {
        if (this.mIsExtractorEOS) {
            return 0;
        }
        int n5 = this.mExtractor.getSampleTrackIndex();
        if (n5 >= 0 && n5 != this.mTrackIndex) {
            return 0;
        }
        int n6 = this.mDecoder.dequeueInputBuffer(l5);
        if (n6 < 0) {
            return 0;
        }
        if (n5 < 0) {
            this.mIsExtractorEOS = true;
            this.mDecoder.queueInputBuffer(n6, 0, 0, 0L, 4);
            return 0;
        }
        VideoTrackTranscoder videoTrackTranscoder = this;
        int n7 = videoTrackTranscoder.mExtractor.readSampleData(this.mDecoderInputBuffers[n6], 0);
        n5 = (videoTrackTranscoder.mExtractor.getSampleFlags() & 1) != 0 ? 1 : 0;
        VideoTrackTranscoder videoTrackTranscoder2 = this;
        long l6 = this.mExtractor.getSampleTime();
        videoTrackTranscoder2.mDecoder.queueInputBuffer(n6, 0, n7, l6, n5);
        videoTrackTranscoder2.mExtractor.advance();
        return 2;
    }

    private int drainDecoder(long l5) {
        if (this.mIsDecoderEOS) {
            return 0;
        }
        int n5 = this.mDecoder.dequeueOutputBuffer(this.mBufferInfo, l5);
        switch (n5) {
            default: {
                if ((this.mBufferInfo.flags & 4) != 0) {
                    this.mEncoder.signalEndOfInputStream();
                    this.mIsDecoderEOS = true;
                    this.mBufferInfo.size = 0;
                }
                boolean bl = this.mBufferInfo.size > 0;
                this.mDecoder.releaseOutputBuffer(n5, bl);
                if (bl) {
                    this.mDecoderOutputSurfaceWrapper.awaitNewImage();
                    n5 = (int)(this.mBufferInfo.presentationTimeUs / 1000000L);
                    if (this.currentSecond == n5) {
                        ++this.currentFrameCount;
                    } else {
                        this.currentSecond = n5;
                        this.currentFrameCount = 0;
                    }
                    n5 = this.frameRate;
                    if (n5 <= 30) {
                        this.mDecoderOutputSurfaceWrapper.drawImage();
                        this.mEncoderInputSurfaceWrapper.setPresentationTime(this.mBufferInfo.presentationTimeUs * 1000L);
                        this.mEncoderInputSurfaceWrapper.swapBuffers();
                    } else if (n5 <= 50) {
                        if (this.currentFrameCount % 5 != 0) {
                            this.mDecoderOutputSurfaceWrapper.drawImage();
                            this.mEncoderInputSurfaceWrapper.setPresentationTime(this.mBufferInfo.presentationTimeUs * 1000L);
                            this.mEncoderInputSurfaceWrapper.swapBuffers();
                        }
                    } else if (this.currentFrameCount % 3 != 0) {
                        this.mDecoderOutputSurfaceWrapper.drawImage();
                        this.mEncoderInputSurfaceWrapper.setPresentationTime(this.mBufferInfo.presentationTimeUs * 1000L);
                        this.mEncoderInputSurfaceWrapper.swapBuffers();
                    }
                }
                return 2;
            }
            case -1: {
                return 0;
            }
            case -3: 
            case -2: 
        }
        return 1;
    }

    private int drainEncoder(long l5) {
        if (videoTrackTranscoder2.mIsEncoderEOS) {
            return 0;
        }
        int n5 = videoTrackTranscoder2.mEncoder.dequeueOutputBuffer(videoTrackTranscoder2.mBufferInfo, l5);
        switch (n5) {
            default: {
                if (videoTrackTranscoder2.mActualOutputFormat != null) {
                    MediaCodec.BufferInfo bufferInfo = videoTrackTranscoder2.mBufferInfo;
                    int n6 = bufferInfo.flags;
                    if ((n6 & 4) != 0) {
                        videoTrackTranscoder2.mIsEncoderEOS = true;
                        bufferInfo.set(0, 0, 0L, n6);
                    }
                    bufferInfo = videoTrackTranscoder2.mBufferInfo;
                    if ((bufferInfo.flags & 2) != 0) {
                        videoTrackTranscoder2.mEncoder.releaseOutputBuffer(n5, false);
                        return 1;
                    }
                    VideoTrackTranscoder videoTrackTranscoder = videoTrackTranscoder2;
                    videoTrackTranscoder.mMuxer.writeSampleData(QueuedMuxer.SampleType.VIDEO, videoTrackTranscoder2.mEncoderOutputBuffers[n5], bufferInfo);
                    videoTrackTranscoder.mWrittenPresentationTimeUs = videoTrackTranscoder.mBufferInfo.presentationTimeUs;
                    videoTrackTranscoder.mEncoder.releaseOutputBuffer(n5, false);
                    return 2;
                }
                throw new RuntimeException("Could not determine actual output format.");
            }
            case -1: {
                return 0;
            }
            case -2: {
                if (videoTrackTranscoder2.mActualOutputFormat == null) {
                    VideoTrackTranscoder videoTrackTranscoder = videoTrackTranscoder2;
                    VideoTrackTranscoder videoTrackTranscoder2 = videoTrackTranscoder.mEncoder.getOutputFormat();
                    videoTrackTranscoder.mActualOutputFormat = videoTrackTranscoder2;
                    videoTrackTranscoder.mMuxer.setOutputFormat(QueuedMuxer.SampleType.VIDEO, (MediaFormat)videoTrackTranscoder2);
                    return 1;
                }
                throw new RuntimeException("Video output format changed twice.");
            }
            case -3: 
        }
        videoTrackTranscoder2.mEncoderOutputBuffers = videoTrackTranscoder2.mEncoder.getOutputBuffers();
        return 1;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setup() {
        OutputSurface outputSurface;
        InputSurface inputSurface;
        InputSurface inputSurface2;
        MediaCodec mediaCodec;
        this.mExtractor.selectTrack(this.mTrackIndex);
        try {
            mediaCodec = MediaCodec.createEncoderByType((String)this.mOutputFormat.getString("mime"));
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        {
            this.mEncoder = mediaCodec;
        }
        mediaCodec.configure(this.mOutputFormat, null, null, 1);
        this.mEncoderInputSurfaceWrapper = inputSurface2 = inputSurface;
        new InputSurface(this.mEncoder.createInputSurface()).makeCurrent();
        this.mEncoder.start();
        this.mEncoderStarted = true;
        this.mEncoderOutputBuffers = this.mEncoder.getOutputBuffers();
        inputSurface2 = this.mExtractor.getTrackFormat(this.mTrackIndex);
        if (inputSurface2.containsKey("rotation-degrees")) {
            inputSurface2.setInteger("rotation-degrees", 0);
        }
        if (inputSurface2.getString("mime").startsWith("video/") && inputSurface2.containsKey("frame-rate")) {
            this.frameRate = inputSurface2.getInteger("frame-rate");
        }
        OutputSurface outputSurface2 = outputSurface;
        outputSurface = new OutputSurface();
        this.mDecoderOutputSurfaceWrapper = outputSurface2;
        try {
            outputSurface2 = MediaCodec.createDecoderByType((String)inputSurface2.getString("mime"));
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        {
            this.mDecoder = outputSurface2;
            outputSurface2.configure((MediaFormat)inputSurface2, this.mDecoderOutputSurfaceWrapper.getSurface(), null, 0);
        }
        this.mDecoder.start();
        this.mDecoderStarted = true;
        this.mDecoderInputBuffers = this.mDecoder.getInputBuffers();
    }

    @Override
    public MediaFormat getDeterminedFormat() {
        return this.mActualOutputFormat;
    }

    @Override
    public boolean stepPipeline() {
        int n5;
        boolean bl = false;
        while (this.drainEncoder(0L) != 0) {
            bl = true;
        }
        do {
            if ((n5 = this.drainDecoder(0L)) == 0) continue;
            bl = true;
        } while (n5 == 1);
        while (this.drainExtractor(0L) != 0) {
            bl = true;
        }
        return bl;
    }

    @Override
    public long getWrittenPresentationTimeUs() {
        return this.mWrittenPresentationTimeUs;
    }

    @Override
    public boolean isFinished() {
        return this.mIsEncoderEOS;
    }

    @Override
    public void release() {
        Object object = this.mDecoderOutputSurfaceWrapper;
        if (object != null) {
            ((OutputSurface)object).release();
            this.mDecoderOutputSurfaceWrapper = null;
        }
        if ((object = this.mEncoderInputSurfaceWrapper) != null) {
            ((InputSurface)object).release();
            this.mEncoderInputSurfaceWrapper = null;
        }
        if ((object = this.mDecoder) != null) {
            if (this.mDecoderStarted) {
                object.stop();
            }
            this.mDecoder.release();
            this.mDecoder = null;
        }
        if ((object = this.mEncoder) != null) {
            if (this.mEncoderStarted) {
                object.stop();
            }
            this.mEncoder.release();
            this.mEncoder = null;
            return;
        }
    }
}

