/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2;

import com.dcloud.zxing2.Binarizer;
import com.dcloud.zxing2.LuminanceSource;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.common.BitArray;
import com.dcloud.zxing2.common.BitMatrix;

public final class BinaryBitmap {
    private final Binarizer binarizer;
    private BitMatrix matrix;

    public BinaryBitmap(Binarizer binarizer) {
        if (binarizer != null) {
            this.binarizer = binarizer;
            return;
        }
        throw new IllegalArgumentException("Binarizer must be non-null.");
    }

    public int getWidth() {
        return this.binarizer.getWidth();
    }

    public int getHeight() {
        return this.binarizer.getHeight();
    }

    public BitArray getBlackRow(int n5, BitArray bitArray) throws NotFoundException {
        return this.binarizer.getBlackRow(n5, bitArray);
    }

    public BitMatrix getBlackMatrix() throws NotFoundException {
        if (this.matrix == null) {
            this.matrix = this.binarizer.getBlackMatrix();
        }
        return this.matrix;
    }

    public boolean isCropSupported() {
        return this.binarizer.getLuminanceSource().isCropSupported();
    }

    public BinaryBitmap crop(int n5, int n6, int n7, int n8) {
        LuminanceSource luminanceSource = this.binarizer.getLuminanceSource().crop(n5, n6, n7, n8);
        return new BinaryBitmap(this.binarizer.createBinarizer(luminanceSource));
    }

    public boolean isRotateSupported() {
        return this.binarizer.getLuminanceSource().isRotateSupported();
    }

    public BinaryBitmap rotateCounterClockwise() {
        LuminanceSource luminanceSource = this.binarizer.getLuminanceSource().rotateCounterClockwise();
        return new BinaryBitmap(this.binarizer.createBinarizer(luminanceSource));
    }

    public BinaryBitmap rotateCounterClockwise45() {
        LuminanceSource luminanceSource = this.binarizer.getLuminanceSource().rotateCounterClockwise45();
        return new BinaryBitmap(this.binarizer.createBinarizer(luminanceSource));
    }

    public String toString() {
        try {
            return this.getBlackMatrix().toString();
        }
        catch (NotFoundException notFoundException) {
            return "";
        }
    }
}

