/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.nineoldandroids.view;

import android.os.Build;
import android.view.View;
import android.view.animation.Interpolator;
import io.dcloud.nineoldandroids.animation.Animator;
import io.dcloud.nineoldandroids.view.ViewPropertyAnimatorHC;
import io.dcloud.nineoldandroids.view.ViewPropertyAnimatorICS;
import io.dcloud.nineoldandroids.view.ViewPropertyAnimatorPreHC;
import java.util.WeakHashMap;

public abstract class ViewPropertyAnimator {
    private static final WeakHashMap<View, ViewPropertyAnimator> ANIMATORS = new WeakHashMap(0);

    public static ViewPropertyAnimator animate(View view) {
        ViewPropertyAnimator animator = ANIMATORS.get(view);
        if (animator == null) {
            int version = Integer.valueOf(Build.VERSION.SDK);
            animator = version >= 14 ? new ViewPropertyAnimatorICS(view) : (version >= 11 ? new ViewPropertyAnimatorHC(view) : new ViewPropertyAnimatorPreHC(view));
            ANIMATORS.put(view, animator);
        }
        return animator;
    }

    public abstract ViewPropertyAnimator setDuration(long var1);

    public abstract long getDuration();

    public abstract long getStartDelay();

    public abstract ViewPropertyAnimator setStartDelay(long var1);

    public abstract ViewPropertyAnimator setInterpolator(Interpolator var1);

    public abstract ViewPropertyAnimator setListener(Animator.AnimatorListener var1);

    public abstract void start();

    public abstract void cancel();

    public abstract ViewPropertyAnimator x(float var1);

    public abstract ViewPropertyAnimator xBy(float var1);

    public abstract ViewPropertyAnimator y(float var1);

    public abstract ViewPropertyAnimator yBy(float var1);

    public abstract ViewPropertyAnimator rotation(float var1);

    public abstract ViewPropertyAnimator rotationBy(float var1);

    public abstract ViewPropertyAnimator rotationX(float var1);

    public abstract ViewPropertyAnimator rotationXBy(float var1);

    public abstract ViewPropertyAnimator rotationY(float var1);

    public abstract ViewPropertyAnimator rotationYBy(float var1);

    public abstract ViewPropertyAnimator translationX(float var1);

    public abstract ViewPropertyAnimator translationXBy(float var1);

    public abstract ViewPropertyAnimator translationY(float var1);

    public abstract ViewPropertyAnimator translationYBy(float var1);

    public abstract ViewPropertyAnimator scaleX(float var1);

    public abstract ViewPropertyAnimator scaleXBy(float var1);

    public abstract ViewPropertyAnimator scaleY(float var1);

    public abstract ViewPropertyAnimator scaleYBy(float var1);

    public abstract ViewPropertyAnimator alpha(float var1);

    public abstract ViewPropertyAnimator alphaBy(float var1);
}

