/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.performance;

import android.util.Log;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.common.WXJSExceptionInfo;
import com.taobao.weex.performance.IWXAnalyzer;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.utils.WXUtils;
import java.util.Iterator;
import java.util.List;
import org.json.JSONObject;

public class WXAnalyzerDataTransfer {
    private static final String GROUP = "WXAnalyzer";
    private static final String MODULE_ERROR = "WXError";
    private static final String MODULE_WX_APM = "wxapm";
    public static boolean isOpenPerformance = false;
    public static final String INTERACTION_TAG = "wxInteractionAnalyzer";
    private static boolean sOpenInteractionLog;

    public static void transferPerformance(String object, String string2, String string3, Object iterator) {
        if (isOpenPerformance) {
            List<IWXAnalyzer> list;
            if (sOpenInteractionLog && "stage".equals(string2)) {
                Log.d((String)INTERACTION_TAG, (String)("[client][stage]" + (String)object + "," + string3 + "," + iterator));
            }
            if ((list = WXSDKManager.getInstance().getWXAnalyzerList()) != null && list.size() != 0 && (object = WXSDKManager.getInstance().getAllInstanceMap().get(object)) != null) {
                List<IWXAnalyzer> list2 = list;
                try {
                    string3 = new JSONObject().put(string3, (Object)iterator).toString();
                    iterator = list2.iterator();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
                while (iterator.hasNext()) {
                    iterator.next().transfer(MODULE_WX_APM, ((WXSDKInstance)object).getInstanceId(), string2, string3);
                }
            }
        }
    }

    public static void transferInteractionInfo(WXComponent wXComponent) {
        List<IWXAnalyzer> list;
        if (isOpenPerformance && (list = WXSDKManager.getInstance().getWXAnalyzerList()) != null && list.size() != 0) {
            Iterator<IWXAnalyzer> iterator;
            long l = WXUtils.getFixUnixTime() - wXComponent.getInstance().getWXPerformance().renderUnixTimeOrigin;
            JSONObject jSONObject = new JSONObject().put("renderOriginDiffTime", l);
            WXComponent wXComponent2 = wXComponent;
            String string2 = "type";
            JSONObject jSONObject2 = jSONObject.put(string2, (Object)wXComponent2.getComponentType());
            WXComponent wXComponent3 = wXComponent;
            string2 = "ref";
            JSONObject jSONObject3 = jSONObject2.put(string2, (Object)wXComponent3.getRef());
            WXComponent wXComponent4 = wXComponent;
            string2 = "style";
            JSONObject jSONObject4 = jSONObject3.put(string2, (Object)wXComponent4.getStyles());
            WXComponent wXComponent5 = wXComponent;
            string2 = "attrs";
            try {
                string2 = jSONObject4.put(string2, (Object)wXComponent5.getAttrs()).toString();
                iterator = list.iterator();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            while (iterator.hasNext()) {
                iterator.next().transfer(MODULE_WX_APM, wXComponent.getInstanceId(), "wxinteraction", string2);
            }
        }
    }

    public static void transferError(WXJSExceptionInfo object, String object2) {
        WXSDKInstance wXSDKInstance;
        Object object3;
        if (WXEnvironment.isApkDebugable() && (object3 = WXSDKManager.getInstance().getWXAnalyzerList()) != null && object3.size() != 0 && (wXSDKInstance = WXSDKManager.getInstance().getSDKInstance((String)object2)) != null) {
            object = ((WXJSExceptionInfo)object).getErrCode();
            String string2 = "";
            JSONObject jSONObject = new JSONObject().put("instanceId", object2);
            WXSDKInstance wXSDKInstance2 = wXSDKInstance;
            object2 = "url";
            JSONObject jSONObject2 = jSONObject.put((String)object2, (Object)wXSDKInstance2.getBundleUrl());
            Object object4 = object;
            object2 = "errorCode";
            JSONObject jSONObject3 = jSONObject2.put((String)object2, (Object)((WXErrorCode)((Object)object4)).getErrorCode());
            Object object5 = object;
            object2 = "errorMsg";
            JSONObject jSONObject4 = jSONObject3.put((String)object2, (Object)((WXErrorCode)((Object)object5)).getErrorMsg());
            Object object6 = object;
            object2 = "errorGroup";
            try {
                string2 = jSONObject4.put((String)object2, (Object)((WXErrorCode)((Object)object6)).getErrorGroup()).toString();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object3 = ((Object)((Object)((WXErrorCode)((Object)object)).getErrorType())).toString();
                ((IWXAnalyzer)object2.next()).transfer(GROUP, MODULE_ERROR, (String)object3, string2);
            }
        }
    }

    public static void switchInteractionLog(boolean bl) {
        if (sOpenInteractionLog != bl && WXEnvironment.JsFrameworkInit) {
            sOpenInteractionLog = bl;
            WXBridgeManager.getInstance().registerCoreEnv("switchInteractionLog", String.valueOf(bl));
            return;
        }
    }

    public static boolean isInteractionLogOpen() {
        return sOpenInteractionLog;
    }
}

