/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.border;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Build;
import androidx.annotation.NonNull;
import com.taobao.weex.base.FloatUtil;

abstract class BorderCorner {
    static final float SWEEP_ANGLE = 45.0f;
    private float mCornerRadius = 0.0f;
    private float mPreBorderWidth = 0.0f;
    private float mPostBorderWidth = 0.0f;
    private RectF mBorderBox;
    protected float mAngleBisector;
    private boolean hasInnerCorner = false;
    private boolean hasOuterCorner = false;
    private float mOvalLeft;
    private float mOvalTop;
    private float mOvalRight;
    private float mOvalBottom;
    private float mRoundCornerStartX;
    private float mRoundCornerStartY;
    private float mRoundCornerEndX;
    private float mRoundCornerEndY;

    BorderCorner() {
    }

    final void set(float f, float f2, float f3, @NonNull RectF rectF, float f4) {
        RectF rectF2;
        if (FloatUtil.floatsEqual(this.mCornerRadius, f) && FloatUtil.floatsEqual(this.mPreBorderWidth, f2) && FloatUtil.floatsEqual(this.mPostBorderWidth, f3) && FloatUtil.floatsEqual(this.mAngleBisector, f4) && ((rectF2 = this.mBorderBox) == null || !rectF2.equals((Object)rectF))) {
            return;
        }
        this.mCornerRadius = f;
        this.mPreBorderWidth = f2;
        this.mPostBorderWidth = f3;
        this.mBorderBox = rectF;
        this.mAngleBisector = f4;
        boolean bl = f > 0.0f && !FloatUtil.floatsEqual(0.0f, f);
        this.hasOuterCorner = bl;
        bl = bl && this.getPreBorderWidth() >= 0.0f && this.getPostBorderWidth() >= 0.0f && this.getOuterCornerRadius() > this.getPreBorderWidth() && this.getOuterCornerRadius() > this.getPostBorderWidth();
        this.hasInnerCorner = bl;
        if (this.hasOuterCorner) {
            this.prepareOval();
        }
        this.prepareRoundCorner();
    }

    protected abstract void prepareOval();

    protected abstract void prepareRoundCorner();

    public final void drawRoundedCorner(@NonNull Canvas canvas, @NonNull Paint paint, float f) {
        if (this.hasOuterCorner()) {
            RectF rectF;
            Paint paint2;
            Paint paint3 = paint2;
            paint2 = new Paint(paint);
            float f2 = Math.abs(this.mOvalLeft - this.mOvalRight);
            if (paint.getStrokeWidth() > f2) {
                paint3.setStrokeWidth(f2);
            }
            paint3.setStrokeCap(Paint.Cap.ROUND);
            if (Build.VERSION.SDK_INT >= 21) {
                BorderCorner borderCorner = this;
                float f3 = borderCorner.mOvalLeft;
                float f4 = borderCorner.mOvalTop;
                f2 = borderCorner.mOvalRight;
                float f5 = borderCorner.mOvalBottom;
                canvas.drawArc(f3, f4, f2, f5, f, 45.0f, false, paint3);
                return;
            }
            Canvas canvas2 = canvas;
            canvas = rectF;
            BorderCorner borderCorner = this;
            float f6 = borderCorner.mOvalLeft;
            f2 = borderCorner.mOvalTop;
            float f7 = borderCorner.mOvalRight;
            float f8 = borderCorner.mOvalBottom;
            rectF = new RectF(f6, f2, f7, f8);
            canvas2.drawArc((RectF)canvas, f, 45.0f, false, paint3);
            return;
        }
        if (this.getRoundCornerStartX() == this.getRoundCornerEndX() && this.getRoundCornerStartY() == this.getRoundCornerEndY()) {
            return;
        }
        BorderCorner borderCorner = this;
        float f9 = borderCorner.getRoundCornerStartX();
        float f10 = borderCorner.getRoundCornerStartY();
        f = borderCorner.getRoundCornerEndX();
        float f11 = borderCorner.getRoundCornerEndY();
        canvas.drawLine(f9, f10, f, f11, paint);
    }

    public final float getRoundCornerStartX() {
        return this.mRoundCornerStartX;
    }

    final void setRoundCornerStartX(float f) {
        this.mRoundCornerStartX = f;
    }

    public final float getRoundCornerStartY() {
        return this.mRoundCornerStartY;
    }

    final void setRoundCornerStartY(float f) {
        this.mRoundCornerStartY = f;
    }

    public final float getRoundCornerEndX() {
        return this.mRoundCornerEndX;
    }

    final void setRoundCornerEndX(float f) {
        this.mRoundCornerEndX = f;
    }

    public final float getRoundCornerEndY() {
        return this.mRoundCornerEndY;
    }

    final void setRoundCornerEndY(float f) {
        this.mRoundCornerEndY = f;
    }

    final void setOvalLeft(float f) {
        this.mOvalLeft = f;
    }

    final void setOvalTop(float f) {
        this.mOvalTop = f;
    }

    final void setOvalRight(float f) {
        this.mOvalRight = f;
    }

    final void setOvalBottom(float f) {
        this.mOvalBottom = f;
    }

    boolean hasInnerCorner() {
        return this.hasInnerCorner;
    }

    boolean hasOuterCorner() {
        return this.hasOuterCorner;
    }

    protected final float getPreBorderWidth() {
        return this.mPreBorderWidth;
    }

    protected final float getPostBorderWidth() {
        return this.mPostBorderWidth;
    }

    protected final float getOuterCornerRadius() {
        return this.mCornerRadius;
    }

    protected final float getAngleBisectorDegree() {
        return this.mAngleBisector;
    }

    protected final RectF getBorderBox() {
        return this.mBorderBox;
    }
}

