/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.uniapp.ui.shadow;

import android.graphics.PointF;
import android.graphics.Rect;
import android.text.TextUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.List;

public class UniBoxShadowOptions {
    private static final String TAG = "UniBoxShadowOptions";
    public List<IParser> optionParamParsers;
    private float viewport = 750.0f;
    public float hShadow;
    public float vShadow;
    public float blur = 0.0f;
    public float spread = 0.0f;
    public float[] radii = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    public int color = -16777216;
    public boolean isInset = false;
    public int viewWidth = 0;
    public int viewHeight = 0;
    public PointF topLeft = null;

    public UniBoxShadowOptions(float f) {
        IParser iParser;
        IParser iParser2;
        if (750.0f != 0.0f) {
            this.viewport = f;
        }
        UniBoxShadowOptions uniBoxShadowOptions = this;
        uniBoxShadowOptions.optionParamParsers = new ArrayList<IParser>();
        IParser iParser3 = iParser2;
        iParser2 = new IParser(){

            @Override
            public void parse(String string2) {
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    float f = WXUtils.getFloat(string2, Float.valueOf(0.0f)).floatValue();
                    UniBoxShadowOptions.this.spread = WXViewUtils.getRealSubPxByWidth(f, UniBoxShadowOptions.this.viewport);
                    WXLogUtils.w(UniBoxShadowOptions.TAG, "Experimental box-shadow attribute: spread");
                    return;
                }
            }
        };
        IParser iParser4 = iParser;
        iParser = new IParser(){

            @Override
            public void parse(String string2) {
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    float f = WXUtils.getFloat(string2, Float.valueOf(0.0f)).floatValue();
                    UniBoxShadowOptions.this.blur = WXViewUtils.getRealSubPxByWidth(f, UniBoxShadowOptions.this.viewport);
                    return;
                }
            }
        };
        uniBoxShadowOptions.optionParamParsers.add(iParser4);
        uniBoxShadowOptions.optionParamParsers.add(iParser3);
    }

    public UniBoxShadowOptions scale(float f) {
        if (f > 0.0f && f <= 1.0f) {
            UniBoxShadowOptions uniBoxShadowOptions;
            UniBoxShadowOptions uniBoxShadowOptions2 = uniBoxShadowOptions;
            uniBoxShadowOptions2(this.viewport);
            uniBoxShadowOptions2.hShadow = this.hShadow * f;
            uniBoxShadowOptions2.vShadow = this.vShadow * f;
            uniBoxShadowOptions2.blur = this.blur * f;
            uniBoxShadowOptions.spread = this.spread * f;
            int n = 0;
            while (true) {
                float[] fArray = this.radii;
                if (n >= this.radii.length) break;
                uniBoxShadowOptions2.radii[n] = fArray[n] * f;
                ++n;
            }
            uniBoxShadowOptions2.viewHeight = (int)((float)this.viewHeight * f);
            uniBoxShadowOptions2.viewWidth = (int)((float)this.viewWidth * f);
            if (this.topLeft != null) {
                PointF pointF;
                PointF pointF2;
                PointF pointF3 = pointF2 = pointF;
                pointF3();
                uniBoxShadowOptions2.topLeft = pointF3;
                pointF2 = this.topLeft;
                pointF.x = pointF2.x * f;
                pointF.y = pointF2.y * f;
            }
            uniBoxShadowOptions2.color = this.color;
            uniBoxShadowOptions2.isInset = this.isInset;
            WXLogUtils.d(TAG, "Scaled BoxShadowOptions: [" + f + "] " + uniBoxShadowOptions2);
            return uniBoxShadowOptions2;
        }
        return null;
    }

    public Rect getTargetCanvasRect() {
        UniBoxShadowOptions uniBoxShadowOptions = this;
        int n = uniBoxShadowOptions.viewWidth + (int)(this.blur + this.spread + Math.abs(this.hShadow)) * 2;
        int n2 = uniBoxShadowOptions.viewHeight + (int)(this.blur + this.spread + Math.abs(this.vShadow)) * 2;
        return new Rect(0, 0, n, n2);
    }

    public String toString() {
        String string2 = "[" + this.radii[0] + "," + this.radii[2] + "," + this.radii[4] + "," + this.radii[6] + "]";
        StringBuffer stringBuffer = new StringBuffer("BoxShadowOptions{");
        stringBuffer.append("h-shadow=").append(this.hShadow);
        stringBuffer.append(", v-shadow=").append(this.vShadow);
        stringBuffer.append(", blur=").append(this.blur);
        stringBuffer.append(", spread=").append(this.spread);
        stringBuffer.append(", corner-radius=").append(string2);
        stringBuffer.append(", color=#").append(Integer.toHexString(this.color));
        stringBuffer.append(", inset=").append(this.isInset);
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public static interface IParser {
        public void parse(String var1);
    }
}

