/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex_media;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.dom.CSSConstants;
import com.taobao.weex.dom.WXAttr;
import com.taobao.weex.layout.ContentBoxMeasurement;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXBaseRefreshLayout;
import com.taobao.weex.utils.WXViewUtils;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.ISysEventListener;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.feature.weex.WeexInstanceMgr;
import io.dcloud.feature.weex.adapter.ScalableViewComponent;
import io.dcloud.feature.weex_media.VideoPlayerView;
import io.dcloud.feature.weex_media.option.EnumPlayStrategy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class VideoComponent
extends WXVContainer<VideoPlayerView>
implements ISysEventListener {
    private WXAttr attrs;
    private Map<String, Object> params;
    private IApp mApp;
    private AtomicBoolean isLoad = new AtomicBoolean(false);

    public VideoComponent(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) {
        super(instance, parent, basicComponentData);
        this.attrs = basicComponentData.getAttrs();
        if (!basicComponentData.getStyles().containsKey((Object)"flex")) {
            this.setContentBoxMeasurement(new ContentBoxMeasurement(){

                public void measureInternal(float width, float height, int widthMeasureMode, int heightMeasureMode) {
                    if (CSSConstants.isUndefined((float)width)) {
                        this.mMeasureWidth = WXViewUtils.getRealPxByWidth((float)300.0f, (float)VideoComponent.this.getInstance().getInstanceViewPortWidthWithFloat());
                    }
                    if (CSSConstants.isUndefined((float)height)) {
                        this.mMeasureHeight = WXViewUtils.getRealPxByWidth((float)225.0f, (float)VideoComponent.this.getInstance().getInstanceViewPortWidthWithFloat());
                    }
                }

                public void layoutBefore() {
                }

                public void layoutAfter(float computedWidth, float computedHeight) {
                }
            });
        }
    }

    protected VideoPlayerView initComponentHostView(Context context) {
        IWebview webview = WeexInstanceMgr.self().findWebview(this.getInstance());
        if (webview != null) {
            this.mApp = webview.obtainApp();
            this.mApp.registerSysEventListener((ISysEventListener)this, ISysEventListener.SysEventType.onKeyUp);
        }
        return new VideoPlayerView(this.getContext(), this);
    }

    public ViewGroup getRealView() {
        if (this.getHostView() != null) {
            return ((VideoPlayerView)this.getHostView()).getPlayerView();
        }
        return null;
    }

    public void addChild(WXComponent child, int index) {
        if (child instanceof ScalableViewComponent) {
            ((ScalableViewComponent)child).setScalable(true);
            super.addChild(child, index);
        }
    }

    public IApp getIApp() {
        IWebview webview;
        if (this.mApp == null && (webview = WeexInstanceMgr.self().findWebview(this.getInstance())) != null) {
            this.mApp = webview.obtainApp();
        }
        return this.mApp;
    }

    public void addSubView(View child, int index) {
        int index1;
        if (child == null || this.getRealView() == null) {
            return;
        }
        if (child instanceof WXBaseRefreshLayout) {
            return;
        }
        int count = this.getRealView().getChildCount();
        int n = index1 = index >= count ? -1 : index;
        if (this.getRealView().indexOfChild(child) == -1) {
            if (index1 == -1) {
                this.getRealView().addView(child);
            } else {
                this.getRealView().addView(child, index1);
            }
        }
        child.bringToFront();
    }

    @WXComponentProp(name="src")
    public void setSrc(String src) {
        if (PdrUtil.isEmpty((Object)src)) {
            return;
        }
        ((VideoPlayerView)this.getHostView()).setSrc(src);
    }

    @WXComponentProp(name="header")
    public void setHeader(String header) {
        if (PdrUtil.isEmpty((Object)header)) {
            return;
        }
        ((VideoPlayerView)this.getHostView()).setHeader(header);
    }

    @WXComponentProp(name="autoplay")
    public void setAutoPlay(boolean autoPlay) {
        if (PdrUtil.isEmpty((Object)autoPlay)) {
            return;
        }
        ((VideoPlayerView)this.getHostView()).setAutoplay(autoPlay);
    }

    @WXComponentProp(name="initialTime")
    public void setInitTime(float time) {
        ((VideoPlayerView)this.getHostView()).setInitialTime(time);
    }

    @WXComponentProp(name="duration")
    public void setDuration(float duration) {
        ((VideoPlayerView)this.getHostView()).setDuration(duration);
    }

    @WXComponentProp(name="danmuList")
    public void setDanmuList(JSONArray list) {
        ((VideoPlayerView)this.getHostView()).setDanmuList(list);
    }

    @WXComponentProp(name="loop")
    public void setLoop(boolean isloop) {
        ((VideoPlayerView)this.getHostView()).setLoop(isloop);
    }

    @WXComponentProp(name="muted")
    public void setMute(boolean isMute) {
        ((VideoPlayerView)this.getHostView()).setMuted(isMute);
    }

    @WXComponentProp(name="direction")
    public void setDirection(int direction) {
        ((VideoPlayerView)this.getHostView()).setDirection(direction);
    }

    @WXComponentProp(name="playStrategy")
    public void setPlayStrategy(int playStrategy) {
        EnumPlayStrategy enumPlayStrategy = EnumPlayStrategy.DEFAULT;
        if (playStrategy == EnumPlayStrategy.PLAY_SMOOTH.getFlagVal()) {
            enumPlayStrategy = EnumPlayStrategy.PLAY_SMOOTH;
        } else if (playStrategy == EnumPlayStrategy.START_QUICK.getFlagVal()) {
            enumPlayStrategy = EnumPlayStrategy.START_QUICK;
        } else if (playStrategy == EnumPlayStrategy.M3U8_SMOOTH.getFlagVal()) {
            enumPlayStrategy = EnumPlayStrategy.M3U8_SMOOTH;
        } else if (playStrategy == EnumPlayStrategy.DEFAULT.getFlagVal()) {
            enumPlayStrategy = EnumPlayStrategy.DEFAULT;
        }
        ((VideoPlayerView)this.getHostView()).setFlowStrategy(enumPlayStrategy);
    }

    @WXComponentProp(name="objectFit")
    public void setFit(String type) {
        if (PdrUtil.isEmpty((Object)type)) {
            return;
        }
        ((VideoPlayerView)this.getHostView()).setObjectFit(type);
    }

    @WXComponentProp(name="showMuteBtn")
    public void isShowMuteBtn(boolean isshow) {
        ((VideoPlayerView)this.getHostView()).setMuteBtn(isshow);
    }

    @WXComponentProp(name="playBtnPosition")
    public void setPlayBtnPosition(String position) {
        if (PdrUtil.isEmpty((Object)position)) {
            return;
        }
        ((VideoPlayerView)this.getHostView()).setPlayBtnPosition(position);
    }

    @WXComponentProp(name="title")
    public void setTitle(String title) {
        if (PdrUtil.isEmpty((Object)title)) {
            return;
        }
        ((VideoPlayerView)this.getHostView()).setTitle(title);
    }

    @WXComponentProp(name="httpCache")
    public void httpCache(boolean cacheEnable) {
        ((VideoPlayerView)this.getHostView()).setHttpCacheEnable(cacheEnable);
    }

    @WXComponentProp(name="codec")
    public void setCodeMode(String codeMode) {
        ((VideoPlayerView)this.getHostView()).setCodec(codeMode);
    }

    @WXComponentProp(name="showLoading")
    public void showLoading(boolean isShow) {
        ((VideoPlayerView)this.getHostView()).setShowLoading(isShow);
    }

    public void updateProperties(Map<String, Object> props) {
        if (props.size() > 0 && this.getHostView() != null) {
            this.params = this.combinMap(this.params, props);
            ((VideoPlayerView)this.getHostView()).setProgress(!this.params.containsKey("showProgress") || Boolean.parseBoolean(this.params.get("showProgress").toString()));
            ((VideoPlayerView)this.getHostView()).setShowFullScreenBtn(!this.params.containsKey("showFullscreenBtn") || Boolean.parseBoolean(this.params.get("showFullscreenBtn").toString()));
            ((VideoPlayerView)this.getHostView()).setPlayBtnVisibility(!this.params.containsKey("showPlayBtn") || Boolean.parseBoolean(this.params.get("showPlayBtn").toString()));
            ((VideoPlayerView)this.getHostView()).setEnableProgressGesture(!this.params.containsKey("enableProgressGesture") || Boolean.parseBoolean(this.params.get("enableProgressGesture").toString()));
            if (props.containsKey("src")) {
                ((VideoPlayerView)this.getHostView()).setSrc((String)props.get("src"));
            }
            ((VideoPlayerView)this.getHostView()).setShowCenterPlayBtn(!this.params.containsKey("showCenterPlayBtn") || Boolean.parseBoolean(this.params.get("showCenterPlayBtn").toString()));
            ((VideoPlayerView)this.getHostView()).setControls(!this.params.containsKey("controls") || Boolean.parseBoolean(this.params.get("controls").toString()));
            if (this.params.containsKey("vslideGestureInFullscreen")) {
                ((VideoPlayerView)this.getHostView()).setFullScreenPageGesture(Boolean.parseBoolean(this.params.get("vslideGestureInFullscreen").toString()));
            }
            if (this.params.containsKey("vslideGesture")) {
                ((VideoPlayerView)this.getHostView()).setPageGesture(Boolean.parseBoolean(this.params.get("vslideGesture").toString()));
            }
            if (this.params.containsKey("showScreenLockButton")) {
                ((VideoPlayerView)this.getHostView()).setLockScreen(Boolean.parseBoolean(this.params.get("showScreenLockButton").toString()));
            }
            if (this.params.containsKey("enablePlayGesture")) {
                ((VideoPlayerView)this.getHostView()).setEnablePlayGesture(Boolean.parseBoolean(this.params.get("enablePlayGesture").toString()));
            }
        }
        super.updateProperties(props);
        if (props.size() > 0 && props.containsKey("src")) {
            String srcParam = (String)props.get("src");
            ((VideoPlayerView)this.getHostView()).onLayoutFinished(srcParam);
        }
    }

    private Map<String, Object> combinMap(Map<String, Object> main, Map<String, Object> second) {
        if (main == null && second == null) {
            return new HashMap<String, Object>();
        }
        if (main == null) {
            return second;
        }
        if (second == null) {
            return main;
        }
        main.putAll(second);
        return main;
    }

    @WXComponentProp(name="poster")
    public void setPoster(String poster) {
        ((VideoPlayerView)this.getHostView()).setPoster(poster);
    }

    @JSMethod
    public void requestFullScreen(JSONObject param) {
        int direction;
        try {
            direction = param.getInteger("direction");
        }
        catch (Exception e) {
            direction = -90;
        }
        ((VideoPlayerView)this.getHostView()).requestFullScreen(direction);
    }

    @JSMethod
    public void play() {
        ((VideoPlayerView)this.getHostView()).play();
    }

    @JSMethod
    public void pause() {
        ((VideoPlayerView)this.getHostView()).pause();
    }

    @JSMethod
    public void stop() {
        ((VideoPlayerView)this.getHostView()).stop();
    }

    @JSMethod
    public void seek(int position) {
        if (PdrUtil.isEmpty((Object)position)) {
            return;
        }
        ((VideoPlayerView)this.getHostView()).seek(position * 1000);
    }

    @JSMethod
    public void sendDanmu(JSONObject danmu) {
        if (danmu != null) {
            ((VideoPlayerView)this.getHostView()).sendDanmu(danmu);
        }
    }

    @JSMethod
    public void playbackRate(float rate) {
        if (PdrUtil.isEmpty((Object)Float.valueOf(rate))) {
            return;
        }
        ((VideoPlayerView)this.getHostView()).sendPlayBackRate(String.valueOf(rate));
    }

    @JSMethod
    public void exitFullScreen() {
        ((VideoPlayerView)this.getHostView()).exitFullScreen();
    }

    protected void onHostViewInitialized(VideoPlayerView host) {
        super.onHostViewInitialized((View)host);
        if (this.attrs != null && this.attrs.size() > 0) {
            ((VideoPlayerView)this.getHostView()).setEnableDanmu(this.attrs.containsKey((Object)"enableDanmu") && Boolean.parseBoolean(this.attrs.get((Object)"enableDanmu").toString()));
            ((VideoPlayerView)this.getHostView()).setDanmuBtn(this.attrs.containsKey((Object)"danmuBtn") && Boolean.parseBoolean(this.attrs.get((Object)"danmuBtn").toString()));
        }
    }

    public void onActivityResume() {
        super.onActivityResume();
        if (this.getHostView() != null) {
            ((VideoPlayerView)this.getHostView()).onActivityResume();
        }
    }

    public void onActivityPause() {
        super.onActivityPause();
        if (this.getHostView() != null) {
            ((VideoPlayerView)this.getHostView()).pause();
        }
    }

    public void destroy() {
        super.destroy();
        if (this.getHostView() != null) {
            ((VideoPlayerView)this.getHostView()).destory();
        }
        if (this.mApp != null) {
            this.mApp.unregisterSysEventListener((ISysEventListener)this, ISysEventListener.SysEventType.onKeyUp);
        }
    }

    public boolean onExecute(ISysEventListener.SysEventType pEventType, Object pArgs) {
        Object[] _args;
        int keyCode;
        if (pEventType == ISysEventListener.SysEventType.onKeyUp && (keyCode = ((Integer)(_args = (Object[])pArgs)[0]).intValue()) == 4 && ((VideoPlayerView)this.getHostView()).isFullScreen() && this.getHostView() != null) {
            return ((VideoPlayerView)this.getHostView()).onBackPress();
        }
        return false;
    }

    public void addEvent(String type) {
        if (type.equals("click")) {
            return;
        }
        super.addEvent(type);
    }
}

