/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.EncodeHintType;
import com.dcloud.zxing2.WriterException;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.oned.OneDimensionalCodeWriter;
import com.dcloud.zxing2.oned.UPCEANReader;
import com.dcloud.zxing2.oned.UPCEANWriter;
import com.dcloud.zxing2.oned.UPCEReader;
import java.util.Map;

public final class UPCEWriter
extends UPCEANWriter {
    private static final int CODE_WIDTH = 51;

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n5, int n6, Map<EncodeHintType, ?> map) throws WriterException {
        if (barcodeFormat == BarcodeFormat.UPC_E) {
            return super.encode(string2, barcodeFormat, n5, n6, map);
        }
        throw new IllegalArgumentException("Can only encode UPC_E, but got " + (Object)((Object)barcodeFormat));
    }

    @Override
    public boolean[] encode(String string2) {
        if (string2.length() == 8) {
            int n5 = UPCEReader.CHECK_DIGIT_ENCODINGS[Integer.parseInt(string2.substring(7, 8))];
            boolean[] blArray = new boolean[51];
            int n6 = OneDimensionalCodeWriter.appendPattern(blArray, 0, UPCEANReader.START_END_PATTERN, true);
            int n7 = 1;
            while (n7 <= 6) {
                int n8 = n7;
                int n9 = n8 + 1;
                int n10 = Integer.parseInt(string2.substring(n8, n9));
                if ((n5 >> 6 - n7 & 1) == 1) {
                    n10 += 10;
                }
                n6 += OneDimensionalCodeWriter.appendPattern(blArray, n6, UPCEANReader.L_AND_G_PATTERNS[n10], false);
                n7 = n9;
            }
            OneDimensionalCodeWriter.appendPattern(blArray, n6, UPCEANReader.END_PATTERN, false);
            return blArray;
        }
        throw new IllegalArgumentException("Requested contents should be 8 digits long, but got " + string2.length());
    }
}

