/*
 * Decompiled with CFR 0.152.
 */
package com.dmcbig.mediapicker;

import android.app.Activity;
import android.app.LoaderManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListPopupWindow;
import android.widget.TextView;
import androidtranscoder.MediaTranscoder;
import androidtranscoder.format.MediaFormatStrategy;
import androidtranscoder.format.MediaFormatStrategyPresets;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.dcloud.android.widget.toast.ToastCompat;
import com.dmcbig.mediapicker.MediaPickerR;
import com.dmcbig.mediapicker.PickerConfig;
import com.dmcbig.mediapicker.PreviewActivity;
import com.dmcbig.mediapicker.adapter.FolderAdapter;
import com.dmcbig.mediapicker.adapter.MediaGridAdapter;
import com.dmcbig.mediapicker.adapter.SpacingDecoration;
import com.dmcbig.mediapicker.data.DataCallback;
import com.dmcbig.mediapicker.data.ImageLoader;
import com.dmcbig.mediapicker.data.MediaLoader;
import com.dmcbig.mediapicker.data.VideoLoader;
import com.dmcbig.mediapicker.entity.Folder;
import com.dmcbig.mediapicker.entity.Media;
import com.dmcbig.mediapicker.utils.ScreenUtils;
import io.dcloud.base.R;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.CompressUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.RuningAcitvityUtil;
import io.dcloud.common.util.ThreadPool;
import io.dcloud.common.util.language.LanguageUtil;
import io.dcloud.feature.gallery.imageedit.IMGEditActivity;
import io.dcloud.js.gallery.GalleryFeatureImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;

public class PickerActivity
extends FragmentActivity
implements DataCallback,
View.OnClickListener {
    Intent argsIntent;
    RecyclerView recyclerView;
    Button done;
    Button category_btn;
    Button preview;
    ImageView fullImage;
    MediaGridAdapter gridAdapter;
    ListPopupWindow mFolderPopupWindow;
    private FolderAdapter mFolderAdapter;
    boolean isSingle = false;
    String doneBtnText = "";
    String cropOptions;
    String docPath;
    boolean isCompress = false;
    boolean isAddImageFor34 = false;
    Iterator<Media> selectIterator;
    private boolean isFinish = false;

    private void checkoutNeedShowPermissionBar() {
        if (Build.VERSION.SDK_INT >= 34) {
            if (ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.READ_MEDIA_IMAGES") == -1) {
                return;
            }
            PickerActivity pickerActivity = this;
            pickerActivity.restartMediaData();
            pickerActivity.findViewById(R.id.dcloud_gallery_permission_bar).setVisibility(8);
            return;
        }
    }

    private void permissionBar() {
        if (Build.VERSION.SDK_INT >= 34) {
            boolean bl = ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.READ_MEDIA_IMAGES") == -1;
            this.isAddImageFor34 = bl;
            if (bl) {
                PickerActivity pickerActivity = this;
                pickerActivity.findViewById(R.id.dcloud_gallery_permission_bar).setVisibility(0);
                pickerActivity.findViewById(R.id.dcloud_gallery_permission_bar_permission_request).setOnClickListener(view -> {
                    if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)stringArray3, (String)"android.permission.READ_MEDIA_IMAGES")) {
                        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
                        intent.setData(Uri.fromParts((String)"package", (String)stringArray3.getPackageName(), null));
                        stringArray3.startActivityForResult(intent, PickerConfig.PERMISSION_REQUEST);
                        return;
                    }
                    String[] stringArray = stringArray3;
                    String[] stringArray2 = new String[1];
                    String[] stringArray3 = stringArray2;
                    stringArray2[0] = "android.permission.READ_MEDIA_IMAGES";
                    ActivityCompat.requestPermissions((Activity)stringArray, (String[])stringArray3, (int)PickerConfig.PERMISSION_REQUEST);
                });
                return;
            }
            return;
        }
        this.findViewById(R.id.dcloud_gallery_permission_bar).setVisibility(4);
    }

    private void setTopAndBottomBarColor() {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(Color.parseColor((String)"#21282C"));
            window.setNavigationBarColor(Color.parseColor((String)"#21282C"));
            return;
        }
    }

    private void getOtherArgs() {
        String string2;
        this.doneBtnText = string2 = this.argsIntent.getStringExtra("done_button_text");
        if (!PdrUtil.isEmpty(string2)) {
            this.done.setText((CharSequence)this.doneBtnText);
        }
        if (!PdrUtil.isEmpty(this.cropOptions)) {
            PickerActivity pickerActivity = this;
            pickerActivity.done.setVisibility(4);
            pickerActivity.findViewById(MediaPickerR.MP_ID_PREVIEW).setVisibility(4);
            pickerActivity.isCompress = false;
            pickerActivity.findViewById(R.id.check_origin_image_layout).setVisibility(8);
            return;
        }
    }

    private void compress(final ArrayList<Media> arrayList) {
        block6: {
            Runnable runnable;
            block7: {
                Media media;
                block8: {
                    block9: {
                        MediaTranscoder.Listener listener;
                        if (this.isFinishing() || this.isDestroyed()) break block6;
                        if (!this.selectIterator.hasNext()) break block7;
                        media = this.selectIterator.next();
                        if (media.extension.equalsIgnoreCase(".png") || media.extension.equalsIgnoreCase(".jpg") || media.extension.equalsIgnoreCase(".jpeg")) break block8;
                        if (media.mediaType != 3) break block9;
                        final String string2 = this.docPath.endsWith("/") ? this.docPath + "compress_video_" + SystemClock.elapsedRealtime() + ".mp4" : this.docPath + "/compress_video_" + SystemClock.elapsedRealtime() + ".mp4";
                        new File(string2).getParentFile().mkdirs();
                        MediaTranscoder mediaTranscoder = MediaTranscoder.getInstance();
                        String string3 = media.path;
                        String string4 = string2;
                        MediaFormatStrategy mediaFormatStrategy = MediaFormatStrategyPresets.createAndroid720pStrategy(2, 1.0);
                        MediaTranscoder.Listener listener2 = listener;
                        try {
                            listener = new MediaTranscoder.Listener(){

                                @Override
                                public void onTranscodeProgress(double d6) {
                                }

                                @Override
                                public void onTranscodeCompleted() {
                                    media.path = string2;
                                    PickerActivity.this.compress(arrayList);
                                }

                                @Override
                                public void onTranscodeCanceled() {
                                    PickerActivity.this.compress(arrayList);
                                }

                                @Override
                                public void onTranscodeFailed(Exception exception) {
                                    PickerActivity.this.compress(arrayList);
                                }
                            };
                            mediaTranscoder.transcodeVideo(string3, string4, mediaFormatStrategy, listener2);
                        }
                        catch (Exception exception) {
                            this.compress(arrayList);
                        }
                        break block6;
                        break block6;
                    }
                    this.compress(arrayList);
                    break block6;
                }
                Media media2 = media;
                String[] stringArray = media2.path.split("/");
                String string5 = this.docPath + "uniapp_temp/compressed/" + System.currentTimeMillis() + "_" + stringArray[stringArray.length - 1];
                if (!TextUtils.isEmpty((CharSequence)(string5 = CompressUtil.compressImage(media2.path, string5, media.extension.equalsIgnoreCase(".png"), (Context)this)))) {
                    media.path = string5;
                }
                this.compress(arrayList);
                break block6;
            }
            Runnable runnable2 = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    Intent intent;
                    5 v02 = this;
                    Intent intent2 = intent;
                    intent2();
                    intent.putParcelableArrayListExtra("select_result", arrayList);
                    v02.PickerActivity.this.setResult(19901026, intent2);
                    v02.PickerActivity.this.finish();
                }
            };
            this.runOnUiThread(runnable2);
            return;
        }
    }

    protected void onCreate(@Nullable Bundle object) {
        super.onCreate((Bundle)object);
        this.requestWindowFeature(1);
        this.argsIntent = this.getIntent();
        this.setContentView(MediaPickerR.MP_LAYOUT_PICKER_MAIN);
        this.recyclerView = (RecyclerView)this.findViewById(MediaPickerR.MP_ID_RECYCLER_VIEW);
        this.findViewById(MediaPickerR.MP_ID_BTN_BACK).setOnClickListener((View.OnClickListener)this);
        this.setTitleBar();
        this.done = (Button)this.findViewById(MediaPickerR.MP_ID_DONE);
        this.category_btn = (Button)this.findViewById(MediaPickerR.MP_ID_CATEGORY_BTN);
        this.preview = (Button)this.findViewById(MediaPickerR.MP_ID_PREVIEW);
        this.fullImage = (ImageView)this.findViewById(R.id.check_origin_image);
        if (this.argsIntent.getIntExtra("select_mode", 101) == 102) {
            boolean bl;
            this.isCompress = bl = this.argsIntent.getBooleanExtra("COMPRESSED", false);
            this.fullImage.setSelected(bl ^ true);
            this.findViewById(R.id.check_origin_image_layout).setVisibility(8);
        } else {
            object = this.argsIntent;
            if (object != null && object.hasExtra("size_type")) {
                object = this.argsIntent.getStringExtra("size_type");
                if (object != null) {
                    if (((String)object).contains("original") && ((String)object).contains("compressed")) {
                        this.isCompress = true;
                        this.findViewById(R.id.check_origin_image_layout).setOnClickListener((View.OnClickListener)this);
                    } else if (((String)object).contains("original")) {
                        this.isCompress = false;
                        this.fullImage.setSelected(true);
                    } else {
                        this.isCompress = true;
                        this.findViewById(R.id.check_origin_image_layout).setVisibility(8);
                    }
                } else {
                    this.isCompress = true;
                    this.findViewById(R.id.check_origin_image_layout).setOnClickListener((View.OnClickListener)this);
                }
            } else {
                this.isCompress = true;
                this.findViewById(R.id.check_origin_image_layout).setOnClickListener((View.OnClickListener)this);
            }
        }
        this.done.setOnClickListener((View.OnClickListener)this);
        this.category_btn.setOnClickListener((View.OnClickListener)this);
        this.preview.setOnClickListener((View.OnClickListener)this);
        if (BaseInfo.sGlobalFullScreen) {
            PickerActivity pickerActivity = this;
            pickerActivity.setFullScreen((Activity)pickerActivity, true);
        }
        this.cropOptions = this.argsIntent.getStringExtra("image_crop");
        this.docPath = this.argsIntent.getStringExtra("doc_path");
        this.permissionBar();
        this.createAdapter();
        this.createFolderAdapter();
        this.getMediaData();
        this.getOtherArgs();
        this.setTopAndBottomBarColor();
    }

    protected void attachBaseContext(Context context) {
        if (Build.VERSION.SDK_INT < 26) {
            super.attachBaseContext(context);
            return;
        }
        super.attachBaseContext(LanguageUtil.updateContextLanguageAfterO(context, false));
    }

    public void setTitleBar() {
        int n5 = this.argsIntent.getIntExtra("select_mode", 101);
        if (n5 == 101) {
            ((TextView)this.findViewById(MediaPickerR.MP_ID_BAR_TITLE)).setText((CharSequence)this.getString(MediaPickerR.MP_STRING_SELECT_TITLE));
            return;
        }
        if (n5 == 100) {
            ((TextView)this.findViewById(MediaPickerR.MP_ID_BAR_TITLE)).setText((CharSequence)this.getString(MediaPickerR.MP_STRING_SELECT_IMAGE_TITLE));
            return;
        }
        if (n5 == 102) {
            ((TextView)this.findViewById(MediaPickerR.MP_ID_BAR_TITLE)).setText((CharSequence)this.getString(MediaPickerR.MP_STRING_SELECT_VIDEO_TITLE));
            return;
        }
    }

    void createAdapter() {
        MediaGridAdapter mediaGridAdapter;
        Object object;
        ArrayList arrayList;
        GridLayoutManager gridLayoutManager;
        Object object2 = gridLayoutManager;
        gridLayoutManager = new GridLayoutManager((Context)this, PickerConfig.GridSpanCount);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)object2);
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new SpacingDecoration(PickerConfig.GridSpanCount, PickerConfig.GridSpace));
        this.recyclerView.setHasFixedSize(true);
        object2 = arrayList;
        arrayList = new ArrayList();
        ArrayList arrayList2 = this.argsIntent.getParcelableArrayListExtra("default_list");
        final String string2 = this.argsIntent.getStringExtra("select_max_cb_id");
        int n5 = this.argsIntent.getIntExtra("max_select_count", Integer.MAX_VALUE);
        long l5 = this.argsIntent.getLongExtra("max_select_size", Long.MAX_VALUE);
        this.isSingle = this.argsIntent.getBooleanExtra("single_select", false);
        if (!TextUtils.isEmpty((CharSequence)this.cropOptions)) {
            this.isSingle = true;
        }
        if (this.isSingle) {
            object = this.done;
            if (object != null) {
                object.setVisibility(8);
            }
            if ((object = this.preview) != null) {
                object.setVisibility(4);
            }
        }
        object = mediaGridAdapter;
        boolean bl = this.isSingle;
        this.gridAdapter = object;
        new MediaGridAdapter((ArrayList<Media>)object2, (Context)this, arrayList2, n5, l5, bl).setOnMaxListener(new MediaGridAdapter.OnPickerSelectMaxListener(){

            @Override
            public void onMaxed() {
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    GalleryFeatureImpl.onMaxed((Context)PickerActivity.this, string2);
                    return;
                }
            }
        });
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.gridAdapter);
    }

    void createFolderAdapter() {
        ArrayList<Folder> arrayList;
        PickerActivity pickerActivity = this;
        ArrayList<Folder> arrayList2 = arrayList;
        arrayList = new ArrayList<Folder>();
        pickerActivity.mFolderAdapter = new FolderAdapter(arrayList2, (Context)this);
        this.mFolderPopupWindow = new ListPopupWindow((Context)this);
        this.mFolderPopupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(-1));
        pickerActivity.mFolderPopupWindow.setAdapter((ListAdapter)this.mFolderAdapter);
        pickerActivity.mFolderPopupWindow.setHeight((int)((double)ScreenUtils.getScreenHeight((Context)this) * 0.6));
        pickerActivity.mFolderPopupWindow.setAnchorView(this.findViewById(MediaPickerR.MP_ID_FOOTER));
        pickerActivity.mFolderPopupWindow.setModal(true);
        pickerActivity.mFolderPopupWindow.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int n5, long l5) {
                2 v02 = object;
                v02.PickerActivity.this.mFolderAdapter.setSelectIndex(n5);
                Object object = v02.PickerActivity.this;
                ((PickerActivity)object).category_btn.setText((CharSequence)((PickerActivity)object).mFolderAdapter.getItem((int)n5).name);
                object = v02.PickerActivity.this;
                ((PickerActivity)object).gridAdapter.updateAdapter(((PickerActivity)object).mFolderAdapter.getSelectMedias());
                v02.PickerActivity.this.mFolderPopupWindow.dismiss();
            }
        });
    }

    void getMediaData() {
        int n5 = this.argsIntent.getIntExtra("select_mode", 101);
        if (n5 == 101) {
            MediaLoader mediaLoader;
            MediaLoader mediaLoader2 = mediaLoader;
            PickerActivity pickerActivity = this;
            mediaLoader = new MediaLoader((Context)pickerActivity, pickerActivity);
            this.getLoaderManager().initLoader(n5, null, (LoaderManager.LoaderCallbacks)mediaLoader2);
            return;
        }
        if (n5 == 100) {
            ImageLoader imageLoader;
            ImageLoader imageLoader2 = imageLoader;
            PickerActivity pickerActivity = this;
            imageLoader = new ImageLoader((Context)pickerActivity, pickerActivity);
            this.getLoaderManager().initLoader(n5, null, (LoaderManager.LoaderCallbacks)imageLoader2);
            return;
        }
        if (n5 == 102) {
            VideoLoader videoLoader;
            VideoLoader videoLoader2 = videoLoader;
            PickerActivity pickerActivity = this;
            videoLoader = new VideoLoader((Context)pickerActivity, pickerActivity);
            this.getLoaderManager().initLoader(n5, null, (LoaderManager.LoaderCallbacks)videoLoader2);
            return;
        }
    }

    void restartMediaData() {
        int n5 = this.argsIntent.getIntExtra("select_mode", 101);
        if (n5 == 101) {
            MediaLoader mediaLoader;
            MediaLoader mediaLoader2 = mediaLoader;
            PickerActivity pickerActivity = this;
            mediaLoader = new MediaLoader((Context)pickerActivity, pickerActivity);
            this.getLoaderManager().restartLoader(n5, null, (LoaderManager.LoaderCallbacks)mediaLoader2);
            return;
        }
        if (n5 == 100) {
            ImageLoader imageLoader;
            ImageLoader imageLoader2 = imageLoader;
            PickerActivity pickerActivity = this;
            imageLoader = new ImageLoader((Context)pickerActivity, pickerActivity);
            this.getLoaderManager().restartLoader(n5, null, (LoaderManager.LoaderCallbacks)imageLoader2);
            return;
        }
        if (n5 == 102) {
            VideoLoader videoLoader;
            VideoLoader videoLoader2 = videoLoader;
            PickerActivity pickerActivity = this;
            videoLoader = new VideoLoader((Context)pickerActivity, pickerActivity);
            this.getLoaderManager().restartLoader(n5, null, (LoaderManager.LoaderCallbacks)videoLoader2);
            return;
        }
    }

    @Override
    public void onData(ArrayList<Folder> arrayList) {
        if (this.isAddImageFor34) {
            int n5 = arrayList.size();
            for (int i5 = 0; i5 < n5; ++i5) {
                Folder folder = arrayList.get(i5);
                folder.addMedias(new Media(R.drawable.dcloud_gallery_permission_add + "", "", 0L, 3, 0L, Integer.MIN_VALUE, ""));
            }
        }
        PickerActivity pickerActivity = this;
        pickerActivity.setView(arrayList);
        pickerActivity.category_btn.setText((CharSequence)arrayList.get((int)0).name);
        pickerActivity.mFolderAdapter.updateAdapter(arrayList);
    }

    void setView(ArrayList<Folder> arrayList) {
        PickerActivity pickerActivity = this;
        pickerActivity.gridAdapter.updateAdapter(arrayList.get(0).getMedias());
        pickerActivity.setButtonText();
        pickerActivity.gridAdapter.setOnItemClickListener(new MediaGridAdapter.OnRecyclerViewItemClickListener(){

            @Override
            public void onItemClick(View object, Media media, ArrayList<Media> arrayList) {
                object = arrayList5.PickerActivity.this;
                if (((PickerActivity)object).isSingle) {
                    ArrayList<Integer> arrayList2;
                    ArrayList<Media> arrayList3;
                    Intent intent;
                    if (!PdrUtil.isEmpty(((PickerActivity)object).cropOptions)) {
                        ArrayList arrayList4;
                        if (!".gif".equalsIgnoreCase(media.extension) && media.mediaType != 3) {
                            Intent intent2;
                            Object object2 = object = intent2;
                            object((Context)arrayList5.PickerActivity.this, IMGEditActivity.class);
                            int n5 = arrayList5.PickerActivity.this.gridAdapter.getItemIndex(media);
                            object.putExtra("IMAGE_URI", (Parcelable)Uri.parse((String)("file://" + media.path)));
                            object2.putExtra("IMAGE_MEDIA_ID", media.id);
                            object2.putExtra("IMAGE_INDEX", n5);
                            intent2.putExtra("IMAGE_CROP", arrayList5.PickerActivity.this.cropOptions);
                            arrayList5.PickerActivity.this.startActivityForResult((Intent)object, 201);
                            return;
                        }
                        3 v22 = arrayList5;
                        ArrayList<Media> arrayList5 = arrayList4;
                        arrayList5();
                        arrayList4.add(media);
                        v22.PickerActivity.this.done(arrayList5);
                        return;
                    }
                    Object object3 = object = intent;
                    object((Context)arrayList5.PickerActivity.this, PreviewActivity.class);
                    object3.putExtra("max_select_count", arrayList5.PickerActivity.this.argsIntent.getIntExtra("max_select_count", Integer.MAX_VALUE));
                    object3.putExtra("single_select", true);
                    arrayList = arrayList3;
                    arrayList(1);
                    arrayList3.add(media);
                    ArrayList<Integer> arrayList6 = arrayList2;
                    arrayList6();
                    arrayList2.add(arrayList5.PickerActivity.this.gridAdapter.getItemIndex(media));
                    object3.putExtra("pre_raw_List", arrayList);
                    object.putExtra("FULL_IMAGE", arrayList5.PickerActivity.this.fullImage.isSelected());
                    object.putExtra("size_type", arrayList5.PickerActivity.this.argsIntent.getStringExtra("size_type"));
                    intent.putExtra("select_mode", arrayList5.PickerActivity.this.argsIntent.getIntExtra("select_mode", 101));
                    intent.putIntegerArrayListExtra("original_preview_index", arrayList6);
                    arrayList5.PickerActivity.this.startActivityForResult((Intent)object, 200);
                    return;
                }
                ((PickerActivity)object).setButtonText();
            }

            @Override
            public void onAddMore() {
                ActivityCompat.requestPermissions((Activity)PickerActivity.this, (String[])new String[]{"android.permission.READ_MEDIA_IMAGES"}, (int)PickerConfig.PERMISSION_REQUEST);
            }
        });
    }

    void setButtonText() {
        PickerActivity pickerActivity = this;
        int n5 = pickerActivity.argsIntent.getIntExtra("max_select_count", Integer.MAX_VALUE);
        if (PdrUtil.isEmpty(pickerActivity.doneBtnText)) {
            this.doneBtnText = this.getString(MediaPickerR.MP_STRING_DONE);
        }
        if (n5 == Integer.MAX_VALUE) {
            this.done.setText((CharSequence)(this.doneBtnText + "(" + this.gridAdapter.getSelectMedias().size() + ")"));
        } else {
            this.done.setText((CharSequence)(this.doneBtnText + "(" + this.gridAdapter.getSelectMedias().size() + "/" + n5 + ")"));
        }
        if (PdrUtil.isEmpty(this.cropOptions)) {
            this.preview.setText((CharSequence)(this.getString(MediaPickerR.MP_STRING_PREVIEW) + "(" + this.gridAdapter.getSelectMedias().size() + ")"));
            return;
        }
        PickerActivity pickerActivity2 = this;
        pickerActivity2.done.setVisibility(4);
        pickerActivity2.findViewById(MediaPickerR.MP_ID_PREVIEW).setVisibility(4);
    }

    public void onClick(View view) {
        int n5 = view.getId();
        if (n5 == MediaPickerR.MP_ID_BTN_BACK) {
            ArrayList<Media> arrayList;
            ArrayList<Media> arrayList2 = arrayList;
            arrayList = new ArrayList<Media>();
            this.done(arrayList2);
            return;
        }
        if (n5 == MediaPickerR.MP_ID_CATEGORY_BTN) {
            if (this.mFolderPopupWindow.isShowing()) {
                this.mFolderPopupWindow.dismiss();
                return;
            }
            this.mFolderPopupWindow.show();
            return;
        }
        if (n5 == MediaPickerR.MP_ID_DONE) {
            this.done(this.gridAdapter.getSelectMedias());
            return;
        }
        if (n5 == MediaPickerR.MP_ID_PREVIEW) {
            if (this.gridAdapter.getSelectMedias().size() <= 0) {
                ToastCompat.makeText((Context)this, this.getString(MediaPickerR.MP_STRING_SELECT_NULL), 0).show();
                return;
            }
            if (PdrUtil.isEmpty(this.cropOptions)) {
                ArrayList<Integer> arrayList;
                Intent intent;
                Intent intent2 = intent;
                new Intent((Context)this, PreviewActivity.class).putExtra("max_select_count", this.argsIntent.getIntExtra("max_select_count", Integer.MAX_VALUE));
                ArrayList<Media> arrayList3 = this.gridAdapter.getSelectMedias();
                intent2.putExtra("pre_raw_List", arrayList3);
                ArrayList<Integer> arrayList4 = arrayList;
                arrayList = new ArrayList<Integer>();
                int n6 = arrayList3.size();
                for (int i5 = 0; i5 < n6; ++i5) {
                    Media media = arrayList3.get(i5);
                    arrayList4.add(this.gridAdapter.getItemIndex(media));
                }
                Intent intent3 = intent2;
                intent3.putExtra("FULL_IMAGE", this.fullImage.isSelected());
                intent3.putExtra("size_type", this.argsIntent.getStringExtra("size_type"));
                intent3.putIntegerArrayListExtra("original_preview_index", arrayList4);
                intent3.putExtra("image_editable", this.argsIntent.getBooleanExtra("image_editable", true));
                intent3.putExtra("done_button_text", this.argsIntent.getStringExtra("done_button_text"));
                intent3.putExtra("select_mode", this.argsIntent.getIntExtra("select_mode", 101));
                this.startActivityForResult(intent2, 200);
                return;
            }
        } else if (n5 == R.id.check_origin_image_layout) {
            ImageView imageView = this.fullImage;
            imageView.setSelected(imageView.isSelected() ^ true);
            this.isCompress = this.fullImage.isSelected() ^ true;
            return;
        }
    }

    public void done(ArrayList<Media> arrayList) {
        Intent intent;
        pickerActivity2.isFinish = true;
        if (pickerActivity2.isCompress && arrayList != null && arrayList.size() > 0) {
            PickerActivity pickerActivity = pickerActivity2;
            pickerActivity.done.setClickable(false);
            pickerActivity.done.setFocusable(true);
            pickerActivity.findViewById(R.id.loading).setVisibility(0);
            pickerActivity2.selectIterator = arrayList.iterator();
            ThreadPool.self().addThreadTask(() -> this.compress(arrayList));
            return;
        }
        PickerActivity pickerActivity = pickerActivity2;
        PickerActivity pickerActivity2 = intent;
        new Intent().putParcelableArrayListExtra("select_result", arrayList);
        pickerActivity.setResult(19901026, (Intent)pickerActivity2);
        pickerActivity.finish();
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        if (this.isFinish) {
            return true;
        }
        return super.dispatchTouchEvent(motionEvent);
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    public void onBackPressed() {
        ArrayList arrayList;
        PickerActivity pickerActivity = arrayList2;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        pickerActivity.done(arrayList2);
        super.onBackPressed();
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
    }

    public void onRequestPermissionsResult(int n5, @NonNull String[] stringArray, @NonNull int[] nArray) {
        PickerActivity pickerActivity = this;
        super.onRequestPermissionsResult(n5, stringArray, nArray);
        n5 = ActivityCompat.checkSelfPermission((Context)pickerActivity, (String)"android.permission.READ_MEDIA_IMAGES") == -1 ? 1 : 0;
        boolean bl = ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.READ_MEDIA_VISUAL_USER_SELECTED") == -1;
        if (n5 != 0 && bl) {
            this.mFolderAdapter.updateAdapter(new ArrayList<Folder>());
            return;
        }
        this.restartMediaData();
        if (n5 == 0) {
            this.isAddImageFor34 = n5;
            this.findViewById(R.id.dcloud_gallery_permission_bar).setVisibility(8);
            return;
        }
    }

    protected void onActivityResult(int n5, int n6, Intent object) {
        super.onActivityResult(n5, n6, (Intent)object);
        if (object != null && object.hasExtra("FULL_IMAGE")) {
            PickerActivity pickerActivity = object3;
            pickerActivity.fullImage.setSelected(object.getBooleanExtra("FULL_IMAGE", false));
            pickerActivity.isCompress = pickerActivity.fullImage.isSelected() ^ true;
        }
        if (n5 == 200) {
            ArrayList arrayList = object.getParcelableArrayListExtra("select_result");
            if (n6 == 1990) {
                ArrayList arrayList2 = object.getIntegerArrayListExtra("original_preview_index");
                object = object.getParcelableArrayListExtra("edited_preview_data");
                if (arrayList2 != null && arrayList2.size() > 0 && object != null && ((ArrayList)object).size() > 0) {
                    ArrayList<Media> arrayList3 = ((PickerActivity)object3).gridAdapter.getMedias();
                    for (int i5 = 0; i5 < arrayList2.size(); ++i5) {
                        int n7 = (Integer)arrayList2.get(i5);
                        if (n7 < 0) continue;
                        arrayList3.set(n7, (Media)((ArrayList)object).get(i5));
                    }
                    ((PickerActivity)object3).gridAdapter.updateAdapter(arrayList3);
                }
                PickerActivity pickerActivity = object3;
                pickerActivity.gridAdapter.updateSelectAdapter(arrayList);
                pickerActivity.setButtonText();
                return;
            }
            if (n6 == 19901026) {
                ((PickerActivity)object3).done(arrayList);
                return;
            }
        } else if (n5 == 201) {
            if (n6 == -1 && object != null) {
                Intent intent = object;
                n5 = intent.getIntExtra("IMAGE_INDEX", -1);
                n6 = intent.getIntExtra("_id", -1);
                if (n6 != -1 && n5 != -1) {
                    ArrayList<Media> arrayList;
                    Media media;
                    PickerActivity pickerActivity = object3;
                    Object object2 = object;
                    Object object3 = object2.getStringExtra("PATH");
                    String string2 = object2.getStringExtra("_display_name");
                    long l5 = System.currentTimeMillis();
                    l5 = object2.getLongExtra("date_added", l5);
                    int n8 = object2.getIntExtra("mime_type", 0);
                    long l6 = object2.getLongExtra("_size", 0L);
                    String string3 = object2.getStringExtra("PARENTPATH");
                    Media media2 = media;
                    media = new Media((String)object3, string2, l5, n8, l6, n6, string3);
                    object3 = arrayList;
                    new ArrayList<Media>().add(media2);
                    pickerActivity.done((ArrayList<Media>)object3);
                    return;
                }
            }
        } else if (n5 == PickerConfig.PERMISSION_SETTING) {
            n5 = ActivityCompat.checkSelfPermission((Context)object3, (String)"android.permission.READ_MEDIA_IMAGES") == -1 ? 1 : 0;
            n6 = ActivityCompat.checkSelfPermission((Context)object3, (String)"android.permission.READ_MEDIA_VISUAL_USER_SELECTED") == -1 ? 1 : 0;
            if (n5 != 0 && n6 != 0) {
                ((PickerActivity)object3).mFolderAdapter.updateAdapter(new ArrayList<Folder>());
                return;
            }
            ((PickerActivity)object3).isAddImageFor34 = n5;
            ((PickerActivity)object3).checkoutNeedShowPermissionBar();
            return;
        }
    }

    public void setFullScreen(Activity activity, boolean bl) {
        PickerActivity pickerActivity = activity.getWindow();
        if (bl) {
            PickerActivity pickerActivity2 = pickerActivity;
            WindowManager.LayoutParams layoutParams = pickerActivity2.getAttributes();
            layoutParams.flags |= 0x400;
            pickerActivity2.setAttributes(layoutParams);
            return;
        }
        PickerActivity pickerActivity3 = pickerActivity;
        WindowManager.LayoutParams layoutParams = pickerActivity3.getAttributes();
        layoutParams.flags &= 0xFFFFFBFF;
        pickerActivity3.setAttributes(layoutParams);
    }

    protected void onResume() {
        PickerActivity pickerActivity = this;
        super.onResume();
        RuningAcitvityUtil.putRuningActivity((Activity)pickerActivity);
    }

    protected void onPause() {
        PickerActivity pickerActivity = this;
        super.onPause();
        RuningAcitvityUtil.removeRuningActivity(pickerActivity.getComponentName().getClassName());
    }
}

