/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import androidx.annotation.Nullable;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.Segment;
import dc.squareup.okio.Sink;
import dc.squareup.okio.Source;
import dc.squareup.okio.Timeout;
import dc.squareup.okio.Util;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;

public class AsyncTimeout
extends Timeout {
    private static final int TIMEOUT_WRITE_SIZE = 65536;
    private static final long IDLE_TIMEOUT_MILLIS;
    private static final long IDLE_TIMEOUT_NANOS;
    @Nullable
    static AsyncTimeout head;
    private boolean inQueue;
    @Nullable
    private AsyncTimeout next;
    private long timeoutAt;

    private static synchronized void scheduleTimeout(AsyncTimeout asyncTimeout, long l5, boolean bl) {
        block9: {
            AsyncTimeout asyncTimeout2;
            long l6;
            block7: {
                block8: {
                    block6: {
                        if (head == null) {
                            head = new AsyncTimeout();
                            new Watchdog().start();
                        }
                        l6 = System.nanoTime();
                        if (l5 == 0L || !bl) break block6;
                        asyncTimeout.timeoutAt = l6 + Math.min(l5, asyncTimeout.deadlineNanoTime() - l6);
                        break block7;
                    }
                    if (l5 == 0L) break block8;
                    asyncTimeout.timeoutAt = l6 + l5;
                    break block7;
                }
                if (!bl) break block9;
                asyncTimeout.timeoutAt = asyncTimeout.deadlineNanoTime();
            }
            l5 = asyncTimeout.remainingNanos(l6);
            AsyncTimeout asyncTimeout3 = head;
            while ((asyncTimeout2 = asyncTimeout3.next) != null && l5 >= asyncTimeout2.remainingNanos(l6)) {
                asyncTimeout3 = asyncTimeout3.next;
            }
            asyncTimeout.next = asyncTimeout3.next;
            asyncTimeout3.next = asyncTimeout;
            if (asyncTimeout3 == head) {
                AsyncTimeout.class.notify();
                return;
            }
            return;
        }
        throw new AssertionError();
    }

    private static synchronized boolean cancelScheduledTimeout(AsyncTimeout asyncTimeout) {
        AsyncTimeout asyncTimeout2 = head;
        while (asyncTimeout2 != null) {
            AsyncTimeout asyncTimeout3 = asyncTimeout2.next;
            if (asyncTimeout3 == asyncTimeout) {
                asyncTimeout2.next = asyncTimeout.next;
                asyncTimeout.next = null;
                return false;
            }
            asyncTimeout2 = asyncTimeout3;
        }
        return true;
    }

    private long remainingNanos(long l5) {
        return this.timeoutAt - l5;
    }

    @Nullable
    static AsyncTimeout awaitTimeout() throws InterruptedException {
        AsyncTimeout asyncTimeout = AsyncTimeout.head.next;
        if (asyncTimeout == null) {
            long l5 = System.nanoTime();
            long l6 = IDLE_TIMEOUT_MILLIS;
            AsyncTimeout.class.wait(l6);
            if (AsyncTimeout.head.next == null && System.nanoTime() - l5 >= IDLE_TIMEOUT_NANOS) {
                return head;
            }
            return null;
        }
        long l7 = asyncTimeout.remainingNanos(System.nanoTime());
        if (l7 > 0L) {
            long l8 = l7;
            long l9 = l8 / 1000000L;
            int n5 = (int)(l8 - l9 * 1000000L);
            AsyncTimeout.class.wait(l9, n5);
            return null;
        }
        AsyncTimeout.head.next = asyncTimeout.next;
        asyncTimeout.next = null;
        return asyncTimeout;
    }

    static {
        long l5;
        IDLE_TIMEOUT_MILLIS = l5 = TimeUnit.SECONDS.toMillis(60L);
        IDLE_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(l5);
    }

    public final void enter() {
        if (!this.inQueue) {
            long l5 = this.timeoutNanos();
            boolean bl = this.hasDeadline();
            if (l5 == 0L && !bl) {
                return;
            }
            this.inQueue = true;
            AsyncTimeout.scheduleTimeout(this, l5, bl);
            return;
        }
        throw new IllegalStateException("Unbalanced enter/exit");
    }

    public final boolean exit() {
        if (!this.inQueue) {
            return false;
        }
        this.inQueue = false;
        return AsyncTimeout.cancelScheduledTimeout(this);
    }

    protected void timedOut() {
    }

    public final Sink sink(final Sink sink) {
        return new Sink(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void write(Buffer buffer, long l5) throws IOException {
                Throwable throwable2;
                boolean bl;
                Util.checkOffsetAndCount(buffer.size, 0L, l5);
                while (true) {
                    if (l5 <= 0L) {
                        return;
                    }
                    long l6 = 0L;
                    Segment segment = buffer.head;
                    while (l6 < 65536L) {
                        if ((l6 += (long)(segment.limit - segment.pos)) >= l5) {
                            l6 = l5;
                            break;
                        }
                        segment = segment.next;
                    }
                    1 v02 = this;
                    bl = false;
                    v02.AsyncTimeout.this.enter();
                    v02.sink.write(buffer, l6);
                    l5 -= l6;
                    {
                        catch (Throwable throwable2) {
                            break;
                        }
                        catch (IOException iOException) {}
                        {
                            throw AsyncTimeout.this.exit(iOException);
                        }
                    }
                    AsyncTimeout.this.exit(true);
                }
                AsyncTimeout.this.exit(bl);
                throw throwable2;
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void flush() throws IOException {
                Throwable throwable2;
                boolean bl;
                block4: {
                    1 v02 = this;
                    bl = false;
                    v02.AsyncTimeout.this.enter();
                    v02.sink.flush();
                    {
                        catch (Throwable throwable2) {
                            break block4;
                        }
                        catch (IOException iOException) {}
                        {
                            throw AsyncTimeout.this.exit(iOException);
                        }
                    }
                    v02.AsyncTimeout.this.exit(true);
                    return;
                }
                AsyncTimeout.this.exit(bl);
                throw throwable2;
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void close() throws IOException {
                Throwable throwable2;
                boolean bl;
                block4: {
                    1 v02 = this;
                    bl = false;
                    v02.AsyncTimeout.this.enter();
                    v02.sink.close();
                    {
                        catch (Throwable throwable2) {
                            break block4;
                        }
                        catch (IOException iOException) {}
                        {
                            throw AsyncTimeout.this.exit(iOException);
                        }
                    }
                    v02.AsyncTimeout.this.exit(true);
                    return;
                }
                AsyncTimeout.this.exit(bl);
                throw throwable2;
            }

            @Override
            public Timeout timeout() {
                return AsyncTimeout.this;
            }

            public String toString() {
                return "AsyncTimeout.sink(" + sink + ")";
            }
        };
    }

    public final Source source(final Source source) {
        return new Source(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public long read(Buffer buffer, long l5) throws IOException {
                Throwable throwable2;
                boolean bl;
                block4: {
                    2 v02 = this;
                    bl = false;
                    v02.AsyncTimeout.this.enter();
                    long l6 = v02.source.read(buffer, l5);
                    {
                        catch (Throwable throwable2) {
                            break block4;
                        }
                        catch (IOException iOException) {}
                        {
                            throw AsyncTimeout.this.exit(iOException);
                        }
                    }
                    AsyncTimeout.this.exit(true);
                    return l6;
                }
                AsyncTimeout.this.exit(bl);
                throw throwable2;
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void close() throws IOException {
                Throwable throwable2;
                boolean bl;
                block4: {
                    2 v02 = this;
                    bl = false;
                    v02.AsyncTimeout.this.enter();
                    v02.source.close();
                    {
                        catch (Throwable throwable2) {
                            break block4;
                        }
                        catch (IOException iOException) {}
                        {
                            throw AsyncTimeout.this.exit(iOException);
                        }
                    }
                    v02.AsyncTimeout.this.exit(true);
                    return;
                }
                AsyncTimeout.this.exit(bl);
                throw throwable2;
            }

            @Override
            public Timeout timeout() {
                return AsyncTimeout.this;
            }

            public String toString() {
                return "AsyncTimeout.source(" + source + ")";
            }
        };
    }

    final void exit(boolean bl) throws IOException {
        if (this.exit() && bl) {
            throw this.newTimeoutException(null);
        }
    }

    final IOException exit(IOException iOException) throws IOException {
        if (!this.exit()) {
            return iOException;
        }
        return this.newTimeoutException(iOException);
    }

    protected IOException newTimeoutException(@Nullable IOException iOException) {
        InterruptedIOException interruptedIOException;
        InterruptedIOException interruptedIOException2 = interruptedIOException;
        interruptedIOException = new InterruptedIOException("timeout");
        if (iOException != null) {
            InterruptedIOException interruptedIOException3 = interruptedIOException2;
            interruptedIOException3.initCause(iOException);
            return interruptedIOException3;
        }
        return interruptedIOException2;
    }

    private static final class Watchdog
    extends Thread {
        Watchdog() {
            Watchdog watchdog = this;
            super("Okio Watchdog");
            watchdog.setDaemon(true);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            while (true) {
                Object object = this = AsyncTimeout.class;
                AsyncTimeout asyncTimeout = AsyncTimeout.awaitTimeout();
                if (asyncTimeout == null) {
                    // MONITOREXIT : this
                    continue;
                }
                if (asyncTimeout == head) {
                    head = null;
                    // MONITOREXIT : this
                    return;
                }
                try {
                    asyncTimeout.timedOut();
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

