/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex.adapter.Fresco;

import android.content.res.Resources;
import android.graphics.ColorFilter;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.facebook.common.internal.Preconditions;
import com.facebook.drawee.drawable.DrawableParent;
import com.facebook.drawee.drawable.FadeDrawable;
import com.facebook.drawee.drawable.ForwardingDrawable;
import com.facebook.drawee.drawable.MatrixDrawable;
import com.facebook.drawee.drawable.ScaleTypeDrawable;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.RoundingParams;
import com.facebook.drawee.interfaces.SettableDraweeHierarchy;
import com.facebook.imagepipeline.systrace.FrescoSystrace;
import io.dcloud.feature.weex.adapter.Fresco.DCGenericDraweeHierarchyBuilder;
import io.dcloud.feature.weex.adapter.Fresco.DCRootDrawable;
import io.dcloud.feature.weex.adapter.Fresco.DCWrappingUtils;
import java.util.Iterator;

public class DCGenericDraweeHierarchy
implements SettableDraweeHierarchy {
    private static final int BACKGROUND_IMAGE_INDEX = 0;
    private static final int PLACEHOLDER_IMAGE_INDEX = 1;
    private static final int ACTUAL_IMAGE_INDEX = 2;
    private static final int PROGRESS_BAR_IMAGE_INDEX = 3;
    private static final int RETRY_IMAGE_INDEX = 4;
    private static final int FAILURE_IMAGE_INDEX = 5;
    private static final int OVERLAY_IMAGES_INDEX = 6;
    private final Drawable mEmptyActualImageDrawable;
    private final Resources mResources;
    @Nullable
    private RoundingParams mRoundingParams;
    private final DCRootDrawable mTopLevelDrawable;
    private final FadeDrawable mFadeDrawable;
    private final ForwardingDrawable mActualImageWrapper;

    DCGenericDraweeHierarchy(DCGenericDraweeHierarchyBuilder dCGenericDraweeHierarchyBuilder) {
        FadeDrawable fadeDrawable;
        ForwardingDrawable forwardingDrawable;
        ColorDrawable colorDrawable;
        ColorDrawable colorDrawable2 = colorDrawable;
        this.mEmptyActualImageDrawable = new ColorDrawable(0);
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"GenericDraweeHierarchy()");
        }
        DCGenericDraweeHierarchy dCGenericDraweeHierarchy = this;
        dCGenericDraweeHierarchy.mResources = dCGenericDraweeHierarchyBuilder.getResources();
        dCGenericDraweeHierarchy.mRoundingParams = dCGenericDraweeHierarchyBuilder.getRoundingParams();
        ForwardingDrawable forwardingDrawable2 = forwardingDrawable;
        dCGenericDraweeHierarchy.mActualImageWrapper = new ForwardingDrawable((Drawable)colorDrawable2);
        int n = dCGenericDraweeHierarchyBuilder.getOverlays() != null ? dCGenericDraweeHierarchyBuilder.getOverlays().size() : 1;
        int n2 = dCGenericDraweeHierarchyBuilder.getPressedStateOverlay() != null ? 1 : 0;
        int n3 = n + n2;
        Drawable[] drawableArray = new Drawable[n3 + 6];
        Drawable[] drawableArray2 = drawableArray;
        drawableArray2[0] = this.buildBranch(dCGenericDraweeHierarchyBuilder.getBackground(), null);
        drawableArray2[1] = this.buildBranch(dCGenericDraweeHierarchyBuilder.getPlaceholderImage(), dCGenericDraweeHierarchyBuilder.getPlaceholderImageScaleType());
        drawableArray2[2] = this.buildActualImageBranch((Drawable)forwardingDrawable2, dCGenericDraweeHierarchyBuilder.getActualImageScaleType(), dCGenericDraweeHierarchyBuilder.getActualImageFocusPoint(), dCGenericDraweeHierarchyBuilder.getActualImageColorFilter());
        drawableArray2[3] = this.buildBranch(dCGenericDraweeHierarchyBuilder.getProgressBarImage(), dCGenericDraweeHierarchyBuilder.getProgressBarImageScaleType());
        drawableArray2[4] = this.buildBranch(dCGenericDraweeHierarchyBuilder.getRetryImage(), dCGenericDraweeHierarchyBuilder.getRetryImageScaleType());
        drawableArray[5] = this.buildBranch(dCGenericDraweeHierarchyBuilder.getFailureImage(), dCGenericDraweeHierarchyBuilder.getFailureImageScaleType());
        if (n3 > 0) {
            int n4 = 0;
            if (dCGenericDraweeHierarchyBuilder.getOverlays() != null) {
                Iterator<Drawable> iterator = dCGenericDraweeHierarchyBuilder.getOverlays().iterator();
                while (iterator.hasNext()) {
                    int n5 = n4 + 1;
                    drawableArray2[n4 += 6] = this.buildBranch(iterator.next(), null);
                    n4 = n5;
                }
            } else {
                n4 = 1;
            }
            if (dCGenericDraweeHierarchyBuilder.getPressedStateOverlay() != null) {
                drawableArray2[n4 += 6] = this.buildBranch(dCGenericDraweeHierarchyBuilder.getPressedStateOverlay(), null);
            }
        }
        ForwardingDrawable forwardingDrawable3 = forwardingDrawable2 = fadeDrawable;
        super(drawableArray2);
        this.mFadeDrawable = forwardingDrawable3;
        forwardingDrawable2.setTransitionDuration(dCGenericDraweeHierarchyBuilder.getFadeDuration());
        dCGenericDraweeHierarchyBuilder = DCWrappingUtils.maybeWrapWithRoundedOverlayColor((Drawable)fadeDrawable, this.mRoundingParams);
        this.mTopLevelDrawable = new DCRootDrawable((Drawable)dCGenericDraweeHierarchyBuilder);
        this.mTopLevelDrawable.mutate();
        this.resetFade();
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
            return;
        }
    }

    @Nullable
    private Drawable buildActualImageBranch(Drawable drawable2, @Nullable ScalingUtils.ScaleType scaleType, @Nullable PointF pointF, @Nullable ColorFilter colorFilter) {
        drawable2.setColorFilter(colorFilter);
        return DCWrappingUtils.maybeWrapWithScaleType(drawable2, scaleType, pointF);
    }

    @Nullable
    private Drawable buildBranch(@Nullable Drawable drawable2, @Nullable ScalingUtils.ScaleType scaleType) {
        DCGenericDraweeHierarchy dCGenericDraweeHierarchy = dCGenericDraweeHierarchy2;
        DCGenericDraweeHierarchy dCGenericDraweeHierarchy2 = dCGenericDraweeHierarchy.mRoundingParams;
        return DCWrappingUtils.maybeWrapWithScaleType(DCWrappingUtils.maybeApplyLeafRounding(drawable2, (RoundingParams)dCGenericDraweeHierarchy2, dCGenericDraweeHierarchy.mResources), scaleType);
    }

    private void resetActualImages() {
        this.mActualImageWrapper.setDrawable(this.mEmptyActualImageDrawable);
    }

    private void resetFade() {
        FadeDrawable fadeDrawable = this.mFadeDrawable;
        if (fadeDrawable != null) {
            DCGenericDraweeHierarchy dCGenericDraweeHierarchy = this;
            fadeDrawable.beginBatchMode();
            dCGenericDraweeHierarchy.mFadeDrawable.fadeInAllLayers();
            dCGenericDraweeHierarchy.fadeOutBranches();
            dCGenericDraweeHierarchy.fadeInLayer(1);
            dCGenericDraweeHierarchy.mFadeDrawable.finishTransitionImmediately();
            dCGenericDraweeHierarchy.mFadeDrawable.endBatchMode();
            return;
        }
    }

    private void fadeOutBranches() {
        DCGenericDraweeHierarchy dCGenericDraweeHierarchy = this;
        dCGenericDraweeHierarchy.fadeOutLayer(1);
        dCGenericDraweeHierarchy.fadeOutLayer(2);
        dCGenericDraweeHierarchy.fadeOutLayer(3);
        dCGenericDraweeHierarchy.fadeOutLayer(4);
        dCGenericDraweeHierarchy.fadeOutLayer(5);
    }

    private void fadeInLayer(int n) {
        if (n >= 0) {
            this.mFadeDrawable.fadeInLayer(n);
            return;
        }
    }

    private void fadeOutLayer(int n) {
        if (n >= 0) {
            this.mFadeDrawable.fadeOutLayer(n);
            return;
        }
    }

    private void setProgress(float f) {
        Drawable drawable2 = this.mFadeDrawable.getDrawable(3);
        if (drawable2 == null) {
            return;
        }
        if (f >= 0.999f) {
            if (drawable2 instanceof Animatable) {
                ((Animatable)drawable2).stop();
            }
            this.fadeOutLayer(3);
        } else {
            if (drawable2 instanceof Animatable) {
                ((Animatable)drawable2).start();
            }
            this.fadeInLayer(3);
        }
        drawable2.setLevel(Math.round(f * 10000.0f));
    }

    private DrawableParent getParentDrawableAtIndex(int n) {
        DCGenericDraweeHierarchy dCGenericDraweeHierarchy = dCGenericDraweeHierarchy.mFadeDrawable.getDrawableParentForIndex(n);
        if (dCGenericDraweeHierarchy.getDrawable() instanceof MatrixDrawable) {
            dCGenericDraweeHierarchy = (MatrixDrawable)dCGenericDraweeHierarchy.getDrawable();
        }
        if (dCGenericDraweeHierarchy.getDrawable() instanceof ScaleTypeDrawable) {
            return (ScaleTypeDrawable)dCGenericDraweeHierarchy.getDrawable();
        }
        return dCGenericDraweeHierarchy;
    }

    private void setChildDrawableAtIndex(int n, @Nullable Drawable drawable2) {
        if (drawable2 == null) {
            dCGenericDraweeHierarchy3.mFadeDrawable.setDrawable(n, null);
            return;
        }
        DCGenericDraweeHierarchy dCGenericDraweeHierarchy = dCGenericDraweeHierarchy3;
        DCGenericDraweeHierarchy dCGenericDraweeHierarchy2 = dCGenericDraweeHierarchy3;
        DCGenericDraweeHierarchy dCGenericDraweeHierarchy3 = dCGenericDraweeHierarchy2.mRoundingParams;
        dCGenericDraweeHierarchy3 = DCWrappingUtils.maybeApplyLeafRounding(drawable2, (RoundingParams)dCGenericDraweeHierarchy3, dCGenericDraweeHierarchy2.mResources);
        dCGenericDraweeHierarchy.getParentDrawableAtIndex(n).setDrawable((Drawable)dCGenericDraweeHierarchy3);
    }

    private ScaleTypeDrawable getScaleTypeDrawableAtIndex(int n) {
        if ((this = this.getParentDrawableAtIndex(n)) instanceof ScaleTypeDrawable) {
            return (ScaleTypeDrawable)this;
        }
        return DCWrappingUtils.wrapChildWithScaleType((DrawableParent)this, ScalingUtils.ScaleType.FIT_XY);
    }

    private boolean hasScaleTypeDrawableAtIndex(int n) {
        return this.getParentDrawableAtIndex(n) instanceof ScaleTypeDrawable;
    }

    public DCRootDrawable getTopLevelDrawable() {
        return this.mTopLevelDrawable;
    }

    public Rect getBounds() {
        return this.mTopLevelDrawable.getBounds();
    }

    public void reset() {
        DCGenericDraweeHierarchy dCGenericDraweeHierarchy = this;
        dCGenericDraweeHierarchy.resetActualImages();
        dCGenericDraweeHierarchy.resetFade();
    }

    public void setImage(Drawable drawable2, float f, boolean bl) {
        DCGenericDraweeHierarchy dCGenericDraweeHierarchy = this;
        Drawable drawable3 = drawable2;
        DCGenericDraweeHierarchy dCGenericDraweeHierarchy2 = this;
        drawable2 = dCGenericDraweeHierarchy2.mRoundingParams;
        drawable2 = DCWrappingUtils.maybeApplyLeafRounding(drawable3, (RoundingParams)drawable2, dCGenericDraweeHierarchy2.mResources);
        drawable2.mutate();
        dCGenericDraweeHierarchy.mActualImageWrapper.setDrawable(drawable2);
        dCGenericDraweeHierarchy.mFadeDrawable.beginBatchMode();
        dCGenericDraweeHierarchy.fadeOutBranches();
        dCGenericDraweeHierarchy.fadeInLayer(2);
        this.setProgress(f);
        if (bl) {
            this.mFadeDrawable.finishTransitionImmediately();
        }
        this.mFadeDrawable.endBatchMode();
    }

    public void setProgress(float f, boolean bl) {
        if (this.mFadeDrawable.getDrawable(3) == null) {
            return;
        }
        this.mFadeDrawable.beginBatchMode();
        this.setProgress(f);
        if (bl) {
            this.mFadeDrawable.finishTransitionImmediately();
        }
        this.mFadeDrawable.endBatchMode();
    }

    public void setFailure(Throwable throwable) {
        DCGenericDraweeHierarchy dCGenericDraweeHierarchy = this;
        dCGenericDraweeHierarchy.mFadeDrawable.beginBatchMode();
        dCGenericDraweeHierarchy.fadeOutBranches();
        if (dCGenericDraweeHierarchy.mFadeDrawable.getDrawable(5) != null) {
            this.fadeInLayer(5);
        } else {
            this.fadeInLayer(1);
        }
        this.mFadeDrawable.endBatchMode();
    }

    public void setRetry(Throwable throwable) {
        DCGenericDraweeHierarchy dCGenericDraweeHierarchy = this;
        dCGenericDraweeHierarchy.mFadeDrawable.beginBatchMode();
        dCGenericDraweeHierarchy.fadeOutBranches();
        if (dCGenericDraweeHierarchy.mFadeDrawable.getDrawable(4) != null) {
            this.fadeInLayer(4);
        } else {
            this.fadeInLayer(1);
        }
        this.mFadeDrawable.endBatchMode();
    }

    public void setControllerOverlay(@Nullable Drawable drawable2) {
        this.mTopLevelDrawable.setControllerOverlay(drawable2);
    }

    public void setFadeDuration(int n) {
        this.mFadeDrawable.setTransitionDuration(n);
    }

    public int getFadeDuration() {
        return this.mFadeDrawable.getTransitionDuration();
    }

    public void setActualImageFocusPoint(PointF pointF) {
        Preconditions.checkNotNull((Object)pointF);
        this.getScaleTypeDrawableAtIndex(2).setFocusPoint(pointF);
    }

    public void setActualImageScaleType(ScalingUtils.ScaleType scaleType) {
        Preconditions.checkNotNull((Object)scaleType);
        this.getScaleTypeDrawableAtIndex(2).setScaleType(scaleType);
    }

    @Nullable
    public ScalingUtils.ScaleType getActualImageScaleType() {
        if (!this.hasScaleTypeDrawableAtIndex(2)) {
            return null;
        }
        return this.getScaleTypeDrawableAtIndex(2).getScaleType();
    }

    public void setActualImageColorFilter(ColorFilter colorFilter) {
        this.mActualImageWrapper.setColorFilter(colorFilter);
    }

    public void getActualImageBounds(RectF rectF) {
        this.mActualImageWrapper.getTransformedBounds(rectF);
    }

    public void setPlaceholderImage(@Nullable Drawable drawable2) {
        this.setChildDrawableAtIndex(1, drawable2);
    }

    public void setPlaceholderImage(Drawable drawable2, ScalingUtils.ScaleType scaleType) {
        DCGenericDraweeHierarchy dCGenericDraweeHierarchy = this;
        dCGenericDraweeHierarchy.setChildDrawableAtIndex(1, drawable2);
        dCGenericDraweeHierarchy.getScaleTypeDrawableAtIndex(1).setScaleType(scaleType);
    }

    public boolean hasPlaceholderImage() {
        return this.mFadeDrawable.getDrawable(1) != null;
    }

    public void setPlaceholderImageFocusPoint(PointF pointF) {
        Preconditions.checkNotNull((Object)pointF);
        this.getScaleTypeDrawableAtIndex(1).setFocusPoint(pointF);
    }

    public void setPlaceholderImage(int n) {
        DCGenericDraweeHierarchy dCGenericDraweeHierarchy = this;
        dCGenericDraweeHierarchy.setPlaceholderImage(dCGenericDraweeHierarchy.mResources.getDrawable(n));
    }

    public void setPlaceholderImage(int n, ScalingUtils.ScaleType scaleType) {
        DCGenericDraweeHierarchy dCGenericDraweeHierarchy = this;
        dCGenericDraweeHierarchy.setPlaceholderImage(dCGenericDraweeHierarchy.mResources.getDrawable(n), scaleType);
    }

    public void setFailureImage(@Nullable Drawable drawable2) {
        this.setChildDrawableAtIndex(5, drawable2);
    }

    public void setFailureImage(Drawable drawable2, ScalingUtils.ScaleType scaleType) {
        DCGenericDraweeHierarchy dCGenericDraweeHierarchy = this;
        dCGenericDraweeHierarchy.setChildDrawableAtIndex(5, drawable2);
        dCGenericDraweeHierarchy.getScaleTypeDrawableAtIndex(5).setScaleType(scaleType);
    }

    public void setFailureImage(int n) {
        DCGenericDraweeHierarchy dCGenericDraweeHierarchy = this;
        dCGenericDraweeHierarchy.setFailureImage(dCGenericDraweeHierarchy.mResources.getDrawable(n));
    }

    public void setFailureImage(int n, ScalingUtils.ScaleType scaleType) {
        DCGenericDraweeHierarchy dCGenericDraweeHierarchy = this;
        dCGenericDraweeHierarchy.setFailureImage(dCGenericDraweeHierarchy.mResources.getDrawable(n), scaleType);
    }

    public void setRetryImage(@Nullable Drawable drawable2) {
        this.setChildDrawableAtIndex(4, drawable2);
    }

    public void setRetryImage(Drawable drawable2, ScalingUtils.ScaleType scaleType) {
        DCGenericDraweeHierarchy dCGenericDraweeHierarchy = this;
        dCGenericDraweeHierarchy.setChildDrawableAtIndex(4, drawable2);
        dCGenericDraweeHierarchy.getScaleTypeDrawableAtIndex(4).setScaleType(scaleType);
    }

    public void setRetryImage(int n) {
        DCGenericDraweeHierarchy dCGenericDraweeHierarchy = this;
        dCGenericDraweeHierarchy.setRetryImage(dCGenericDraweeHierarchy.mResources.getDrawable(n));
    }

    public void setRetryImage(int n, ScalingUtils.ScaleType scaleType) {
        DCGenericDraweeHierarchy dCGenericDraweeHierarchy = this;
        dCGenericDraweeHierarchy.setRetryImage(dCGenericDraweeHierarchy.mResources.getDrawable(n), scaleType);
    }

    public void setProgressBarImage(@Nullable Drawable drawable2) {
        this.setChildDrawableAtIndex(3, drawable2);
    }

    public void setProgressBarImage(Drawable drawable2, ScalingUtils.ScaleType scaleType) {
        DCGenericDraweeHierarchy dCGenericDraweeHierarchy = this;
        dCGenericDraweeHierarchy.setChildDrawableAtIndex(3, drawable2);
        dCGenericDraweeHierarchy.getScaleTypeDrawableAtIndex(3).setScaleType(scaleType);
    }

    public void setProgressBarImage(int n) {
        DCGenericDraweeHierarchy dCGenericDraweeHierarchy = this;
        dCGenericDraweeHierarchy.setProgressBarImage(dCGenericDraweeHierarchy.mResources.getDrawable(n));
    }

    public void setProgressBarImage(int n, ScalingUtils.ScaleType scaleType) {
        DCGenericDraweeHierarchy dCGenericDraweeHierarchy = this;
        dCGenericDraweeHierarchy.setProgressBarImage(dCGenericDraweeHierarchy.mResources.getDrawable(n), scaleType);
    }

    public void setBackgroundImage(@Nullable Drawable drawable2) {
        this.setChildDrawableAtIndex(0, drawable2);
    }

    public void setOverlayImage(int n, @Nullable Drawable drawable2) {
        Preconditions.checkArgument((n >= 0 && n + 6 < this.mFadeDrawable.getNumberOfLayers() ? 1 : 0) != 0, (Object)"The given index does not correspond to an overlay image.");
        this.setChildDrawableAtIndex(n + 6, drawable2);
    }

    public void setOverlayImage(@Nullable Drawable drawable2) {
        this.setOverlayImage(0, drawable2);
    }

    public void setRoundingParams(@Nullable RoundingParams roundingParams) {
        this.mRoundingParams = roundingParams;
        DCWrappingUtils.updateOverlayColorRounding((DrawableParent)this.mTopLevelDrawable, roundingParams);
        for (int i = 0; i < this.mFadeDrawable.getNumberOfLayers(); ++i) {
            DCGenericDraweeHierarchy dCGenericDraweeHierarchy = this;
            RoundingParams roundingParams2 = dCGenericDraweeHierarchy.mRoundingParams;
            DCWrappingUtils.updateLeafRounding(this.getParentDrawableAtIndex(i), roundingParams2, dCGenericDraweeHierarchy.mResources);
        }
    }

    @Nullable
    public RoundingParams getRoundingParams() {
        return this.mRoundingParams;
    }

    @VisibleForTesting
    public boolean hasImage() {
        return this.mActualImageWrapper.getDrawable() != this.mEmptyActualImageDrawable;
    }
}

