/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.aztec.decoder;

import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.aztec.AztecDetectorResult;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.common.DecoderResult;
import com.dcloud.zxing2.common.reedsolomon.GenericGF;
import com.dcloud.zxing2.common.reedsolomon.ReedSolomonDecoder;
import com.dcloud.zxing2.common.reedsolomon.ReedSolomonException;
import java.util.Arrays;

public final class Decoder {
    private static final String[] UPPER_TABLE;
    private static final String[] LOWER_TABLE;
    private static final String[] MIXED_TABLE;
    private static final String[] PUNCT_TABLE;
    private static final String[] DIGIT_TABLE;
    private AztecDetectorResult ddata;

    public static String highLevelDecode(boolean[] blArray) {
        return Decoder.getEncodedData(blArray);
    }

    private static String getEncodedData(boolean[] blArray) {
        StringBuilder stringBuilder;
        int n5 = blArray.length;
        Object object = Table.UPPER;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(20);
        int n6 = 0;
        Table table = object;
        int n7 = n6;
        while (n7 < n5) {
            int n8;
            if (object == Table.BINARY) {
                int n9;
                block6: {
                    if (n5 - n7 < 5) break;
                    n9 = Decoder.readCode(blArray, n7, 5);
                    n8 = n7 + 5;
                    if (n9 == 0) {
                        if (n5 - n8 < 11) break;
                        n9 = Decoder.readCode(blArray, n8, 11) + 31;
                        n8 = n7 + 16;
                    }
                    for (n7 = 0; n7 < n9; ++n7) {
                        if (n5 - n8 < 8) {
                            n9 = n5;
                            break block6;
                        }
                        stringBuilder2.append((char)Decoder.readCode(blArray, n8, 8));
                        n8 += 8;
                    }
                    n9 = n8;
                }
                object = table;
                n7 = n9;
                continue;
            }
            n8 = object == Table.DIGIT ? 4 : 5;
            if (n5 - n7 < n8) break;
            int n10 = Decoder.readCode(blArray, n7, n8);
            n7 += n8;
            if (((String)(object = Decoder.getCharacter(object, n10))).startsWith("CTRL_")) {
                Table table2 = object;
                object = Decoder.getTable(((String)((Object)table2)).charAt(5));
                if (((String)((Object)table2)).charAt(6) != 'L') continue;
                table = object;
                continue;
            }
            stringBuilder2.append((String)object);
            object = table;
        }
        return stringBuilder2.toString();
    }

    private static Table getTable(char c6) {
        if (c6 != 'B') {
            if (c6 != 'D') {
                if (c6 != 'P') {
                    if (c6 != 'L') {
                        if (c6 != 'M') {
                            return Table.UPPER;
                        }
                        return Table.MIXED;
                    }
                    return Table.LOWER;
                }
                return Table.PUNCT;
            }
            return Table.DIGIT;
        }
        return Table.BINARY;
    }

    private static String getCharacter(Table table, int n5) {
        switch (1.$SwitchMap$com$dcloud$zxing2$aztec$decoder$Decoder$Table[table.ordinal()]) {
            default: {
                throw new IllegalStateException("Bad table");
            }
            case 5: {
                return DIGIT_TABLE[n5];
            }
            case 4: {
                return PUNCT_TABLE[n5];
            }
            case 3: {
                return MIXED_TABLE[n5];
            }
            case 2: {
                return LOWER_TABLE[n5];
            }
            case 1: 
        }
        return UPPER_TABLE[n5];
    }

    private boolean[] correctBits(boolean[] blArray) throws FormatException {
        GenericGF genericGF;
        int n5;
        if (this.ddata.getNbLayers() <= 2) {
            n5 = 6;
            genericGF = GenericGF.AZTEC_DATA_6;
        } else if (this.ddata.getNbLayers() <= 8) {
            n5 = 8;
            genericGF = GenericGF.AZTEC_DATA_8;
        } else if (this.ddata.getNbLayers() <= 22) {
            n5 = 10;
            genericGF = GenericGF.AZTEC_DATA_10;
        } else {
            n5 = 12;
            genericGF = GenericGF.AZTEC_DATA_12;
        }
        int n6 = this.ddata.getNbDatablocks();
        int n7 = blArray.length / n5;
        if (n7 >= n6) {
            int n8;
            int n9;
            int n10 = n7;
            int n11 = blArray.length % n5;
            int n12 = n10 - n6;
            int[] nArray = new int[n10];
            int n13 = 0;
            while (n13 < n7) {
                nArray[n13] = Decoder.readCode(blArray, n11, n5);
                ++n13;
                n11 += n5;
            }
            try {
                new ReedSolomonDecoder(genericGF).decode(nArray, n12);
                n9 = 1 << n5;
                n8 = n9 - 1;
                n7 = 0;
            }
            catch (ReedSolomonException reedSolomonException) {
                throw FormatException.getFormatInstance(reedSolomonException);
            }
            for (n11 = 0; n11 < n6; ++n11) {
                n12 = nArray[n11];
                if (n12 != 0 && n12 != n8) {
                    if (n12 != 1 && n12 != n9 - 2) continue;
                    ++n7;
                    continue;
                }
                throw FormatException.getFormatInstance();
            }
            boolean[] blArray2 = new boolean[n6 * n5 - n7];
            n7 = 0;
            for (n11 = 0; n11 < n6; ++n11) {
                n12 = nArray[n11];
                if (n12 != 1 && n12 != n9 - 2) {
                    for (n13 = n5 - 1; n13 >= 0; --n13) {
                        int n14 = n7 + 1;
                        boolean bl = (n12 & 1 << n13) != 0;
                        blArray2[n7] = bl;
                        n7 = n14;
                    }
                    continue;
                }
                int n15 = n12;
                n12 = n7 + n5 - 1;
                n13 = n15 > 1 ? 1 : 0;
                Arrays.fill(blArray2, n7, n12, n13 != 0);
                n7 += n5 - 1;
            }
            return blArray2;
        }
        throw FormatException.getFormatInstance();
    }

    private static int readCode(boolean[] blArray, int n5, int n6) {
        int n7 = 0;
        for (int i5 = n5; i5 < n5 + n6; ++i5) {
            n7 <<= 1;
            if (!blArray[i5]) continue;
            n7 |= 1;
        }
        return n7;
    }

    private static int totalBitsInLayer(int n5, boolean bl) {
        return ((bl ? 88 : 112) + n5 * 16) * n5;
    }

    static {
        String[] stringArray = new String[32];
        String[] stringArray2 = stringArray;
        stringArray[0] = "CTRL_PS";
        stringArray2[1] = " ";
        stringArray2[2] = "A";
        stringArray2[3] = "B";
        stringArray2[4] = "C";
        stringArray2[5] = "D";
        stringArray2[6] = "E";
        stringArray2[7] = "F";
        stringArray2[8] = "G";
        stringArray2[9] = "H";
        stringArray2[10] = "I";
        stringArray2[11] = "J";
        stringArray2[12] = "K";
        stringArray2[13] = "L";
        stringArray2[14] = "M";
        stringArray2[15] = "N";
        stringArray2[16] = "O";
        stringArray2[17] = "P";
        stringArray2[18] = "Q";
        stringArray2[19] = "R";
        stringArray2[20] = "S";
        stringArray2[21] = "T";
        stringArray2[22] = "U";
        stringArray2[23] = "V";
        stringArray2[24] = "W";
        stringArray2[25] = "X";
        stringArray2[26] = "Y";
        stringArray2[27] = "Z";
        stringArray2[28] = "CTRL_LL";
        stringArray2[29] = "CTRL_ML";
        stringArray2[30] = "CTRL_DL";
        stringArray2[31] = "CTRL_BS";
        UPPER_TABLE = stringArray2;
        String[] stringArray3 = new String[32];
        stringArray2 = stringArray3;
        stringArray3[0] = "CTRL_PS";
        stringArray2[1] = " ";
        stringArray2[2] = "a";
        stringArray2[3] = "b";
        stringArray2[4] = "c";
        stringArray2[5] = "d";
        stringArray2[6] = "e";
        stringArray2[7] = "f";
        stringArray2[8] = "g";
        stringArray2[9] = "h";
        stringArray2[10] = "i";
        stringArray2[11] = "j";
        stringArray2[12] = "k";
        stringArray2[13] = "l";
        stringArray2[14] = "m";
        stringArray2[15] = "n";
        stringArray2[16] = "o";
        stringArray2[17] = "p";
        stringArray2[18] = "q";
        stringArray2[19] = "r";
        stringArray2[20] = "s";
        stringArray2[21] = "t";
        stringArray2[22] = "u";
        stringArray2[23] = "v";
        stringArray2[24] = "w";
        stringArray2[25] = "x";
        stringArray2[26] = "y";
        stringArray2[27] = "z";
        stringArray2[28] = "CTRL_US";
        stringArray2[29] = "CTRL_ML";
        stringArray2[30] = "CTRL_DL";
        stringArray2[31] = "CTRL_BS";
        LOWER_TABLE = stringArray2;
        String[] stringArray4 = new String[32];
        stringArray2 = stringArray4;
        stringArray4[0] = "CTRL_PS";
        stringArray2[1] = " ";
        stringArray2[2] = "\u0001";
        stringArray2[3] = "\u0002";
        stringArray2[4] = "\u0003";
        stringArray2[5] = "\u0004";
        stringArray2[6] = "\u0005";
        stringArray2[7] = "\u0006";
        stringArray2[8] = "\u0007";
        stringArray2[9] = "\b";
        stringArray2[10] = "\t";
        stringArray2[11] = "\n";
        stringArray2[12] = "\u000b";
        stringArray2[13] = "\f";
        stringArray2[14] = "\r";
        stringArray2[15] = "\u001b";
        stringArray2[16] = "\u001c";
        stringArray2[17] = "\u001d";
        stringArray2[18] = "\u001e";
        stringArray2[19] = "\u001f";
        stringArray2[20] = "@";
        stringArray2[21] = "\\";
        stringArray2[22] = "^";
        stringArray2[23] = "_";
        stringArray2[24] = "`";
        stringArray2[25] = "|";
        stringArray2[26] = "~";
        stringArray2[27] = "\u007f";
        stringArray2[28] = "CTRL_LL";
        stringArray2[29] = "CTRL_UL";
        stringArray2[30] = "CTRL_PL";
        stringArray2[31] = "CTRL_BS";
        MIXED_TABLE = stringArray2;
        String[] stringArray5 = new String[32];
        stringArray2 = stringArray5;
        stringArray5[0] = "";
        stringArray2[1] = "\r";
        stringArray2[2] = "\r\n";
        stringArray2[3] = ". ";
        stringArray2[4] = ", ";
        stringArray2[5] = ": ";
        stringArray2[6] = "!";
        stringArray2[7] = "\"";
        stringArray2[8] = "#";
        stringArray2[9] = "$";
        stringArray2[10] = "%";
        stringArray2[11] = "&";
        stringArray2[12] = "'";
        stringArray2[13] = "(";
        stringArray2[14] = ")";
        stringArray2[15] = "*";
        stringArray2[16] = "+";
        stringArray2[17] = ",";
        stringArray2[18] = "-";
        stringArray2[19] = ".";
        stringArray2[20] = "/";
        stringArray2[21] = ":";
        stringArray2[22] = ";";
        stringArray2[23] = "<";
        stringArray2[24] = "=";
        stringArray2[25] = ">";
        stringArray2[26] = "?";
        stringArray2[27] = "[";
        stringArray2[28] = "]";
        stringArray2[29] = "{";
        stringArray2[30] = "}";
        stringArray2[31] = "CTRL_UL";
        PUNCT_TABLE = stringArray2;
        DIGIT_TABLE = new String[]{"CTRL_PS", " ", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ",", ".", "CTRL_UL", "CTRL_US"};
    }

    public DecoderResult decode(AztecDetectorResult aztecDetectorResult) throws FormatException {
        Decoder decoder = string2;
        ((Decoder)((Object)string2)).ddata = aztecDetectorResult;
        String string2 = Decoder.getEncodedData(decoder.correctBits(decoder.extractBits(aztecDetectorResult.getBits())));
        return new DecoderResult(null, string2, null, null);
    }

    boolean[] extractBits(BitMatrix bitMatrix) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        boolean bl = this.ddata.isCompact();
        int n10 = this.ddata.getNbLayers();
        int n11 = bl ? n10 * 4 + 11 : n10 * 4 + 14;
        int[] nArray = new int[n11];
        boolean[] blArray = new boolean[Decoder.totalBitsInLayer(n10, bl)];
        if (bl) {
            n9 = 0;
            while (n9 < n11) {
                int n12 = n9++;
                nArray[n12] = n12;
            }
        } else {
            n9 = n11 / 2;
            n8 = (n11 + 1 + (n9 - 1) / 15 * 2) / 2;
            for (n7 = 0; n7 < n9; ++n7) {
                int n13 = n7;
                n6 = n13 + n13 / 15;
                n5 = n9 - n13 - 1;
                nArray[n5] = n8 - n6 - 1;
                n5 = n9 + n7;
                nArray[n5] = n8 + n6 + 1;
            }
        }
        n8 = 0;
        for (n9 = 0; n9 < n10; ++n9) {
            n7 = bl ? (n10 - n9) * 4 + 9 : (n10 - n9) * 4 + 12;
            n6 = n9 * 2;
            n5 = n11 - 1 - n6;
            for (int i5 = 0; i5 < n7; ++i5) {
                int n14 = i5 * 2;
                for (int i6 = 0; i6 < 2; ++i6) {
                    int n15 = n8 + n14 + i6;
                    int n16 = n6 + i6;
                    int n17 = nArray[n16];
                    int n18 = n6 + i5;
                    blArray[n15] = bitMatrix.get(n17, nArray[n18]);
                    n15 = n8 + n7 * 2 + n14 + i6;
                    n17 = nArray[n18];
                    n18 = n5 - i6;
                    blArray[n15] = bitMatrix.get(n17, nArray[n18]);
                    n15 = n8 + n7 * 4 + n14 + i6;
                    n17 = nArray[n18];
                    n18 = n5 - i5;
                    blArray[n15] = bitMatrix.get(n17, nArray[n18]);
                    n15 = n8 + n7 * 6 + n14 + i6;
                    n17 = nArray[n18];
                    blArray[n15] = bitMatrix.get(n17, nArray[n16]);
                }
            }
            n8 += n7 * 8;
        }
        return blArray;
    }

    private static enum Table {
        UPPER,
        LOWER,
        MIXED,
        DIGIT,
        PUNCT,
        BINARY;

    }
}

